/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;

public class AuthorityInformationAccess
extends ASN1Encodable {
    DERObjectIdentifier accessMethod = null;
    GeneralName accessLocation = null;

    public AuthorityInformationAccess getInstance(Object obj) {
        if (obj instanceof AuthorityInformationAccess) {
            return (AuthorityInformationAccess)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new AuthorityInformationAccess((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public AuthorityInformationAccess(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        if (e.hasMoreElements()) {
            DERSequence vec = (DERSequence)e.nextElement();
            if (vec.size() != 2) {
                throw new IllegalArgumentException("wrong number of elements in inner sequence");
            }
            this.accessMethod = (DERObjectIdentifier)vec.getObjectAt(0);
            this.accessLocation = (GeneralName)vec.getObjectAt(1);
        }
    }

    public AuthorityInformationAccess(DERObjectIdentifier oid, GeneralName location) {
        this.accessMethod = oid;
        this.accessLocation = location;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector accessDescription = new ASN1EncodableVector();
        accessDescription.add(this.accessMethod);
        accessDescription.add(this.accessLocation);
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add(new DERSequence(accessDescription));
        return new DERSequence(vec);
    }

    public String toString() {
        return "AuthorityInformationAccess: Oid(" + this.accessMethod.getId() + ")";
    }
}

