/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTester;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterContact;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterContactListener;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterListener;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerAdapter;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class SpeedManagerImpl
implements SpeedManager {
    private static final int UNLIMITED = Integer.MAX_VALUE;
    private static final int CONTACT_NUMBER = 3;
    private static final int CONTACT_PING_SECS = 5;
    private static final int MODE_RUNNING = 0;
    private static final int MODE_FORCED_MIN = 1;
    private static final int MODE_FORCED_MAX = 2;
    private static final int TICK_PERIOD = 1000;
    private static final String CONFIG_AVAIL = "AutoSpeed Available";
    private static final String CONFIG_MIN_UP = "AutoSpeed Min Upload KBs";
    private static final String CONFIG_MAX_UP = "AutoSpeed Max Upload KBs";
    private static final String CONFIG_MAX_INC = "AutoSpeed Max Increment KBs";
    private static final String CONFIG_MAX_DEC = "AutoSpeed Max Decrement KBs";
    private static final String CONFIG_CHOKE_PING = "AutoSpeed Choking Ping Millis";
    private static final String CONFIG_DOWNADJ_ENABLE = "AutoSpeed Download Adj Enable";
    private static final String CONFIG_DOWNADJ_RATIO = "AutoSpeed Download Adj Ratio";
    private static final String CONFIG_LATENCY_FACTOR = "AutoSpeed Latency Factor";
    private static final String CONFIG_DEBUG = "Auto Upload Speed Debug Enabled";
    private static final String[] CONFIG_PARAMS = new String[]{"AutoSpeed Min Upload KBs", "AutoSpeed Max Upload KBs", "AutoSpeed Max Increment KBs", "AutoSpeed Max Decrement KBs", "AutoSpeed Choking Ping Millis", "AutoSpeed Download Adj Enable", "AutoSpeed Download Adj Ratio", "AutoSpeed Latency Factor", "Auto Upload Speed Debug Enabled"};
    private static int PING_CHOKE_TIME;
    private static int MIN_UP;
    private static int MAX_UP;
    private static boolean DEBUG;
    private static boolean ADJUST_DOWNLOAD_ENABLE;
    private static float ADJUST_DOWNLOAD_RATIO;
    private static int MAX_INCREMENT;
    private static int MAX_DECREMENT;
    private static int LATENCY_FACTOR;
    private static final int FORCED_MAX_TICKS = 30;
    private static final int FORCED_MIN_TICKS = 60;
    private static final int FORCED_MIN_AT_START_TICK_LIMIT = 60;
    private static final int FORCED_MIN_SPEED = 4096;
    private static final int PING_AVERAGE_HISTORY_COUNT = 5;
    private static final int IDLE_UPLOAD_SPEED = 5120;
    private static final int INITIAL_IDLE_AVERAGE = 100;
    private static final int MIN_IDLE_AVERAGE = 50;
    private static final int INCREASING = 1;
    private static final int DECREASING = 2;
    private AzureusCore core;
    private DHTSpeedTester speed_tester;
    private SpeedManagerAdapter adapter;
    private boolean enabled;
    private Average upload_average = AverageFactory.MovingImmediateAverage(5);
    private Average upload_short_average = AverageFactory.MovingImmediateAverage(2);
    private Average upload_short_prot_average = AverageFactory.MovingImmediateAverage(2);
    private Average ping_average_history = AverageFactory.MovingImmediateAverage(5);
    private Average choke_speed_average = AverageFactory.MovingImmediateAverage(3);
    private int mode;
    private volatile int mode_ticks;
    private int saved_limit;
    private int direction;
    private int ticks;
    private int idle_ticks;
    private int idle_average;
    private boolean idle_average_set;
    private int max_ping;
    private int max_upload_average;
    private Map contacts = new HashMap();
    private volatile int total_contacts;
    private volatile int replacement_contacts;
    private SpeedManagerPingSource[] contacts_array = new SpeedManagerPingSource[0];

    protected void reset() {
        this.ticks = 0;
        this.mode = 0;
        this.mode_ticks = 0;
        this.idle_ticks = 0;
        this.idle_average = 100;
        this.idle_average_set = false;
        this.max_upload_average = 0;
        this.direction = 1;
        this.total_contacts = 0;
        this.replacement_contacts = 0;
        this.max_ping = 0;
        this.choke_speed_average.reset();
        this.upload_average.reset();
        this.upload_short_average.reset();
        this.upload_short_prot_average.reset();
        this.ping_average_history.reset();
    }

    public SpeedManagerImpl(AzureusCore _core, SpeedManagerAdapter _adapter) {
        this.core = _core;
        this.adapter = _adapter;
        COConfigurationManager.setParameter(CONFIG_AVAIL, false);
        this.reset();
    }

    public void setSpeedTester(DHTSpeedTester _tester) {
        if (this.speed_tester != null) {
            Debug.out("speed tester already set!");
            return;
        }
        COConfigurationManager.setParameter(CONFIG_AVAIL, true);
        this.speed_tester = _tester;
        this.speed_tester.addListener(new DHTSpeedTesterListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void contactAdded(DHTSpeedTesterContact contact) {
                if (SpeedManagerImpl.this.core.getInstanceManager().isLANAddress(contact.getContact().getAddress().getAddress())) {
                    contact.destroy();
                } else {
                    SpeedManagerImpl.this.log("activePing: " + contact.getContact().getString());
                    contact.setPingPeriod(5);
                    Map map = SpeedManagerImpl.this.contacts;
                    synchronized (map) {
                        SpeedManagerImpl.this.contacts.put(contact, new pingContact(contact));
                        SpeedManagerImpl.access$1102(SpeedManagerImpl.this, new SpeedManagerPingSource[SpeedManagerImpl.this.contacts.size()]);
                        SpeedManagerImpl.this.contacts.values().toArray(SpeedManagerImpl.this.contacts_array);
                    }
                    SpeedManagerImpl.this.total_contacts++;
                    if (SpeedManagerImpl.this.total_contacts > 3) {
                        SpeedManagerImpl.this.replacement_contacts++;
                    }
                    contact.addListener(new DHTSpeedTesterContactListener(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void ping(DHTSpeedTesterContact contact, int round_trip_time) {
                        }

                        public void pingFailed(DHTSpeedTesterContact contact) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void contactDied(DHTSpeedTesterContact contact) {
                            2.access$1400(this.this$1).log("deadPing: " + contact.getContact().getString());
                            Map map = SpeedManagerImpl.access$1000(2.access$1400(this.this$1));
                            synchronized (map) {
                                SpeedManagerImpl.access$1000(2.access$1400(this.this$1)).remove(contact);
                                SpeedManagerImpl.access$1102(2.access$1400(this.this$1), new SpeedManagerPingSource[SpeedManagerImpl.access$1000(2.access$1400(this.this$1)).size()]);
                                SpeedManagerImpl.access$1000(2.access$1400(this.this$1)).values().toArray(SpeedManagerImpl.access$1100(2.access$1400(this.this$1)));
                            }
                        }
                    });
                }
            }

            public void resultGroup(DHTSpeedTesterContact[] contacts, int[] round_trip_times) {
                SpeedManagerImpl.this.calculate(contacts, round_trip_times);
            }

            static /* synthetic */ SpeedManagerImpl access$1400(2 x0) {
                return x0.SpeedManagerImpl.this;
            }
        });
        SimpleTimer.addPeriodicEvent("SpeedManager:stats", 1000L, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                int current_protocol_speed = SpeedManagerImpl.this.adapter.getCurrentProtocolUploadSpeed();
                int current_data_speed = SpeedManagerImpl.this.adapter.getCurrentDataUploadSpeed();
                int current_speed = current_protocol_speed + current_data_speed;
                SpeedManagerImpl.this.upload_average.update(current_speed);
                SpeedManagerImpl.this.upload_short_average.update(current_speed);
                SpeedManagerImpl.this.upload_short_prot_average.update(current_protocol_speed);
                SpeedManagerImpl.this.mode_ticks++;
                SpeedManagerImpl.this.ticks++;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculate(DHTSpeedTesterContact[] rtt_contacts, int[] round_trip_times) {
        int current_limit;
        int up_average;
        if (!this.enabled) {
            for (int i = 0; i < rtt_contacts.length; ++i) {
                rtt_contacts[i].destroy();
            }
            return;
        }
        int min_rtt = Integer.MAX_VALUE;
        for (int i = 0; i < rtt_contacts.length; ++i) {
            int rtt = round_trip_times[i];
            if (rtt <= 0 || rtt >= min_rtt) continue;
            min_rtt = rtt;
        }
        String str = "";
        int ping_total = 0;
        int ping_count = 0;
        for (int i = 0; i < rtt_contacts.length; ++i) {
            pingContact pc;
            Map map = this.contacts;
            synchronized (map) {
                pc = (pingContact)this.contacts.get(rtt_contacts[i]);
            }
            int rtt = round_trip_times[i];
            str = str + (i == 0 ? "" : ",") + rtt;
            if (pc != null) {
                boolean good_ping = rtt < 5 * Math.max(min_rtt, 75);
                pc.pingReceived(rtt, good_ping);
                if (!good_ping) {
                    rtt = -1;
                }
            }
            if (rtt == -1) continue;
            ping_total += round_trip_times[i];
            ++ping_count;
        }
        if (ping_count == 0) {
            return;
        }
        int ping_average = ping_total / ping_count;
        int running_average = (int)this.ping_average_history.update(ping_average);
        if (ping_average > this.max_ping) {
            this.max_ping = ping_average;
        }
        if ((up_average = (int)this.upload_average.getAverage()) <= 5120 || running_average < this.idle_average && !this.idle_average_set) {
            ++this.idle_ticks;
            if (this.idle_ticks >= 5) {
                this.idle_average = Math.max(running_average, 50);
                this.log("New idle average: " + this.idle_average);
                this.idle_average_set = true;
            }
        } else {
            if (up_average > this.max_upload_average) {
                this.max_upload_average = up_average;
                this.log("New max upload:" + this.max_upload_average);
            }
            this.idle_ticks = 0;
        }
        if (this.idle_average_set && running_average < this.idle_average) {
            this.idle_average = Math.max(running_average, 50);
        }
        int current_speed = this.adapter.getCurrentDataUploadSpeed() + this.adapter.getCurrentProtocolUploadSpeed();
        int new_limit = current_limit = this.adapter.getCurrentUploadLimit();
        this.log("Pings: " + str + ", average=" + ping_average + ", running_average=" + running_average + ",idle_average=" + this.idle_average + ", speed=" + current_speed + ",limit=" + current_limit + ",choke = " + (int)this.choke_speed_average.getAverage());
        if (this.mode == 2) {
            if (this.mode_ticks > 30) {
                this.mode = 0;
                current_limit = new_limit = this.saved_limit;
            }
        } else if (this.mode == 1) {
            if (this.idle_average_set || this.mode_ticks > 60) {
                this.log("Mode -> running");
                if (!this.idle_average_set) {
                    this.idle_average = Math.max(running_average, 50);
                    this.idle_average_set = true;
                }
                this.mode = 0;
                this.mode_ticks = 0;
                current_limit = new_limit = this.saved_limit;
            } else if (this.mode_ticks == 5) {
                this.ping_average_history.reset();
            }
        }
        if (this.mode == 0) {
            if (this.ticks > 60 && !this.idle_average_set || this.replacement_contacts >= 2 && this.idle_average_set) {
                this.log("Mode -> forced min");
                this.mode = 1;
                this.mode_ticks = 0;
                this.saved_limit = current_limit;
                this.idle_average_set = false;
                this.idle_ticks = 0;
                this.replacement_contacts = 0;
                new_limit = 4096;
            } else {
                int short_up = (int)this.upload_short_average.getAverage();
                int choke_speed = (int)this.choke_speed_average.getAverage();
                if (running_average < 2 * this.idle_average && ping_average < PING_CHOKE_TIME) {
                    this.direction = 1;
                    int diff = running_average - this.idle_average;
                    if (diff < 100) {
                        diff = 100;
                    }
                    int increment = 1024 * (diff / LATENCY_FACTOR);
                    int max_inc = MAX_INCREMENT;
                    if (new_limit + 2048 > choke_speed) {
                        max_inc = 1024;
                    } else if (new_limit + 5120 > choke_speed) {
                        max_inc += 3072;
                    }
                    new_limit += Math.min(increment, max_inc);
                } else if (ping_average > 4 * this.idle_average || ping_average > PING_CHOKE_TIME) {
                    if (this.direction == 1 && this.idle_average_set) {
                        this.choke_speed_average.update(short_up);
                    }
                    this.direction = 2;
                    int decrement = 1024 * ((ping_average - 3 * this.idle_average) / LATENCY_FACTOR);
                    if ((double)(new_limit -= Math.min(decrement, MAX_DECREMENT)) < this.upload_short_prot_average.getAverage() + 1024.0) {
                        new_limit = (int)this.upload_short_prot_average.getAverage() + 1024;
                    }
                }
                if (new_limit < 1024) {
                    new_limit = 1024;
                }
            }
            if (MIN_UP > 0 && new_limit < MIN_UP && this.mode != 1) {
                new_limit = MIN_UP;
            } else if (MAX_UP > 0 && new_limit > MAX_UP && this.mode != 2) {
                new_limit = MAX_UP;
            }
            if (new_limit > current_limit && current_speed < current_limit - 10240) {
                new_limit = current_limit;
            }
        }
        if (this.enabled) {
            new_limit = (new_limit + 1023) / 1024 * 1024;
            this.adapter.setCurrentUploadLimit(new_limit);
            if (ADJUST_DOWNLOAD_ENABLE && !Float.isInfinite(ADJUST_DOWNLOAD_RATIO) && !Float.isNaN(ADJUST_DOWNLOAD_RATIO)) {
                int dl_limit = (int)((float)new_limit * ADJUST_DOWNLOAD_RATIO);
                this.adapter.setCurrentDownloadLimit(dl_limit);
            }
        }
    }

    public boolean isAvailable() {
        return this.speed_tester != null;
    }

    public void setMinumumUploadSpeed(int speed) {
        COConfigurationManager.setParameter(CONFIG_MIN_UP, speed);
    }

    public int getMinumumUploadSpeed() {
        return MIN_UP;
    }

    public void setMaximumUploadSpeed(int speed) {
        COConfigurationManager.setParameter(CONFIG_MAX_UP, speed);
    }

    public int getMaximumUploadSpeed() {
        return MAX_UP;
    }

    public int getChokePingTime() {
        return PING_CHOKE_TIME;
    }

    public void setChokePingTime(int milliseconds) {
        COConfigurationManager.setParameter(CONFIG_CHOKE_PING, milliseconds);
    }

    public void setEnabled(boolean _enabled) {
        if (this.enabled != _enabled) {
            this.reset();
            this.enabled = _enabled;
            if (this.speed_tester != null) {
                this.speed_tester.setContactNumber(this.enabled ? 3 : 0);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DHTSpeedTester getSpeedTester() {
        return this.speed_tester;
    }

    public SpeedManagerPingSource[] getPingSources() {
        return this.contacts_array;
    }

    public int getIdlePingMillis() {
        return this.idle_average;
    }

    public int getCurrentPingMillis() {
        return (int)this.ping_average_history.getAverage();
    }

    public int getMaxPingMillis() {
        return this.max_ping;
    }

    public int getCurrentChokeSpeed() {
        return (int)this.choke_speed_average.getAverage();
    }

    public int getMaxUploadSpeed() {
        return this.max_upload_average;
    }

    protected void log(String str) {
        if (DEBUG) {
            System.out.println(str);
        }
    }

    static /* synthetic */ SpeedManagerPingSource[] access$1102(SpeedManagerImpl x0, SpeedManagerPingSource[] x1) {
        x0.contacts_array = x1;
        return x1;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(CONFIG_PARAMS, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                PING_CHOKE_TIME = COConfigurationManager.getIntParameter(SpeedManagerImpl.CONFIG_CHOKE_PING);
                MIN_UP = COConfigurationManager.getIntParameter(SpeedManagerImpl.CONFIG_MIN_UP) * 1024;
                MAX_UP = COConfigurationManager.getIntParameter(SpeedManagerImpl.CONFIG_MAX_UP) * 1024;
                MAX_INCREMENT = COConfigurationManager.getIntParameter(SpeedManagerImpl.CONFIG_MAX_INC) * 1024;
                MAX_DECREMENT = COConfigurationManager.getIntParameter(SpeedManagerImpl.CONFIG_MAX_DEC) * 1024;
                ADJUST_DOWNLOAD_ENABLE = COConfigurationManager.getBooleanParameter(SpeedManagerImpl.CONFIG_DOWNADJ_ENABLE);
                String str = COConfigurationManager.getStringParameter(SpeedManagerImpl.CONFIG_DOWNADJ_RATIO);
                LATENCY_FACTOR = COConfigurationManager.getIntParameter(SpeedManagerImpl.CONFIG_LATENCY_FACTOR);
                if (LATENCY_FACTOR < 1) {
                    LATENCY_FACTOR = 1;
                }
                DEBUG = COConfigurationManager.getBooleanParameter(SpeedManagerImpl.CONFIG_DEBUG);
                try {
                    ADJUST_DOWNLOAD_RATIO = Float.parseFloat(str);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    protected class pingContact
    implements SpeedManagerPingSource {
        private DHTSpeedTesterContact contact;
        private int bad_pings;
        private int last_good_ping;

        protected pingContact(DHTSpeedTesterContact _contact) {
            this.contact = _contact;
        }

        void pingReceived(int time, boolean good_ping) {
            if (good_ping) {
                this.bad_pings = 0;
                this.last_good_ping = time;
            } else {
                ++this.bad_pings;
            }
            if (this.bad_pings == 3) {
                this.contact.destroy();
            }
        }

        public InetSocketAddress getAddress() {
            return this.contact.getContact().getAddress();
        }

        public int getPingTime() {
            return this.last_good_ping;
        }
    }
}

