/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelector;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelectorFactory;
import com.aelitis.azureus.core.networkmanager.impl.IncomingConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TransportCryptoManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Date;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class IncomingSocketChannelManager {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private int tcp_listen_port = COConfigurationManager.getIntParameter("TCP.Listen.Port");
    private int so_rcvbuf_size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_RCVBUF");
    private String bind_address = COConfigurationManager.getStringParameter("Bind IP");
    private VirtualServerChannelSelector server_selector = null;
    private IncomingConnectionManager incoming_manager = IncomingConnectionManager.getSingleton();
    protected AEMonitor this_mon = new AEMonitor("IncomingSocketChannelManager");
    int listen_fail_count = 0;

    public IncomingSocketChannelManager() {
        COConfigurationManager.addParameterListener("TCP.Listen.Port", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                int port = COConfigurationManager.getIntParameter("TCP.Listen.Port");
                if (port != IncomingSocketChannelManager.this.tcp_listen_port) {
                    IncomingSocketChannelManager.this.tcp_listen_port = port;
                    IncomingSocketChannelManager.this.restart();
                }
            }
        });
        COConfigurationManager.addParameterListener("TCP.Listen.Port.Enable", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                IncomingSocketChannelManager.this.restart();
            }
        });
        COConfigurationManager.addParameterListener("network.tcp.socket.SO_RCVBUF", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                int size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_RCVBUF");
                if (size != IncomingSocketChannelManager.this.so_rcvbuf_size) {
                    IncomingSocketChannelManager.this.so_rcvbuf_size = size;
                    IncomingSocketChannelManager.this.restart();
                }
            }
        });
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                String address = COConfigurationManager.getStringParameter("Bind IP");
                if (!address.equals(IncomingSocketChannelManager.this.bind_address)) {
                    IncomingSocketChannelManager.this.bind_address = address;
                    IncomingSocketChannelManager.this.restart();
                }
            }
        });
        this.start();
        SimpleTimer.addPeriodicEvent("IncomingSocketChannelManager:concheck", 60000L, new TimerEventPerformer(){

            public void perform(TimerEvent ev) {
                block8: {
                    if (IncomingSocketChannelManager.this.server_selector != null && IncomingSocketChannelManager.this.server_selector.isRunning()) {
                        long accept_idle = SystemTime.getCurrentTime() - IncomingSocketChannelManager.this.server_selector.getTimeOfLastAccept();
                        if (accept_idle > 600000L) {
                            InetAddress inet_address = IncomingSocketChannelManager.this.server_selector.getBoundToAddress();
                            try {
                                if (inet_address == null) {
                                    inet_address = InetAddress.getByName("127.0.0.1");
                                }
                                Socket sock = new Socket(inet_address, IncomingSocketChannelManager.this.tcp_listen_port, inet_address, 0);
                                sock.close();
                                IncomingSocketChannelManager.this.listen_fail_count = 0;
                            }
                            catch (Throwable t) {
                                try {
                                    Socket sock = new Socket(InetAddress.getByName("127.0.0.1"), IncomingSocketChannelManager.this.tcp_listen_port);
                                    sock.close();
                                    IncomingSocketChannelManager.this.listen_fail_count = 0;
                                    break block8;
                                }
                                catch (Throwable x) {
                                    ++IncomingSocketChannelManager.this.listen_fail_count;
                                    Debug.out(new Date() + ": listen port on [" + inet_address + ": " + IncomingSocketChannelManager.this.tcp_listen_port + "] seems CLOSED [" + IncomingSocketChannelManager.this.listen_fail_count + "x]");
                                    if (IncomingSocketChannelManager.this.listen_fail_count > 4) {
                                        String error = t.getMessage() == null ? "<null>" : t.getMessage();
                                        String msg = "Listen server socket on [" + inet_address + ": " + IncomingSocketChannelManager.this.tcp_listen_port + "] does not appear to be accepting inbound connections.\n[" + error + "]\nAuto-repairing listen service....\n";
                                        Logger.log(new LogAlert(false, 1, msg));
                                        IncomingSocketChannelManager.this.restart();
                                        IncomingSocketChannelManager.this.listen_fail_count = 0;
                                    }
                                    break block8;
                                }
                            }
                        }
                        IncomingSocketChannelManager.this.listen_fail_count = 0;
                    }
                }
            }
        });
    }

    public int getTCPListeningPortNumber() {
        return this.tcp_listen_port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        block7: {
            try {
                this.this_mon.enter();
                if (this.tcp_listen_port < 0 || this.tcp_listen_port > 65535 || this.tcp_listen_port == 6880) {
                    String msg = "Invalid incoming TCP listen port configured, " + this.tcp_listen_port + ". Port reset to default. Please check your config!";
                    Debug.out(msg);
                    Logger.log(new LogAlert(false, 3, msg));
                    this.tcp_listen_port = RandomUtils.generateRandomNetworkListenPort();
                    COConfigurationManager.setParameter("TCP.Listen.Port", this.tcp_listen_port);
                }
                if (COConfigurationManager.getBooleanParameter("TCP.Listen.Port.Enable")) {
                    InetSocketAddress address;
                    if (this.server_selector != null) break block7;
                    try {
                        address = this.bind_address.length() > 6 ? new InetSocketAddress(InetAddress.getByName(this.bind_address), this.tcp_listen_port) : new InetSocketAddress(this.tcp_listen_port);
                    }
                    catch (UnknownHostException e) {
                        Debug.out(e);
                        address = new InetSocketAddress(this.tcp_listen_port);
                    }
                    this.server_selector = VirtualServerChannelSelectorFactory.createTest(address, this.so_rcvbuf_size, new VirtualServerChannelSelector.SelectListener(){

                        public void newConnectionAccepted(ServerSocketChannel server, SocketChannel channel) {
                            TCPTransportHelper helper = new TCPTransportHelper(channel);
                            TransportCryptoManager.getSingleton().manageCrypto(helper, null, true, null, new TransportCryptoManager.HandshakeListener(this, server, channel, helper){
                                private final /* synthetic */ ServerSocketChannel val$server;
                                private final /* synthetic */ SocketChannel val$channel;
                                private final /* synthetic */ TCPTransportHelper val$helper;
                                private final /* synthetic */ 6 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$server = val$server;
                                    this.val$channel = val$channel;
                                    this.val$helper = val$helper;
                                }

                                public void handshakeSuccess(ProtocolDecoder decoder, ByteBuffer remaining_initial_data) {
                                    6.access$500(this.this$1).process(this.val$server.socket().getLocalPort(), decoder.getFilter());
                                }

                                public void handshakeFailure(Throwable failure_msg) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(IncomingSocketChannelManager.access$600(), "incoming crypto handshake failure: " + Debug.getNestedExceptionMessage(failure_msg)));
                                    }
                                    TCPNetworkManager.getSingleton().closeSocketChannel(this.val$channel);
                                }

                                public void gotSecret(byte[] session_secret) {
                                }

                                public int getMaximumPlainHeaderLength() {
                                    return IncomingSocketChannelManager.access$700(6.access$500(this.this$1)).getMaxMinMatchBufferSize();
                                }

                                public int matchPlainHeader(ByteBuffer buffer) {
                                    Object[] match_data = IncomingSocketChannelManager.access$700(6.access$500(this.this$1)).checkForMatch(this.val$helper, this.val$server.socket().getLocalPort(), buffer, true);
                                    if (match_data == null) {
                                        return 1;
                                    }
                                    IncomingConnectionManager.MatchListener match = (IncomingConnectionManager.MatchListener)match_data[0];
                                    if (match.autoCryptoFallback()) {
                                        return 3;
                                    }
                                    return 2;
                                }
                            });
                        }

                        static /* synthetic */ IncomingSocketChannelManager access$500(6 x0) {
                            return x0.IncomingSocketChannelManager.this;
                        }
                    });
                    this.server_selector.start();
                    break block7;
                }
                Logger.log(new LogEvent(LOGID, "Not starting TCP listener on port " + this.tcp_listen_port + " as protocol disabled"));
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected void process(int local_port, TransportHelperFilter filter) {
        SocketChannel channel = ((TCPTransportHelper)filter.getHelper()).getSocketChannel();
        try {
            String ip_tos;
            int so_sndbuf_size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_SNDBUF");
            if (so_sndbuf_size > 0) {
                channel.socket().setSendBufferSize(so_sndbuf_size);
            }
            if ((ip_tos = COConfigurationManager.getStringParameter("network.tcp.socket.IPTOS")).length() > 0) {
                channel.socket().setTrafficClass(Integer.decode(ip_tos));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        InetSocketAddress tcp_address = new InetSocketAddress(channel.socket().getInetAddress(), channel.socket().getPort());
        ConnectionEndpoint co_ep = new ConnectionEndpoint(tcp_address);
        ProtocolEndpointTCP pe_tcp = new ProtocolEndpointTCP(co_ep, tcp_address);
        TCPTransportImpl transport = new TCPTransportImpl(pe_tcp, filter);
        this.incoming_manager.addConnection(local_port, filter, transport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart() {
        try {
            this.this_mon.enter();
            if (this.server_selector != null) {
                this.server_selector.stop();
                this.server_selector = null;
            }
        }
        finally {
            this.this_mon.exit();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.start();
    }

    static /* synthetic */ LogIDs access$600() {
        return LOGID;
    }

    static /* synthetic */ IncomingConnectionManager access$700(IncomingSocketChannelManager x0) {
        return x0.incoming_manager;
    }
}

