/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.ext_viewer.jgoodies.looks.plastic;

import com.tonicsystems.ext_viewer.jgoodies.looks.common.ExtBasicArrowButtonHandler;
import com.tonicsystems.ext_viewer.jgoodies.looks.common.ExtBasicSpinnerLayout;
import com.tonicsystems.ext_viewer.jgoodies.looks.plastic.PlasticArrowButton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class PlasticSpinnerUI
extends BasicSpinnerUI {
    private static final Border MARGIN_BORDER = new BorderUIResource(new BasicBorders.MarginBorder());
    private static final ExtBasicArrowButtonHandler nextButtonHandler = new ExtBasicArrowButtonHandler("increment", true);
    private static final ExtBasicArrowButtonHandler previousButtonHandler = new ExtBasicArrowButtonHandler("decrement", false);

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticSpinnerUI();
    }

    protected Component createPreviousButton() {
        return new SpinnerArrowButton(5, previousButtonHandler);
    }

    protected Component createNextButton() {
        return new SpinnerArrowButton(1, nextButtonHandler);
    }

    protected LayoutManager createLayout() {
        return new ExtBasicSpinnerLayout();
    }

    protected JComponent createEditor() {
        JComponent jComponent = this.spinner.getEditor();
        this.configureEditor(jComponent);
        return jComponent;
    }

    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        this.configureEditor(jComponent2);
        this.spinner.add((Component)jComponent2, "Editor");
    }

    private void configureEditor(JComponent jComponent) {
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            defaultEditor.getTextField().getUI();
            defaultEditor.getTextField().setBorder(MARGIN_BORDER);
            Insets insets = UIManager.getInsets("Spinner.defaultEditorInsets");
            defaultEditor.getTextField().setMargin(insets);
        }
    }

    private static final class SpinnerArrowButton
    extends PlasticArrowButton {
        private SpinnerArrowButton(int n2, ExtBasicArrowButtonHandler extBasicArrowButtonHandler) {
            super(n2, UIManager.getInt("ScrollBar.width"), true);
            this.addActionListener(extBasicArrowButtonHandler);
            this.addMouseListener(extBasicArrowButtonHandler);
        }

        protected int calculateArrowHeight(int n2, int n3) {
            int n4 = Math.min((n2 - 4) / 3, (n3 - 4) / 3);
            return Math.max(n4, 3);
        }

        protected int calculateArrowOffset() {
            return 1;
        }

        protected boolean isPaintingNorthBottom() {
            return true;
        }
    }
}

