/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.ext_viewer.jgoodies.looks.plastic;

import com.tonicsystems.ext_viewer.jgoodies.looks.plastic.PlasticArrowButton;
import com.tonicsystems.ext_viewer.jgoodies.looks.plastic.PlasticBumps;
import com.tonicsystems.ext_viewer.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public final class PlasticScrollBarUI
extends MetalScrollBarUI {
    private static final String PROPERTY_PREFIX = "ScrollBar.";
    public static final String MAX_BUMPS_WIDTH_KEY = "ScrollBar.maxBumpsWidth";
    private static Color shadowColor;
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    private PlasticBumps bumps;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticScrollBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.bumps = new PlasticBumps(10, 10, thumbHighlightColor, thumbShadow, thumbColor);
    }

    protected JButton createDecreaseButton(int n2) {
        this.decreaseButton = new PlasticArrowButton(n2, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int n2) {
        this.increaseButton = new PlasticArrowButton(n2, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        shadowColor = UIManager.getColor("ScrollBar.shadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        thumbColor = UIManager.getColor("ScrollBar.thumb");
        thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.translate(rectangle.x, rectangle.y);
        boolean bl = PlasticUtils.isLeftToRight(jComponent);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                if (!bl) {
                    ++rectangle.width;
                    graphics.translate(-1, 0);
                } else {
                    rectangle.width += 2;
                }
            }
            if (jComponent.isEnabled()) {
                graphics.setColor(darkShadowColor);
                graphics.drawLine(0, 0, 0, rectangle.height - 1);
                graphics.drawLine(rectangle.width - 2, 0, rectangle.width - 2, rectangle.height - 1);
                graphics.drawLine(1, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
                graphics.drawLine(1, 0, rectangle.width - 2, 0);
                graphics.setColor(shadowColor);
                graphics.drawLine(1, 1, 1, rectangle.height - 2);
                graphics.drawLine(1, 1, rectangle.width - 3, 1);
                if (this.scrollbar.getValue() != this.scrollbar.getMaximum()) {
                    int n2 = this.thumbRect.y + this.thumbRect.height - rectangle.y;
                    graphics.drawLine(1, n2, rectangle.width - 1, n2);
                }
                graphics.setColor(highlightColor);
                graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
            } else {
                PlasticUtils.drawDisabledBorder(graphics, 0, 0, rectangle.width, rectangle.height);
            }
            if (!this.isFreeStanding) {
                if (!bl) {
                    --rectangle.width;
                    graphics.translate(1, 0);
                } else {
                    rectangle.width -= 2;
                }
            }
        } else {
            if (!this.isFreeStanding) {
                rectangle.height += 2;
            }
            if (jComponent.isEnabled()) {
                graphics.setColor(darkShadowColor);
                graphics.drawLine(0, 0, rectangle.width - 1, 0);
                graphics.drawLine(0, 1, 0, rectangle.height - 2);
                graphics.drawLine(0, rectangle.height - 2, rectangle.width - 1, rectangle.height - 2);
                graphics.drawLine(rectangle.width - 1, 1, rectangle.width - 1, rectangle.height - 1);
                graphics.setColor(shadowColor);
                graphics.drawLine(1, 1, rectangle.width - 2, 1);
                graphics.drawLine(1, 1, 1, rectangle.height - 3);
                graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
                if (this.scrollbar.getValue() != this.scrollbar.getMaximum()) {
                    int n3 = this.thumbRect.x + this.thumbRect.width - rectangle.x;
                    graphics.drawLine(n3, 1, n3, rectangle.height - 1);
                }
            } else {
                PlasticUtils.drawDisabledBorder(graphics, 0, 0, rectangle.width, rectangle.height);
            }
            if (!this.isFreeStanding) {
                rectangle.height -= 2;
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (!jComponent.isEnabled()) {
            return;
        }
        boolean bl = PlasticUtils.isLeftToRight(jComponent);
        graphics.translate(rectangle.x, rectangle.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                if (!bl) {
                    ++rectangle.width;
                    graphics.translate(-1, 0);
                } else {
                    rectangle.width += 2;
                }
            }
            graphics.setColor(thumbColor);
            graphics.fillRect(0, 0, rectangle.width - 2, rectangle.height - 1);
            graphics.setColor(thumbShadow);
            graphics.drawRect(0, 0, rectangle.width - 2, rectangle.height - 1);
            graphics.setColor(thumbHighlightColor);
            graphics.drawLine(1, 1, rectangle.width - 3, 1);
            graphics.drawLine(1, 1, 1, rectangle.height - 2);
            this.paintBumps(graphics, jComponent, 3, 4, rectangle.width - 6, rectangle.height - 7);
            if (!this.isFreeStanding) {
                if (!bl) {
                    --rectangle.width;
                    graphics.translate(1, 0);
                } else {
                    rectangle.width -= 2;
                }
            }
        } else {
            if (!this.isFreeStanding) {
                rectangle.height += 2;
            }
            graphics.setColor(thumbColor);
            graphics.fillRect(0, 0, rectangle.width - 1, rectangle.height - 2);
            graphics.setColor(thumbShadow);
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 2);
            graphics.setColor(thumbHighlightColor);
            graphics.drawLine(1, 1, rectangle.width - 2, 1);
            graphics.drawLine(1, 1, 1, rectangle.height - 3);
            this.paintBumps(graphics, jComponent, 4, 3, rectangle.width - 7, rectangle.height - 6);
            if (!this.isFreeStanding) {
                rectangle.height -= 2;
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
        if (PlasticUtils.is3D(PROPERTY_PREFIX)) {
            this.paintThumb3D(graphics, rectangle);
        }
    }

    private void paintBumps(Graphics graphics, JComponent jComponent, int n2, int n3, int n4, int n5) {
        if (!this.useNarrowBumps()) {
            this.bumps.setBumpArea(n4, n5);
            this.bumps.paintIcon(jComponent, graphics, n2, n3);
        } else {
            int n6 = UIManager.getInt(MAX_BUMPS_WIDTH_KEY);
            int n7 = Math.min(n6, n4);
            int n8 = Math.min(n6, n5);
            int n9 = n2 + (n4 - n7) / 2;
            int n10 = n3 + (n5 - n8) / 2;
            this.bumps.setBumpArea(n7, n8);
            this.bumps.paintIcon(jComponent, graphics, n9, n10);
        }
    }

    private void paintThumb3D(Graphics graphics, Rectangle rectangle) {
        boolean bl = this.scrollbar.getOrientation() == 0;
        int n2 = rectangle.width - (bl ? 3 : 1);
        int n3 = rectangle.height - (bl ? 1 : 3);
        Rectangle rectangle2 = new Rectangle(rectangle.x + 2, rectangle.y + 2, n2, n3);
        PlasticUtils.addLight3DEffekt(graphics, rectangle2, bl);
    }

    private boolean useNarrowBumps() {
        Object object = UIManager.get(MAX_BUMPS_WIDTH_KEY);
        return object != null && object instanceof Integer;
    }
}

