/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.ext_viewer.jgoodies.looks;

import com.tonicsystems.ext_viewer.jgoodies.looks.LookUtils;

public final class FontSizeHints {
    public static final FontSizeHints LARGE = new FontSizeHints(12, 12, 14, 14);
    public static final FontSizeHints SYSTEM = new FontSizeHints(11, 11, 14, 14);
    public static final FontSizeHints MIXED2 = new FontSizeHints(11, 11, 14, 13);
    public static final FontSizeHints MIXED = new FontSizeHints(11, 11, 14, 12);
    public static final FontSizeHints SMALL = new FontSizeHints(11, 11, 12, 12);
    public static final FontSizeHints FIXED = new FontSizeHints(12, 12, 12, 12);
    public static final FontSizeHints DEFAULT = SYSTEM;
    private final int loResMenuFontSize;
    private final int loResControlFontSize;
    private final int hiResMenuFontSize;
    private final int hiResControlFontSize;

    public FontSizeHints(int n2, int n3, int n4, int n5) {
        this.loResMenuFontSize = n2;
        this.loResControlFontSize = n3;
        this.hiResMenuFontSize = n4;
        this.hiResControlFontSize = n5;
    }

    public int loResMenuFontSize() {
        return this.loResMenuFontSize;
    }

    public int loResControlFontSize() {
        return this.loResControlFontSize;
    }

    public int hiResMenuFontSize() {
        return this.hiResMenuFontSize;
    }

    public int hiResControlFontSize() {
        return this.hiResControlFontSize;
    }

    public int menuFontSize() {
        return LookUtils.IS_LOW_RESOLUTION ? this.loResMenuFontSize : this.hiResMenuFontSize();
    }

    public int controlFontSize() {
        return LookUtils.IS_LOW_RESOLUTION ? this.loResControlFontSize : this.hiResControlFontSize();
    }

    public float menuFontSizeDelta() {
        return this.menuFontSize() - SYSTEM.menuFontSize();
    }

    public float controlFontSizeDelta() {
        return this.controlFontSize() - SYSTEM.controlFontSize();
    }

    public static FontSizeHints valueOf(String string) {
        if (string.equalsIgnoreCase("LARGE")) {
            return LARGE;
        }
        if (string.equalsIgnoreCase("SYSTEM")) {
            return SYSTEM;
        }
        if (string.equalsIgnoreCase("MIXED")) {
            return MIXED;
        }
        if (string.equalsIgnoreCase("SMALL")) {
            return SMALL;
        }
        if (string.equalsIgnoreCase("FIXED")) {
            return FIXED;
        }
        throw new IllegalArgumentException("Unknown font size hints name: " + string);
    }
}

