/*
Copyright (c) 2006-2007, Tom Thielicke IT Solutions

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301, USA.
*/

/****************************************************************
**
** Implementation of the HelpBrowser class
** File name: helpbrowser.cpp
**
****************************************************************/

#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QCoreApplication>

#include "helpbrowser.h"

HelpBrowser::HelpBrowser(QString link, QWidget *parent) : QDialog(parent) {
	setWindowTitle(QObject::tr("Hilfe"));
	setWindowIcon(QIcon("img/icon.ico"));
	//setModal(false);
	// Create buttons
    createButtons();

	textBrowser = new QTextBrowser(this);
    textBrowser->setSource(QString("file:///") + QCoreApplication::applicationDirPath() + QString("/help/index.html"));
    if (link != "") {
		textBrowser->setSource(QString("file:///") + QCoreApplication::applicationDirPath() + QString("/help/content/") + link);
	}

	// Set the layout of all widgets created above
	createLayout();

	// Widget connections
    connect(buttonClose, SIGNAL(clicked()), this, SLOT(clickClose()));
	connect(buttonBack, SIGNAL(clicked()), textBrowser, SLOT(backward()));
	connect(buttonHome, SIGNAL(clicked()), textBrowser, SLOT(home()));
	connect(textBrowser, SIGNAL(sourceChanged(QUrl)), this, SLOT(changePage(QUrl)));
	connect(textBrowser, SIGNAL(backwardAvailable(bool)), buttonBack,
		SLOT(setEnabled(bool)));

	setWindowTitle(QObject::tr("Hilfe"));
	setWindowIcon(QIcon("img/icon.ico"));

    buttonClose->setFocus();

    resize(760, 500);
}

void HelpBrowser::createButtons() {
	//Buttons
	buttonBack = new QPushButton(QIcon(":/img/help_arrow_left.png"), QObject::tr(" Zurck"));
	buttonBack->setEnabled(false);
	buttonHome = new QPushButton(QIcon(":/img/help_home.png"), QObject::tr(" Inhaltsverzeichnis"));
	buttonClose = new QPushButton(QObject::tr("&Schlieen"));
	buttonClose->setDefault(true);
}

void HelpBrowser::createLayout() {
	// Button layout horizontal
	QHBoxLayout *buttonLayoutTop = new QHBoxLayout;
    buttonLayoutTop->addWidget(buttonBack);
    buttonLayoutTop->addWidget(buttonHome);
    buttonLayoutTop->addStretch(1);
	// Center layout horizontal
	QHBoxLayout *layoutHorizontal = new QHBoxLayout;
    layoutHorizontal->addSpacing(1);
    layoutHorizontal->addWidget(textBrowser);
    layoutHorizontal->addSpacing(1);
	// Button layout horizontal
	QHBoxLayout *buttonLayoutBottom = new QHBoxLayout;
    buttonLayoutBottom->addStretch(1);
    buttonLayoutBottom->addWidget(buttonClose);
	// Full layout of all widgets vertical
	QVBoxLayout *mainLayout = new QVBoxLayout;
    mainLayout->addLayout(buttonLayoutTop);
    mainLayout->addLayout(layoutHorizontal);
    mainLayout->addSpacing(1);
    mainLayout->addLayout(buttonLayoutBottom);
    mainLayout->setMargin(15);
    mainLayout->setSpacing(15);
    // Pass layout to parent widget (this)
	this->setLayout(mainLayout);
}

void HelpBrowser::clickClose() {
	accept();
}

void HelpBrowser::changePage(QUrl url) {
	//this->setWindowTitle(url.toString());
}
