/*
Copyright (c) 2006-2007, Tom Thielicke IT Solutions

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301, USA.
*/

/****************************************************************
**
** Implementation of the ErrorMessage class
** File name: errormessage.cpp
**
****************************************************************/

#include <QMessageBox>

#include "errormessage.h"
#include "def/errordefines.h"
#include "def/defines.h"

ErrorMessage::ErrorMessage(QWidget *parent) : QWidget(parent) {
}

void ErrorMessage::showMessage(int errorNo, int errorType, int cancelProcedure,
	QString addon) {
	QString message;
	// First generate the error text
	message = getErrorText(errorNo);
	// If exist, append an additional text
	if (addon != "") {
		message.append("\n" + addon);
	}
	if (cancelProcedure != CANCEL_NO) {
		// Append fix text
		message.append(QObject::tr("\n\nBitte melden Sie den Fehler "
			"(Fehlernummer) und die Umstnde unter denen er aufgetreten "
			"ist im Internet unter: ") + APP_URL
			+ QObject::tr("\nSo kann ") + APP_NAME
			+ QObject::tr(" verbessert werden. Danke!"));
	}

	// Append, what the program do now
	message.append("\n\n" + getCancelText(cancelProcedure));

	// Choose a message style
	switch (errorType) {
		case TYPE_INFO:
			QMessageBox::information(0, APP_NAME, message);
			break;
		case TYPE_WARNING:
			QMessageBox::warning(0, APP_NAME, message);
			break;
		case TYPE_CRITICAL:
		default:
			QMessageBox::critical(0, APP_NAME, message);
			break;
	}
}

QString ErrorMessage::getCancelText(int number) {
	QString cancelText = "";
	switch (number) {
		case CANCEL_NO:
			cancelText = "";
			break;
		case CANCEL_OPERATION:
			cancelText = QObject::tr("Der Vorgang wird abgebrochen.");
			break;
		case CANCEL_UPDATE:
			cancelText = QObject::tr("Das Update wird abgebrochen.");
			break;
		case CANCEL_PROGRAM:
		default:
			cancelText = QObject::tr("Die Anwendung wird beendet.");
			break;
	}
	return cancelText;
}

QString ErrorMessage::getErrorText(int number) {
	QString errorText = "";
	switch (number) {
		case ERR_LOGO_PIC:
			errorText = QObject::tr("Das Programmlogo konnte nicht geladen "
				"werden.");
			break;
		case ERR_KEY_PIC:
			errorText = QObject::tr("Ein Tastatur-Bitmap konnte nicht geladen "
				"werden.");
			break;
		case ERR_TICKER_PIC:
			errorText = QObject::tr("Der Lauftext-Hintergund konnte nicht "
				"geladen werden.");
			break;
		case ERR_STATUS_PIC:
			errorText = QObject::tr("Der Statusleisten-Hintergund konnte "
				"nicht geladen werden.");
			break;

		case ERR_SQL_DB_APP_EXIST:
			errorText = QObject::tr("Die Datenbank ") + APP_DB +
				QObject::tr(" im Programmverzeichnis konnte "
				"leider nicht gefunden werden.\n"
				"Sie muss existieren, um TIPP10 starten zu knnen.");
			break;
		case ERR_SQL_DB_USER_EXIST:
			errorText = QObject::tr("Im angegebenen Verzeichnis konnte keine "
				"Datenbank gefunden werden. Es wird nun "
				"versucht, eine neue, leere Datenbank in diesem "
				"Verzeichnis anzulegen.\n\n"
				"Den Verzeichnispfad zur Datenbank knnen Sie "
				"in den Einstellungen verndern.\n");
			break;
		case ERR_SQL_DB_APP_COPY:
			errorText = QObject::tr("Die Benutzer-Datenbank konnte nicht in "
				"Ihrem HOME-Verzeichnis angelegt werden. Eventell fehlen die Schreibrechte.\n"
				"Es wird nun versucht, die Original-Datenbank im Programmverzeichnis zu verwenden.\n\n"
				"Den Verzeichnispfad zur Datenbank knnen Sie anschlieend in den "
				"Einstellungen verndern.\n");
			break;
		case ERR_SQL_DB_USER_COPY:
			errorText = QObject::tr("Die Benutzer-Datenbank konnte nicht im "
				"angegebenen Verzeichnis angelegt werden. "
				"Eventell fehlt das Verzeichnis oder es "
				"sind keine Schreibrechte vorhanden.\n"
				"Es wird nun versucht, eine Datenbank in Ihrem HOME-Verzeichnis anzulegen.\n\n"
				"Den Verzeichnispfad zur Datenbank knnen Sie anschlieend in den "
				"Einstellungen verndern.\n");
			break;
		case ERR_SQL_CONNECTION:
			errorText = QObject::tr("Die Verbindung zur Datenbank ist leider "
				"fehlgeschlagen.");
			break;

		case ERR_DB_VERSION_EXIST:
			errorText = QObject::tr("Die Verbindung zur Datenbank ist leider "
				"fehlgeschlagen.");
			break;
		case ERR_USER_LESSONS_FLUSH:
			errorText = QObject::tr("Kann Benutzertabelle mit den "
				"Lektionendaten nicht leeren.\nSQL-Statement fehlgeschlagen.");
			break;
		case ERR_USER_ERRORS_FLUSH:
			errorText = QObject::tr("Kann Benutzertabelle mit den "
				"Fehlerdaten nicht leeren.\nSQL-Statement fehlgeschlagen.");
			break;
		case ERR_LESSONS_EXIST:
			errorText = QObject::tr("Keine Lektionen vorhanden.");
			break;
		case ERR_LESSONS_SELECTED:
			errorText = QObject::tr("Es wurde keine Lektion selektiert.\n"
				"Bitte whlen Sie eine Lektion aus.");
			break;
		case ERR_LESSONS_CREATION:
			errorText = QObject::tr("Lektion konnte nicht erstellt werden.\n"
				"SQL-Statement fehlgeschlagen.");
			break;
		case ERR_LESSONS_UPDATE:
			errorText = QObject::tr("Lektion konnte nicht aktualisiert "
				"werden.\nSQL-Statement fehlgeschlagen.");
			break;
		case ERR_USER_ERRORS_REFRESH:
			errorText = QObject::tr("Die Benutzertabelle mit den Fehlerdaten "
				"konnte nicht aktualisiert werden.\nSQL-Statement "
				"fehlgeschlagen.");
			break;
		case ERR_USER_LESSONS_REFRESH:
			errorText = QObject::tr("Die Benutzertabelle mit den "
				"Lektionendaten konnte nicht aktualisiert werden.\n"
				"SQL-Statement fehlgeschlagen.");
			break;
		case ERR_USER_LESSON_ADD:
			errorText = QObject::tr("Die Lektion konnte nicht gespeichert "
				"werden.\n"
				"SQL-Statement fehlgeschlagen.");
			break;
		case ERR_USER_LESSON_GET:
			errorText = QObject::tr("Die Lektion konnte nicht angefordert "
				"werden.\n"
				"SQL-Statement fehlgeschlagen.");
			break;
		case ERR_USER_LESSON_ANALYZE:
			errorText = QObject::tr("Die Lektion konnte nicht analysiert "
				"werden.\n"
				"SQL-Statement fehlgeschlagen.");
			break;

		case ERR_TEMP_FILE_CREATION:
			errorText = QObject::tr("Temporre Datei konnte nicht erzeugt "
				"werden.");
			break;
		case ERR_UPDATE_EXECUTION:
			errorText = QObject::tr("Das Update konnte leider nicht "
				"durchgefhrt werden.\nBitte berprfen Sie Ihre "
				"Internetverbindung und die Proxyeinstellung.");
			break;
		case ERR_ONLINE_VERSION_READABLE:
			errorText = QObject::tr("Die Online-Versionsinformation konnte "
				"nicht gelesen werden.");
			break;
		case ERR_DB_VERSION_READABLE:
			errorText = QObject::tr("Die Datenbank-Versionsinformation konnte "
				"nicht gelesen werden.");
			break;
		case ERR_UPDATE_SQL_EXECUTION:
			errorText = QObject::tr("SQL-String konnte nicht verarbeitet "
				"werden");
			break;
		case ERR_ERROR_DEFINES_EXIST:
			errorText = QObject::tr("Keine Tippfehler-Definitonen vorhanden.");
			break;
		case ERR_LESSON_CONTENT_EXIST:
			errorText = QObject::tr("Temporre Datei konnte nicht erzeugt "
				"werden.\nDas Update wird abgebrochen.");
			break;
		case ERR_ANALYZE_TABLE_CREATION:
			errorText = QObject::tr("Analyse-Tabelle kann nicht erstellt "
				"werden.");
			break;
		case ERR_ANALYZE_INDEX_CREATION:
			errorText = QObject::tr("Analyse-Index kann nicht erstellt "
				"werden.");
			break;
		case ERR_ANALYZE_TABLE_FILL:
			errorText = QObject::tr("Analyse-Tabelle kann nicht mit "
				"Inhalten gefllt werden");
			break;

		default:
			errorText = QObject::tr("Ein Fehler ist aufgetreten.");
			break;
	}
	// Append the error number
	errorText.append(QObject::tr("\n(Fehlernummer: ")
		+ QString::number(number) + QObject::tr(")\n"));
	return errorText;
}
