/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.borders.TinyButtonBorder;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;

public class TinyButtonUI
extends MetalButtonUI {
    private static final HashMap cache = new HashMap();
    public static final int BG_CHANGE_AMOUNT = 10;
    private static final TinyButtonUI buttonUI = new TinyButtonUI();
    private static final BasicStroke focusStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);
    private boolean graphicsTranslated;
    private boolean isToolBarButton;
    private boolean isFileChooserButton;
    private boolean isDefaultButton;

    public static void clearCache() {
        cache.clear();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (!Theme.buttonEnter.getValue()) {
            return;
        }
        if (!jComponent.isFocusable()) {
            return;
        }
        InputMap inputMap = (InputMap)UIManager.get(this.getPropertyPrefix() + "focusInputMap");
        if (inputMap != null) {
            inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "pressed");
            inputMap.put(KeyStroke.getKeyStroke(10, 0, true), "released");
        }
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setRolloverEnabled(true);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (this.isFileChooserButton || this.isToolBarButton && !Theme.toolFocus.getValue() || !Theme.buttonFocus.getValue()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle4 = abstractButton.getBounds();
        graphics.setColor(Color.black);
        graphics2D.setStroke(focusStroke);
        int n = 2;
        int n2 = 2;
        int n3 = n + rectangle4.width - 5;
        int n4 = n2 + rectangle4.height - 5;
        if (!this.isToolBarButton) {
            ++n;
            ++n2;
            --n3;
            --n4;
        }
        if (this.graphicsTranslated) {
            graphics.translate(-1, -1);
        }
        graphics2D.drawLine(n, n2, n3, n2);
        graphics2D.drawLine(n, n2, n, n4);
        graphics2D.drawLine(n, n4, n3, n4);
        graphics2D.drawLine(n3, n2, n3, n4);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return buttonUI;
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (this.isToolBarButton || this.isFileChooserButton) {
            return;
        }
        Color color = null;
        color = !(abstractButton.getBackground() instanceof ColorUIResource) ? ColorRoutines.darken(abstractButton.getBackground(), 10) : (abstractButton instanceof JToggleButton ? Theme.toggleSelectedBg.getColor() : Theme.buttonPressedColor.getColor());
        graphics.setColor(color);
        this.drawXpButton(graphics, abstractButton, color, false);
        if (!(abstractButton instanceof JToggleButton) && Theme.shiftButtonText.getValue() && abstractButton.getText() != null && !"".equals(abstractButton.getText())) {
            graphics.translate(1, 1);
            this.graphicsTranslated = true;
        }
    }

    public void paintToolBarButton(Graphics graphics, AbstractButton abstractButton) {
        ColorUIResource colorUIResource = null;
        boolean bl = abstractButton.getModel().isRollover() || abstractButton.getModel().isArmed();
        Color color = null;
        color = this.isFileChooserButton ? abstractButton.getParent().getBackground() : Theme.toolButtColor.getColor();
        colorUIResource = abstractButton.getModel().isPressed() ? (bl ? Theme.toolButtPressedColor.getColor() : (abstractButton.isSelected() ? Theme.toolButtSelectedColor.getColor() : color)) : (bl ? (abstractButton.isSelected() ? Theme.toolButtSelectedColor.getColor() : Theme.toolButtRolloverColor.getColor()) : (abstractButton.isSelected() ? Theme.toolButtSelectedColor.getColor() : color));
        graphics.setColor(colorUIResource);
        this.drawXpToolBarButton(graphics, abstractButton, colorUIResource, false);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (this.isToolBarButton || this.isFileChooserButton) {
            this.paintToolBarButton(graphics, abstractButton);
        } else if (abstractButton instanceof JToggleButton && abstractButton.isSelected()) {
            this.paintButtonPressed(graphics, abstractButton);
        } else {
            this.isDefaultButton = jComponent instanceof JButton && ((JButton)jComponent).isDefaultButton();
            boolean bl = abstractButton.getModel().isRollover();
            boolean bl2 = jComponent.getBackground().equals(Theme.buttonNormalColor.getColor()) || jComponent.getBackground() instanceof ColorUIResource;
            Color color = null;
            color = !abstractButton.isEnabled() ? Theme.buttonDisabledColor.getColor() : (abstractButton.getModel().isPressed() ? (bl ? (bl2 ? Theme.buttonPressedColor.getColor() : ColorRoutines.darken(jComponent.getBackground(), 10)) : jComponent.getBackground()) : (bl ? (bl2 ? Theme.buttonRolloverBgColor.getColor() : ColorRoutines.lighten(jComponent.getBackground(), 10)) : (bl2 ? Theme.buttonNormalColor.getColor() : jComponent.getBackground())));
            graphics.setColor(color);
            if (TinyLookAndFeel.controlPanelInstantiated) {
                this.drawXpButtonNoCache(graphics, abstractButton, color, bl);
            } else {
                this.drawXpButton(graphics, abstractButton, color, bl);
            }
        }
        super.paint(graphics, jComponent);
    }

    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (jComponent instanceof JToggleButton) {
            this.paintToggleButtonIcon(graphics, jComponent, rectangle);
        } else {
            super.paintIcon(graphics, jComponent, rectangle);
        }
    }

    protected void paintToggleButtonIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = null;
        if (!buttonModel.isEnabled()) {
            icon = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon = abstractButton.getPressedIcon();
            if (icon == null) {
                icon = abstractButton.getSelectedIcon();
            }
        } else if (buttonModel.isSelected()) {
            if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                icon = abstractButton.getRolloverSelectedIcon();
                if (icon == null) {
                    icon = abstractButton.getSelectedIcon();
                }
            } else {
                icon = abstractButton.getSelectedIcon();
            }
        } else if (buttonModel.isRollover()) {
            icon = abstractButton.getRolloverIcon();
        }
        if (icon == null) {
            icon = abstractButton.getIcon();
        }
        icon.paintIcon(abstractButton, graphics, rectangle.x, rectangle.y);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.isToolBarButton = Boolean.TRUE.equals(jComponent.getClientProperty("isToolbarButton"));
        this.isFileChooserButton = Boolean.TRUE.equals(jComponent.getClientProperty("isFileChooserButton"));
        this.paint(graphics, jComponent);
        this.graphicsTranslated = false;
    }

    private void drawXpButton(Graphics graphics, AbstractButton abstractButton, Color color, boolean bl) {
        Border border;
        if (!abstractButton.isContentAreaFilled()) {
            return;
        }
        if (!abstractButton.isOpaque()) {
            return;
        }
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        Color color2 = abstractButton.getParent().getBackground();
        ButtonKey buttonKey = new ButtonKey(color, color2, n2, bl & Theme.buttonRolloverBorder.getValue(), this.isDefaultButton, abstractButton.hasFocus(), abstractButton.isBorderPainted());
        Object v = cache.get(buttonKey);
        if (v != null) {
            int n3 = ((Image)v).getWidth(abstractButton);
            if (n3 == n) {
                graphics.drawImage((Image)v, 0, 0, abstractButton);
                return;
            }
            int n4 = 0;
            int n5 = 3;
            int n6 = n2;
            int n7 = 0;
            int n8 = n5;
            int n9 = n6;
            graphics.drawImage((Image)v, n7, 0, n8, n9, n4, 0, n5, n6, abstractButton);
            n4 = n3 - 4;
            n5 = n3;
            n7 = n - 4;
            n8 = n;
            graphics.drawImage((Image)v, n7, 0, n8, n9, n4, 0, n5, n6, abstractButton);
            n4 = 3;
            n5 = n3 - 4;
            n7 = n4;
            n8 = n - 4;
            graphics.drawImage((Image)v, n7, 0, n8, n9, n4, 0, n5, n6, abstractButton);
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics graphics2 = ((Image)bufferedImage).getGraphics();
        graphics2.setColor(color2);
        graphics2.drawRect(0, 0, n - 1, n2 - 1);
        int n10 = Theme.buttonSpreadLight.getValue();
        int n11 = Theme.buttonSpreadDark.getValue();
        if (!abstractButton.isEnabled()) {
            n10 = Theme.buttonSpreadLightDisabled.getValue();
            n11 = Theme.buttonSpreadDarkDisabled.getValue();
        }
        float f = 10.0f * (float)n10 / (float)(n2 - 3);
        float f2 = 10.0f * (float)n11 / (float)(n2 - 3);
        int n12 = n2 / 2;
        for (int i = 1; i < n2 - 1; ++i) {
            int n13;
            if (i < n12) {
                n13 = n12 - i;
                graphics2.setColor(ColorRoutines.lighten(color, (int)((float)n13 * f)));
            } else if (i == n12) {
                graphics2.setColor(color);
            } else {
                n13 = i - n12;
                graphics2.setColor(ColorRoutines.darken(color, (int)((float)n13 * f2)));
            }
            graphics2.drawLine(2, i, n - 3, i);
            if (i == 1) {
                graphics2.drawLine(1, 1, 1, n2 - 2);
                if (!bl && !this.isDefaultButton) continue;
                graphics2.drawLine(n - 2, 1, n - 2, n2 - 2);
                continue;
            }
            if (i != n2 - 2 || bl || this.isDefaultButton) continue;
            graphics2.drawLine(n - 2, 1, n - 2, n2 - 2);
        }
        if (abstractButton.isBorderPainted() && (border = abstractButton.getBorder()) != null && border instanceof TinyButtonBorder.CompoundBorderUIResource) {
            if (bl && Theme.buttonRolloverBorder.getValue()) {
                graphics2.setColor(Theme.buttonRolloverColor.getColor());
                graphics2.drawLine(1, n2 - 2, 1, n2 - 2);
                graphics2.drawLine(n - 2, n2 - 2, n - 2, n2 - 2);
            } else if (this.isDefaultButton && abstractButton.isEnabled()) {
                graphics2.setColor(Theme.buttonDefaultColor.getColor());
                graphics2.drawLine(1, n2 - 2, 1, n2 - 2);
                graphics2.drawLine(n - 2, n2 - 2, n - 2, n2 - 2);
            }
            this.drawXpBorder(abstractButton, graphics2, 0, 0, n, n2);
        }
        graphics2.dispose();
        graphics.drawImage(bufferedImage, 0, 0, abstractButton);
        cache.put(buttonKey, bufferedImage);
    }

    private void drawXpBorder(AbstractButton abstractButton, Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl = Boolean.TRUE.equals(abstractButton.getClientProperty("isComboBoxButton"));
        if (bl) {
            if (!abstractButton.isEnabled()) {
                DrawRoutines.drawRoundedBorder(graphics, Theme.comboBorderDisabledColor.getColor(), n, n2, n3, n4);
            } else {
                DrawRoutines.drawRoundedBorder(graphics, Theme.comboBorderColor.getColor(), n, n2, n3, n4);
                if (abstractButton.getModel().isPressed()) {
                    return;
                }
                if (abstractButton.getModel().isRollover() && Theme.comboRollover.getValue()) {
                    DrawRoutines.drawRolloverBorder(graphics, Theme.buttonRolloverColor.getColor(), n, n2, n3, n4);
                }
            }
        } else {
            boolean bl2;
            boolean bl3 = abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton();
            boolean bl4 = Boolean.TRUE.equals(abstractButton.getClientProperty("isSpinnerButton"));
            boolean bl5 = bl4 && Theme.spinnerRollover.getValue() || !bl4 && Theme.buttonRolloverBorder.getValue();
            boolean bl6 = bl2 = bl3 || bl4 && Theme.buttonFocusBorder.getValue() && abstractButton.isFocusOwner() || !bl4 && Theme.buttonFocusBorder.getValue() && abstractButton.isFocusOwner() && abstractButton.isFocusPainted();
            if (!abstractButton.isEnabled()) {
                DrawRoutines.drawRoundedBorder(graphics, Theme.buttonBorderDisabledColor.getColor(), n, n2, n3, n4);
            } else {
                DrawRoutines.drawRoundedBorder(graphics, Theme.buttonBorderColor.getColor(), n, n2, n3, n4);
                if (abstractButton.getModel().isPressed()) {
                    return;
                }
                if (abstractButton.getModel().isRollover() && bl5) {
                    DrawRoutines.drawRolloverBorder(graphics, Theme.buttonRolloverColor.getColor(), n, n2, n3, n4);
                } else if (bl2) {
                    DrawRoutines.drawRolloverBorder(graphics, Theme.buttonDefaultColor.getColor(), n, n2, n3, n4);
                }
            }
        }
    }

    private void drawXpButtonNoCache(Graphics graphics, AbstractButton abstractButton, Color color, boolean bl) {
        if (!abstractButton.isContentAreaFilled()) {
            return;
        }
        if (!abstractButton.isOpaque()) {
            return;
        }
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        Color color2 = abstractButton.getParent().getBackground();
        graphics.setColor(color2);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        int n3 = Theme.buttonSpreadLight.getValue();
        int n4 = Theme.buttonSpreadDark.getValue();
        if (!abstractButton.isEnabled()) {
            n3 = Theme.buttonSpreadLightDisabled.getValue();
            n4 = Theme.buttonSpreadDarkDisabled.getValue();
        }
        float f = 10.0f * (float)n3 / (float)(n2 - 3);
        float f2 = 10.0f * (float)n4 / (float)(n2 - 3);
        int n5 = n2 / 2;
        for (int i = 1; i < n2 - 1; ++i) {
            int n6;
            if (i < n5) {
                n6 = n5 - i;
                graphics.setColor(ColorRoutines.lighten(color, (int)((float)n6 * f)));
            } else if (i == n5) {
                graphics.setColor(color);
            } else {
                n6 = i - n5;
                graphics.setColor(ColorRoutines.darken(color, (int)((float)n6 * f2)));
            }
            graphics.drawLine(2, i, n - 3, i);
            if (i == 1) {
                graphics.drawLine(1, 1, 1, n2 - 2);
                if (!bl && !this.isDefaultButton) continue;
                graphics.drawLine(n - 2, 1, n - 2, n2 - 2);
                continue;
            }
            if (i != n2 - 2 || bl || this.isDefaultButton) continue;
            graphics.drawLine(n - 2, 1, n - 2, n2 - 2);
        }
        if (abstractButton.isBorderPainted()) {
            if (bl && Theme.buttonRolloverBorder.getValue()) {
                graphics.setColor(Theme.buttonRolloverColor.getColor());
                graphics.drawLine(1, n2 - 2, 1, n2 - 2);
                graphics.drawLine(n - 2, n2 - 2, n - 2, n2 - 2);
            } else if (this.isDefaultButton && abstractButton.isEnabled()) {
                graphics.setColor(Theme.buttonDefaultColor.getColor());
                graphics.drawLine(1, n2 - 2, 1, n2 - 2);
                graphics.drawLine(n - 2, n2 - 2, n - 2, n2 - 2);
            }
        }
    }

    private void drawXpToolBarButton(Graphics graphics, AbstractButton abstractButton, Color color, boolean bl) {
        Color color2;
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        if (abstractButton.isContentAreaFilled()) {
            graphics.fillRect(1, 1, n - 2, n2 - 2);
        }
        if ((color2 = abstractButton.getParent().getBackground()) instanceof ColorUIResource && !this.isFileChooserButton) {
            graphics.setColor(Theme.toolBarColor.getColor());
        } else {
            graphics.setColor(color2);
        }
        graphics.drawRect(0, 0, n - 1, n2 - 1);
    }

    private static class ButtonKey {
        private Color background;
        private Color parentBackground;
        private int height;
        private boolean rollover;
        private boolean isDefault;
        private boolean hasFocus;
        private boolean isBorderPainted;

        ButtonKey(Color color, Color color2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.background = color;
            this.parentBackground = color2;
            this.height = n;
            this.rollover = bl;
            this.isDefault = bl2;
            this.hasFocus = bl3;
            this.isBorderPainted = bl4;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof ButtonKey)) {
                return false;
            }
            ButtonKey buttonKey = (ButtonKey)object;
            return this.height == buttonKey.height && this.rollover == buttonKey.rollover && this.isDefault == buttonKey.isDefault && this.hasFocus == buttonKey.hasFocus && this.isBorderPainted == buttonKey.isBorderPainted && this.background.equals(buttonKey.background) && this.parentBackground.equals(buttonKey.parentBackground);
        }

        public int hashCode() {
            return this.background.hashCode() * this.parentBackground.hashCode() * this.height * (this.rollover ? 2 : 1) * (this.isDefault ? 8 : 4) * (this.hasFocus ? 16 : 8) * (this.isBorderPainted ? 32 : 16);
        }
    }
}

