/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.util;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import de.muntjak.tinylookandfeel.controlpanel.SBControl;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.plaf.ColorUIResource;

public class SBReference {
    public static final int ABS_COLOR = 1;
    public static final int MAIN_COLOR = 2;
    public static final int BACK_COLOR = 3;
    public static final int DIS_COLOR = 4;
    public static final int FRAME_COLOR = 5;
    public static final int SUB1_COLOR = 6;
    public static final int SUB2_COLOR = 7;
    public static final int SUB3_COLOR = 8;
    public static final int SUB4_COLOR = 9;
    public static final int SUB5_COLOR = 10;
    public static final int SUB6_COLOR = 11;
    public static final int SUB7_COLOR = 12;
    public static final int SUB8_COLOR = 13;
    private static final Vector instances = new Vector();
    protected ColorUIResource color;
    protected ColorUIResource referenceColor;
    protected int sat = 0;
    protected int bri = 0;
    protected int ref;
    protected boolean locked;
    protected ColorIcon icon;
    protected static ColorIcon absoluteIcon;

    public SBReference() {
        this.color = new ColorUIResource(Color.BLACK);
        this.ref = 1;
        instances.add(this);
    }

    public SBReference(boolean dummy) {
        this.color = new ColorUIResource(Color.BLACK);
        this.ref = 1;
    }

    public SBReference(Color c, int sat, int bri, int ref) {
        this.color = new ColorUIResource(c);
        this.sat = sat;
        this.bri = bri;
        this.ref = ref;
        instances.add(this);
    }

    public SBReference(Color c, int sat, int bri, int ref, boolean locked) {
        this.color = new ColorUIResource(c);
        this.sat = sat;
        this.bri = bri;
        this.ref = ref;
        this.locked = locked;
    }

    public SBReference(SBReference other) {
        this.color = new ColorUIResource(other.color);
        this.sat = other.sat;
        this.bri = other.bri;
        this.ref = other.ref;
        this.locked = other.locked;
    }

    public SBReference copy() {
        SBReference retVal = new SBReference(this);
        if (!this.isAbsoluteColor()) {
            retVal.referenceColor = this.getReferenceColor();
        }
        return retVal;
    }

    public static int getNumReferences(int ref) {
        int n = 0;
        Iterator ii = instances.iterator();
        while (ii.hasNext()) {
            if (ref != ((SBReference)ii.next()).ref) continue;
            ++n;
        }
        return n;
    }

    public static void printReferences(int ref) {
        Iterator ii = instances.iterator();
        while (ii.hasNext()) {
            SBReference sb = (SBReference)ii.next();
            if (ref != sb.ref) continue;
            System.out.println(sb);
        }
    }

    public void update(Color c, int sat, int bri, int ref) {
        this.color = new ColorUIResource(c);
        this.sat = sat;
        this.bri = bri;
        this.ref = ref;
    }

    public void update(SBReference sb) {
        if (sb.isAbsoluteColor() || sb.referenceColor == null) {
            this.color = new ColorUIResource(sb.color);
            this.sat = sb.sat;
            this.bri = sb.bri;
            this.ref = sb.ref;
        } else {
            this.update(sb, sb.referenceColor);
        }
    }

    public void update(SBReference other, Vector referenceColors) {
        if (other.isAbsoluteColor()) {
            this.color = new ColorUIResource(other.color);
            this.sat = other.sat;
            this.bri = other.bri;
            this.ref = other.ref;
        } else {
            this.update(other, (ColorUIResource)referenceColors.get(other.ref - 2));
        }
    }

    private void update(SBReference sb, ColorUIResource cr) {
        if (!sb.getReferenceColor().equals(cr)) {
            int newRef = this.getRefForColor(cr);
            if (newRef != -1) {
                this.ref = newRef;
                this.sat = sb.sat;
                this.bri = sb.bri;
                return;
            }
            newRef = this.getEmptyReferenceColor();
            if (newRef != -1) {
                this.ref = newRef;
                SBControl control = ControlPanel.instance.getSBControlFromRef(this.ref);
                control.getSBReference().setReference(1);
                control.getSBReference().setSaturation(0);
                control.getSBReference().setBrightness(0);
                control.getSBReference().setColor(cr);
                control.update();
                this.sat = sb.sat;
                this.bri = sb.bri;
                return;
            }
            this.color = new ColorUIResource(sb.getColor());
            this.sat = 0;
            this.bri = 0;
            this.ref = 1;
            return;
        }
        this.color = new ColorUIResource(sb.color);
        this.sat = sb.sat;
        this.bri = sb.bri;
        this.ref = sb.ref;
    }

    private int getEmptyReferenceColor() {
        for (int i = 6; i <= 13; ++i) {
            if (SBReference.getNumReferences(i) != 0) continue;
            return i;
        }
        return -1;
    }

    private int getRefForColor(ColorUIResource cr) {
        if (Theme.mainColor.getColor().equals(cr)) {
            return 2;
        }
        if (Theme.backColor.getColor().equals(cr)) {
            return 3;
        }
        if (Theme.disColor.getColor().equals(cr)) {
            return 4;
        }
        if (Theme.frameColor.getColor().equals(cr)) {
            return 5;
        }
        if (Theme.sub1Color.getColor().equals(cr)) {
            return 6;
        }
        if (Theme.sub2Color.getColor().equals(cr)) {
            return 7;
        }
        if (Theme.sub3Color.getColor().equals(cr)) {
            return 8;
        }
        if (Theme.sub4Color.getColor().equals(cr)) {
            return 9;
        }
        if (Theme.sub5Color.getColor().equals(cr)) {
            return 10;
        }
        if (Theme.sub6Color.getColor().equals(cr)) {
            return 11;
        }
        if (Theme.sub7Color.getColor().equals(cr)) {
            return 12;
        }
        if (Theme.sub8Color.getColor().equals(cr)) {
            return 13;
        }
        return -1;
    }

    public void update(Color c) {
        this.color = new ColorUIResource(c);
        this.sat = 0;
        this.bri = 0;
        this.ref = 1;
    }

    public void reset() {
        this.sat = 0;
        this.bri = 0;
    }

    public ColorUIResource getColor() {
        return this.color;
    }

    public int getSaturation() {
        return this.sat;
    }

    public int getBrightness() {
        return this.bri;
    }

    public int getReference() {
        return this.ref;
    }

    public ColorUIResource getReferenceColor() {
        return SBReference.getReferencedColor(this.ref);
    }

    public static ColorUIResource getReferencedColor(int ref) {
        switch (ref) {
            case 2: {
                return Theme.mainColor.getColor();
            }
            case 3: {
                return Theme.backColor.getColor();
            }
            case 4: {
                return Theme.disColor.getColor();
            }
            case 5: {
                return Theme.frameColor.getColor();
            }
            case 6: {
                return Theme.sub1Color.getColor();
            }
            case 7: {
                return Theme.sub2Color.getColor();
            }
            case 8: {
                return Theme.sub3Color.getColor();
            }
            case 9: {
                return Theme.sub4Color.getColor();
            }
            case 10: {
                return Theme.sub5Color.getColor();
            }
            case 11: {
                return Theme.sub6Color.getColor();
            }
            case 12: {
                return Theme.sub7Color.getColor();
            }
            case 13: {
                return Theme.sub8Color.getColor();
            }
        }
        return null;
    }

    public String getReferenceString() {
        switch (this.ref) {
            case 2: {
                return "Main Color";
            }
            case 3: {
                return "Back Color";
            }
            case 4: {
                return "Disabled Color";
            }
            case 5: {
                return "Frame Color";
            }
            case 6: {
                return "Sub1 Color";
            }
            case 7: {
                return "Sub2 Color";
            }
            case 8: {
                return "Sub3 Color";
            }
            case 9: {
                return "Sub4 Color";
            }
            case 10: {
                return "Sub5 Color";
            }
            case 11: {
                return "Sub6 Color";
            }
            case 12: {
                return "Sub7 Color";
            }
            case 13: {
                return "Sub8 Color";
            }
        }
        return "";
    }

    public void setColor(Color newColor) {
        this.color = new ColorUIResource(newColor);
    }

    public void setSaturation(int newSat) {
        this.sat = newSat;
    }

    public void setBrightness(int newBri) {
        this.bri = newBri;
    }

    public void setReference(int newRef) {
        this.ref = newRef;
    }

    public void setColor(int sat, int bri) {
        if (this.isAbsoluteColor()) {
            return;
        }
        this.sat = sat;
        this.bri = bri;
        this.updateColor();
    }

    private void updateColor() {
        switch (this.ref) {
            case 2: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.mainColor.getColor(), this.sat, this.bri));
                break;
            }
            case 3: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.backColor.getColor(), this.sat, this.bri));
                break;
            }
            case 4: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.disColor.getColor(), this.sat, this.bri));
                break;
            }
            case 5: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.frameColor.getColor(), this.sat, this.bri));
                break;
            }
            case 6: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub1Color.getColor(), this.sat, this.bri));
                break;
            }
            case 7: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub2Color.getColor(), this.sat, this.bri));
                break;
            }
            case 8: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub3Color.getColor(), this.sat, this.bri));
                break;
            }
            case 9: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub4Color.getColor(), this.sat, this.bri));
                break;
            }
            case 10: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub5Color.getColor(), this.sat, this.bri));
                break;
            }
            case 11: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub6Color.getColor(), this.sat, this.bri));
                break;
            }
            case 12: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub7Color.getColor(), this.sat, this.bri));
                break;
            }
            case 13: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub8Color.getColor(), this.sat, this.bri));
            }
        }
    }

    public ColorUIResource update() {
        if (this.isAbsoluteColor()) {
            return this.color;
        }
        this.updateColor();
        return this.color;
    }

    public boolean isAbsoluteColor() {
        return this.ref == 1;
    }

    public boolean isReferenceColor() {
        return this.locked || this.equals(Theme.sub1Color) || this.equals(Theme.sub2Color) || this.equals(Theme.sub3Color) || this.equals(Theme.sub4Color) || this.equals(Theme.sub5Color) || this.equals(Theme.sub6Color) || this.equals(Theme.sub7Color) || this.equals(Theme.sub8Color);
    }

    public void setLocked(boolean newLocked) {
        this.locked = newLocked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public String toString() {
        return "SBReference[bri=" + this.bri + ",sat=" + this.sat + ",ref=" + this.ref + ",c=(" + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue() + ")]";
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = new ColorIcon(false);
        }
        return this.icon;
    }

    public Icon getAbsoluteIcon() {
        if (absoluteIcon == null) {
            absoluteIcon = new ColorIcon(true);
        }
        return absoluteIcon;
    }

    public void save(DataOutputStream out) throws IOException {
        out.writeInt(this.color.getRGB());
        out.writeInt(this.sat);
        out.writeInt(this.bri);
        out.writeInt(this.ref);
        out.writeBoolean(this.locked);
    }

    public void load(DataInputStream in) throws IOException {
        try {
            this.color = Theme.fileID >= 12852 ? new ColorUIResource(in.readInt()) : new ColorUIResource(in.readInt(), in.readInt(), in.readInt());
            this.sat = in.readInt();
            this.bri = in.readInt();
            this.ref = in.readInt();
            this.locked = in.readBoolean();
        }
        catch (Exception ex) {
            throw new IOException("SBReference.load() : " + ex);
        }
    }

    public static void loadDummyData(DataInputStream in) throws IOException {
        try {
            if (Theme.fileID >= 12852) {
                in.readInt();
            } else {
                in.readInt();
                in.readInt();
                in.readInt();
            }
            in.readInt();
            in.readInt();
            in.readInt();
            in.readBoolean();
        }
        catch (Exception ex) {
            throw new IOException("SBReference.loadDummyData() : " + ex.getMessage());
        }
    }

    class ColorIcon
    implements Icon {
        private boolean paintGradients;

        ColorIcon(boolean paintGradients) {
            this.paintGradients = paintGradients;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component comp, Graphics g, int x, int y) {
            Color tempCol = g.getColor();
            g.setColor(Color.GRAY);
            g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
            if (this.paintGradients) {
                float hue = 0.0f;
                for (int i = 0; i < 15; ++i) {
                    g.setColor(Color.getHSBColor(hue, 0.5f, 1.0f));
                    g.drawLine(x + 1 + i, y + 1, x + 1 + i, y + this.getIconHeight() - 1);
                    hue = (float)((double)hue + 0.0625);
                }
            } else {
                g.setColor(SBReference.this.color);
                g.fillRect(x + 1, y + 1, this.getIconWidth() - 1, this.getIconHeight() - 1);
            }
            if (comp instanceof AbstractButton && ((AbstractButton)comp).isSelected()) {
                g.setColor(Color.WHITE);
                this.drawArrow(g, x + 1, y + 1);
                g.setColor(Color.BLACK);
                this.drawArrow(g, x, y);
            }
            g.setColor(tempCol);
        }

        private void drawArrow(Graphics g, int x, int y) {
            g.drawLine(x + 3, y + 5, x + 3, y + 7);
            g.drawLine(x + 4, y + 6, x + 4, y + 8);
            g.drawLine(x + 5, y + 7, x + 5, y + 9);
            g.drawLine(x + 6, y + 6, x + 6, y + 8);
            g.drawLine(x + 7, y + 5, x + 7, y + 7);
            g.drawLine(x + 8, y + 4, x + 8, y + 6);
            g.drawLine(x + 9, y + 3, x + 9, y + 5);
        }
    }
}

