/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import de.muntjak.tinylookandfeel.controlpanel.InsetsControl;
import de.muntjak.tinylookandfeel.controlpanel.IntControl;
import de.muntjak.tinylookandfeel.controlpanel.ParameterSet;
import de.muntjak.tinylookandfeel.controlpanel.SBControl;
import de.muntjak.tinylookandfeel.util.ColoredFont;
import de.muntjak.tinylookandfeel.util.HSBReference;
import de.muntjak.tinylookandfeel.util.SBReference;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.swing.plaf.ColorUIResource;

public class UndoManager {
    private static final Stack undoStack = new Stack();
    private static final Stack redoStack = new Stack();
    private static String undoDescription;
    private static String redoDescription;
    private static final Vector delayedUndoItems;

    static void clear() {
        undoStack.clear();
        redoStack.clear();
        delayedUndoItems.clear();
    }

    static boolean activateDelayedUndoItems(ControlPanel cp) {
        if (delayedUndoItems.isEmpty()) {
            return false;
        }
        if (delayedUndoItems.size() == 1) {
            undoStack.push(delayedUndoItems.get(0));
        } else {
            undoStack.push(delayedUndoItems.clone());
        }
        undoDescription = UndoManager.getDescription(undoStack.peek());
        delayedUndoItems.clear();
        redoStack.clear();
        cp.undoItemsActivated();
        return true;
    }

    private static void printVector(Vector v) {
        System.out.println("\n" + v.size() + " items:");
        Iterator ii = v.iterator();
        while (ii.hasNext()) {
            System.out.println("  " + ii.next());
        }
    }

    private static String getDescription(Object o) {
        if (o instanceof UndoData) {
            return ((UndoData)o).description;
        }
        if (o instanceof Vector) {
            Vector v = (Vector)o;
            String description = null;
            Iterator ii = v.iterator();
            while (ii.hasNext()) {
                UndoData data = (UndoData)ii.next();
                if (description == null) {
                    description = data.description;
                    continue;
                }
                if (description.equals(data.description)) continue;
                if (description.startsWith("Change Inset") && data.description.startsWith("Change Inset")) {
                    description = "Change Inset";
                    continue;
                }
                description = "Multiple Actions";
                break;
            }
            if ("Change Inset".equals(description)) {
                description = "Change multiple Insets";
            } else if ("Change Boolean".equals(description)) {
                description = "Change multiple Booleans";
            } else if ("Change Spread".equals(description)) {
                description = "Change multiple Spreads";
            } else if ("Change Color".equals(description)) {
                description = "Change multiple Colors";
            } else if ("Change Font".equals(description)) {
                description = "Change multiple Fonts";
            } else if (!"Multiple Actions".equals(description)) {
                description = "Multiple " + description + "s";
            }
            return description;
        }
        return null;
    }

    static String getUndoDescription() {
        return undoDescription;
    }

    static String getRedoDescription() {
        return redoDescription;
    }

    static void storeUndoData(ColoredFont cf) {
        UndoData data = new UndoData(cf);
        if (delayedUndoItems.contains(data)) {
            int index = delayedUndoItems.indexOf(data);
            UndoData old = (UndoData)delayedUndoItems.get(index);
            delayedUndoItems.remove(data);
            data.cfData = old.cfData;
            delayedUndoItems.add(data);
        } else {
            delayedUndoItems.add(data);
        }
    }

    static void storeUndoData(SBControl sb) {
        UndoData data = new UndoData(sb);
        if (sb.forceUpdate) {
            if (delayedUndoItems.contains(data)) {
                int index = delayedUndoItems.indexOf(data);
                UndoData old = (UndoData)delayedUndoItems.get(index);
                delayedUndoItems.remove(data);
                data.sbData = old.sbData;
                delayedUndoItems.add(data);
            } else {
                delayedUndoItems.add(data);
            }
        } else {
            undoStack.push(data);
            redoStack.clear();
            undoDescription = data.description;
        }
    }

    static void storeUndoData(ControlPanel.SpreadControl sc) {
        UndoData data = new UndoData(sc);
        undoDescription = data.description;
        undoStack.push(data);
        redoStack.clear();
    }

    static void storeUndoData(ControlPanel.BooleanControl bc) {
        UndoData data = new UndoData(bc);
        if (bc.forceUpdate) {
            if (delayedUndoItems.contains(data)) {
                delayedUndoItems.remove(data);
            } else {
                delayedUndoItems.add(data);
            }
        } else {
            undoStack.push(data);
            redoStack.clear();
            undoDescription = data.description;
        }
    }

    static void storeUndoData(ControlPanel.HSBControl hsb, ControlPanel.ColorizeIconCheck cc) {
        UndoData data = new UndoData(hsb, cc);
        if (delayedUndoItems.contains(data)) {
            int index = delayedUndoItems.indexOf(data);
            UndoData old = (UndoData)delayedUndoItems.get(index);
            delayedUndoItems.remove(data);
            data.hsbData = old.hsbData;
            data.cc = old.cc;
            delayedUndoItems.add(data);
        } else {
            delayedUndoItems.add(data);
        }
    }

    static void storeUndoData(ControlPanel.ColorizeIconCheck cc) {
        UndoData data = new UndoData(cc);
        if (delayedUndoItems.contains(data)) {
            delayedUndoItems.remove(data);
        } else {
            delayedUndoItems.add(data);
        }
    }

    static void storeUndoData(InsetsControl ic, int icValue) {
        UndoData data = new UndoData(ic, icValue);
        delayedUndoItems.add(data);
    }

    static void storeUndoData(IntControl ic, int icValue) {
        UndoData data = new UndoData(ic, icValue);
        delayedUndoItems.add(data);
    }

    public static void storeUndoData(ParameterSet params) {
        UndoData data = new UndoData(params);
        undoDescription = data.description;
        undoStack.push(data);
        redoStack.clear();
    }

    static boolean doUndo(ControlPanel cp) {
        if (undoStack.isEmpty()) {
            return false;
        }
        Object o = undoStack.pop();
        redoStack.push(o);
        if (o instanceof UndoData) {
            ((UndoData)o).doUndo(cp, true);
        } else {
            int top;
            Vector v = (Vector)o;
            for (int i = top = v.size() - 1; i >= 0; --i) {
                ((UndoData)v.get(i)).doUndo(cp, false);
            }
            cp.setTheme();
        }
        if (!undoStack.isEmpty()) {
            undoDescription = UndoManager.getDescription(undoStack.peek());
        }
        redoDescription = UndoManager.getDescription(redoStack.peek());
        return true;
    }

    static boolean doRedo(ControlPanel cp) {
        if (redoStack.isEmpty()) {
            return false;
        }
        Object o = redoStack.pop();
        undoStack.push(o);
        if (o instanceof UndoData) {
            ((UndoData)o).doUndo(cp, true);
        } else {
            int top;
            Vector v = (Vector)o;
            for (int i = top = v.size() - 1; i >= 0; --i) {
                ((UndoData)v.get(i)).doUndo(cp, false);
            }
            cp.setTheme();
        }
        if (!redoStack.isEmpty()) {
            redoDescription = UndoManager.getDescription(redoStack.peek());
        }
        undoDescription = UndoManager.getDescription(undoStack.peek());
        return true;
    }

    static boolean canUndo() {
        return !undoStack.isEmpty();
    }

    static boolean canRedo() {
        return !redoStack.isEmpty();
    }

    static {
        delayedUndoItems = new Vector();
    }

    private static class UndoData {
        String description;
        SBControl sb;
        SBReference sbData;
        ColoredFont cf;
        ColoredFont cfData;
        ControlPanel.BooleanControl bc;
        boolean bcValue;
        ControlPanel.HSBControl hsb;
        HSBReference hsbData;
        ControlPanel.SpreadControl sc;
        int spread;
        ControlPanel.ColorizeIconCheck cc;
        boolean ccValue;
        IntControl intControl;
        int intControlValue;
        InsetsControl insetsControl;
        int insetsControlValue;
        ParameterSet params;
        ParameterSet paramData;

        UndoData(SBControl sb) {
            this.sb = sb;
            this.sbData = new SBReference(sb.getSBReference());
            this.description = "Change Color";
        }

        UndoData(ColoredFont cf) {
            this.cf = cf;
            this.cfData = new ColoredFont(cf);
            this.description = "Change Font";
        }

        UndoData(ControlPanel.BooleanControl bc) {
            this.bc = bc;
            this.bcValue = bc.ref.getValue();
            this.description = "Change Boolean";
        }

        UndoData(ControlPanel.SpreadControl sc) {
            this.sc = sc;
            this.spread = sc.spread;
            this.description = "Change Spread";
        }

        UndoData(ControlPanel.HSBControl hsb, ControlPanel.ColorizeIconCheck cc) {
            this.hsb = hsb;
            this.hsbData = new HSBReference(hsb.getUndoReference());
            this.description = "Colorize Icon Action";
            if (!cc.isSelected()) {
                this.cc = cc;
                this.ccValue = cc.isSelected();
            }
        }

        UndoData(ControlPanel.ColorizeIconCheck cc) {
            this.cc = cc;
            this.ccValue = !cc.isSelected();
            this.description = "Colorize Icon Action";
        }

        UndoData(InsetsControl insetsControl, int value) {
            this.insetsControl = insetsControl;
            this.insetsControlValue = value;
            this.description = "Change Insets." + insetsControl.getPositionString();
        }

        UndoData(IntControl intControl, int value) {
            this.intControl = intControl;
            this.intControlValue = value;
            this.description = "Change " + intControl.getDescription();
        }

        UndoData(ParameterSet params) {
            this.params = params;
            this.paramData = params.getGenerator().getParameterSet();
            this.description = params.getUndoString();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof UndoData)) {
                return false;
            }
            UndoData other = (UndoData)o;
            if (this.cf != null) {
                return this.cf.equals(other.cf);
            }
            if (this.sb != null) {
                return this.sb.equals(other.sb);
            }
            if (this.sc != null) {
                return this.sc.equals(other.sc);
            }
            if (this.bc != null) {
                return this.bc.equals(other.bc);
            }
            if (this.hsb != null) {
                return this.hsb.equals(other.hsb);
            }
            if (this.cc != null) {
                return this.cc.equals(other.cc);
            }
            if (this.insetsControl != null) {
                return this.insetsControl.equals(other.insetsControl);
            }
            if (this.intControl != null) {
                return this.intControl.equals(other.intControl);
            }
            if (this.params != null) {
                return this.insetsControl.equals(other.params);
            }
            return false;
        }

        public String toString() {
            if (this.sb != null) {
                return "Current Cr:" + this.sb.getSBReference() + " Undo Cr:" + this.sbData;
            }
            return super.toString();
        }

        void doUndo(ControlPanel cp, boolean setTheme) {
            if (this.sb != null) {
                int bri = this.sbData.getBrightness();
                ColorUIResource c = this.sbData.getColor();
                int ref = this.sbData.getReference();
                int sat = this.sbData.getSaturation();
                SBReference colorRef = this.sb.getSBReference();
                this.sbData.setBrightness(colorRef.getBrightness());
                this.sbData.setReference(colorRef.getReference());
                this.sbData.setSaturation(colorRef.getSaturation());
                this.sbData.setColor(colorRef.getColor());
                colorRef.setBrightness(bri);
                colorRef.setReference(ref);
                colorRef.setSaturation(sat);
                colorRef.setColor(c);
                this.sb.update();
                if (setTheme) {
                    this.sb.updateTargets(false);
                }
            } else if (this.sc != null) {
                int mem = this.sc.spread;
                if (setTheme) {
                    this.sc.update(this.spread, false);
                }
                this.spread = mem;
            } else if (this.bc != null) {
                this.bc.ref.setValue(this.bcValue);
                this.bc.setSelected(this.bcValue);
                if (setTheme) {
                    this.bc.updateTargets(false);
                }
                this.bcValue = !this.bcValue;
            } else if (this.hsb != null) {
                int bri = this.hsbData.getBrightness();
                int hue = this.hsbData.getHue();
                boolean preserveGrey = this.hsbData.isPreserveGrey();
                int ref = this.hsbData.getReference();
                int sat = this.hsbData.getSaturation();
                HSBReference r = this.hsb.getHSBReference();
                this.hsbData.setBrightness(r.getBrightness());
                this.hsbData.setHue(r.getHue());
                this.hsbData.setPreserveGrey(r.isPreserveGrey());
                this.hsbData.setReference(r.getReference());
                this.hsbData.setSaturation(r.getSaturation());
                r.setBrightness(bri);
                r.setHue(hue);
                r.setPreserveGrey(preserveGrey);
                r.setReference(ref);
                r.setSaturation(sat);
                if (this.cc != null) {
                    this.cc.setSelected(this.ccValue);
                    this.cc.ref.setValue(this.ccValue);
                    if (setTheme) {
                        this.hsb.update();
                        cp.colorizeIcon(this.hsb, this.ccValue);
                    }
                    this.ccValue = !this.ccValue;
                } else if (setTheme) {
                    this.hsb.update();
                    cp.colorizeIcon(this.hsb, true);
                }
                if (setTheme) {
                    cp.setTheme();
                }
            } else if (this.cc != null) {
                this.cc.setSelected(this.ccValue);
                this.cc.ref.setValue(this.ccValue);
                if (setTheme) {
                    cp.colorizeIcon(this.cc.hsb, this.ccValue);
                    cp.setTheme();
                }
                this.ccValue = !this.ccValue;
            } else if (this.insetsControl != null) {
                int mem = (Integer)this.insetsControl.getValue();
                this.insetsControl.commitValue(this.insetsControlValue);
                if (setTheme) {
                    cp.setTheme();
                }
                this.insetsControlValue = mem;
            } else if (this.intControl != null) {
                int mem = (Integer)this.intControl.getValue();
                this.intControl.commitValue(this.intControlValue);
                if (setTheme) {
                    cp.setTheme();
                }
                this.intControlValue = mem;
            } else if (this.cf != null) {
                ColoredFont temp = new ColoredFont(this.cfData);
                this.cfData = new ColoredFont(this.cf);
                this.cf.update(temp);
                cp.initFonts();
                if (setTheme) {
                    cp.setTheme();
                }
            } else if (this.params != null) {
                this.params.updateValues(this.paramData);
                this.paramData.updateValues();
                this.params.pasteParameters(false);
                this.params.updateReferenceColors();
            }
        }
    }
}

