/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class NonSortableTableModel
extends AbstractTableModel {
    protected Vector data;
    private Record template;
    private Vector columnNames;
    private boolean sortable;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public NonSortableTableModel() {
        this(false);
    }

    protected NonSortableTableModel(boolean sortable) {
        this.sortable = sortable;
        this.createData();
    }

    private void createData() {
        this.columnNames = new Vector();
        this.columnNames.add("C1");
        this.columnNames.add("C2");
        this.columnNames.add("C3");
        this.columnNames.add("C4");
        this.columnNames.add("C5");
        TableColorIcon.reset();
        this.template = null;
        this.data = new Vector();
        for (int i = 0; i < 50; ++i) {
            Record rec = new Record(i + 1);
            this.data.add(rec);
            if (this.template != null) continue;
            this.template = rec;
        }
    }

    public int getColumnCount() {
        if (this.template == null) {
            return 0;
        }
        return this.template.getColumnCount();
    }

    public int getRowCount() {
        return this.data.size();
    }

    public Object getValueAt(int row, int column) {
        Record rec = (Record)this.data.get(row);
        return rec.getValueAt(column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        if (column == 4) {
            Record rec = (Record)this.data.get(row);
            rec.setValueAt(aValue, column);
            this.fireTableRowsUpdated(row, row);
        }
    }

    public Class getColumnClass(int column) {
        if (this.template == null) {
            return Object.class;
        }
        return this.template.getColumnClass(column);
    }

    public String getColumnName(int column) {
        return (String)this.columnNames.get(column);
    }

    public boolean isCellEditable(int row, int col) {
        return col == 4;
    }

    public void addColumn(Class cl, int column) {
        this.columnNames.add(column, "N" + (column + 1));
        Iterator ii = this.data.iterator();
        while (ii.hasNext()) {
            Record rec = (Record)ii.next();
            rec.addColumn(cl, column);
        }
        this.fireTableStructureChanged();
    }

    public void removeColumn(int column) {
        this.columnNames.remove(column);
        Iterator ii = this.data.iterator();
        while (ii.hasNext()) {
            Record rec = (Record)ii.next();
            rec.removeColumn(column);
        }
        this.fireTableStructureChanged();
    }

    public void removeAllRows() {
        this.data.clear();
        this.fireTableDataChanged();
    }

    public void createNewData() {
        this.createData();
        this.fireTableStructureChanged();
    }

    public static final class TableColorIcon
    implements Icon {
        private Color color = Color.getHSBColor((float)((double)hue / 360.0), 0.5f, 0.9f);
        private static int hue = 0;

        TableColorIcon() {
            hue += 18;
        }

        static void reset() {
            hue = 0;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.DARK_GRAY);
            g.drawRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
            g.setColor(this.color);
            g.fillRect(x + 1, y + 1, this.getIconWidth() - 2, this.getIconHeight() - 2);
        }

        public int getIconWidth() {
            return 24;
        }

        public int getIconHeight() {
            return 12;
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 1;
            }
            if (!(o instanceof TableColorIcon)) {
                return 1;
            }
            Color c2 = ((TableColorIcon)o).color;
            if (this.color.getRGB() == c2.getRGB()) {
                return 0;
            }
            if (this.color.getRGB() > c2.getRGB()) {
                return 1;
            }
            return -1;
        }
    }

    protected class Record {
        private Vector values = new Vector();
        private int oldRow;
        private int newRow;

        protected Record(int index) {
            Integer v1 = new Integer(index);
            Icon v2 = this.createRandomIcon();
            String v3 = null;
            v3 = NonSortableTableModel.this.sortable ? (index == 1 ? "Sortable" : (index == 2 ? "Table" : (index == 3 ? "Data" : this.createRandomString()))) : (index == 1 ? "Non-" : (index == 2 ? "sortable" : (index == 3 ? "Table" : (index == 4 ? "Data" : this.createRandomString()))));
            Integer v4 = this.createRandomInteger();
            Boolean v5 = this.createRandomBoolean();
            this.values.add(v1);
            this.values.add(v2);
            this.values.add(v3);
            this.values.add(v4);
            this.values.add(v5);
        }

        public Object getValueAt(int column) {
            if (column < 0 || column >= this.values.size()) {
                return null;
            }
            return this.values.get(column);
        }

        public void setValueAt(Object v, int column) {
            this.values.remove(column);
            this.values.add(column, v);
        }

        public Class getColumnClass(int column) {
            if (column < 0 || column >= this.values.size()) {
                return class$java$lang$Object == null ? (class$java$lang$Object = NonSortableTableModel.class$("java.lang.Object")) : class$java$lang$Object;
            }
            return this.values.get(column).getClass();
        }

        public void addColumn(Class cl, int column) {
            if ((class$java$lang$Double == null ? (class$java$lang$Double = NonSortableTableModel.class$("java.lang.Double")) : class$java$lang$Double).equals(cl)) {
                this.values.add(column, this.createRandomDouble());
            } else if ((class$javax$swing$Icon == null ? (class$javax$swing$Icon = NonSortableTableModel.class$("javax.swing.Icon")) : class$javax$swing$Icon).equals(cl)) {
                this.values.add(column, this.createRandomIcon());
            } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = NonSortableTableModel.class$("java.lang.Integer")) : class$java$lang$Integer).equals(cl)) {
                this.values.add(column, this.createRandomInteger());
            } else if ((class$java$lang$String == null ? (class$java$lang$String = NonSortableTableModel.class$("java.lang.String")) : class$java$lang$String).equals(cl)) {
                this.values.add(column, this.createRandomString());
            } else if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = NonSortableTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(cl)) {
                this.values.add(column, this.createRandomBoolean());
            }
        }

        public void removeColumn(int column) {
            this.values.remove(column);
        }

        public int getColumnCount() {
            return this.values.size();
        }

        private String createRandomString() {
            char[] a = new char[3];
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.createRandomChar();
            }
            return new String(a);
        }

        private char createRandomChar() {
            return (char)(65 + (char)(Math.random() * 3.0));
        }

        private Boolean createRandomBoolean() {
            return new Boolean(Math.random() >= 0.5);
        }

        private Double createRandomDouble() {
            int x = (int)(Math.random() * 10000.0);
            return new Double((double)x / 100.0);
        }

        private Integer createRandomInteger() {
            return new Integer((int)(Math.random() * 20.0) + 1);
        }

        private Icon createRandomIcon() {
            return new TableColorIcon();
        }

        public int getNewRow() {
            return this.newRow;
        }

        public void setNewRow(int newRow) {
            this.newRow = newRow;
        }

        public int getOldRow() {
            return this.oldRow;
        }

        public void setOldRow(int oldRow) {
            this.oldRow = oldRow;
        }
    }
}

