/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyButtonUI;
import de.muntjak.tinylookandfeel.TinyInternalFrameTitlePane;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.TinyTitlePane;
import de.muntjak.tinylookandfeel.borders.TinyFrameBorder;
import de.muntjak.tinylookandfeel.borders.TinyInternalFrameBorder;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class TinyWindowButtonUI
extends TinyButtonUI {
    private static final HashMap cache = new HashMap();
    protected static final Dimension frameExternalButtonSize = new Dimension(21, 21);
    protected static final Dimension frameInternalButtonSize = new Dimension(17, 17);
    protected static final Dimension framePaletteButtonSize = new Dimension(13, 13);
    private int type;
    public static final int CLOSE = 0;
    public static final int MAXIMIZE = 1;
    public static final int MINIMIZE = 2;
    public static final String EXTERNAL_FRAME_BUTTON_KEY = "externalFrameButton";
    public static final String DISABLED_WINDOW_BUTTON_KEY = "disabledWindowButton";

    public static void clearCache() {
        cache.clear();
    }

    public static ComponentUI createUI(JComponent c) {
        throw new IllegalStateException("Must not be used this way.");
    }

    TinyWindowButtonUI(int type) {
        this.type = type;
    }

    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        button.setBorder(null);
        button.setFocusable(false);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        boolean frameSelected = false;
        boolean frameMaximized = false;
        Container window = c.getParent();
        if (window instanceof TinyInternalFrameTitlePane) {
            frameSelected = ((TinyInternalFrameTitlePane)window).isFrameSelected();
            frameMaximized = ((TinyInternalFrameTitlePane)window).isFrameMaximized();
        } else if (window instanceof TinyTitlePane) {
            frameSelected = ((TinyTitlePane)window).isSelected();
            frameMaximized = ((TinyTitlePane)window).isFrameMaximized();
        }
        int w = button.getWidth();
        int h = button.getHeight();
        ColorUIResource col = null;
        col = !frameSelected ? (button.isEnabled() ? (button.getModel().isPressed() ? (this.type == 0 ? Theme.frameButtClosePressedColor.getColor() : Theme.frameButtPressedColor.getColor()) : (this.type == 0 ? Theme.frameButtCloseColor.getColor() : Theme.frameButtColor.getColor())) : (this.type == 0 ? Theme.frameButtCloseDisabledColor.getColor() : Theme.frameButtDisabledColor.getColor())) : (button.getModel().isPressed() ? (button.getModel().isRollover() || button.getModel().isArmed() ? (this.type == 0 ? Theme.frameButtClosePressedColor.getColor() : Theme.frameButtPressedColor.getColor()) : (this.type == 0 ? Theme.frameButtCloseColor.getColor() : Theme.frameButtColor.getColor())) : (button.getModel().isRollover() ? (this.type == 0 ? Theme.frameButtCloseRolloverColor.getColor() : Theme.frameButtRolloverColor.getColor()) : (this.type == 0 ? Theme.frameButtCloseColor.getColor() : Theme.frameButtColor.getColor())));
        g.setColor(col);
        if (TinyLookAndFeel.controlPanelInstantiated) {
            this.drawXpButtonNoCache(g, button, col, w, h, frameSelected, frameMaximized);
        } else {
            this.drawXpButton(g, button, col, w, h, frameSelected, frameMaximized);
        }
    }

    private void drawXpButton(Graphics g, AbstractButton button, Color c, int w, int h, boolean frameSelected, boolean frameMaximized) {
        ButtonKey key = new ButtonKey(c, w, this.type, button.getModel().isRollover() || button.getModel().isArmed(), button.getModel().isPressed(), frameSelected, frameMaximized);
        Object value = cache.get(key);
        if (value != null) {
            g.drawImage((Image)value, 0, 0, button);
            return;
        }
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics imgGraphics = ((Image)img).getGraphics();
        imgGraphics.setColor(g.getColor());
        if (button.getClientProperty(EXTERNAL_FRAME_BUTTON_KEY) == Boolean.TRUE) {
            this.drawXpLargeButton(imgGraphics, button, c, w, h, frameSelected);
        } else {
            imgGraphics.fillRect(1, 1, w - 2, h - 2);
            if (frameSelected) {
                imgGraphics.setColor(TinyInternalFrameBorder.frameUpperColor);
                imgGraphics.drawLine(0, 0, w - 1, 0);
                imgGraphics.drawLine(0, 1, 0, 1);
                imgGraphics.drawLine(w - 1, 1, w - 1, 1);
                imgGraphics.setColor(TinyInternalFrameBorder.frameLowerColor);
                imgGraphics.drawLine(0, h - 1, w - 1, h - 1);
                imgGraphics.drawLine(0, h - 2, 0, h - 2);
                imgGraphics.drawLine(w - 1, h - 2, w - 1, h - 2);
            } else {
                imgGraphics.setColor(TinyInternalFrameBorder.disabledUpperColor);
                imgGraphics.drawLine(0, 0, w - 1, 0);
                imgGraphics.drawLine(0, 1, 0, 1);
                imgGraphics.drawLine(w - 1, 1, w - 1, 1);
                imgGraphics.setColor(TinyInternalFrameBorder.disabledLowerColor);
                imgGraphics.drawLine(0, h - 1, w - 1, h - 1);
                imgGraphics.drawLine(0, h - 2, 0, h - 2);
                imgGraphics.drawLine(w - 1, h - 2, w - 1, h - 2);
            }
            Color col = null;
            col = !button.isEnabled() ? (this.type == 0 ? Theme.frameButtCloseBorderDisabledColor.getColor() : Theme.frameButtBorderDisabledColor.getColor()) : (this.type == 0 ? Theme.frameButtCloseBorderColor.getColor() : Theme.frameButtBorderColor.getColor());
            DrawRoutines.drawRoundedBorder(imgGraphics, col, 0, 0, w, h);
            col = !button.isEnabled() ? (this.type == 0 ? Theme.frameButtCloseDisabledColor.getColor() : Theme.frameButtDisabledColor.getColor()) : (this.type == 0 ? Theme.frameButtCloseColor.getColor() : Theme.frameButtColor.getColor());
            imgGraphics.setColor(col);
            imgGraphics.drawLine(2, 1, w - 3, 1);
            imgGraphics.drawLine(1, 2, 1, h - 3);
            col = !button.isEnabled() ? (this.type == 0 ? Theme.frameButtCloseDisabledColor.getColor() : Theme.frameButtDisabledColor.getColor()) : (this.type == 0 ? ColorRoutines.darken(Theme.frameButtCloseColor.getColor(), 20) : ColorRoutines.darken(Theme.frameButtColor.getColor(), 20));
            imgGraphics.setColor(col);
            imgGraphics.drawLine(w - 2, 2, w - 2, h - 3);
            imgGraphics.drawLine(2, h - 2, w - 3, h - 2);
        }
        if (!button.isEnabled()) {
            if (this.type == 0) {
                imgGraphics.setColor(Theme.frameSymbolCloseDisabledColor.getColor());
            } else {
                imgGraphics.setColor(Theme.frameSymbolDisabledColor.getColor());
            }
        } else if (this.type == 0) {
            imgGraphics.setColor(Theme.frameSymbolCloseColor.getColor());
        } else {
            imgGraphics.setColor(Theme.frameSymbolColor.getColor());
        }
        this.drawXpSymbol(imgGraphics, button, c, w, h, frameSelected, frameMaximized);
        imgGraphics.dispose();
        g.drawImage(img, 0, 0, button);
        cache.put(key, img);
    }

    private void drawXpButtonNoCache(Graphics g, AbstractButton button, Color c, int w, int h, boolean frameSelected, boolean frameMaximized) {
        if (button.getClientProperty(EXTERNAL_FRAME_BUTTON_KEY) == Boolean.TRUE) {
            this.drawXpLargeButton(g, button, c, w, h, frameSelected);
        } else {
            g.fillRect(1, 1, w - 2, h - 2);
            if (frameSelected) {
                g.setColor(TinyInternalFrameBorder.frameUpperColor);
                g.drawLine(0, 0, w - 1, 0);
                g.drawLine(0, 1, 0, 1);
                g.drawLine(w - 1, 1, w - 1, 1);
                g.setColor(TinyInternalFrameBorder.frameLowerColor);
                g.drawLine(0, h - 1, w - 1, h - 1);
                g.drawLine(0, h - 2, 0, h - 2);
                g.drawLine(w - 1, h - 2, w - 1, h - 2);
            } else {
                g.setColor(TinyInternalFrameBorder.disabledUpperColor);
                g.drawLine(0, 0, w - 1, 0);
                g.drawLine(0, 1, 0, 1);
                g.drawLine(w - 1, 1, w - 1, 1);
                g.setColor(TinyInternalFrameBorder.disabledLowerColor);
                g.drawLine(0, h - 1, w - 1, h - 1);
                g.drawLine(0, h - 2, 0, h - 2);
                g.drawLine(w - 1, h - 2, w - 1, h - 2);
            }
            Color col = null;
            col = !button.isEnabled() ? (this.type == 0 ? Theme.frameButtCloseBorderDisabledColor.getColor() : Theme.frameButtBorderDisabledColor.getColor()) : (this.type == 0 ? Theme.frameButtCloseBorderColor.getColor() : Theme.frameButtBorderColor.getColor());
            DrawRoutines.drawWindowButtonBorder(g, col, 0, 0, w, h);
            col = !button.isEnabled() ? (this.type == 0 ? Theme.frameButtCloseDisabledColor.getColor() : Theme.frameButtDisabledColor.getColor()) : (this.type == 0 ? Theme.frameButtCloseColor.getColor() : Theme.frameButtColor.getColor());
            g.setColor(col);
            g.drawLine(2, 1, w - 3, 1);
            g.drawLine(1, 2, 1, h - 3);
            col = !button.isEnabled() ? (this.type == 0 ? Theme.frameButtCloseDisabledColor.getColor() : Theme.frameButtDisabledColor.getColor()) : (this.type == 0 ? ColorRoutines.darken(Theme.frameButtCloseColor.getColor(), 20) : ColorRoutines.darken(Theme.frameButtColor.getColor(), 20));
            g.setColor(col);
            g.drawLine(w - 2, 2, w - 2, h - 3);
            g.drawLine(2, h - 2, w - 3, h - 2);
        }
        if (!button.isEnabled()) {
            if (this.type == 0) {
                g.setColor(Theme.frameSymbolCloseDisabledColor.getColor());
            } else {
                g.setColor(Theme.frameSymbolDisabledColor.getColor());
            }
        } else if (this.type == 0) {
            g.setColor(Theme.frameSymbolCloseColor.getColor());
        } else {
            g.setColor(Theme.frameSymbolColor.getColor());
        }
        this.drawXpSymbol(g, button, c, w, h, frameSelected, frameMaximized);
    }

    private void drawXpLargeButton(Graphics g, AbstractButton b, Color c, int w, int h, boolean frameSelected) {
        boolean isDisabledButton;
        g.drawLine(1, 2, 1, h - 2);
        g.drawLine(1, 1, w - 2, 1);
        g.drawLine(w - 2, h - 2, w - 2, h - 2);
        boolean bl = isDisabledButton = b.getClientProperty(DISABLED_WINDOW_BUTTON_KEY) == Boolean.TRUE;
        if (isDisabledButton) {
            g.setColor(TinyFrameBorder.buttonUpperDisabledColor);
        } else {
            g.setColor(TinyTitlePane.buttonUpperColor);
        }
        g.drawLine(0, 0, w - 1, 0);
        g.drawLine(0, 1, 0, 1);
        g.drawLine(w - 1, 1, w - 1, 1);
        if (isDisabledButton) {
            g.setColor(TinyFrameBorder.buttonLowerDisabledColor);
        } else {
            g.setColor(TinyTitlePane.buttonLowerColor);
        }
        g.drawLine(0, h - 1, w - 1, h - 1);
        g.drawLine(0, h - 2, 0, h - 2);
        g.drawLine(w - 1, h - 2, w - 1, h - 2);
        if (isDisabledButton) {
            g.setColor(ColorRoutines.darken(c, 14));
        } else {
            g.setColor(ColorRoutines.darken(c, 28));
        }
        g.drawLine(w - 2, 2, w - 2, h - 3);
        g.drawLine(2, h - 2, w - 3, h - 2);
        int spread1 = Theme.frameButtSpreadLight.getValue();
        int spread2 = Theme.frameButtSpreadDark.getValue();
        if (!b.isEnabled()) {
            if (this.type == 0) {
                spread1 = Theme.frameButtCloseSpreadLightDisabled.getValue();
                spread2 = Theme.frameButtCloseSpreadDarkDisabled.getValue();
            } else {
                spread1 = Theme.frameButtSpreadLightDisabled.getValue();
                spread2 = Theme.frameButtSpreadDarkDisabled.getValue();
            }
        } else if (this.type == 0) {
            spread1 = Theme.frameButtCloseSpreadLight.getValue();
            spread2 = Theme.frameButtCloseSpreadDark.getValue();
        }
        float spreadStep1 = 10.0f * (float)spread1 / (float)(h - 5);
        float spreadStep2 = 10.0f * (float)spread2 / (float)(h - 5);
        int halfY = h / 2;
        for (int y = 2; y < h - 2; ++y) {
            int yd;
            if (y < halfY) {
                yd = halfY - y;
                g.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
            } else if (y == halfY) {
                g.setColor(c);
            } else {
                yd = y - halfY;
                g.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
            }
            g.drawLine(2, y, w - 3, y);
        }
        if (!b.isEnabled()) {
            if (this.type == 0) {
                DrawRoutines.drawWindowButtonBorder(g, Theme.frameButtCloseBorderDisabledColor.getColor(), 0, 0, w, h);
            } else {
                DrawRoutines.drawWindowButtonBorder(g, Theme.frameButtBorderDisabledColor.getColor(), 0, 0, w, h);
            }
        } else if (this.type == 0) {
            DrawRoutines.drawWindowButtonBorder(g, Theme.frameButtCloseBorderColor.getColor(), 0, 0, w, h);
        } else {
            DrawRoutines.drawWindowButtonBorder(g, Theme.frameButtBorderColor.getColor(), 0, 0, w, h);
        }
    }

    private void drawXpSymbol(Graphics g, AbstractButton button, Color c, int w, int h, boolean frameSelected, boolean frameMaximized) {
        if (button.getClientProperty(EXTERNAL_FRAME_BUTTON_KEY) == Boolean.TRUE) {
            this.drawXpLargeSymbol(g, button, c, w, h, frameSelected, frameMaximized);
            return;
        }
        if (button.getParent() instanceof TinyInternalFrameTitlePane && ((TinyInternalFrameTitlePane)button.getParent()).isPalette()) {
            this.drawXpSmallSymbol(g, button, c, w, h, frameSelected, frameMaximized);
            return;
        }
        if (!frameSelected) {
            if (button.isEnabled() && !button.getModel().isPressed()) {
                if (this.type == 0) {
                    g.setColor(Theme.frameSymbolCloseColor.getColor());
                } else {
                    g.setColor(Theme.frameSymbolColor.getColor());
                }
            } else if (this.type == 0) {
                if (button.getModel().isPressed()) {
                    g.setColor(Theme.frameSymbolClosePressedColor.getColor());
                } else {
                    g.setColor(Theme.frameSymbolCloseDisabledColor.getColor());
                }
            } else if (button.getModel().isPressed()) {
                g.setColor(Theme.frameSymbolPressedColor.getColor());
            } else {
                g.setColor(Theme.frameSymbolDisabledColor.getColor());
            }
        } else if (button.getModel().isPressed() && (button.getModel().isRollover() || button.getModel().isArmed())) {
            if (this.type == 0) {
                g.setColor(Theme.frameSymbolClosePressedColor.getColor());
            } else {
                g.setColor(Theme.frameSymbolPressedColor.getColor());
            }
        } else if (this.type == 0) {
            g.setColor(Theme.frameSymbolCloseColor.getColor());
        } else {
            g.setColor(Theme.frameSymbolColor.getColor());
        }
        int x = 0;
        int y = 0;
        switch (this.type) {
            case 0: {
                g.drawLine(x + 4, y + 3, x + 4, y + 3);
                g.drawLine(x + 12, y + 3, x + 12, y + 3);
                g.drawLine(x + 3, y + 4, x + 5, y + 4);
                g.drawLine(x + 11, y + 4, x + 13, y + 4);
                g.drawLine(x + 4, y + 5, x + 6, y + 5);
                g.drawLine(x + 10, y + 5, x + 12, y + 5);
                g.drawLine(x + 5, y + 6, x + 7, y + 6);
                g.drawLine(x + 9, y + 6, x + 11, y + 6);
                g.drawLine(x + 6, y + 7, x + 10, y + 7);
                g.drawLine(x + 7, y + 8, x + 9, y + 8);
                g.drawLine(x + 4, y + 13, x + 4, y + 13);
                g.drawLine(x + 12, y + 13, x + 12, y + 13);
                g.drawLine(x + 3, y + 12, x + 5, y + 12);
                g.drawLine(x + 11, y + 12, x + 13, y + 12);
                g.drawLine(x + 4, y + 11, x + 6, y + 11);
                g.drawLine(x + 10, y + 11, x + 12, y + 11);
                g.drawLine(x + 5, y + 10, x + 7, y + 10);
                g.drawLine(x + 9, y + 10, x + 11, y + 10);
                g.drawLine(x + 6, y + 9, x + 10, y + 9);
                break;
            }
            case 1: {
                if (frameMaximized) {
                    g.fillRect(x + 5, y + 3, 8, 2);
                    g.drawLine(x + 12, y + 5, x + 12, y + 9);
                    g.drawLine(x + 11, y + 9, x + 11, y + 9);
                    g.drawLine(x + 3, y + 6, x + 9, y + 6);
                    g.drawRect(x + 3, y + 7, 6, 5);
                    break;
                }
                g.fillRect(x + 3, y + 3, 11, 2);
                g.drawRect(x + 3, y + 5, 10, 8);
                break;
            }
            case 2: {
                g.fillRect(x + 3, y + 11, 7, 3);
            }
        }
    }

    private void drawXpSmallSymbol(Graphics g, AbstractButton button, Color c, int w, int h, boolean frameSelected, boolean frameMaximized) {
        if (!frameSelected) {
            if (button.isEnabled() && !button.getModel().isPressed()) {
                if (this.type == 0) {
                    g.setColor(Theme.frameSymbolCloseColor.getColor());
                } else {
                    g.setColor(Theme.frameSymbolColor.getColor());
                }
            } else if (this.type == 0) {
                if (button.getModel().isPressed()) {
                    g.setColor(Theme.frameSymbolClosePressedColor.getColor());
                } else {
                    g.setColor(Theme.frameSymbolCloseDisabledColor.getColor());
                }
            } else if (button.getModel().isPressed()) {
                g.setColor(Theme.frameSymbolPressedColor.getColor());
            } else {
                g.setColor(Theme.frameSymbolDisabledColor.getColor());
            }
        } else if (button.getModel().isPressed() && (button.getModel().isRollover() || button.getModel().isArmed())) {
            if (this.type == 0) {
                g.setColor(Theme.frameSymbolClosePressedColor.getColor());
            } else {
                g.setColor(Theme.frameSymbolPressedColor.getColor());
            }
        } else if (this.type == 0) {
            g.setColor(Theme.frameSymbolCloseColor.getColor());
        } else {
            g.setColor(Theme.frameSymbolColor.getColor());
        }
        int x = 0;
        int y = 0;
        switch (this.type) {
            case 0: {
                g.drawLine(x + 3, y + 2, x + 3, y + 2);
                g.drawLine(x + 9, y + 2, x + 9, y + 2);
                g.drawLine(x + 2, y + 3, x + 4, y + 3);
                g.drawLine(x + 8, y + 3, x + 10, y + 3);
                g.drawLine(x + 3, y + 4, x + 5, y + 4);
                g.drawLine(x + 7, y + 4, x + 9, y + 4);
                g.drawLine(x + 4, y + 5, x + 8, y + 5);
                g.drawLine(x + 5, y + 6, x + 7, y + 6);
                g.drawLine(x + 4, y + 7, x + 8, y + 7);
                g.drawLine(x + 3, y + 8, x + 5, y + 8);
                g.drawLine(x + 7, y + 8, x + 9, y + 8);
                g.drawLine(x + 2, y + 9, x + 4, y + 9);
                g.drawLine(x + 8, y + 9, x + 10, y + 9);
                g.drawLine(x + 3, y + 10, x + 3, y + 10);
                g.drawLine(x + 9, y + 10, x + 9, y + 10);
                break;
            }
            case 1: {
                if (frameMaximized) {
                    g.drawRect(x + 3, y + 6, 4, 3);
                    g.drawLine(x + 3, y + 5, x + 7, y + 5);
                    g.fillRect(x + 5, y + 2, 5, y + 2);
                    g.drawLine(x + 9, y + 4, x + 9, y + 7);
                    break;
                }
                g.drawLine(x + 3, y + 3, x + 9, y + 3);
                g.drawRect(x + 3, y + 4, 6, 5);
                break;
            }
            case 2: {
                g.fillRect(x + 3, y + 8, 5, 2);
            }
        }
    }

    private void drawXpLargeSymbol(Graphics g, AbstractButton b, Color c, int w, int h, boolean frameSelected, boolean frameMaximized) {
        if (!frameSelected) {
            if (b.isEnabled() && !b.getModel().isPressed()) {
                if (this.type == 0) {
                    g.setColor(Theme.frameSymbolCloseColor.getColor());
                } else {
                    g.setColor(Theme.frameSymbolColor.getColor());
                }
            } else if (this.type == 0) {
                if (b.getModel().isPressed()) {
                    g.setColor(Theme.frameSymbolClosePressedColor.getColor());
                } else {
                    g.setColor(Theme.frameSymbolCloseDisabledColor.getColor());
                }
            } else if (b.getModel().isPressed()) {
                g.setColor(Theme.frameSymbolPressedColor.getColor());
            } else {
                g.setColor(Theme.frameSymbolDisabledColor.getColor());
            }
        } else if (b.getModel().isPressed() && (b.getModel().isRollover() || b.getModel().isArmed())) {
            if (this.type == 0) {
                g.setColor(Theme.frameSymbolClosePressedColor.getColor());
            } else {
                g.setColor(Theme.frameSymbolPressedColor.getColor());
            }
        } else if (this.type == 0) {
            g.setColor(Theme.frameSymbolCloseColor.getColor());
        } else {
            g.setColor(Theme.frameSymbolColor.getColor());
        }
        int x = 0;
        int y = 0;
        switch (this.type) {
            case 0: {
                g.drawLine(x + 5, y + 5, x + 6, y + 5);
                g.drawLine(x + 14, y + 5, x + 15, y + 5);
                g.drawLine(x + 5, y + 6, x + 7, y + 6);
                g.drawLine(x + 13, y + 6, x + 15, y + 6);
                g.drawLine(x + 6, y + 7, x + 8, y + 7);
                g.drawLine(x + 12, y + 7, x + 14, y + 7);
                g.drawLine(x + 7, y + 8, x + 9, y + 8);
                g.drawLine(x + 11, y + 8, x + 13, y + 8);
                g.drawLine(x + 8, y + 9, x + 12, y + 9);
                g.drawLine(x + 9, y + 10, x + 11, y + 10);
                g.drawLine(x + 5, y + 15, x + 6, y + 15);
                g.drawLine(x + 14, y + 15, x + 15, y + 15);
                g.drawLine(x + 5, y + 14, x + 7, y + 14);
                g.drawLine(x + 13, y + 14, x + 15, y + 14);
                g.drawLine(x + 6, y + 13, x + 8, y + 13);
                g.drawLine(x + 12, y + 13, x + 14, y + 13);
                g.drawLine(x + 7, y + 12, x + 9, y + 12);
                g.drawLine(x + 11, y + 12, x + 13, y + 12);
                g.drawLine(x + 8, y + 11, x + 12, y + 11);
                break;
            }
            case 1: {
                if (frameMaximized) {
                    g.drawLine(x + 8, y + 6, x + 13, y + 6);
                    g.drawLine(x + 5, y + 10, x + 10, y + 10);
                    break;
                }
                g.fillRect(x + 5, y + 6, 10, 2);
                break;
            }
            case 2: {
                g.fillRect(x + 5, y + 14, 6, 2);
            }
        }
        ColorUIResource col = null;
        col = b.isEnabled() ? Theme.frameSymbolLightColor.getColor() : Theme.frameSymbolLightDisabledColor.getColor();
        g.setColor(col);
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                if (frameMaximized) {
                    g.drawLine(x + 7, y + 6, x + 7, y + 8);
                    g.drawLine(x + 9, y + 7, x + 13, y + 7);
                    g.drawLine(x + 13, y + 8, x + 13, y + 10);
                    g.drawLine(x + 12, y + 12, x + 14, y + 12);
                    g.drawLine(x + 4, y + 10, x + 4, y + 16);
                    g.drawLine(x + 5, y + 16, x + 11, y + 16);
                    g.drawLine(x + 6, y + 11, x + 10, y + 11);
                    g.drawLine(x + 10, y + 12, x + 10, y + 14);
                    break;
                }
                g.drawLine(x + 4, y + 6, x + 4, y + 15);
                g.drawLine(x + 4, y + 16, x + 15, y + 16);
                g.drawLine(x + 6, y + 8, x + 13, y + 8);
                g.drawLine(x + 14, y + 8, x + 14, y + 14);
                break;
            }
            case 2: {
                g.drawLine(x + 4, y + 13, x + 4, y + 16);
                g.drawLine(x + 5, y + 16, x + 11, y + 16);
            }
        }
        col = this.type == 0 ? (b.isEnabled() ? Theme.frameSymbolCloseDarkColor.getColor() : Theme.frameSymbolCloseDarkDisabledColor.getColor()) : (b.isEnabled() ? Theme.frameSymbolDarkColor.getColor() : Theme.frameSymbolDarkDisabledColor.getColor());
        g.setColor(col);
        switch (this.type) {
            case 0: {
                g.drawLine(x + 5, y + 4, x + 6, y + 4);
                g.drawLine(x + 14, y + 4, x + 15, y + 4);
                g.drawLine(x + 7, y + 5, x + 7, y + 5);
                g.drawLine(x + 13, y + 5, x + 13, y + 5);
                g.drawLine(x + 8, y + 6, x + 8, y + 6);
                g.drawLine(x + 12, y + 6, x + 12, y + 6);
                g.drawLine(x + 9, y + 7, x + 9, y + 7);
                g.drawLine(x + 11, y + 7, x + 11, y + 7);
                g.drawLine(x + 10, y + 8, x + 10, y + 8);
                g.drawLine(x + 8, y + 10, x + 8, y + 10);
                g.drawLine(x + 12, y + 10, x + 12, y + 10);
                g.drawLine(x + 7, y + 11, x + 7, y + 11);
                g.drawLine(x + 13, y + 11, x + 13, y + 11);
                g.drawLine(x + 6, y + 12, x + 6, y + 12);
                g.drawLine(x + 14, y + 12, x + 14, y + 12);
                g.drawLine(x + 5, y + 13, x + 5, y + 13);
                g.drawLine(x + 15, y + 13, x + 15, y + 13);
                g.drawLine(x + 4, y + 14, x + 4, y + 14);
                g.drawLine(x + 16, y + 14, x + 16, y + 14);
                break;
            }
            case 1: {
                if (frameMaximized) {
                    g.drawLine(x + 8, y + 5, x + 14, y + 5);
                    g.drawLine(x + 14, y + 6, x + 14, y + 11);
                    g.drawLine(x + 12, y + 11, x + 13, y + 11);
                    g.drawLine(x + 8, y + 7, x + 8, y + 8);
                    g.drawLine(x + 5, y + 9, x + 11, y + 9);
                    g.drawLine(x + 11, y + 10, x + 11, y + 15);
                    g.drawLine(x + 5, y + 15, x + 10, y + 15);
                    g.drawLine(x + 5, y + 11, x + 5, y + 14);
                    break;
                }
                g.drawLine(x + 5, y + 5, x + 14, y + 5);
                g.drawLine(x + 15, y + 5, x + 15, y + 15);
                g.drawLine(x + 5, y + 15, x + 14, y + 15);
                g.drawLine(x + 5, y + 8, x + 5, y + 14);
                break;
            }
            case 2: {
                g.drawLine(x + 5, y + 13, x + 10, y + 13);
                g.drawLine(x + 11, y + 13, x + 11, y + 15);
            }
        }
    }

    public static TinyWindowButtonUI createButtonUIForType(int type) {
        return new TinyWindowButtonUI(type);
    }

    public Dimension getPreferredSize(JComponent c) {
        if (((AbstractButton)c).getClientProperty(EXTERNAL_FRAME_BUTTON_KEY) == Boolean.TRUE) {
            return frameExternalButtonSize;
        }
        if (c.getParent() instanceof TinyInternalFrameTitlePane && ((TinyInternalFrameTitlePane)c.getParent()).isPalette()) {
            return framePaletteButtonSize;
        }
        return frameInternalButtonSize;
    }

    private static class ButtonKey {
        private Color background;
        private int size;
        private int type;
        private boolean rollover;
        private boolean pressed;
        private boolean frameSelected;
        private boolean frameMaximized;

        ButtonKey(Color background, int size, int type, boolean rollover, boolean pressed, boolean frameSelected, boolean frameMaximized) {
            this.background = background;
            this.size = size;
            this.type = type + 1;
            this.rollover = rollover;
            this.pressed = pressed;
            this.frameSelected = frameSelected;
            this.frameMaximized = frameMaximized;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ButtonKey)) {
                return false;
            }
            ButtonKey other = (ButtonKey)o;
            return this.size == other.size && this.type == other.type && this.rollover == other.rollover && this.pressed == other.pressed && this.frameSelected == other.frameSelected && this.frameMaximized == other.frameMaximized && this.background.equals(other.background);
        }

        public int hashCode() {
            return this.background.hashCode() * this.type * this.size * (this.rollover ? 2 : 1) * (this.pressed ? 8 : 4) * (this.frameSelected ? 32 : 16) * (this.frameMaximized ? 128 : 64);
        }
    }
}

