/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyButtonUI;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.plaf.ComponentUI;

public class TinySpinnerButtonUI
extends TinyButtonUI {
    private static final HashMap cache = new HashMap();
    private int orientation;
    protected static final Dimension xpSize = new Dimension(15, 8);

    public static void clearCache() {
        cache.clear();
    }

    public static Container getSpinnerParent(Component button) {
        boolean spinnerFound = false;
        for (Container parent = button.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JSpinner)) continue;
            spinnerFound = true;
            if (!spinnerFound) continue;
            return parent;
        }
        return null;
    }

    public static JSpinner getSpinner(Component button) {
        return (JSpinner)button.getParent();
    }

    public static ComponentUI createUI(JComponent c) {
        throw new IllegalStateException("Must not be used this way.");
    }

    TinySpinnerButtonUI(int type) {
        this.orientation = type;
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        if (!button.isEnabled()) {
            g.setColor(Theme.spinnerButtDisabledColor.getColor());
        } else if (button.getModel().isPressed()) {
            if (button.getModel().isRollover() || button.getModel().isArmed()) {
                g.setColor(Theme.spinnerButtPressedColor.getColor());
            } else {
                g.setColor(Theme.spinnerButtColor.getColor());
            }
        } else if (button.getModel().isRollover() || button.getModel().isArmed()) {
            g.setColor(Theme.spinnerButtRolloverColor.getColor());
        } else {
            g.setColor(Theme.spinnerButtColor.getColor());
        }
        if (TinyLookAndFeel.controlPanelInstantiated) {
            this.drawXpButtonNoCache(g, button);
        } else {
            this.drawXpButton(g, button);
        }
    }

    private void drawXpButton(Graphics g, AbstractButton b) {
        boolean paintRollover = !b.getModel().isPressed() && b.getModel().isRollover() && Theme.spinnerRollover.getValue();
        Color bg = TinySpinnerButtonUI.getSpinnerParent(b).getBackground();
        ButtonKey key = new ButtonKey(g.getColor(), bg, b.getSize(), paintRollover, this.orientation);
        Object value = cache.get(key);
        if (value != null) {
            g.drawImage((Image)value, 0, 0, b);
            return;
        }
        int x2 = b.getWidth() - 1;
        int y2 = b.getHeight() - 1;
        int h = b.getHeight();
        BufferedImage img = new BufferedImage(x2 + 1, h, 2);
        Graphics imgGraphics = ((Image)img).getGraphics();
        int spread1 = Theme.spinnerSpreadLight.getValue();
        int spread2 = Theme.spinnerSpreadDark.getValue();
        if (!b.isEnabled()) {
            spread1 = Theme.spinnerSpreadLightDisabled.getValue();
            spread2 = Theme.spinnerSpreadDarkDisabled.getValue();
        }
        float spreadStep1 = 10.0f * (float)spread1 / (float)(h - 2);
        float spreadStep2 = 10.0f * (float)spread2 / (float)(h - 2);
        int halfY = h / 2;
        Color c = g.getColor();
        for (int y = 1; y < h - 1; ++y) {
            int yd;
            if (y < halfY) {
                yd = halfY - y;
                imgGraphics.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
            } else if (y == halfY) {
                imgGraphics.setColor(c);
            } else {
                yd = y - halfY;
                imgGraphics.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
            }
            imgGraphics.drawLine(1, y, x2, y);
        }
        imgGraphics.setColor(bg);
        imgGraphics.drawRect(0, 0, x2, y2);
        imgGraphics.setColor(TinySpinnerButtonUI.getSpinner(b).getBackground());
        if (Boolean.TRUE.equals(b.getClientProperty("isNextButton"))) {
            imgGraphics.drawLine(0, y2, 0, y2);
        } else {
            imgGraphics.drawLine(0, 0, 0, 0);
        }
        if (!b.isEnabled()) {
            imgGraphics.setColor(Theme.spinnerBorderDisabledColor.getColor());
        } else {
            imgGraphics.setColor(Theme.spinnerBorderColor.getColor());
        }
        imgGraphics.drawLine(1, 0, x2 - 1, 0);
        imgGraphics.drawLine(1, y2, x2 - 1, y2);
        imgGraphics.drawLine(0, 1, 0, y2 - 1);
        imgGraphics.drawLine(x2, 1, x2, y2 - 1);
        if (paintRollover) {
            DrawRoutines.drawRolloverBorder(imgGraphics, Theme.buttonRolloverColor.getColor(), 0, 0, x2 + 1, h);
        }
        if (!b.isEnabled()) {
            imgGraphics.setColor(Theme.spinnerArrowDisabledColor.getColor());
        } else {
            imgGraphics.setColor(Theme.spinnerArrowColor.getColor());
        }
        this.drawXpArrow(imgGraphics, b);
        imgGraphics.dispose();
        g.drawImage(img, 0, 0, b);
        cache.put(key, img);
    }

    private void drawXpButtonNoCache(Graphics g, AbstractButton b) {
        boolean paintRollover = !b.getModel().isPressed() && b.getModel().isRollover() && Theme.spinnerRollover.getValue();
        int x2 = b.getWidth() - 1;
        int y2 = b.getHeight() - 1;
        int h = y2 + 1;
        int spread1 = Theme.spinnerSpreadLight.getValue();
        int spread2 = Theme.spinnerSpreadDark.getValue();
        if (!b.isEnabled()) {
            spread1 = Theme.spinnerSpreadLightDisabled.getValue();
            spread2 = Theme.spinnerSpreadDarkDisabled.getValue();
        }
        float spreadStep1 = 10.0f * (float)spread1 / (float)(h - 2);
        float spreadStep2 = 10.0f * (float)spread2 / (float)(h - 2);
        int halfY = h / 2;
        Color c = g.getColor();
        for (int y = 1; y < h - 1; ++y) {
            int yd;
            if (y < halfY) {
                yd = halfY - y;
                g.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
            } else if (y == halfY) {
                g.setColor(c);
            } else {
                yd = y - halfY;
                g.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
            }
            g.drawLine(1, y, x2, y);
        }
        if (!b.isEnabled()) {
            g.setColor(Theme.spinnerArrowDisabledColor.getColor());
        } else {
            g.setColor(Theme.spinnerArrowColor.getColor());
        }
        this.drawXpArrow(g, b);
    }

    private void drawXpArrow(Graphics g, AbstractButton b) {
        int y = (b.getSize().height - 6) / 2;
        switch (this.orientation) {
            case 1: {
                g.drawLine(7, --y + 2, 7, y + 2);
                g.drawLine(6, y + 3, 8, y + 3);
                g.drawLine(5, y + 4, 9, y + 4);
                g.drawLine(4, y + 5, 6, y + 5);
                g.drawLine(8, y + 5, 10, y + 5);
                break;
            }
            case 5: {
                g.drawLine(4, y + 2, 6, y + 2);
                g.drawLine(8, y + 2, 10, y + 2);
                g.drawLine(5, y + 3, 9, y + 3);
                g.drawLine(6, y + 4, 8, y + 4);
                g.drawLine(7, y + 5, 7, y + 5);
            }
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        return xpSize;
    }

    private static class ButtonKey {
        private Color background;
        private Color parentBackground;
        private Dimension size;
        private boolean rollover;
        private int orientation;

        ButtonKey(Color background, Color parentBackground, Dimension size, boolean rollover, int orientation) {
            this.background = background;
            this.parentBackground = parentBackground;
            this.size = size;
            this.rollover = rollover;
            this.orientation = orientation;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ButtonKey)) {
                return false;
            }
            ButtonKey other = (ButtonKey)o;
            return this.orientation == other.orientation && this.rollover == other.rollover && this.background.equals(other.background) && this.parentBackground.equals(other.parentBackground) && this.size.equals(other.size);
        }

        public int hashCode() {
            return this.background.hashCode() * this.parentBackground.hashCode() * this.size.hashCode() * this.orientation * (this.rollover ? 2 : 1);
        }
    }
}

