/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.TinyUtils;
import de.muntjak.tinylookandfeel.borders.TinyPopupMenuBorder;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

public class TinyPopupFactory
extends PopupFactory {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_DIALOGS = false;
    public static final String SHADOW_POPUP_KEY = "SHADOW_POPUP_KEY";
    public static final String VERTICAL_IMAGE_KEY = "VERTICAL_IMAGE_KEY";
    public static final String HORIZONTAL_IMAGE_KEY = "HORIZONTAL_IMAGE_KEY";
    public static final String COMPONENT_ORIENTATION_KEY = "COMPONENT_ORIENTATION_KEY";
    private static final Vector DIALOGS = new Vector();
    private static WindowListener activationListener;
    private static final Stack SHADOW_POPUP_CACHE;
    private PopupFactory storedFactory;

    private TinyPopupFactory(PopupFactory factory) {
        this.storedFactory = factory;
    }

    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        boolean useShadowPopup;
        Popup popup = super.getPopup(owner, contents, x, y);
        boolean bl = useShadowPopup = contents instanceof JPopupMenu && ((JComponent)contents).getBorder() instanceof TinyPopupMenuBorder;
        if (useShadowPopup) {
            return ShadowPopup.getInstance(owner, popup, (JPopupMenu)contents, x, y);
        }
        return popup;
    }

    public static void addDialog(JDialog dialog) {
        if (TinyUtils.isOSMac()) {
            return;
        }
        if (!dialog.isModal()) {
            DIALOGS.add(dialog);
            if (activationListener == null) {
                activationListener = new WindowAdapter(){

                    public void windowActivated(WindowEvent e) {
                        Window w = e.getWindow();
                        DIALOGS.remove(w);
                        DIALOGS.add(w);
                    }

                    public void windowClosed(WindowEvent e) {
                        Window w = e.getWindow();
                        w.removeWindowListener(activationListener);
                        DIALOGS.remove(w);
                    }
                };
            }
            dialog.addWindowListener(activationListener);
        }
    }

    public static void closeDialogs() {
        Iterator ii = DIALOGS.iterator();
        while (ii.hasNext()) {
            JDialog d = (JDialog)ii.next();
            d.dispose();
        }
    }

    private static void printDialogs() {
        System.out.println();
        String indent = "";
        Iterator ii = DIALOGS.iterator();
        while (ii.hasNext()) {
            JDialog d = (JDialog)ii.next();
            System.out.println(indent + d.getTitle());
            indent = indent + "  ";
        }
    }

    public static void install() {
        if (!TinyPopupFactory.isPopupShadowEnabled()) {
            return;
        }
        PopupFactory factory = PopupFactory.getSharedInstance();
        if (factory instanceof TinyPopupFactory) {
            return;
        }
        if (!DIALOGS.isEmpty()) {
            DIALOGS.clear();
        }
        PopupFactory.setSharedInstance(new TinyPopupFactory(factory));
    }

    public static boolean isPopupShadowEnabled() {
        return !TinyUtils.isOSMac() && Theme.menuPopupShadow.getValue() && TinyLookAndFeel.ROBOT != null;
    }

    public static void uninstall() {
        while (!SHADOW_POPUP_CACHE.empty()) {
            Object o = SHADOW_POPUP_CACHE.pop();
            o = null;
        }
        while (!DIALOGS.isEmpty()) {
            Window w = (Window)DIALOGS.get(0);
            w.removeWindowListener(activationListener);
            DIALOGS.remove(w);
        }
        PopupFactory factory = PopupFactory.getSharedInstance();
        if (!(factory instanceof TinyPopupFactory)) {
            return;
        }
        PopupFactory.setSharedInstance(((TinyPopupFactory)factory).storedFactory);
    }

    static {
        SHADOW_POPUP_CACHE = new Stack();
    }

    private static class ShadowPopup
    extends Popup {
        private static final Rectangle RECT = new Rectangle();
        private static final Point POINT = new Point();
        private static final Dimension SIZE = new Dimension();
        private Component owner;
        private Popup delegate;
        private JPopupMenu contents;
        private int x;
        private int y;
        private BufferedImage vertImg;
        private BufferedImage horzImg;

        private ShadowPopup(Component owner, Popup delegate, JPopupMenu contents, int x, int y) {
            this.init(owner, delegate, contents, x, y);
        }

        static ShadowPopup getInstance(Component owner, Popup delegate, JPopupMenu contents, int x, int y) {
            if (SHADOW_POPUP_CACHE.empty()) {
                return new ShadowPopup(owner, delegate, contents, x, y);
            }
            ShadowPopup popup = (ShadowPopup)SHADOW_POPUP_CACHE.pop();
            popup.init(owner, delegate, contents, x, y);
            return popup;
        }

        private void init(Component owner, Popup delegate, JPopupMenu contents, int x, int y) {
            this.owner = owner;
            this.delegate = delegate;
            this.contents = contents;
            this.x = x;
            this.y = y;
            ComponentOrientation co = ComponentOrientation.LEFT_TO_RIGHT;
            if (owner != null) {
                co = owner.getComponentOrientation();
            }
            contents.putClientProperty(TinyPopupFactory.SHADOW_POPUP_KEY, Boolean.TRUE);
            contents.putClientProperty(TinyPopupFactory.COMPONENT_ORIENTATION_KEY, co);
        }

        public void show() {
            this.makeSnapshot();
            this.delegate.show();
        }

        public void hide() {
            this.delegate.hide();
            this.uninstall();
        }

        private void makeSnapshot() {
            boolean isLeftToRight;
            SIZE.setSize(this.contents.getPreferredSize());
            if (ShadowPopup.SIZE.width < 5 || ShadowPopup.SIZE.height < 5) {
                return;
            }
            Object co = this.contents.getClientProperty(TinyPopupFactory.COMPONENT_ORIENTATION_KEY);
            boolean bl = isLeftToRight = co == null ? true : ((ComponentOrientation)co).isLeftToRight();
            if (isLeftToRight) {
                JLayeredPane layeredPane;
                RECT.setBounds(this.x + ShadowPopup.SIZE.width - 5, this.y, 5, ShadowPopup.SIZE.height);
                this.vertImg = TinyLookAndFeel.ROBOT.createScreenCapture(RECT);
                this.contents.putClientProperty(TinyPopupFactory.VERTICAL_IMAGE_KEY, this.vertImg);
                RECT.setBounds(this.x, this.y + ShadowPopup.SIZE.height - 5, ShadowPopup.SIZE.width, 5);
                this.horzImg = TinyLookAndFeel.ROBOT.createScreenCapture(RECT);
                this.contents.putClientProperty(TinyPopupFactory.HORIZONTAL_IMAGE_KEY, this.horzImg);
                JRootPane rootPane = SwingUtilities.getRootPane(this.owner);
                if (rootPane != null && (layeredPane = rootPane.getLayeredPane()) != null) {
                    int windowHeight;
                    int windowWidth;
                    int layeredPaneWidth = layeredPane.getWidth();
                    int layeredPaneHeight = layeredPane.getHeight();
                    ShadowPopup.POINT.x = this.x;
                    ShadowPopup.POINT.y = this.y;
                    SwingUtilities.convertPointFromScreen(POINT, layeredPane);
                    ShadowPopup.RECT.x = ShadowPopup.POINT.x;
                    ShadowPopup.RECT.y = ShadowPopup.POINT.y + ShadowPopup.SIZE.height - 5;
                    ShadowPopup.RECT.width = ShadowPopup.SIZE.width;
                    ShadowPopup.RECT.height = 5;
                    if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > layeredPaneWidth) {
                        ShadowPopup.RECT.width = layeredPaneWidth - ShadowPopup.RECT.x;
                    }
                    if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > layeredPaneHeight) {
                        ShadowPopup.RECT.height = layeredPaneHeight - ShadowPopup.RECT.y;
                    }
                    Graphics2D g = this.horzImg.createGraphics();
                    if (!RECT.isEmpty()) {
                        ((Graphics)g).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        g.setClip(RECT);
                        if (layeredPane instanceof JComponent) {
                            JLayeredPane c = layeredPane;
                            boolean doubleBuffered = c.isDoubleBuffered();
                            c.setDoubleBuffered(false);
                            c.paintAll(g);
                            c.setDoubleBuffered(doubleBuffered);
                        } else {
                            layeredPane.paintAll(g);
                        }
                        ((Graphics)g).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    Iterator ii = DIALOGS.iterator();
                    while (ii.hasNext()) {
                        Window window = (Window)ii.next();
                        windowWidth = window.getWidth();
                        windowHeight = window.getHeight();
                        ShadowPopup.POINT.x = this.x;
                        ShadowPopup.POINT.y = this.y;
                        SwingUtilities.convertPointFromScreen(POINT, window);
                        ShadowPopup.RECT.x = ShadowPopup.POINT.x;
                        ShadowPopup.RECT.y = ShadowPopup.POINT.y + ShadowPopup.SIZE.height - 5;
                        ShadowPopup.RECT.width = ShadowPopup.SIZE.width;
                        ShadowPopup.RECT.height = 5;
                        if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > windowWidth) {
                            ShadowPopup.RECT.width = windowWidth - ShadowPopup.RECT.x;
                        }
                        if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > windowHeight) {
                            ShadowPopup.RECT.height = windowHeight - ShadowPopup.RECT.y;
                        }
                        if (RECT.isEmpty()) continue;
                        ((Graphics)g).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        g.setClip(RECT);
                        window.paintAll(g);
                        ((Graphics)g).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    g.dispose();
                    ShadowPopup.POINT.x = this.x;
                    ShadowPopup.POINT.y = this.y;
                    SwingUtilities.convertPointFromScreen(POINT, layeredPane);
                    ShadowPopup.RECT.x = ShadowPopup.POINT.x + ShadowPopup.SIZE.width - 5;
                    ShadowPopup.RECT.y = ShadowPopup.POINT.y;
                    ShadowPopup.RECT.width = 5;
                    ShadowPopup.RECT.height = ShadowPopup.SIZE.height;
                    if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > layeredPaneWidth) {
                        ShadowPopup.RECT.width = layeredPaneWidth - ShadowPopup.RECT.x;
                    }
                    if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > layeredPaneHeight) {
                        ShadowPopup.RECT.height = layeredPaneHeight - ShadowPopup.RECT.y;
                    }
                    g = this.vertImg.createGraphics();
                    if (!RECT.isEmpty()) {
                        ((Graphics)g).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        g.setClip(RECT);
                        if (layeredPane instanceof JComponent) {
                            JLayeredPane c = layeredPane;
                            boolean doubleBuffered = c.isDoubleBuffered();
                            c.setDoubleBuffered(false);
                            c.paintAll(g);
                            c.setDoubleBuffered(doubleBuffered);
                        } else {
                            layeredPane.paintAll(g);
                        }
                        ((Graphics)g).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    ii = DIALOGS.iterator();
                    while (ii.hasNext()) {
                        Window window = (Window)ii.next();
                        windowWidth = window.getWidth();
                        windowHeight = window.getHeight();
                        ShadowPopup.POINT.x = this.x;
                        ShadowPopup.POINT.y = this.y;
                        SwingUtilities.convertPointFromScreen(POINT, window);
                        ShadowPopup.RECT.x = ShadowPopup.POINT.x + ShadowPopup.SIZE.width - 5;
                        ShadowPopup.RECT.y = ShadowPopup.POINT.y;
                        ShadowPopup.RECT.width = 5;
                        ShadowPopup.RECT.height = ShadowPopup.SIZE.height;
                        if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > windowWidth) {
                            ShadowPopup.RECT.width = windowWidth - ShadowPopup.RECT.x;
                        }
                        if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > windowHeight) {
                            ShadowPopup.RECT.height = windowHeight - ShadowPopup.RECT.y;
                        }
                        if (RECT.isEmpty()) continue;
                        ((Graphics)g).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        g.setClip(RECT);
                        window.paintAll(g);
                        ((Graphics)g).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    g.dispose();
                }
            } else {
                JLayeredPane layeredPane;
                RECT.setBounds(this.x, this.y, 5, ShadowPopup.SIZE.height);
                this.vertImg = TinyLookAndFeel.ROBOT.createScreenCapture(RECT);
                this.contents.putClientProperty(TinyPopupFactory.VERTICAL_IMAGE_KEY, this.vertImg);
                RECT.setBounds(this.x, this.y + ShadowPopup.SIZE.height - 5, ShadowPopup.SIZE.width, 5);
                this.horzImg = TinyLookAndFeel.ROBOT.createScreenCapture(RECT);
                this.contents.putClientProperty(TinyPopupFactory.HORIZONTAL_IMAGE_KEY, this.horzImg);
                JRootPane rootPane = SwingUtilities.getRootPane(this.owner);
                if (rootPane != null && (layeredPane = rootPane.getLayeredPane()) != null) {
                    int windowHeight;
                    int windowWidth;
                    int layeredPaneWidth = layeredPane.getWidth();
                    int layeredPaneHeight = layeredPane.getHeight();
                    ShadowPopup.POINT.x = this.x;
                    ShadowPopup.POINT.y = this.y;
                    SwingUtilities.convertPointFromScreen(POINT, layeredPane);
                    ShadowPopup.RECT.x = ShadowPopup.POINT.x;
                    ShadowPopup.RECT.y = ShadowPopup.POINT.y + ShadowPopup.SIZE.height - 5;
                    ShadowPopup.RECT.width = ShadowPopup.SIZE.width;
                    ShadowPopup.RECT.height = 5;
                    if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > layeredPaneWidth) {
                        ShadowPopup.RECT.width = layeredPaneWidth - ShadowPopup.RECT.x;
                    }
                    if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > layeredPaneHeight) {
                        ShadowPopup.RECT.height = layeredPaneHeight - ShadowPopup.RECT.y;
                    }
                    Graphics2D g = this.horzImg.createGraphics();
                    if (!RECT.isEmpty()) {
                        ((Graphics)g).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        g.setClip(RECT);
                        if (layeredPane instanceof JComponent) {
                            JLayeredPane c = layeredPane;
                            boolean doubleBuffered = c.isDoubleBuffered();
                            c.setDoubleBuffered(false);
                            c.paintAll(g);
                            c.setDoubleBuffered(doubleBuffered);
                        } else {
                            layeredPane.paintAll(g);
                        }
                        ((Graphics)g).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    Iterator ii = DIALOGS.iterator();
                    while (ii.hasNext()) {
                        Window window = (Window)ii.next();
                        windowWidth = window.getWidth();
                        windowHeight = window.getHeight();
                        ShadowPopup.POINT.x = this.x;
                        ShadowPopup.POINT.y = this.y;
                        SwingUtilities.convertPointFromScreen(POINT, window);
                        ShadowPopup.RECT.x = ShadowPopup.POINT.x;
                        ShadowPopup.RECT.y = ShadowPopup.POINT.y + ShadowPopup.SIZE.height - 5;
                        ShadowPopup.RECT.width = ShadowPopup.SIZE.width;
                        ShadowPopup.RECT.height = 5;
                        if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > windowWidth) {
                            ShadowPopup.RECT.width = windowWidth - ShadowPopup.RECT.x;
                        }
                        if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > windowHeight) {
                            ShadowPopup.RECT.height = windowHeight - ShadowPopup.RECT.y;
                        }
                        if (RECT.isEmpty()) continue;
                        ((Graphics)g).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        g.setClip(RECT);
                        window.paintAll(g);
                        ((Graphics)g).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    g.dispose();
                    ShadowPopup.POINT.x = this.x;
                    ShadowPopup.POINT.y = this.y;
                    SwingUtilities.convertPointFromScreen(POINT, layeredPane);
                    ShadowPopup.RECT.x = ShadowPopup.POINT.x;
                    ShadowPopup.RECT.y = ShadowPopup.POINT.y;
                    ShadowPopup.RECT.width = 5;
                    ShadowPopup.RECT.height = ShadowPopup.SIZE.height;
                    if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > layeredPaneWidth) {
                        ShadowPopup.RECT.width = layeredPaneWidth - ShadowPopup.RECT.x;
                    }
                    if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > layeredPaneHeight) {
                        ShadowPopup.RECT.height = layeredPaneHeight - ShadowPopup.RECT.y;
                    }
                    g = this.vertImg.createGraphics();
                    if (!RECT.isEmpty()) {
                        ((Graphics)g).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        g.setClip(RECT);
                        if (layeredPane instanceof JComponent) {
                            JLayeredPane c = layeredPane;
                            boolean doubleBuffered = c.isDoubleBuffered();
                            c.setDoubleBuffered(false);
                            c.paintAll(g);
                            c.setDoubleBuffered(doubleBuffered);
                        } else {
                            layeredPane.paintAll(g);
                        }
                        ((Graphics)g).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    ii = DIALOGS.iterator();
                    while (ii.hasNext()) {
                        Window window = (Window)ii.next();
                        windowWidth = window.getWidth();
                        windowHeight = window.getHeight();
                        ShadowPopup.POINT.x = this.x;
                        ShadowPopup.POINT.y = this.y;
                        SwingUtilities.convertPointFromScreen(POINT, window);
                        ShadowPopup.RECT.x = ShadowPopup.POINT.x;
                        ShadowPopup.RECT.y = ShadowPopup.POINT.y;
                        ShadowPopup.RECT.width = 5;
                        ShadowPopup.RECT.height = ShadowPopup.SIZE.height;
                        if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > windowWidth) {
                            ShadowPopup.RECT.width = windowWidth - ShadowPopup.RECT.x;
                        }
                        if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > windowHeight) {
                            ShadowPopup.RECT.height = windowHeight - ShadowPopup.RECT.y;
                        }
                        if (RECT.isEmpty()) continue;
                        ((Graphics)g).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        g.setClip(RECT);
                        window.paintAll(g);
                        ((Graphics)g).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    g.dispose();
                }
            }
        }

        private void uninstall() {
            this.contents.putClientProperty(TinyPopupFactory.SHADOW_POPUP_KEY, null);
            this.contents.putClientProperty(TinyPopupFactory.COMPONENT_ORIENTATION_KEY, null);
            this.contents.putClientProperty(TinyPopupFactory.VERTICAL_IMAGE_KEY, null);
            this.contents.putClientProperty(TinyPopupFactory.HORIZONTAL_IMAGE_KEY, null);
            this.contents = null;
            this.delegate = null;
            this.vertImg = null;
            this.horzImg = null;
            SHADOW_POPUP_CACHE.push(this);
        }
    }
}

