/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tintfu;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.tintfu.DotFileViewer;
import net.sourceforge.tintfu.DotParameters;
import net.sourceforge.tintfu.Pair;
import net.sourceforge.tintfu.PairCollection;
import net.sourceforge.tintfu.Queue;
import net.sourceforge.tintfu.StateTransition;

public class YStateMachine
implements Serializable {
    private PairCollection stateTransitions = new PairCollection();
    private PrintStream changeRequestLogStream;
    private PrintStream stateChangeLogStream = null;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Queue lastTransitions = new Queue(10);
    private String name = "unnamedYStateMachine";
    private VetoableChangeSupport vetoableChangeSupport = new VetoableChangeSupport(this);
    private String[] states = null;
    private boolean inTransition = false;
    private int state = -1;

    public YStateMachine() {
        this.addPropertyChangeListener(new DoTransition());
        this.addVetoableChangeListener(new RequestTransition());
    }

    public String[] getAllStates() {
        String[] ret = new String[this.states.length];
        boolean j = false;
        int i = 0;
        while (i < this.states.length) {
            ret[i] = new String(this.states[i]);
            ++i;
        }
        return ret;
    }

    public void setChangeRequestLogStream(PrintStream changeRequestLogStream) {
        this.changeRequestLogStream = changeRequestLogStream;
    }

    public PrintStream getChangeRequestLogStream() {
        return this.changeRequestLogStream;
    }

    public synchronized void setInitialState(String aState) throws Exception {
        int index = this.stateIndex(aState);
        if (index < 0) {
            throw new Exception("Cannot set '" + aState + "' as the initial state: no such state.");
        }
        this.state = index;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setState(String state) throws PropertyVetoException {
        String oldState = this.states[this.state];
        this.vetoableChangeSupport.fireVetoableChange("state", oldState, state);
        this.state = this.stateIndex(state);
        this.propertyChangeSupport.firePropertyChange("state", oldState, state);
    }

    public synchronized void setState(int state) throws PropertyVetoException {
        String oldState = this.states[this.state];
        this.vetoableChangeSupport.fireVetoableChange("state", oldState, this.states[state]);
        this.state = state;
        this.propertyChangeSupport.firePropertyChange("state", oldState, this.states[state]);
    }

    public String getState() {
        return this.states[this.state];
    }

    public void setStateChangeLogStream(PrintStream stateChangeLogStream) {
        this.stateChangeLogStream = stateChangeLogStream;
    }

    public int getStateIndex() {
        return this.state;
    }

    public synchronized boolean setStateIndirect(String aState) {
        Set oneBefore;
        String orgState = this.states[this.state];
        StateTransition dir = null;
        dir = this.findStateTransition(orgState, aState);
        if (dir != null) {
            try {
                this.setState(aState);
                return true;
            }
            catch (Exception ex) {
                this.setStateIndirect(orgState);
            }
        }
        if ((oneBefore = this.stateTransitions.getPairsForB(aState)).isEmpty()) {
            return false;
        }
        Iterator i = oneBefore.iterator();
        while (i.hasNext()) {
            StateTransition str = (StateTransition)i.next();
            if (!this.setStateIndirect(str.getFromState())) continue;
            try {
                this.setState(aState);
                return true;
            }
            catch (Exception ex) {
                this.setStateIndirect(orgState);
                return false;
            }
        }
        return false;
    }

    public StateTransition[][] getStateTransitionMatrix() {
        List all = this.stateTransitions.getAll();
        StateTransition[][] ret = new StateTransition[this.states.length][this.states.length];
        int i = 0;
        while (i < all.size()) {
            StateTransition str;
            ret[this.stateIndex((String)str.getFromState())][this.stateIndex((String)str.getToState())] = str = (StateTransition)all.get(i);
            ++i;
        }
        return ret;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.addVetoableChangeListener(l);
    }

    public void printLastTransitions(PrintStream out) {
        out.println("Last " + this.lastTransitions.size() + " on state machine [" + this.name + "]:");
        int i = 0;
        while (i < this.lastTransitions.size()) {
            StateTransition str = (StateTransition)this.lastTransitions.get(i);
            out.print(str.getFromState() + " -> " + str.getToState());
            if (str.getComment() != null) {
                out.println(" (" + str.getComment() + ")");
            } else {
                out.println();
            }
            ++i;
        }
        out.flush();
    }

    public void printTerminalStates(PrintStream out) {
        boolean header = false;
        int i = 0;
        while (i < this.states.length) {
            if (this.stateTransitions.getPairsForB(this.states[i]).isEmpty()) {
                if (!header) {
                    out.println("Start (from-only) states:");
                    header = true;
                    out.print(this.states[i]);
                } else {
                    out.print(", " + this.states[i]);
                }
            }
            ++i;
        }
        if (header) {
            out.println();
            header = false;
        }
        int i2 = 0;
        while (i2 < this.states.length) {
            if (this.stateTransitions.getPairsForA(this.states[i2]).isEmpty()) {
                if (!header) {
                    out.println("End (to-only) states:");
                    header = true;
                    out.print(this.states[i2]);
                } else {
                    out.print(", " + this.states[i2]);
                }
            }
            ++i2;
        }
        if (header) {
            out.println();
            header = false;
        }
        int i3 = 0;
        while (i3 < this.states.length) {
            if (this.stateTransitions.getPairsForA(this.states[i3]).isEmpty() && this.stateTransitions.getPairsForB(this.states[i3]).isEmpty()) {
                if (!header) {
                    out.println("Unreachable(!) states:");
                    header = true;
                    out.print(this.states[i3]);
                } else {
                    out.print(", " + this.states[i3]);
                }
            }
            ++i3;
        }
        if (header) {
            out.println();
            boolean bl = false;
        }
    }

    public void registerStateTransition(StateTransition transition) throws Exception {
        if (transition.getFromState().equals(transition.getToState())) {
            throw new Exception("Attempt to register a transition from and to the same state!");
        }
        if (this.findStateTransition(transition.getFromState(), transition.getToState()) != null) {
            throw new Exception("Attempt to register a duplicate state transition!");
        }
        this.appendNewState(transition.getFromState());
        this.appendNewState(transition.getToState());
        this.stateTransitions.add(transition);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    public boolean stateExists(String aState) {
        return this.stateIndex(aState) >= 0;
    }

    public synchronized int stateIndex(String aState) {
        if (this.states == null) {
            return -1;
        }
        int i = 0;
        while (i < this.states.length) {
            if (this.states[i].equals(aState)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void writeDotFile(DotParameters parms) throws Exception {
        PrintWriter pw = new PrintWriter(new FileOutputStream(parms.dotFile));
        pw.println("digraph \"" + this.getName() + "\" {\n    size=\"" + parms.graphSize + "\";");
        int i = 0;
        while (i < this.states.length) {
            pw.print("    \"node" + i + "\" [ label=\"" + this.states[i] + "\" shape=ellipse ");
            if (parms.highLightCurrentState != null && i == this.state) {
                pw.print("style=filled fillcolor=" + parms.highLightCurrentState + " ");
            } else if (parms.highLightNextStates != null && i != this.state && this.findStateTransition(this.states[this.state], this.states[i]) != null) {
                pw.print("style=filled fillcolor=" + parms.highLightNextStates + " ");
            }
            pw.println("];");
            ++i;
        }
        List all = this.stateTransitions.getAll();
        if (parms.transitionColor != null) {
            int i2 = 0;
            while (i2 < all.size()) {
                StateTransition str = (StateTransition)all.get(i2);
                pw.print("    \"node" + this.stateIndex(str.getFromState()) + "\" -> " + "\"node" + this.stateIndex(str.getToState()) + "\" [ color=" + parms.transitionColor);
                if (parms.transitionComments != null && str.getComment() != null) {
                    pw.println(" fontcolor=" + parms.transitionComments + " label=\"" + str.getComment() + "\" ];");
                } else {
                    pw.println(" ];");
                }
                ++i2;
            }
        }
        if (parms.showHistory != null) {
            int offset = this.lastTransitions.size() - 1;
            int i3 = 0;
            while (i3 < this.lastTransitions.size()) {
                StateTransition str = (StateTransition)this.lastTransitions.get(i3);
                pw.print("    \"node" + this.stateIndex(str.getFromState()) + "\" -> " + "\"node" + this.stateIndex(str.getToState()) + "\"");
                pw.print(" [ color=" + parms.showHistory);
                pw.print(" fontcolor=" + parms.showHistory);
                if (str.getComment() != null) {
                    pw.println(" label=\"T=" + (i3 - offset) + ", " + str.getComment() + "\" ];");
                } else {
                    pw.println(" label=\"T=" + (i3 - offset) + "\" ];");
                }
                ++i3;
            }
        }
        pw.println("}");
        pw.flush();
        pw.close();
        if (parms.outputFile != null) {
            FileOutputStream out = new FileOutputStream(parms.outputFile);
            Process p = Runtime.getRuntime().exec(parms.dotCommand + " -T" + parms.outputType + " " + parms.dotFile.getAbsolutePath());
            byte[] buf = new byte[4096];
            int bts = 0;
            while ((bts = p.getInputStream().read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, bts);
            }
            out.flush();
            ((OutputStream)out).close();
            p.waitFor();
            if (parms.showCommand != null) {
                p = Runtime.getRuntime().exec(parms.showCommand + " " + parms.outputFile.getAbsolutePath());
            } else {
                new DotFileViewer(parms).start();
            }
        }
    }

    protected void appendNewState(String state) {
        if (!this.stateExists(state)) {
            if (this.states == null) {
                this.states = new String[1];
                this.states[0] = state;
                this.state = 0;
            } else {
                String[] tmp = new String[this.states.length + 1];
                int i = 0;
                while (i < this.states.length) {
                    tmp[i] = this.states[i];
                    ++i;
                }
                tmp[i] = state;
                this.states = tmp;
            }
        }
    }

    protected List findStateTransitionsFrom(String fromState) {
        return new ArrayList(this.stateTransitions.getPairsForA(fromState));
    }

    protected List findStateTransitionsTo(String toState) {
        return new ArrayList(this.stateTransitions.getPairsForB(toState));
    }

    private StateTransition findStateTransition(String fromState, String toState) {
        return (StateTransition)this.stateTransitions.get(new Pair(fromState, toState));
    }

    public final boolean stateIs(String state) {
        return this.getState().equals(state);
    }

    private class RequestTransition
    implements VetoableChangeListener {
        private RequestTransition() {
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (evt.getPropertyName().equals("state")) {
                String fromState = (String)evt.getOldValue();
                if (fromState == null) {
                    throw new PropertyVetoException("No initial state defined?", evt);
                }
                String toState = (String)evt.getNewValue();
                if (fromState == null) {
                    throw new PropertyVetoException("Cannot change to (null) state!", evt);
                }
                if (!YStateMachine.this.inTransition) {
                    YStateMachine.this.inTransition = true;
                    StateTransition str = YStateMachine.this.findStateTransition(fromState, toState);
                    if (YStateMachine.this.changeRequestLogStream != null) {
                        YStateMachine.this.changeRequestLogStream.print("State transition request in [" + YStateMachine.this.name + "]: from '" + fromState + "' to '" + toState + "'");
                        if (str == null) {
                            YStateMachine.this.changeRequestLogStream.println(" ILLEGAL!");
                        } else if (str.getComment() != null) {
                            YStateMachine.this.changeRequestLogStream.println(" (" + str.getComment() + ")");
                        } else {
                            YStateMachine.this.changeRequestLogStream.println();
                        }
                        YStateMachine.this.changeRequestLogStream.flush();
                    }
                    if (str == null) {
                        throw new PropertyVetoException("Illegal state transition in [" + YStateMachine.this.name + "]: from '" + fromState + "' to '" + toState + "'", evt);
                    }
                    try {
                        str.before();
                    }
                    catch (Exception ex) {
                        PropertyVetoException pve = new PropertyVetoException("State transition failed in [" + YStateMachine.this.name + "]: from '" + fromState + "' to '" + toState + "'", evt);
                        pve.initCause(ex);
                        throw pve;
                    }
                } else {
                    if (YStateMachine.this.changeRequestLogStream != null) {
                        YStateMachine.this.changeRequestLogStream.println("Reverting: in [" + YStateMachine.this.name + "]: " + fromState + " -> " + toState);
                    }
                    YStateMachine.this.inTransition = false;
                }
            }
        }
    }

    private class DoTransition
    implements PropertyChangeListener {
        private DoTransition() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            block7: {
                if (!evt.getPropertyName().equals("state")) break block7;
                String fromState = evt.getOldValue().toString();
                String toState = evt.getNewValue().toString();
                YStateMachine.this.inTransition = false;
                StateTransition str = YStateMachine.this.findStateTransition(fromState, toState);
                if (YStateMachine.this.stateChangeLogStream != null) {
                    YStateMachine.this.stateChangeLogStream.print("State transition in [" + YStateMachine.this.name + "]: from '" + fromState + "' to '" + toState + "'");
                    if (str == null) {
                        YStateMachine.this.stateChangeLogStream.println(" ILLEGAL? Error in YStateMachine!");
                    } else if (str.getComment() != null) {
                        YStateMachine.this.stateChangeLogStream.println(" (" + str.getComment() + ")");
                    } else {
                        YStateMachine.this.stateChangeLogStream.println();
                    }
                    YStateMachine.this.stateChangeLogStream.flush();
                }
                try {
                    str.after();
                    YStateMachine.this.lastTransitions.add(str);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }
}

