/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tintfu;

import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import net.sourceforge.tintfu.DotAttribute;
import net.sourceforge.tintfu.DotEdge;
import net.sourceforge.tintfu.DotElement;
import net.sourceforge.tintfu.DotNode;

public class DotTreeNode
extends DefaultMutableTreeNode {
    DotElement elm;

    public DotTreeNode(DotElement elm) {
        this.elm = elm;
    }

    public void getGlobalLists(List nodes, List edges) {
        if (this.elm instanceof DotNode) {
            nodes.add(this);
        } else if (this.elm instanceof DotEdge) {
            edges.add(this);
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            ((DotTreeNode)e.nextElement()).getGlobalLists(nodes, edges);
        }
    }

    public String getNodeDesc(String nodeName) {
        String s = this.findNodeDesc(nodeName);
        if (s != null) {
            return s;
        }
        return nodeName;
    }

    public void renameNode(String oldName, String newName) {
        if (this.elm instanceof DotNode) {
            if (this.elm.getName().equals(oldName)) {
                ((DotAttribute)this.elm.fields.get(0)).setValue(newName);
            }
        } else if (this.elm instanceof DotEdge) {
            if (this.elm.getFromNode().equals(oldName)) {
                ((DotAttribute)this.elm.fields.get(0)).setValue(newName);
            }
            if (this.elm.getToNode().equals(oldName)) {
                ((DotAttribute)this.elm.fields.get(1)).setValue(newName);
            }
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            ((DotTreeNode)e.nextElement()).renameNode(oldName, newName);
        }
    }

    public String toString() {
        return this.elm.toString();
    }

    private String findNodeDesc(String nodeName) {
        if (this.elm instanceof DotNode && this.elm.getName().equals(nodeName)) {
            DotAttribute da = this.elm.getByName("label");
            if (da != null && da.getValue() != null) {
                return nodeName + ": (" + da.getValue() + ")";
            }
            return nodeName;
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            String s = ((DotTreeNode)e.nextElement()).findNodeDesc(nodeName);
            if (s == null) continue;
            return s;
        }
        return null;
    }
}

