/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tintfu;

import net.sourceforge.tintfu.AbstractToken;
import net.sourceforge.tintfu.Token;

public class DefaultToken
extends AbstractToken {
    public static final Token EOF = new DefaultToken(null, -6);
    public static final Token BOF = new DefaultToken(null, -7);
    public static final Token BLANK = new DefaultToken(Character.toString('\u0000'), 0);
    private int type = 0;

    public DefaultToken() {
    }

    public DefaultToken(String s) {
        super.setToken(s);
        this.type = -1;
    }

    public DefaultToken(String s, int type) {
        super.setToken(s);
        this.type = type;
    }

    public DefaultToken(boolean b) {
        super.setToken("" + b);
        this.type = -4;
    }

    public DefaultToken(long l) {
        super.setToken("" + l);
        this.type = -2;
    }

    public DefaultToken(double d) {
        super.setToken("" + d);
        this.type = -3;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void guessTypeFromValue() {
        String s = super.getToken();
        if (s == null) {
            this.type = 0;
            return;
        }
        try {
            Long.valueOf(s);
            this.type = -2;
            return;
        }
        catch (NumberFormatException ex) {
            try {
                Double.valueOf(s);
                this.type = -3;
                return;
            }
            catch (NumberFormatException ex2) {
                if (s.equals("false") || s.equals("true")) {
                    this.type = -4;
                    return;
                }
                this.type = -1;
                return;
            }
        }
    }

    public String dumpAsString() {
        String retValue = super.dumpAsString() + ", type=" + this.type;
        return retValue;
    }
}

