package au.edu.mq.itec802.cardGame.blackjack;

import java.util.Scanner;

import au.edu.mq.itec802.cardGame.Card;
import au.edu.mq.itec802.cardGame.Hand;
import au.edu.mq.itec802.cardGame.Pack;
import au.edu.mq.itec802.cardGame.Player;

/**
 * The Class BlackjackPlayer.
 *
 * @author		Tomas Krajca <tomas.krajca@students.mq.edu.au>
 * @version 	$Id: BlackjackPlayer.java 22/03/2011 jumbo$
 */
public class BlackjackPlayer extends BlackjackAbstractPlayer implements Player {

	/** The initial amount. */
	private int initAmount;

	/** The actual amount. */
	private int amount;

	/** The player's number. */
	private int number = -1;

	/**
	 * Play -- simulates the playing player
	 * 
	 * @see
	 * au.edu.mq.itec802.cardGame.blackjack.BlackjackAbstractPlayer#play
	 * (au.edu.mq.itec802.cardGame.blackjack.BlackjackPack)
	 */
	@Override
	public void play(BlackjackPack pack) {
		hand = new Hand();
		Scanner in = new Scanner(System.in);
		String yesno = "";
		Card card;

		hand.add(pack.getCard());
		hand.add(pack.getCard());
		do {
			System.out.print("User " + number + " hand: " + hand + " (total "
					+ this.score(true));
			if (this.score(true) != this.score(false))
				System.out.print("/" + this.score(false));
			System.out.println(")");
			System.out.print("Deal another card? (yes/no): ");
			do {
				yesno = in.nextLine();
				if (!yesno.toLowerCase().equals("yes")
						&& !yesno.toLowerCase().equals("no"))
					System.out.print("Please, answer 'yes' or 'no': ");
			} while (!yesno.toLowerCase().equals("yes")
					&& !yesno.toLowerCase().equals("no"));
			if (yesno.toLowerCase().equals("no"))
				break;

			card = pack.getCard();
			System.out.println("Card dealt: " + card);
			hand.add(card);
		} while (this.score(false) < 21); // the lowest possible

		if (this.score(false) == 21)
			System.out.println("Player " + this.getNumber() + " Blackjack!");
		else if (this.score(false) > 21)
			System.out.println("Player " + this.getNumber() + " goes bust!");
	}

	/**
	 * Gets the actual amount.
	 * 
	 * @return the actual amount
	 */
	@Override
	public int getAmount() {
		return amount;
	}

	/**
	 * Sets the amount.
	 * 
	 * @param amount
	 *            the amount to set
	 */
	public void setAmount(int amount) {
		this.amount = amount;
	}

	/**
	 * Instantiates a new blackjack player.
	 * 
	 * @param number the player's number
	 * @param amount the initial amount
	 * @param bet the bet
	 */
	public BlackjackPlayer(int number, int amount, int bet) {
		super();
		this.initAmount = amount;
		this.amount = amount;
		this.number = number;
		this.bet = bet;

	}

	/**
	 * Gets the initial amount
	 * 
	 * @see
	 * au.edu.mq.itec802.cardGame.blackjack.BlackjackAbstractPlayer#getInitAmount
	 * ()
	 */
	@Override
	public int getInitAmount() {
		return this.initAmount;
	}

	/**
	 * Gets the player's number
	 * 
	 * @see
	 * au.edu.mq.itec802.cardGame.blackjack.BlackjackAbstractPlayer#getNumber()
	 */
	@Override
	public int getNumber() {
		return this.number;
	}

	/**
	 * Simulates the playing player
	 * 
	 * @see
	 * au.edu.mq.itec802.cardGame.blackjack.BlackjackAbstractPlayer#play
	 * (au.edu.mq.itec802.cardGame.blackjack.BlackjackPack)
	 */
	@Override
	public void play(Pack pack) {
		this.play((BlackjackPack) pack);
	}

	/**
	 * Simulates the player winning a round
	 * 
	 * @see
	 * au.edu.mq.itec802.cardGame.blackjack.BlackjackAbstractPlayer#wins(int)
	 */
	@Override
	public void wins(int bet) {
		this.amount += bet;
	}

	/**
	 * Simulates the player losing a round
	 * 
	 * @see au.edu.mq.itec802.cardGame.blackjack.BlackjackAbstractPlayer#loses()
	 */
	@Override
	public void loses() {
		this.amount -= this.bet;
	}
}
