package au.edu.mq.itec802.cardGame.blackjack;

import java.util.ArrayList;
import au.edu.mq.itec802.cardGame.Card;
import au.edu.mq.itec802.cardGame.Pack;

/**
 * The Class BlackjackPack -- models a pack of cards for Blackjack.
 *
 * @author		Tomas Krajca <tomas.krajca@students.mq.edu.au>
 * @version 	$Id: BlackjackPack.java 22/03/2011 jumbo$
 */
public class BlackjackPack implements Pack {

	/** The cards. */
	private ArrayList<Card> cards;

	/** The suits. */
	private ArrayList<String> suits;

	/** The high cards -- not numbers. */
	private ArrayList<String> highCards;

	/**
	 * Shuffles the pack
	 *
	 * @see au.edu.mq.itec802.cardGame.Pack#shuffle(int)
	 */
	public void shuffle(int alot) {
		// generate
		for (int i = 0; i < 4; i++) {
			for (int j = 2; j <= 10; j++)
				cards.add(new Card(j, j + " of " + suits.get(i), false));
			for (int j = 0; j < 3; j++)
				cards.add(new Card(10, highCards.get(j) + " of " + suits.get(i),
						false));
			cards.add(new Card(1, "Ace of " + suits.get(i), true));
		}
		// shuffle
		Card card = null;
		int index = 0;
		int index2 = 0;
		int seed = (int) (Math.random() * alot * Math.random() * alot);
		// System.out.print("Shuffling ...");
		for (int i = 0; i < seed; i++) {
			// if (i % (79 * 3) == 0)
			// System.out.println();
			// if (i % 3 == 0)
			// System.out.print(".");
			index = (int) (Math.random() * cards.size());
			index2 = (int) (Math.random() * cards.size() - 1);
			card = cards.get(index);
			cards.remove(index);
			cards.add(cards.get(index2));
			cards.remove(index2);
			cards.add(card);
		}
		// System.out.println();
	}

	/**
	 * Instantiates a new blackjack pack.
	 * 
	 * Note: aces are treated separately -- they should, in fact, be modeled 
	 *+as a subclass of Card
	 */
	public BlackjackPack() {
		super();
		suits = new ArrayList<String>();
		suits.add("hearts");
		suits.add("spades");
		suits.add("diamonds");
		suits.add("clubs");

		highCards = new ArrayList<String>();
		highCards.add("King");
		highCards.add("Queen");
		highCards.add("Jack");

		cards = new ArrayList<Card>();
	}

	/**
	 * Get the top-most card from the pack
	 * 
	 * @see au.edu.mq.itec802.cardGame.Pack#getCard()
	 */
	public Card getCard() {
		if (cards.size() == 0)
			this.shuffle(137);

		Card card = cards.get(0);
		cards.remove(0);
		return card;
	}

	/**
	 * Serializes the pack into string
	 * 
	 * @return String representation of the pack
	 */
	@Override
	public String toString() {
		String output = "";
		for (Card card : cards)
			output += card.toString() + "\n";

		return output;
	}

}
