package au.edu.mq.itec802.cardGame.blackjack;

import au.edu.mq.itec802.cardGame.Card;
import au.edu.mq.itec802.cardGame.Hand;
import au.edu.mq.itec802.cardGame.Pack;

/**
 * The Class BlackjackHouse.
 * 
 * @author		Tomas Krajca <tomas.krajca@students.mq.edu.au>
 * @version 	$Id: BlackjackHouse.java 22/03/2011 jumbo$
 */
public class BlackjackHouse extends BlackjackAbstractPlayer {

	/**
	 * Simulates the house playing a round
	 * 
	 * @see
	 * au.edu.mq.itec802.cardGame.blackjack.BlackjackAbstractPlayer#play
	 * (au.edu.mq.itec802.cardGame.blackjack.BlackjackPack)
	 */
	@Override
	public void play(BlackjackPack pack) {
		hand = new Hand();
		Card card;
		bet = 50;

		hand.add(pack.getCard());
		hand.add(pack.getCard());

		do {
			System.out.print("House hand: " + hand + " (total "
					+ this.score(true));
			if (this.score(true) != this.score(false))
				System.out.print("/" + this.score(false));
			System.out.println(")");
			if (this.score(true) >= 17)
				break;
			card = pack.getCard();
			System.out.println("House deals another card: " + card);
			hand.add(card);
		} while (this.score(true) < 17); // the lowest possible score
		if (this.score(false) == 21)
			System.out.print("House Blackjack!");
		if (this.score(false) > 21)
			System.out.println("House goes bust!");
	}

	/**
	 * The house is house, obviously :)
	 * 
	 * @see
	 * au.edu.mq.itec802.cardGame.blackjack.BlackjackAbstractPlayer#isHouse()
	 */
	@Override
	public boolean isHouse() {
		return true;
	}
	
	/**
	 * The house does not have any number, obviously, it's not a player
	 * 
	 * Note: this should never be called
	 * @see
	 * au.edu.mq.itec802.cardGame.blackjack.BlackjackAbstractPlayer#getNumber()
	 */
	@Override
	public int getNumber() {
		return -1;
	}

	/**
	 * The house has an infinite amount
	 * 
	 * Note: this should never be called
	 * @see
	 * au.edu.mq.itec802.cardGame.blackjack.BlackjackAbstractPlayer#getAmount()
	 */
	@Override
	public int getAmount() {
		return -1;
	}

	// this should not ever be called
	/**
	 * The house has infinite amount
	 * 
	 * Note: this should never be called
	 * @see
	 * au.edu.mq.itec802.cardGame.blackjack.BlackjackAbstractPlayer#getInitAmount
	 * ()
	 */
	@Override
	public int getInitAmount() {
		return -1;
	}

	/**
	 * Simulates the house playing a round
	 * 
	 * @see
	 * au.edu.mq.itec802.cardGame.Player#play(au.edu.mq.itec802.cardGame.Pack)
	 */
	@Override
	public void play(Pack pack) {
		this.play((BlackjackPack) pack);
	}

}
