package au.edu.mq.itec802.cardGame.blackjack;

import java.util.ArrayList;
import java.util.Scanner;

import au.edu.mq.itec802.cardGame.Game;

/**
 * The Class BlackjackGame.<br />
 * <br />
 * Simple Blackjack game (developed as Assignment 1 for ITEC802@MQ)<br />
 * <br />
 * A game of Blackjack is played against the “House” (Casino). There are several
 * versions of this game and I am explaining one of the versions. The idea of
 * the game is to have 21 as the total value, where numerical cards have usual
 * values, Jack, Queen and King are valued at 10 and Ace can be treated as 1 OR
 * 10 by the player and house. The player comes in with a fixed amount of money
 * (configurable). The house deals two cards to the player and itself, one at a
 * time, in that order. To play a game, the player has to pay an initial amount
 * (configurable) to play the game. The player can then choose to ask for more
 * cards, till <br />
 *-a. (s)he is happy/ confident of his/her cards (happens usually at
 * an accumulated value between 18 and 21)<br /> 
 *-b. (s)he goes bust (total exceeds 21) Automatic loss<br /> 
 * Once the player completes his/her turn of getting more cards,
 * the house does the same (house has to ask for more cards until it reaches 17)
 * and if both are still in the game after that, the one with higher value
 * (<=21) wins. For more information about this game, please refer to
 * http://en.wikipedia.org/wiki/Blackjack
 * <br />
 * TODO: finish support for multiple players
 *       finish evaluation when multiple players win (same score -- split)
 *
 * @author		Tomas Krajca <tomas.krajca@students.mq.edu.au>
 * @version 	$Id: BlackjackGame.java 20/03/2011 jumbo$
 */
public class BlackjackGame implements Game {

	/** The individual rounds. */
	private ArrayList<BlackjackRound> rounds = new ArrayList<BlackjackRound>();

	/** The active players + house. */
	private ArrayList<BlackjackAbstractPlayer> players = new ArrayList<BlackjackAbstractPlayer>();

	/** The players which lost all their money :). */
	private ArrayList<BlackjackAbstractPlayer> playersout = new ArrayList<BlackjackAbstractPlayer>();

	/**
	 * Instantiates a new blackjack game.
	 * 
	 * @param playersNum
	 *            the number of player
	 * @param amounts
	 *            the amounts that the players begin with
	 * @param bets
	 *            the bets that the players bet every round
	 */
	public BlackjackGame(int playersNum, int[] amounts, int[] bets) {
		super();

		System.out.println("\n=== Welcome to the game of Blackjack! ===\n");

		for (int i = 0; i < playersNum; i++)
			this.players.add(new BlackjackPlayer(i + 1, amounts[i], bets[i]));
		this.players.add(new BlackjackHouse());
	}

	/**
	 * Simulates the entire game (core method)
	 */
	@Override
	public void play() {
		Scanner in = new Scanner(System.in);
		String yesno = "";
		do {
			System.out.printf("Round %d:\n", rounds.size() + 1);
			BlackjackRound round = new BlackjackRound(this.players);
			round.play();
			rounds.add(round);
			for (int i = 0; i < players.size(); i++) {
				if (players.get(i).isHouse())
					continue;
				if (players.get(i).getAmount() <= 0) {
					System.out.println("Player " + players.get(i).getNumber()
							+ " is out of the game!");
					playersout.add(players.get(i));
					players.remove(players.get(i));
				}
			}
			if (players.size() == 1) // only house stays in the game
				// (forever)
				break;

			System.out.println("-------------------------------");
			System.out.print("Start another game? (yes/no): ");

			do {
				yesno = in.nextLine();
			} while (!yesno.toLowerCase().equals("yes")
					&& !yesno.toLowerCase().equals("no"));
		} while (yesno.toLowerCase().equals("yes"));
	}

	/**
	 * Formats and returns results of the game.
	 * 
	 * @return results of the game as String
	 */
	@Override
	public String toString() {
		// temporary
		for (BlackjackAbstractPlayer playerout : playersout)
			players.add(playerout);

		int i = 0;
		String output = "Summary:\n";
		for (i = 0; i < players.size(); i++) {
			if (players.get(i).isHouse())
				continue;

			output += "Amount at start of game - player "
					+ players.get(i).getNumber() + ": $"
					+ players.get(i).getInitAmount() + "\n";
		}
		for (i = 0; i < rounds.size(); i++) {
			output += "Round " + (i+1) + ": " + rounds.get(i).toString();
			// players amounts saved within rounds
		}
		for (i = 0; i < players.size(); i++) {
			if (players.get(i).isHouse())
				continue;

			output += "Amount at end of game - player "
					+ players.get(i).getNumber() + ": $"
					+ players.get(i).getAmount();
			if (players.get(i).getInitAmount() < players.get(i).getAmount())
				output += " (gain)\n";
			else if (players.get(i).getInitAmount() > players.get(i)
					.getAmount())
				output += " (loss)\n";
			else
				output += " (no loss/gain)\n";
		}
		// reverse
		for (BlackjackAbstractPlayer playerout : playersout)
			players.remove(playerout);

		return output;
	}
}
