package au.edu.mq.itec802.cardGame;

/**
 * The Class Card.
 * 
 * TODO: Aces could be modelled as a subclass of Card redefining
 *          appropriate methods and properties (more logical, I guess) :-)
 * 
 * @author Tomas Krajca <tomas.krajca@students.mq.edu.au>
 * @version $Id: Card.java 19/03/2011 jumbo$   
 */
public class Card {

	/** The value of the card. */
	private int value;

	/** The name of the card. */
	private String name;

	/** The is ace. */
	private boolean isAce;

	/**
	 * Instantiates a new card.
	 * 
	 * @param value the value of the card
	 * @param name  the name of the card
	 * @param isAce determines whether it should be treated as an Ace
	 */
	public Card(int value, String name, boolean isAce) {
		super();
		this.setValue(value);
		this.setName(name);
		this.setAce(isAce);
	}

	/**
	 * Sets the name.
	 * 
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Sets the ace.
	 * 
	 * @param isAce
	 *            the isAce to set
	 */
	public void setAce(boolean isAce) {
		this.isAce = isAce;
	}

	/**
	 * Gets the value.
	 * 
	 * @return the value
	 */
	public int getValue() {
		return value;
	}

	/**
	 * Sets the value.
	 * 
	 * @param value
	 *            the value to set
	 */
	public void setValue(int value) {
		this.value = value;
	}

	/**
	 * Gets the name.
	 * 
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Checks if is ace.
	 * 
	 * @return the isAce
	 */
	public boolean isAce() {
		return isAce;
	}

	/**
	 * Serializes the card into String
	 * 
	 * @return card as String 
	 */
	@Override
	public String toString() {
		return this.getName();
	}
}
