/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkGCValues;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.internal.gtk.PangoItem;
import org.eclipse.swt.internal.gtk.PangoLayoutLine;
import org.eclipse.swt.internal.gtk.PangoLayoutRun;
import org.eclipse.swt.internal.gtk.PangoLogAttr;
import org.eclipse.swt.internal.gtk.PangoRectangle;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    int ascent;
    int descent;
    int indent;
    int wrapIndent;
    int wrapWidth;
    int[] segments;
    char[] segmentsChars;
    int[] tabs;
    StyleItem[] styles;
    int stylesCount;
    int layout;
    int context;
    int attrList;
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final char ZWS = '\u200b';
    static final char ZWNBS = '\ufeff';

    public TextLayout(Device device) {
        super(device);
        device = this.device;
        this.context = OS.gdk_pango_context_get();
        if (this.context == 0) {
            SWT.error(2);
        }
        OS.pango_context_set_language(this.context, OS.gtk_get_default_language());
        OS.pango_context_set_base_dir(this.context, 0);
        OS.gdk_pango_context_set_colormap(this.context, OS.gdk_colormap_get_system());
        this.layout = OS.pango_layout_new(this.context);
        if (this.layout == 0) {
            SWT.error(2);
        }
        OS.pango_layout_set_font_description(this.layout, device.systemFont.handle);
        OS.pango_layout_set_wrap(this.layout, 2);
        OS.pango_layout_set_tabs(this.layout, device.emptyTab);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.pango_layout_set_auto_dir(this.layout, false);
        }
        this.text = "";
        this.descent = -1;
        this.ascent = -1;
        this.wrapWidth = -1;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns() {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        int n6;
        int n7;
        if (this.attrList != 0) {
            return;
        }
        String string = this.getSegmentsText();
        byte[] byArray = Converter.wcsToMbcs(null, string, false);
        OS.pango_layout_set_text(this.layout, byArray, byArray.length);
        if (this.stylesCount == 2 && this.styles[0].style == null && this.ascent == -1 && this.descent == -1 && this.segments == null) {
            return;
        }
        int n8 = OS.pango_layout_get_text(this.layout);
        this.attrList = OS.pango_attr_list_new();
        PangoAttribute pangoAttribute = new PangoAttribute();
        char[] cArray = null;
        int n9 = string.length();
        int n10 = n7 = n9 - this.text.length();
        if ((this.ascent != -1 || this.descent != -1) && n9 > 0) {
            PangoRectangle pangoRectangle = new PangoRectangle();
            if (this.ascent != -1) {
                pangoRectangle.y = -(this.ascent * 1024);
            }
            pangoRectangle.height = (Math.max(0, this.ascent) + Math.max(0, this.descent)) * 1024;
            n6 = OS.pango_layout_get_line_count(this.layout);
            cArray = new char[n9 + n6 * 2];
            n5 = 0;
            int n11 = 0;
            object = new PangoLayoutLine();
            while (n11 < n6) {
                n4 = OS.pango_layout_get_line(this.layout, n11);
                OS.memmove((PangoLayoutLine)object, n4, PangoLayoutLine.sizeof);
                n3 = ((PangoLayoutLine)object).start_index;
                n2 = n11 * 6;
                n = OS.pango_attr_shape_new(pangoRectangle, pangoRectangle);
                OS.memmove(pangoAttribute, n, PangoAttribute.sizeof);
                pangoAttribute.start_index = n3 + n2;
                pangoAttribute.end_index = n3 + n2 + 3;
                OS.memmove(n, pangoAttribute, PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, n);
                n = OS.pango_attr_shape_new(pangoRectangle, pangoRectangle);
                OS.memmove(pangoAttribute, n, PangoAttribute.sizeof);
                pangoAttribute.start_index = n3 + n2 + 3;
                pangoAttribute.end_index = n3 + n2 + 6;
                OS.memmove(n, pangoAttribute, PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, n);
                int n12 = OS.g_utf8_pointer_to_offset(n8, n8 + n3);
                cArray[n12 + n11 * 2] = 8203;
                cArray[n12 + n11 * 2 + 1] = 65279;
                string.getChars(n5, n12, cArray, n5 + n11 * 2);
                n5 = n12;
                ++n11;
            }
            string.getChars(n5, n9, cArray, n5 + n11 * 2);
            byArray = Converter.wcsToMbcs(null, cArray, false);
            OS.pango_layout_set_text(this.layout, byArray, byArray.length);
            n8 = OS.pango_layout_get_text(this.layout);
            n10 += 2 * n6;
        } else {
            cArray = new char[n9];
            string.getChars(0, n9, cArray, 0);
        }
        this.invalidOffsets = new int[n10];
        if (n10 > 0) {
            n10 = 0;
            int n13 = 0;
            n6 = 0;
            while (n6 < cArray.length) {
                n5 = cArray[n6];
                if (n5 == 65279 || n5 == 8203) {
                    this.invalidOffsets[n10++] = n6;
                } else if (n13 < n7 && n6 - n10 == this.segments[n13]) {
                    this.invalidOffsets[n10++] = n6;
                    ++n13;
                }
                ++n6;
            }
        }
        int n14 = OS.strlen(n8);
        Font font = this.font != null ? this.font : this.device.systemFont;
        n5 = 0;
        while (n5 < this.stylesCount - 1) {
            StyleItem styleItem = this.styles[n5];
            object = styleItem.style;
            if (object != null) {
                int n15;
                GlyphMetrics glyphMetrics;
                int n16;
                Color color;
                Color color2;
                int n17;
                n4 = this.translateOffset(styleItem.start);
                n3 = this.translateOffset(this.styles[n5 + 1].start - 1);
                n2 = OS.g_utf8_offset_to_pointer(n8, n4) - n8;
                n = OS.g_utf8_offset_to_pointer(n8, n3 + 1) - n8;
                n2 = Math.min(n2, n14);
                n = Math.min(n, n14);
                Font font2 = ((TextStyle)object).font;
                if (font2 != null && !font2.isDisposed() && !font.equals(font2)) {
                    n17 = OS.pango_attr_font_desc_new(font2.handle);
                    OS.memmove(pangoAttribute, n17, PangoAttribute.sizeof);
                    pangoAttribute.start_index = n2;
                    pangoAttribute.end_index = n;
                    OS.memmove(n17, pangoAttribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, n17);
                }
                if (((TextStyle)object).underline) {
                    int n18;
                    n17 = 0;
                    switch (((TextStyle)object).underlineStyle) {
                        case 0: {
                            n17 = 1;
                            break;
                        }
                        case 1: {
                            n17 = 2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) break;
                            n17 = 4;
                            break;
                        }
                        case 4: {
                            if (((TextStyle)object).foreground == null) {
                                n18 = OS.pango_attr_foreground_new((short)0, (short)13107, (short)-26215);
                                OS.memmove(pangoAttribute, n18, PangoAttribute.sizeof);
                                pangoAttribute.start_index = n2;
                                pangoAttribute.end_index = n;
                                OS.memmove(n18, pangoAttribute, PangoAttribute.sizeof);
                                OS.pango_attr_list_insert(this.attrList, n18);
                            }
                            if (((TextStyle)object).underlineColor != null) break;
                            n17 = 1;
                        }
                    }
                    if (n17 != 0 && ((TextStyle)object).underlineColor == null) {
                        n18 = OS.pango_attr_underline_new(n17);
                        OS.memmove(pangoAttribute, n18, PangoAttribute.sizeof);
                        pangoAttribute.start_index = n2;
                        pangoAttribute.end_index = n;
                        OS.memmove(n18, pangoAttribute, PangoAttribute.sizeof);
                        OS.pango_attr_list_insert(this.attrList, n18);
                    }
                }
                if (((TextStyle)object).strikeout && ((TextStyle)object).strikeoutColor == null) {
                    n17 = OS.pango_attr_strikethrough_new(true);
                    OS.memmove(pangoAttribute, n17, PangoAttribute.sizeof);
                    pangoAttribute.start_index = n2;
                    pangoAttribute.end_index = n;
                    OS.memmove(n17, pangoAttribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, n17);
                }
                if ((color2 = ((TextStyle)object).foreground) != null && !color2.isDisposed()) {
                    GdkColor gdkColor = color2.handle;
                    int n19 = OS.pango_attr_foreground_new(gdkColor.red, gdkColor.green, gdkColor.blue);
                    OS.memmove(pangoAttribute, n19, PangoAttribute.sizeof);
                    pangoAttribute.start_index = n2;
                    pangoAttribute.end_index = n;
                    OS.memmove(n19, pangoAttribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, n19);
                }
                if ((color = ((TextStyle)object).background) != null && !color.isDisposed()) {
                    GdkColor gdkColor = color.handle;
                    n16 = OS.pango_attr_background_new(gdkColor.red, gdkColor.green, gdkColor.blue);
                    OS.memmove(pangoAttribute, n16, PangoAttribute.sizeof);
                    pangoAttribute.start_index = n2;
                    pangoAttribute.end_index = n;
                    OS.memmove(n16, pangoAttribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, n16);
                }
                if ((glyphMetrics = ((TextStyle)object).metrics) != null) {
                    PangoRectangle pangoRectangle = new PangoRectangle();
                    pangoRectangle.y = -(glyphMetrics.ascent * 1024);
                    pangoRectangle.height = (glyphMetrics.ascent + glyphMetrics.descent) * 1024;
                    pangoRectangle.width = glyphMetrics.width * 1024;
                    n15 = OS.pango_attr_shape_new(pangoRectangle, pangoRectangle);
                    OS.memmove(pangoAttribute, n15, PangoAttribute.sizeof);
                    pangoAttribute.start_index = n2;
                    pangoAttribute.end_index = n;
                    OS.memmove(n15, pangoAttribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, n15);
                }
                if ((n16 = ((TextStyle)object).rise) != 0) {
                    n15 = OS.pango_attr_rise_new(n16 * 1024);
                    OS.memmove(pangoAttribute, n15, PangoAttribute.sizeof);
                    pangoAttribute.start_index = n2;
                    pangoAttribute.end_index = n;
                    OS.memmove(n15, pangoAttribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, n15);
                }
            }
            ++n5;
        }
        OS.pango_layout_set_attributes(this.layout, this.attrList);
    }

    int[] computePolyline(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 - n2;
        int n7 = 2 * n6;
        int n8 = Compatibility.ceil(n3 - n, n7);
        if (n8 == 0 && n3 - n > 2) {
            n8 = 1;
        }
        if ((n5 = (2 * n8 + 1) * 2) < 0) {
            return new int[0];
        }
        int[] nArray = new int[n5];
        int n9 = 0;
        while (n9 < n8) {
            int n10 = 4 * n9;
            nArray[n10] = n + n7 * n9;
            nArray[n10 + 1] = n4;
            nArray[n10 + 2] = nArray[n10] + n7 / 2;
            nArray[n10 + 3] = n2;
            ++n9;
        }
        nArray[n5 - 2] = n + n7 * n8;
        nArray[n5 - 1] = n4;
        return nArray;
    }

    void destroy() {
        this.font = null;
        this.text = null;
        this.styles = null;
        this.freeRuns();
        this.segments = null;
        this.segmentsChars = null;
        if (this.layout != 0) {
            OS.g_object_unref(this.layout);
        }
        this.layout = 0;
        if (this.context != 0) {
            OS.g_object_unref(this.context);
        }
        this.context = 0;
    }

    public void draw(GC gC, int n, int n2) {
        this.draw(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.draw(gC, n, n2, n3, n4, color, color2, 0);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        int n6;
        int n7;
        this.checkLayout();
        this.computeRuns();
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        gC.checkGC(1);
        int n8 = this.text.length();
        n += Math.min(this.indent, this.wrapIndent);
        boolean bl = n3 <= n4 && n3 != -1 && n4 != -1;
        GCData gCData = gC.data;
        int n9 = gCData.cairo;
        if (n5 != 0 && (bl || (n5 & 0x100000) != 0)) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            PangoLogAttr pangoLogAttr = new PangoLogAttr();
            PangoRectangle pangoRectangle = new PangoRectangle();
            n7 = OS.pango_layout_get_line_count(this.layout);
            int n10 = OS.pango_layout_get_text(this.layout);
            int n11 = OS.pango_layout_get_iter(this.layout);
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
            if (n9 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                Cairo.cairo_save(n9);
                GdkColor gdkColor = color2.handle;
                Cairo.cairo_set_source_rgba(n9, (float)(gdkColor.red & 0xFFFF) / 65535.0f, (float)(gdkColor.green & 0xFFFF) / 65535.0f, (float)(gdkColor.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
            } else {
                OS.gdk_gc_set_foreground(gC.handle, color2.handle);
            }
            n6 = 0;
            do {
                int n12;
                int n13;
                int n14;
                OS.pango_layout_iter_get_line_extents(n11, null, pangoRectangle);
                if (OS.pango_layout_iter_next_line(n11)) {
                    n14 = OS.pango_layout_iter_get_index(n11);
                    n13 = OS.g_utf8_pointer_to_offset(n10, n10 + n14);
                } else {
                    n13 = OS.g_utf8_strlen(n10, -1);
                }
                n14 = 0;
                if (n6 == n7 - 1 && (n5 & 0x100000) != 0) {
                    n14 = 1;
                } else {
                    if (nArray[0] == 0) {
                        OS.pango_layout_get_log_attrs(this.layout, nArray, nArray2);
                    }
                    OS.memmove(pangoLogAttr, nArray[0] + n13 * PangoLogAttr.sizeof, PangoLogAttr.sizeof);
                    if (!pangoLogAttr.is_line_break) {
                        if (n3 <= n13 && n13 <= n4) {
                            n14 = 1;
                        }
                    } else if (n3 <= n13 && n13 < n4 && (n5 & 0x10000) != 0) {
                        n14 = 1;
                    }
                }
                if (n14 == 0) continue;
                int n15 = n + OS.PANGO_PIXELS(pangoRectangle.x) + OS.PANGO_PIXELS(pangoRectangle.width);
                int n16 = n2 + OS.PANGO_PIXELS(pangoRectangle.y);
                int n17 = OS.PANGO_PIXELS(pangoRectangle.height);
                if (this.ascent != -1 && this.descent != -1) {
                    n17 = Math.max(n17, this.ascent + this.descent);
                }
                int n18 = n12 = (n5 & 0x10000) != 0 ? Integer.MAX_VALUE : n17 / 3;
                if (n9 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                    Cairo.cairo_rectangle(n9, n15, n16, n12, n17);
                    Cairo.cairo_fill(n9);
                    continue;
                }
                OS.gdk_draw_rectangle(gCData.drawable, gC.handle, 1, n15, n16, n12, n17);
            } while (++n6 < n7);
            OS.pango_layout_iter_free(n11);
            if (nArray[0] != 0) {
                OS.g_free(nArray[0]);
            }
            if (n9 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                Cairo.cairo_restore(n9);
            } else {
                OS.gdk_gc_set_foreground(gC.handle, gCData.foreground);
            }
        }
        if (n8 == 0) {
            return;
        }
        if (!bl) {
            if (n9 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                if ((gCData.style & 0x8000000) != 0) {
                    Cairo.cairo_save(n9);
                    Cairo.cairo_scale(n9, -1.0, 1.0);
                    Cairo.cairo_translate(n9, -2 * n - this.width(), 0.0);
                }
                Cairo.cairo_move_to(n9, n, n2);
                OS.pango_cairo_show_layout(n9, this.layout);
                this.drawBorder(gC, n, n2, null);
                if ((gCData.style & 0x8000000) != 0) {
                    Cairo.cairo_restore(n9);
                }
            } else {
                OS.gdk_draw_layout(gCData.drawable, gC.handle, n, n2, this.layout);
                this.drawBorder(gC, n, n2, null);
            }
        } else {
            boolean bl2;
            n3 = Math.min(Math.max(0, n3), n8 - 1);
            n4 = Math.min(Math.max(0, n4), n8 - 1);
            n8 = OS.g_utf8_strlen(OS.pango_layout_get_text(this.layout), -1);
            n3 = this.translateOffset(n3);
            n4 = this.translateOffset(n4);
            if (color == null) {
                color = this.device.getSystemColor(27);
            }
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
            boolean bl3 = bl2 = n3 == 0 && n4 == n8 - 1;
            if (bl2) {
                if (n9 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                    int n19 = OS.pango_layout_get_text(this.layout);
                    if ((gCData.style & 0x8000000) != 0) {
                        Cairo.cairo_save(n9);
                        Cairo.cairo_scale(n9, -1.0, 1.0);
                        Cairo.cairo_translate(n9, -2 * n - this.width(), 0.0);
                    }
                    this.drawWithCairo(gC, n, n2, 0, OS.strlen(n19), bl2, color.handle, color2.handle);
                    if ((gCData.style & 0x8000000) != 0) {
                        Cairo.cairo_restore(n9);
                    }
                } else {
                    OS.gdk_draw_layout_with_colors(gCData.drawable, gC.handle, n, n2, this.layout, color.handle, color2.handle);
                    this.drawBorder(gC, n, n2, color.handle);
                }
            } else {
                int n20 = OS.pango_layout_get_text(this.layout);
                int n21 = OS.g_utf8_offset_to_pointer(n20, n3) - n20;
                int n22 = OS.g_utf8_offset_to_pointer(n20, n4 + 1) - n20;
                n7 = OS.strlen(n20);
                n21 = Math.min(n21, n7);
                n22 = Math.min(n22, n7);
                if (n9 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                    if ((gCData.style & 0x8000000) != 0) {
                        Cairo.cairo_save(n9);
                        Cairo.cairo_scale(n9, -1.0, 1.0);
                        Cairo.cairo_translate(n9, -2 * n - this.width(), 0.0);
                    }
                    this.drawWithCairo(gC, n, n2, n21, n22, bl2, color.handle, color2.handle);
                    if ((gCData.style & 0x8000000) != 0) {
                        Cairo.cairo_restore(n9);
                    }
                } else {
                    Region region = new Region();
                    gC.getClipping(region);
                    OS.gdk_draw_layout(gCData.drawable, gC.handle, n, n2, this.layout);
                    this.drawBorder(gC, n, n2, null);
                    int[] nArray = new int[]{n21, n22};
                    n6 = OS.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray, nArray.length / 2);
                    if (n6 != 0) {
                        OS.gdk_gc_set_clip_region(gC.handle, n6);
                        OS.gdk_region_destroy(n6);
                    }
                    OS.gdk_draw_layout_with_colors(gCData.drawable, gC.handle, n, n2, this.layout, color.handle, color2.handle);
                    this.drawBorder(gC, n, n2, color.handle);
                    gC.setClipping(region);
                    region.dispose();
                }
            }
        }
    }

    void drawWithCairo(GC gC, int n, int n2, int n3, int n4, boolean bl, GdkColor gdkColor, GdkColor gdkColor2) {
        int[] nArray;
        int n5;
        GCData gCData = gC.data;
        int n6 = gCData.cairo;
        Cairo.cairo_save(n6);
        if (!bl) {
            Cairo.cairo_move_to(n6, n, n2);
            OS.pango_cairo_show_layout(n6, this.layout);
            this.drawBorder(gC, n, n2, null);
        }
        if ((n5 = OS.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray = new int[]{n3, n4}, nArray.length / 2)) != 0) {
            OS.gdk_cairo_region(n6, n5);
            Cairo.cairo_clip(n6);
            Cairo.cairo_set_source_rgba(n6, (float)(gdkColor2.red & 0xFFFF) / 65535.0f, (float)(gdkColor2.green & 0xFFFF) / 65535.0f, (float)(gdkColor2.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
            Cairo.cairo_paint(n6);
            OS.gdk_region_destroy(n5);
        }
        Cairo.cairo_set_source_rgba(n6, (float)(gdkColor.red & 0xFFFF) / 65535.0f, (float)(gdkColor.green & 0xFFFF) / 65535.0f, (float)(gdkColor.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
        Cairo.cairo_move_to(n6, n, n2);
        OS.pango_cairo_show_layout(n6, this.layout);
        this.drawBorder(gC, n, n2, gdkColor);
        Cairo.cairo_restore(n6);
    }

    void drawBorder(GC gC, int n, int n2, GdkColor gdkColor) {
        GCData gCData = gC.data;
        int n3 = gCData.cairo;
        int n4 = gC.handle;
        int n5 = OS.pango_layout_get_text(this.layout);
        GdkGCValues gdkGCValues = null;
        if (n3 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
            Cairo.cairo_save(n3);
        }
        int n6 = 0;
        while (n6 < this.stylesCount - 1) {
            TextStyle textStyle = this.styles[n6].style;
            if (textStyle != null) {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                Object object;
                Object object2;
                int[] nArray;
                int[] nArray2;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16;
                boolean bl;
                boolean bl2 = bl = textStyle.borderStyle != 0;
                if (bl && !textStyle.isAdherentBorder(this.styles[n6 + 1].style)) {
                    n16 = this.styles[n6].start;
                    n15 = n6;
                    while (n15 > 0 && textStyle.isAdherentBorder(this.styles[n15 - 1].style)) {
                        n16 = this.styles[n15 - 1].start;
                        --n15;
                    }
                    n16 = this.translateOffset(n16);
                    n15 = this.translateOffset(this.styles[n6 + 1].start - 1);
                    n14 = OS.g_utf8_offset_to_pointer(n5, n16) - n5;
                    int[] nArray3 = new int[]{n14, n13 = OS.g_utf8_offset_to_pointer(n5, n15 + 1) - n5};
                    n12 = OS.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray3, nArray3.length / 2);
                    if (n12 != 0) {
                        nArray2 = new int[1];
                        nArray = new int[1];
                        OS.gdk_region_get_rectangles(n12, nArray, nArray2);
                        object2 = new GdkRectangle();
                        object = null;
                        if (object == null && textStyle.borderColor != null) {
                            object = textStyle.borderColor.handle;
                        }
                        if (object == null && gdkColor != null) {
                            object = gdkColor;
                        }
                        if (object == null && textStyle.foreground != null) {
                            object = textStyle.foreground.handle;
                        }
                        if (object == null) {
                            object = gCData.foreground;
                        }
                        int n17 = 1;
                        float[] fArray = null;
                        switch (textStyle.borderStyle) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                fArray = n17 != 0 ? GC.LINE_DASH : GC.LINE_DASH_ZERO;
                                break;
                            }
                            case 4: {
                                float[] fArray2 = fArray = n17 != 0 ? GC.LINE_DOT : GC.LINE_DOT_ZERO;
                            }
                        }
                        if (n3 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                            Cairo.cairo_set_source_rgba(n3, (float)(object.red & 0xFFFF) / 65535.0f, (float)(object.green & 0xFFFF) / 65535.0f, (float)(object.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
                            Cairo.cairo_set_line_width(n3, n17);
                            if (fArray != null) {
                                double[] dArray = new double[fArray.length];
                                n11 = 0;
                                while (n11 < dArray.length) {
                                    dArray[n11] = n17 == 0 || gCData.lineStyle == 6 ? fArray[n11] : fArray[n11] * (float)n17;
                                    ++n11;
                                }
                                Cairo.cairo_set_dash(n3, dArray, dArray.length, 0.0);
                            } else {
                                Cairo.cairo_set_dash(n3, null, 0, 0.0);
                            }
                            n10 = 0;
                            while (n10 < nArray2[0]) {
                                OS.memmove((GdkRectangle)object2, nArray[0] + n10 * GdkRectangle.sizeof, GdkRectangle.sizeof);
                                Cairo.cairo_rectangle(n3, (double)((GdkRectangle)object2).x + 0.5, (double)((GdkRectangle)object2).y + 0.5, ((GdkRectangle)object2).width - 1, ((GdkRectangle)object2).height - 1);
                                ++n10;
                            }
                            Cairo.cairo_stroke(n3);
                        } else {
                            if (gdkGCValues == null) {
                                gdkGCValues = new GdkGCValues();
                                OS.gdk_gc_get_values(n4, gdkGCValues);
                            }
                            OS.gdk_gc_set_foreground(n4, (GdkColor)object);
                            n10 = 1;
                            n11 = 0;
                            n9 = 0;
                            if (fArray != null) {
                                byte[] byArray = new byte[fArray.length];
                                int n18 = 0;
                                while (n18 < byArray.length) {
                                    byArray[n18] = (byte)(n17 == 0 || gCData.lineStyle == 6 ? fArray[n18] : fArray[n18] * (float)n17);
                                    ++n18;
                                }
                                OS.gdk_gc_set_dashes(n4, 0, byArray, byArray.length);
                                n9 = 1;
                            } else {
                                n9 = 0;
                            }
                            OS.gdk_gc_set_line_attributes(n4, n17, n9, n10, n11);
                            n8 = 0;
                            while (n8 < nArray2[0]) {
                                OS.memmove((GdkRectangle)object2, nArray[0] + n8 * GdkRectangle.sizeof, GdkRectangle.sizeof);
                                OS.gdk_draw_rectangle(gCData.drawable, n4, 0, ((GdkRectangle)object2).x, ((GdkRectangle)object2).y, ((GdkRectangle)object2).width - 1, ((GdkRectangle)object2).height - 1);
                                ++n8;
                            }
                        }
                        if (nArray[0] != 0) {
                            OS.g_free(nArray[0]);
                        }
                        OS.gdk_region_destroy(n12);
                    }
                }
                n16 = 0;
                if (textStyle.underline && textStyle.underlineColor != null) {
                    n16 = 1;
                }
                if (textStyle.underline && (textStyle.underlineStyle == 2 || textStyle.underlineStyle == 3) && OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
                    n16 = 1;
                }
                if (n16 != 0 && !textStyle.isAdherentUnderline(this.styles[n6 + 1].style)) {
                    int n19;
                    n15 = this.styles[n6].start;
                    n14 = n6;
                    while (n14 > 0 && textStyle.isAdherentUnderline(this.styles[n14 - 1].style)) {
                        n15 = this.styles[n14 - 1].start;
                        --n14;
                    }
                    n15 = this.translateOffset(n15);
                    n14 = this.translateOffset(this.styles[n6 + 1].start - 1);
                    n13 = OS.g_utf8_offset_to_pointer(n5, n15) - n5;
                    int[] nArray4 = new int[]{n13, n19 = OS.g_utf8_offset_to_pointer(n5, n14 + 1) - n5};
                    int n20 = OS.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray4, nArray4.length / 2);
                    if (n20 != 0) {
                        nArray = new int[1];
                        object2 = new int[1];
                        OS.gdk_region_get_rectangles(n20, (int[])object2, nArray);
                        object = new GdkRectangle();
                        GdkColor gdkColor2 = null;
                        if (gdkColor2 == null && textStyle.underlineColor != null) {
                            gdkColor2 = textStyle.underlineColor.handle;
                        }
                        if (gdkColor2 == null && gdkColor != null) {
                            gdkColor2 = gdkColor;
                        }
                        if (gdkColor2 == null && textStyle.foreground != null) {
                            gdkColor2 = textStyle.foreground.handle;
                        }
                        if (gdkColor2 == null) {
                            gdkColor2 = gCData.foreground;
                        }
                        if (n3 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                            Cairo.cairo_set_source_rgba(n3, (float)(gdkColor2.red & 0xFFFF) / 65535.0f, (float)(gdkColor2.green & 0xFFFF) / 65535.0f, (float)(gdkColor2.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
                        } else {
                            if (gdkGCValues == null) {
                                gdkGCValues = new GdkGCValues();
                                OS.gdk_gc_get_values(n4, gdkGCValues);
                            }
                            OS.gdk_gc_set_foreground(n4, gdkColor2);
                        }
                        int n21 = -1;
                        n10 = 1;
                        if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                            Font font = textStyle.font;
                            if (font == null) {
                                font = this.font;
                            }
                            if (font == null) {
                                font = this.device.systemFont;
                            }
                            n9 = OS.pango_context_get_language(this.context);
                            n8 = OS.pango_context_get_metrics(this.context, font.handle, n9);
                            n21 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_underline_position(n8));
                            n10 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_underline_thickness(n8));
                            OS.pango_font_metrics_unref(n8);
                        }
                        n11 = 0;
                        while (n11 < nArray[0]) {
                            OS.memmove((GdkRectangle)object, (int)(object2[0] + n11 * GdkRectangle.sizeof), GdkRectangle.sizeof);
                            n9 = this.getOffset(object.x - n, object.y - n2, null);
                            n8 = this.getLineIndex(n9);
                            FontMetrics fontMetrics = this.getLineMetrics(n8);
                            n7 = object.y + fontMetrics.ascent - n21 - textStyle.rise;
                            switch (textStyle.underlineStyle) {
                                case 2: 
                                case 3: {
                                    int n22 = n10;
                                    int n23 = 2 * n22;
                                    int n24 = Math.min(n7, object.y + object.height - n23 - 1);
                                    int[] nArray5 = this.computePolyline(object.x, n24, object.x + object.width, n24 + n23);
                                    if (n3 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                                        Cairo.cairo_set_line_width(n3, n22);
                                        Cairo.cairo_set_line_cap(n3, 0);
                                        Cairo.cairo_set_line_join(n3, 0);
                                        if (nArray5.length <= 0) break;
                                        double d = 0.5;
                                        double d2 = 0.5;
                                        Cairo.cairo_move_to(n3, (double)nArray5[0] + d, (double)nArray5[1] + d2);
                                        int n25 = 2;
                                        while (n25 < nArray5.length) {
                                            Cairo.cairo_line_to(n3, (double)nArray5[n25] + d, (double)nArray5[n25 + 1] + d2);
                                            n25 += 2;
                                        }
                                        Cairo.cairo_stroke(n3);
                                        break;
                                    }
                                    OS.gdk_gc_set_line_attributes(n4, n22, 0, 1, 0);
                                    OS.gdk_draw_lines(gCData.drawable, n4, nArray5, nArray5.length / 2);
                                    break;
                                }
                                case 1: {
                                    if (n3 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                                        Cairo.cairo_rectangle(n3, object.x, n7 + n10 * 2, object.width, n10);
                                        Cairo.cairo_fill(n3);
                                    } else {
                                        OS.gdk_draw_rectangle(gCData.drawable, n4, 1, object.x, n7 + n10 * 2, object.width, n10);
                                    }
                                }
                                case 0: 
                                case 4: {
                                    if (n3 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                                        Cairo.cairo_rectangle(n3, object.x, n7, object.width, n10);
                                        Cairo.cairo_fill(n3);
                                        break;
                                    }
                                    OS.gdk_draw_rectangle(gCData.drawable, n4, 1, object.x, n7, object.width, n10);
                                }
                            }
                            ++n11;
                        }
                        if (object2[0] != false) {
                            OS.g_free((int)object2[0]);
                        }
                        OS.gdk_region_destroy(n20);
                    }
                }
                n15 = 0;
                if (textStyle.strikeout && textStyle.strikeoutColor != null) {
                    n15 = 1;
                }
                if (n15 != 0 && !textStyle.isAdherentStrikeout(this.styles[n6 + 1].style)) {
                    n14 = this.styles[n6].start;
                    n13 = n6;
                    while (n13 > 0 && textStyle.isAdherentStrikeout(this.styles[n13 - 1].style)) {
                        n14 = this.styles[n13 - 1].start;
                        --n13;
                    }
                    n14 = this.translateOffset(n14);
                    n13 = this.translateOffset(this.styles[n6 + 1].start - 1);
                    int n26 = OS.g_utf8_offset_to_pointer(n5, n14) - n5;
                    nArray2 = new int[]{n26, n12 = OS.g_utf8_offset_to_pointer(n5, n13 + 1) - n5};
                    int n27 = OS.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray2, nArray2.length / 2);
                    if (n27 != 0) {
                        object2 = new int[1];
                        object = new int[1];
                        OS.gdk_region_get_rectangles(n27, object, (int[])object2);
                        GdkRectangle gdkRectangle = new GdkRectangle();
                        GdkColor gdkColor3 = null;
                        if (gdkColor3 == null && textStyle.strikeoutColor != null) {
                            gdkColor3 = textStyle.strikeoutColor.handle;
                        }
                        if (gdkColor3 == null && gdkColor != null) {
                            gdkColor3 = gdkColor;
                        }
                        if (gdkColor3 == null && textStyle.foreground != null) {
                            gdkColor3 = textStyle.foreground.handle;
                        }
                        if (gdkColor3 == null) {
                            gdkColor3 = gCData.foreground;
                        }
                        if (n3 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                            Cairo.cairo_set_source_rgba(n3, (float)(gdkColor3.red & 0xFFFF) / 65535.0f, (float)(gdkColor3.green & 0xFFFF) / 65535.0f, (float)(gdkColor3.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
                        } else {
                            if (gdkGCValues == null) {
                                gdkGCValues = new GdkGCValues();
                                OS.gdk_gc_get_values(n4, gdkGCValues);
                            }
                            OS.gdk_gc_set_foreground(n4, gdkColor3);
                        }
                        n10 = -1;
                        n11 = 1;
                        if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                            Font font = textStyle.font;
                            if (font == null) {
                                font = this.font;
                            }
                            if (font == null) {
                                font = this.device.systemFont;
                            }
                            n8 = OS.pango_context_get_language(this.context);
                            int n28 = OS.pango_context_get_metrics(this.context, font.handle, n8);
                            n10 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_strikethrough_position(n28));
                            n11 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_strikethrough_thickness(n28));
                            OS.pango_font_metrics_unref(n28);
                        }
                        n9 = 0;
                        while (n9 < object2[0]) {
                            OS.memmove(gdkRectangle, object[0] + n9 * GdkRectangle.sizeof, GdkRectangle.sizeof);
                            n8 = gdkRectangle.y + gdkRectangle.height / 2 - textStyle.rise;
                            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                                int n29 = this.getOffset(gdkRectangle.x - n, gdkRectangle.y - n2, null);
                                n7 = this.getLineIndex(n29);
                                FontMetrics fontMetrics = this.getLineMetrics(n7);
                                n8 = gdkRectangle.y + fontMetrics.ascent - n10 - textStyle.rise;
                            }
                            if (n3 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                                Cairo.cairo_rectangle(n3, gdkRectangle.x, n8, gdkRectangle.width, n11);
                                Cairo.cairo_fill(n3);
                            } else {
                                OS.gdk_draw_rectangle(gCData.drawable, n4, 1, gdkRectangle.x, n8, gdkRectangle.width, n11);
                            }
                            ++n9;
                        }
                        if (object[0] != 0) {
                            OS.g_free(object[0]);
                        }
                        OS.gdk_region_destroy(n27);
                    }
                }
            }
            ++n6;
        }
        if (gdkGCValues != null) {
            n6 = 245761;
            OS.gdk_gc_set_values(n4, gdkGCValues, n6);
            gCData.state &= 0xFFFFFFF7;
        }
        if (n3 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
            Cairo.cairo_restore(n3);
        }
    }

    void freeRuns() {
        if (this.attrList == 0) {
            return;
        }
        OS.pango_layout_set_attributes(this.layout, 0);
        OS.pango_attr_list_unref(this.attrList);
        this.attrList = 0;
        this.invalidOffsets = null;
    }

    public int getAlignment() {
        this.checkLayout();
        int n = OS.pango_layout_get_alignment(this.layout);
        boolean bl = OS.pango_context_get_base_dir(this.context) == 1;
        switch (n) {
            case 0: {
                return bl ? 131072 : 16384;
            }
            case 2: {
                return bl ? 16384 : 131072;
            }
        }
        return 0x1000000;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_size(this.layout, nArray, nArray2);
        int n = OS.pango_layout_get_width(this.layout);
        nArray[0] = n != -1 ? n : nArray[0] + OS.pango_layout_get_indent(this.layout);
        int n2 = OS.PANGO_PIXELS(nArray[0]);
        int n3 = OS.PANGO_PIXELS(nArray2[0]);
        if (this.ascent != -1 && this.descent != -1) {
            n3 = Math.max(n3, this.ascent + this.descent);
        }
        return new Rectangle(0, 0, n2, n3 += OS.PANGO_PIXELS(OS.pango_layout_get_spacing(this.layout)));
    }

    public Rectangle getBounds(int n, int n2) {
        int n3;
        this.checkLayout();
        this.computeRuns();
        int n4 = this.text.length();
        if (n4 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n > n2) {
            return new Rectangle(0, 0, 0, 0);
        }
        n = Math.min(Math.max(0, n), n4 - 1);
        n2 = Math.min(Math.max(0, n2), n4 - 1);
        n = this.translateOffset(n);
        n2 = this.translateOffset(n2);
        int n5 = OS.pango_layout_get_text(this.layout);
        int n6 = OS.g_utf8_offset_to_pointer(n5, n) - n5;
        int n7 = OS.g_utf8_offset_to_pointer(n5, n2 + 1) - n5;
        int n8 = OS.strlen(n5);
        int[] nArray = new int[]{n6 = Math.min(n6, n8), n7 = Math.min(n7, n8)};
        int n9 = OS.gdk_pango_layout_get_clip_region(this.layout, 0, 0, nArray, 1);
        if (n9 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        PangoRectangle pangoRectangle = new PangoRectangle();
        int n10 = OS.pango_layout_get_iter(this.layout);
        if (n10 == 0) {
            SWT.error(2);
        }
        if ((n3 = OS.gdk_region_new()) == 0) {
            SWT.error(2);
        }
        int n11 = 0;
        do {
            OS.pango_layout_iter_get_line_extents(n10, null, pangoRectangle);
            n11 = OS.pango_layout_iter_next_line(n10) ? OS.pango_layout_iter_get_index(n10) - 1 : n8;
            if (n6 > n11) continue;
            gdkRectangle.x = OS.PANGO_PIXELS(pangoRectangle.x);
            gdkRectangle.y = OS.PANGO_PIXELS(pangoRectangle.y);
            gdkRectangle.width = OS.PANGO_PIXELS(pangoRectangle.width);
            gdkRectangle.height = OS.PANGO_PIXELS(pangoRectangle.height);
            OS.gdk_region_union_with_rect(n3, gdkRectangle);
        } while (n11 + 1 <= n7);
        OS.gdk_region_intersect(n9, n3);
        OS.gdk_region_destroy(n3);
        OS.pango_layout_iter_free(n10);
        OS.gdk_region_get_clipbox(n9, gdkRectangle);
        OS.gdk_region_destroy(n9);
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            gdkRectangle.x = this.width() - gdkRectangle.x - gdkRectangle.width;
        }
        gdkRectangle.x += Math.min(this.indent, this.wrapIndent);
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return OS.pango_layout_get_justify(this.layout);
    }

    public int getLevel(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        int n3 = OS.pango_layout_get_iter(this.layout);
        if (n3 == 0) {
            SWT.error(2);
        }
        int n4 = 0;
        PangoItem pangoItem = new PangoItem();
        PangoLayoutRun pangoLayoutRun = new PangoLayoutRun();
        int n5 = OS.pango_layout_get_text(this.layout);
        int n6 = OS.g_utf8_offset_to_pointer(n5, n) - n5;
        int n7 = OS.strlen(n5);
        n6 = Math.min(n6, n7);
        do {
            int n8;
            if ((n8 = OS.pango_layout_iter_get_run(n3)) == 0) continue;
            OS.memmove(pangoLayoutRun, n8, PangoLayoutRun.sizeof);
            OS.memmove(pangoItem, pangoLayoutRun.item, PangoItem.sizeof);
            if (pangoItem.offset > n6 || n6 >= pangoItem.offset + pangoItem.length) continue;
            n4 = pangoItem.analysis_level;
            break;
        } while (OS.pango_layout_iter_next_run(n3));
        OS.pango_layout_iter_free(n3);
        return n4;
    }

    public Rectangle getLineBounds(int n) {
        int n2;
        this.checkLayout();
        this.computeRuns();
        int n3 = OS.pango_layout_get_line_count(this.layout);
        if (n < 0 || n >= n3) {
            SWT.error(6);
        }
        if ((n2 = OS.pango_layout_get_iter(this.layout)) == 0) {
            SWT.error(2);
        }
        int n4 = 0;
        while (n4 < n) {
            OS.pango_layout_iter_next_line(n2);
            ++n4;
        }
        PangoRectangle pangoRectangle = new PangoRectangle();
        OS.pango_layout_iter_get_line_extents(n2, null, pangoRectangle);
        OS.pango_layout_iter_free(n2);
        int n5 = OS.PANGO_PIXELS(pangoRectangle.x);
        int n6 = OS.PANGO_PIXELS(pangoRectangle.y);
        int n7 = OS.PANGO_PIXELS(pangoRectangle.width);
        int n8 = OS.PANGO_PIXELS(pangoRectangle.height);
        if (this.ascent != -1 && this.descent != -1) {
            n8 = Math.max(n8, this.ascent + this.descent);
        }
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            n5 = this.width() - n5 - n7;
        }
        return new Rectangle(n5 += Math.min(this.indent, this.wrapIndent), n6, n7, n8);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return OS.pango_layout_get_line_count(this.layout);
    }

    public int getLineIndex(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(5);
        }
        n = this.translateOffset(n);
        int n3 = 0;
        int n4 = OS.pango_layout_get_text(this.layout);
        int n5 = OS.g_utf8_offset_to_pointer(n4, n) - n4;
        int n6 = OS.strlen(n4);
        n5 = Math.min(n5, n6);
        int n7 = OS.pango_layout_get_iter(this.layout);
        if (n7 == 0) {
            SWT.error(2);
        }
        while (OS.pango_layout_iter_next_line(n7)) {
            if (OS.pango_layout_iter_get_index(n7) > n5) break;
            ++n3;
        }
        OS.pango_layout_iter_free(n7);
        return n3;
    }

    public FontMetrics getLineMetrics(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = OS.pango_layout_get_line_count(this.layout);
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 0;
        int n4 = 0;
        PangoLayoutLine pangoLayoutLine = new PangoLayoutLine();
        OS.memmove(pangoLayoutLine, OS.pango_layout_get_line(this.layout, n), PangoLayoutLine.sizeof);
        if (pangoLayoutLine.runs == 0) {
            int n5 = this.font != null ? this.font.handle : this.device.systemFont.handle;
            int n6 = OS.pango_context_get_language(this.context);
            int n7 = OS.pango_context_get_metrics(this.context, n5, n6);
            n3 = OS.pango_font_metrics_get_ascent(n7);
            n4 = OS.pango_font_metrics_get_descent(n7);
            OS.pango_font_metrics_unref(n7);
        } else {
            PangoRectangle pangoRectangle = new PangoRectangle();
            OS.pango_layout_line_get_extents(OS.pango_layout_get_line(this.layout, n), null, pangoRectangle);
            n3 = -pangoRectangle.y;
            n4 = pangoRectangle.height - n3;
        }
        n3 = Math.max(this.ascent, OS.PANGO_PIXELS(n3));
        n4 = Math.max(this.descent, OS.PANGO_PIXELS(n4));
        return FontMetrics.gtk_new(n3, n4, 0, 0, n3 + n4);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int n = OS.pango_layout_get_line_count(this.layout);
        int[] nArray = new int[n + 1];
        int n2 = OS.pango_layout_get_text(this.layout);
        PangoLayoutLine pangoLayoutLine = new PangoLayoutLine();
        int n3 = 0;
        while (n3 < n) {
            int n4 = OS.pango_layout_get_line(this.layout, n3);
            OS.memmove(pangoLayoutLine, n4, PangoLayoutLine.sizeof);
            int n5 = OS.g_utf8_pointer_to_offset(n2, n2 + pangoLayoutLine.start_index);
            nArray[n3] = this.untranslateOffset(n5);
            ++n3;
        }
        nArray[n] = this.text.length();
        return nArray;
    }

    public Point getLocation(int n, boolean bl) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        int n3 = OS.pango_layout_get_text(this.layout);
        int n4 = OS.g_utf8_offset_to_pointer(n3, n) - n3;
        int n5 = OS.strlen(n3);
        n4 = Math.min(n4, n5);
        PangoRectangle pangoRectangle = new PangoRectangle();
        OS.pango_layout_index_to_pos(this.layout, n4, pangoRectangle);
        int n6 = bl ? pangoRectangle.x + pangoRectangle.width : pangoRectangle.x;
        int n7 = pangoRectangle.y;
        n6 = OS.PANGO_PIXELS(n6);
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            n6 = this.width() - n6;
        }
        return new Point(n6 += Math.min(this.indent, this.wrapIndent), OS.PANGO_PIXELS(n7));
    }

    public int getNextOffset(int n, int n2) {
        return this._getOffset(n, n2, true);
    }

    int _getOffset(int n, int n2, boolean bl) {
        int n3;
        this.checkLayout();
        this.computeRuns();
        int n4 = this.text.length();
        if (n < 0 || n > n4) {
            SWT.error(6);
        }
        if (bl) {
            if (n == n4) {
                return n4;
            }
        } else if (n == 0) {
            return 0;
        }
        int n5 = n3 = bl ? 1 : -1;
        if ((n2 & 1) != 0) {
            return n + n3;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_log_attrs(this.layout, nArray, nArray2);
        if (nArray[0] == 0) {
            return n + n3;
        }
        n4 = OS.g_utf8_strlen(OS.pango_layout_get_text(this.layout), -1);
        int n6 = this.translateOffset(n += n3);
        PangoLogAttr pangoLogAttr = new PangoLogAttr();
        while (n6 > 0 && n6 < n4) {
            OS.memmove(pangoLogAttr, nArray[0] + n6 * PangoLogAttr.sizeof, PangoLogAttr.sizeof);
            if ((n2 & 2) != 0 && pangoLogAttr.is_cursor_position || (n2 & 4) != 0 && (!bl ? pangoLogAttr.is_word_start : pangoLogAttr.is_word_end)) break;
            if ((n2 & 0x10) != 0 && (pangoLogAttr.is_word_start || pangoLogAttr.is_sentence_end) || (n2 & 8) != 0 && pangoLogAttr.is_word_end) break;
            n6 = this.translateOffset(n += n3);
        }
        OS.g_free(nArray[0]);
        return Math.min(Math.max(0, n), this.text.length());
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    public int getOffset(int n, int n2, int[] nArray) {
        int n3;
        this.checkLayout();
        this.computeRuns();
        if (nArray != null && nArray.length < 1) {
            SWT.error(5);
        }
        n -= Math.min(this.indent, this.wrapIndent);
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            n = this.width() - n;
        }
        if ((n3 = OS.pango_layout_get_iter(this.layout)) == 0) {
            SWT.error(2);
        }
        PangoRectangle pangoRectangle = new PangoRectangle();
        do {
            OS.pango_layout_iter_get_line_extents(n3, null, pangoRectangle);
            pangoRectangle.y = OS.PANGO_PIXELS(pangoRectangle.y);
            pangoRectangle.height = OS.PANGO_PIXELS(pangoRectangle.height);
            if (pangoRectangle.y > n2 || n2 >= pangoRectangle.y + pangoRectangle.height) continue;
            pangoRectangle.x = OS.PANGO_PIXELS(pangoRectangle.x);
            pangoRectangle.width = OS.PANGO_PIXELS(pangoRectangle.width);
            if (n >= pangoRectangle.x + pangoRectangle.width) {
                n = pangoRectangle.x + pangoRectangle.width - 1;
            }
            if (n >= pangoRectangle.x) break;
            n = pangoRectangle.x;
            break;
        } while (OS.pango_layout_iter_next_line(n3));
        OS.pango_layout_iter_free(n3);
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.pango_layout_xy_to_index(this.layout, n * 1024, n2 * 1024, nArray2, nArray3);
        int n4 = OS.pango_layout_get_text(this.layout);
        int n5 = OS.g_utf8_pointer_to_offset(n4, n4 + nArray2[0]);
        if (nArray != null) {
            nArray[0] = nArray3[0];
        }
        return this.untranslateOffset(n5);
    }

    public int getOrientation() {
        this.checkLayout();
        int n = OS.pango_context_get_base_dir(this.context);
        return n == 1 ? 0x4000000 : 0x2000000;
    }

    public int getPreviousOffset(int n, int n2) {
        return this._getOffset(n, n2, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.stylesCount * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < this.stylesCount - 1) {
            if (this.styles[n2].style != null) {
                nArray[n++] = this.styles[n2].start;
                nArray[n++] = this.styles[n2 + 1].start - 1;
            }
            ++n2;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int n;
        int n2 = this.text.length();
        if (n2 == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int n3 = this.segments.length;
        if (n3 == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (n3 == 1) {
                return this.text;
            }
            if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
                return this.text;
            }
        }
        char[] cArray = new char[n2];
        this.text.getChars(0, n2, cArray, 0);
        char[] cArray2 = new char[n2 + n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (n4 < n2) {
            if (n5 < n3 && n4 == this.segments[n5]) {
                n = this.segmentsChars != null && this.segmentsChars.length > n5 ? this.segmentsChars[n5] : n6;
                cArray2[n4 + n5++] = n;
                continue;
            }
            cArray2[n4 + n5] = cArray[n4++];
        }
        while (n5 < n3) {
            this.segments[n5] = n4;
            n = this.segmentsChars != null && this.segmentsChars.length > n5 ? this.segmentsChars[n5] : n6;
            cArray2[n4 + n5++] = n;
        }
        return new String(cArray2, 0, cArray2.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return OS.PANGO_PIXELS(OS.pango_layout_get_spacing(this.layout));
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 1;
        while (n3 < this.stylesCount) {
            StyleItem styleItem = this.styles[n3];
            if (styleItem.start > n) {
                return this.styles[n3 - 1].style;
            }
            ++n3;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.stylesCount];
        int n = 0;
        int n2 = 0;
        while (n2 < this.stylesCount) {
            if (this.styles[n2].style != null) {
                textStyleArray[n++] = this.styles[n2].style;
            }
            ++n2;
        }
        if (n != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return this.wrapIndent;
    }

    public boolean isDisposed() {
        return this.layout == 0;
    }

    public void setAlignment(int n) {
        this.checkLayout();
        int n2 = 16924672;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x4000) != 0) {
            n = 16384;
        }
        if ((n & 0x20000) != 0) {
            n = 131072;
        }
        boolean bl = OS.pango_context_get_base_dir(this.context) == 1;
        int n3 = 1;
        switch (n) {
            case 16384: {
                n3 = bl ? 2 : 0;
                break;
            }
            case 131072: {
                n3 = bl ? 0 : 2;
            }
        }
        OS.pango_layout_set_alignment(this.layout, n3);
    }

    public void setAscent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.ascent == n) {
            return;
        }
        this.freeRuns();
        this.ascent = n;
    }

    public void setDescent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.descent == n) {
            return;
        }
        this.freeRuns();
        this.descent = n;
    }

    public void setFont(Font font) {
        Font font2;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.freeRuns();
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        OS.pango_layout_set_font_description(this.layout, font != null ? font.handle : this.device.systemFont.handle);
    }

    public void setIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        if (this.indent == n) {
            return;
        }
        this.indent = n;
        OS.pango_layout_set_indent(this.layout, (n - this.wrapIndent) * 1024);
        if (this.wrapWidth != -1) {
            this.setWidth();
        }
    }

    public void setJustify(boolean bl) {
        this.checkLayout();
        OS.pango_layout_set_justify(this.layout, bl);
    }

    public void setOrientation(int n) {
        int n2;
        this.checkLayout();
        int n3 = 0x6000000;
        if ((n &= n3) == 0) {
            return;
        }
        if ((n & 0x2000000) != 0) {
            n = 0x2000000;
        }
        int n4 = n2 = n == 0x4000000 ? 1 : 0;
        if (OS.pango_context_get_base_dir(this.context) == n2) {
            return;
        }
        OS.pango_context_set_base_dir(this.context, n2);
        OS.pango_layout_context_changed(this.layout);
        int n5 = OS.pango_layout_get_alignment(this.layout);
        if (n5 != 1) {
            n5 = n5 == 0 ? 2 : 0;
            OS.pango_layout_set_alignment(this.layout, n5);
        }
    }

    public void setSpacing(int n) {
        this.checkLayout();
        if (n < 0) {
            SWT.error(5);
        }
        OS.pango_layout_set_spacing(this.layout, n * 1024);
    }

    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.segments[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = nArray;
    }

    public void setSegmentsChars(char[] cArray) {
        this.checkLayout();
        if (this.segmentsChars == null && cArray == null) {
            return;
        }
        if (this.segmentsChars != null && cArray != null && this.segmentsChars.length == cArray.length) {
            int n = 0;
            while (n < cArray.length) {
                if (this.segmentsChars[n] != cArray[n]) break;
                ++n;
            }
            if (n == cArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segmentsChars = cArray;
    }

    public void setStyle(TextStyle textStyle, int n, int n2) {
        int n3;
        int n4;
        int n5;
        this.checkLayout();
        int n6 = this.text.length();
        if (n6 == 0) {
            return;
        }
        if (n > n2) {
            return;
        }
        n = Math.min(Math.max(0, n), n6 - 1);
        n2 = Math.min(Math.max(0, n2), n6 - 1);
        if (n > 0 && TextLayout.isAlef(this.text.charAt(n)) && TextLayout.isLam(this.text.charAt(n - 1))) {
            --n;
        }
        if (n2 < n6 - 1 && TextLayout.isLam(this.text.charAt(n2)) && TextLayout.isAlef(this.text.charAt(n2 + 1))) {
            ++n2;
        }
        int n7 = -1;
        int n8 = this.stylesCount;
        while (n8 - n7 > 1) {
            n5 = (n8 + n7) / 2;
            if (this.styles[n5 + 1].start > n) {
                n8 = n5;
                continue;
            }
            n7 = n5;
        }
        if (n8 >= 0 && n8 < this.stylesCount) {
            StyleItem styleItem = this.styles[n8];
            if (styleItem.start == n && this.styles[n8 + 1].start - 1 == n2 && (textStyle == null ? styleItem.style == null : textStyle.equals(styleItem.style))) {
                return;
            }
        }
        this.freeRuns();
        int n9 = n5 = n8;
        while (n9 < this.stylesCount) {
            if (this.styles[n9 + 1].start > n2) break;
            ++n9;
        }
        if (n5 == n9) {
            n4 = this.styles[n5].start;
            n3 = this.styles[n9 + 1].start - 1;
            if (n4 == n && n3 == n2) {
                this.styles[n5].style = textStyle;
                return;
            }
            if (n4 != n && n3 != n2) {
                int n10 = this.stylesCount + 2;
                if (n10 > this.styles.length) {
                    int n11 = Math.min(n10 + 1024, Math.max(64, n10 * 2));
                    StyleItem[] styleItemArray = new StyleItem[n11];
                    System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
                    this.styles = styleItemArray;
                }
                System.arraycopy(this.styles, n9 + 1, this.styles, n9 + 3, this.stylesCount - n9 - 1);
                StyleItem styleItem = new StyleItem();
                styleItem.start = n;
                styleItem.style = textStyle;
                this.styles[n5 + 1] = styleItem;
                styleItem = new StyleItem();
                styleItem.start = n2 + 1;
                styleItem.style = this.styles[n5].style;
                this.styles[n5 + 2] = styleItem;
                this.stylesCount = n10;
                return;
            }
        }
        if (n == this.styles[n5].start) {
            --n5;
        }
        if (n2 == this.styles[n9 + 1].start - 1) {
            ++n9;
        }
        if ((n4 = this.stylesCount + 1 - (n9 - n5 - 1)) > this.styles.length) {
            n3 = Math.min(n4 + 1024, Math.max(64, n4 * 2));
            StyleItem[] styleItemArray = new StyleItem[n3];
            System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
            this.styles = styleItemArray;
        }
        System.arraycopy(this.styles, n9, this.styles, n5 + 2, this.stylesCount - n9);
        StyleItem styleItem = new StyleItem();
        styleItem.start = n;
        styleItem.style = textStyle;
        this.styles[n5 + 1] = styleItem;
        this.styles[n5 + 2].start = n2 + 1;
        this.stylesCount = n4;
    }

    public void setTabs(int[] nArray) {
        int n;
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        if (this.tabs != null && nArray != null && this.tabs.length == nArray.length) {
            n = 0;
            while (n < nArray.length) {
                if (this.tabs[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.tabs = nArray;
        if (nArray == null) {
            OS.pango_layout_set_tabs(this.layout, this.device.emptyTab);
        } else {
            n = OS.pango_tab_array_new(nArray.length, true);
            if (n != 0) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    OS.pango_tab_array_set_tab(n, n2, 0, nArray[n2]);
                    ++n2;
                }
                OS.pango_layout_set_tabs(this.layout, n);
                OS.pango_tab_array_free(n);
            }
        }
        OS.pango_layout_context_changed(this.layout);
    }

    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = string;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = string.length();
        this.stylesCount = 2;
    }

    public void setWidth(int n) {
        this.checkLayout();
        if (n < -1 || n == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == n) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = n;
        this.setWidth();
    }

    void setWidth() {
        if (this.wrapWidth == -1) {
            OS.pango_layout_set_width(this.layout, -1);
            boolean bl = OS.pango_context_get_base_dir(this.context) == 1;
            OS.pango_layout_set_alignment(this.layout, bl ? 2 : 0);
        } else {
            int n = Math.min(this.indent, this.wrapIndent);
            OS.pango_layout_set_width(this.layout, (this.wrapWidth - n) * 1024);
        }
    }

    public void setWrapIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        if (this.wrapIndent == n) {
            return;
        }
        this.wrapIndent = n;
        OS.pango_layout_set_indent(this.layout, (this.indent - n) * 1024);
        if (this.wrapWidth != -1) {
            this.setWidth();
        }
    }

    static final boolean isLam(int n) {
        return n == 1604;
    }

    static final boolean isAlef(int n) {
        switch (n) {
            case 1570: 
            case 1571: 
            case 1573: 
            case 1575: 
            case 1609: 
            case 1648: 
            case 1649: 
            case 1650: 
            case 1651: 
            case 1653: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.layout + "}";
    }

    int translateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.invalidOffsets == null) {
            return n;
        }
        int n3 = 0;
        while (n3 < this.invalidOffsets.length) {
            if (n < this.invalidOffsets[n3]) break;
            ++n;
            ++n3;
        }
        return n;
    }

    int untranslateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.invalidOffsets == null) {
            return n;
        }
        int n3 = 0;
        while (n3 < this.invalidOffsets.length && n > this.invalidOffsets[n3]) {
            ++n3;
        }
        return n - n3;
    }

    int width() {
        int n = OS.pango_layout_get_width(this.layout);
        if (n != -1) {
            return OS.PANGO_PIXELS(n);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_size(this.layout, nArray, nArray2);
        return OS.PANGO_PIXELS(nArray[0]);
    }

    static class StyleItem {
        TextStyle style;
        int start;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

