/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class ClipboardProxy {
    Object[] clipboardData;
    Transfer[] clipboardDataTypes;
    Object[] primaryClipboardData;
    Transfer[] primaryClipboardDataTypes;
    int clipboardOwner = OS.gtk_window_new(0);
    Display display;
    Clipboard activeClipboard = null;
    Clipboard activePrimaryClipboard = null;
    Callback getFunc;
    Callback clearFunc;
    static String ID = "CLIPBOARD PROXY OBJECT";

    static ClipboardProxy _getInstance(final Display display) {
        ClipboardProxy clipboardProxy = (ClipboardProxy)display.getData(ID);
        if (clipboardProxy != null) {
            return clipboardProxy;
        }
        clipboardProxy = new ClipboardProxy(display);
        display.setData(ID, clipboardProxy);
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ClipboardProxy clipboardProxy = (ClipboardProxy)display.getData(ID);
                if (clipboardProxy == null) {
                    return;
                }
                display.setData(ID, null);
                clipboardProxy.dispose();
            }
        });
        return clipboardProxy;
    }

    ClipboardProxy(Display display) {
        this.display = display;
        this.getFunc = new Callback(this, "getFunc", 4);
        if (this.getFunc.getAddress() == 0) {
            SWT.error(3);
        }
        this.clearFunc = new Callback(this, "clearFunc", 2);
        if (this.clearFunc.getAddress() == 0) {
            SWT.error(3);
        }
    }

    void clear(Clipboard clipboard, int n) {
        if ((n & 1) != 0 && this.activeClipboard == clipboard) {
            OS.gtk_clipboard_clear(Clipboard.GTKCLIPBOARD);
        }
        if ((n & 2) != 0 && this.activePrimaryClipboard == clipboard) {
            OS.gtk_clipboard_clear(Clipboard.GTKPRIMARYCLIPBOARD);
        }
    }

    int clearFunc(int n, int n2) {
        if (n == Clipboard.GTKCLIPBOARD) {
            this.activeClipboard = null;
            this.clipboardData = null;
            this.clipboardDataTypes = null;
        }
        if (n == Clipboard.GTKPRIMARYCLIPBOARD) {
            this.activePrimaryClipboard = null;
            this.primaryClipboardData = null;
            this.primaryClipboardDataTypes = null;
        }
        return 1;
    }

    void dispose() {
        if (this.display == null) {
            return;
        }
        if (this.activeClipboard != null) {
            OS.gtk_clipboard_clear(Clipboard.GTKCLIPBOARD);
        }
        if (this.activePrimaryClipboard != null) {
            OS.gtk_clipboard_clear(Clipboard.GTKPRIMARYCLIPBOARD);
        }
        this.display = null;
        if (this.getFunc != null) {
            this.getFunc.dispose();
        }
        this.getFunc = null;
        if (this.clearFunc != null) {
            this.clearFunc.dispose();
        }
        this.clearFunc = null;
        this.clipboardData = null;
        this.clipboardDataTypes = null;
        this.primaryClipboardData = null;
        this.primaryClipboardDataTypes = null;
        if (this.clipboardOwner != 0) {
            OS.gtk_widget_destroy(this.clipboardOwner);
        }
        this.clipboardOwner = 0;
    }

    int getFunc(int n, int n2, int n3, int n4) {
        if (n2 == 0) {
            return 0;
        }
        GtkSelectionData gtkSelectionData = new GtkSelectionData();
        OS.memmove(gtkSelectionData, n2, GtkSelectionData.sizeof);
        TransferData transferData = new TransferData();
        transferData.type = gtkSelectionData.target;
        Transfer[] transferArray = n == Clipboard.GTKCLIPBOARD ? this.clipboardDataTypes : this.primaryClipboardDataTypes;
        int n5 = -1;
        int n6 = 0;
        while (n6 < transferArray.length) {
            if (transferArray[n6].isSupportedType(transferData)) {
                n5 = n6;
                break;
            }
            ++n6;
        }
        if (n5 == -1) {
            return 0;
        }
        Object[] objectArray = n == Clipboard.GTKCLIPBOARD ? this.clipboardData : this.primaryClipboardData;
        transferArray[n5].javaToNative(objectArray[n5], transferData);
        if (transferData.format < 8 || transferData.format % 8 != 0) {
            return 0;
        }
        OS.gtk_selection_data_set(n2, transferData.type, transferData.format, transferData.pValue, transferData.length);
        OS.g_free(transferData.pValue);
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    boolean setData(Clipboard var1_1, Object[] var2_2, Transfer[] var3_3, int var4_4) {
        block17: {
            block16: {
                var5_5 = new GtkTargetEntry[]{};
                var6_6 = 0;
                var7_7 = 0;
                while (var7_7 < var3_3.length) {
                    var8_8 = var3_3[var7_7];
                    var9_10 = var8_8.getTypeIds();
                    var10_12 = var8_8.getTypeNames();
                    var11_13 = 0;
                    while (var11_13 < var9_10.length) {
                        var12_14 = new GtkTargetEntry();
                        var12_14.info = var9_10[var11_13];
                        var13_15 = Converter.wcsToMbcs(null, var10_12[var11_13], true);
                        var14_16 = OS.g_malloc(var13_15.length);
                        OS.memmove(var14_16, var13_15, var13_15.length);
                        var12_14.target = var14_16;
                        var15_17 = new GtkTargetEntry[var5_5.length + 1];
                        System.arraycopy(var5_5, 0, var15_17, 0, var5_5.length);
                        var15_17[var5_5.length] = var12_14;
                        var5_5 = var15_17;
                        ++var11_13;
                    }
                    ++var7_7;
                }
                var6_6 = OS.g_malloc(GtkTargetEntry.sizeof * var5_5.length);
                var7_7 = 0;
                var8_9 = 0;
                while (var8_9 < var5_5.length) {
                    OS.memmove(var6_6 + var7_7, var5_5[var8_9], GtkTargetEntry.sizeof);
                    var7_7 += GtkTargetEntry.sizeof;
                    ++var8_9;
                }
                if ((var4_4 & 1) == 0) ** GOTO lbl54
                this.clipboardData = var2_2;
                this.clipboardDataTypes = var3_3;
                var8_9 = this.getFunc.getAddress();
                if (OS.gtk_clipboard_set_with_owner(Clipboard.GTKCLIPBOARD, var6_6, var5_5.length, var8_9, var9_11 = this.clearFunc.getAddress(), this.clipboardOwner)) break block16;
                while (true) {
                    var16_18 = null;
                    var18_21 = 0;
                    while (var18_21 < var5_5.length) {
                        var19_24 = var5_5[var18_21];
                        if (var19_24.target != 0) {
                            OS.g_free(var19_24.target);
                        }
                        ++var18_21;
                    }
                    if (var6_6 != 0) {
                        OS.g_free(var6_6);
                    }
                    return false;
                }
            }
            try {
                this.activeClipboard = var1_1;
lbl54:
                // 2 sources

                if ((var4_4 & 2) != 0) {
                    this.primaryClipboardData = var2_2;
                    this.primaryClipboardDataTypes = var3_3;
                    if (!OS.gtk_clipboard_set_with_owner(Clipboard.GTKPRIMARYCLIPBOARD, var6_6, var5_5.length, var8_9 = this.getFunc.getAddress(), var9_11 = this.clearFunc.getAddress(), this.clipboardOwner)) ** continue;
                    this.activePrimaryClipboard = var1_1;
                }
                var16_19 = null;
                var18_22 = 0;
                ** while (var18_22 < var5_5.length)
            }
            catch (Throwable var17_27) {
                var16_20 = null;
                var18_23 = 0;
                ** while (var18_23 < var5_5.length)
            }
lbl-1000:
            // 1 sources

            {
                var19_25 = var5_5[var18_22];
                if (var19_25.target != 0) {
                    OS.g_free(var19_25.target);
                }
                ++var18_22;
                continue;
            }
lbl68:
            // 1 sources

            if (var6_6 != 0) {
                OS.g_free(var6_6);
            }
            return true;
lbl-1000:
            // 1 sources

            {
                var19_26 = var5_5[var18_23];
                if (var19_26.target != 0) {
                    OS.g_free(var19_26.target);
                }
                ++var18_23;
                continue;
            }
lbl81:
            // 1 sources

            if (var6_6 == 0) break block17;
            OS.g_free(var6_6);
        }
        throw var17_27;
    }
}

