/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;

public abstract class Device
implements Drawable {
    protected long xDisplay;
    long shellHandle;
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    GdkColor[] gdkColors;
    int[] colorRefCount;
    boolean disposed;
    long logProc;
    Callback logCallback;
    String[] log_domains = new String[]{"GLib-GObject", "GLib", "GObject", "Pango", "ATK", "GdkPixbuf", "Gdk", "Gtk", "GnomeVFS"};
    int[] handler_ids = new int[this.log_domains.length];
    int warningLevel;
    static Callback XErrorCallback;
    static Callback XIOErrorCallback;
    static long XErrorProc;
    static long XIOErrorProc;
    static long XNullErrorProc;
    static long XNullIOErrorProc;
    static Device[] Devices;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    long emptyTab;
    boolean useXRender;
    static boolean CAIRO_LOADED;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;
    static /* synthetic */ Class class$0;

    static {
        Devices = new Device[4];
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData data) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (data != null) {
                this.debug = data.debug;
                this.tracking = data.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.create(data);
            this.init();
            Device.register(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void checkCairo() {
        if (CAIRO_LOADED) {
            return;
        }
        try {
            byte[] buffer = Converter.wcsToMbcs(null, "libcairo.so.2", true);
            long libcairo = OS.dlopen(buffer, 1);
            if (libcairo != 0L) {
                OS.dlclose(libcairo);
            } else {
                try {
                    System.loadLibrary("cairo-swt");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            }
            Class.forName("org.eclipse.swt.internal.cairo.Cairo");
            CAIRO_LOADED = true;
        }
        catch (Throwable t) {
            SWT.error(16, t, " [Cairo is required]");
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData data) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            Device.deregister(this);
            this.xDisplay = 0L;
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int i = 0;
            while (i < this.objects.length) {
                if (this.objects[i] == object) {
                    this.objects[i] = null;
                    this.errors[i] = null;
                    return;
                }
                ++i;
            }
        }
    }

    static synchronized Device findDevice(long xDisplay) {
        int i = 0;
        while (i < Devices.length) {
            Device device = Devices[i];
            if (device != null && device.xDisplay == xDisplay) {
                return device;
            }
            ++i;
        }
        return null;
    }

    static synchronized void deregister(Device device) {
        int i = 0;
        while (i < Devices.length) {
            if (device == Devices[i]) {
                Device.Devices[i] = null;
            }
            ++i;
        }
    }

    protected void destroy() {
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData data = new DeviceData();
        data.debug = this.debug;
        data.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int count = 0;
                int length = this.objects.length;
                int i = 0;
                while (i < length) {
                    if (this.objects[i] != null) {
                        ++count;
                    }
                    ++i;
                }
                int index = 0;
                data.objects = new Object[count];
                data.errors = new Error[count];
                int i2 = 0;
                while (i2 < length) {
                    if (this.objects[i2] != null) {
                        data.objects[index] = this.objects[i2];
                        data.errors[index] = this.errors[i2];
                        ++index;
                    }
                    ++i2;
                }
            }
        } else {
            data.objects = new Object[0];
            data.errors = new Error[0];
        }
        return data;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return 0;
    }

    public Point getDPI() {
        this.checkDevice();
        return new Point(72, 72);
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        this.checkDevice();
        if (!scalable) {
            return new FontData[0];
        }
        long[] family = new long[1];
        long[] face = new long[1];
        long[] families = new long[1];
        int[] n_families = new int[1];
        long[] faces = new long[1];
        int[] n_faces = new int[1];
        long context = OS.gdk_pango_context_get();
        OS.pango_context_list_families(context, families, n_families);
        int nFds = 0;
        FontData[] fds = new FontData[faceName != null ? 4 : n_families[0]];
        int i = 0;
        while (i < n_families[0]) {
            OS.memmove(family, families[0] + (long)(i * OS.PTR_SIZEOF), (long)OS.PTR_SIZEOF);
            boolean match = true;
            if (faceName != null) {
                long familyName = OS.pango_font_family_get_name(family[0]);
                int length = OS.strlen(familyName);
                byte[] buffer = new byte[length];
                OS.memmove(buffer, familyName, (long)length);
                String name = new String(Converter.mbcsToWcs(null, buffer));
                match = Compatibility.equalsIgnoreCase(faceName, name);
            }
            if (match) {
                OS.pango_font_family_list_faces(family[0], faces, n_faces);
                int j = 0;
                while (j < n_faces[0]) {
                    OS.memmove(face, faces[0] + (long)(j * OS.PTR_SIZEOF), (long)OS.PTR_SIZEOF);
                    long fontDesc = OS.pango_font_face_describe(face[0]);
                    Font font = Font.gtk_new(this, fontDesc);
                    FontData data = font.getFontData()[0];
                    if (nFds == fds.length) {
                        FontData[] newFds = new FontData[fds.length + n_families[0]];
                        System.arraycopy(fds, 0, newFds, 0, nFds);
                        fds = newFds;
                    }
                    fds[nFds++] = data;
                    OS.pango_font_description_free(fontDesc);
                    ++j;
                }
                OS.g_free(faces[0]);
                if (faceName != null) break;
            }
            ++i;
        }
        OS.g_free(families[0]);
        OS.g_object_unref(context);
        if (nFds == fds.length) {
            return fds;
        }
        FontData[] result = new FontData[nFds];
        System.arraycopy(fds, 0, result, 0, nFds);
        return result;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        switch (id) {
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warningLevel == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void init() {
        Object error_basep;
        int[] event_basep;
        if (this.xDisplay != 0L && OS.XRenderQueryExtension(this.xDisplay, event_basep = new int[1], error_basep = new int[1])) {
            int[] major_versionp = new int[1];
            int[] minor_versionp = new int[1];
            OS.XRenderQueryVersion(this.xDisplay, major_versionp, minor_versionp);
            boolean bl = this.useXRender = major_versionp[0] > 0 || major_versionp[0] == 0 && minor_versionp[0] >= 8;
        }
        if (this.debug && this.xDisplay != 0L) {
            Class<?> clazz;
            Class<?> clazz2 = clazz = this.getClass();
            error_basep = clazz2;
            // MONITORENTER : clazz2
            int index = 0;
            while (index < Devices.length && Devices[index] == null) {
                ++index;
            }
            if (index == Devices.length) {
                XErrorCallback = new Callback(clazz, "XErrorProc", 2);
                XNullErrorProc = XErrorCallback.getAddress();
                if (XNullErrorProc == 0L) {
                    SWT.error(3);
                }
                if ((XNullIOErrorProc = (XIOErrorCallback = new Callback(clazz, "XIOErrorProc", 1)).getAddress()) == 0L) {
                    SWT.error(3);
                }
                XErrorProc = OS.XSetErrorHandler(XNullErrorProc);
                XIOErrorProc = OS.XSetIOErrorHandler(XNullIOErrorProc);
            }
            // MONITOREXIT : error_basep
            OS.XSynchronize(this.xDisplay, true);
        }
        if (this.xDisplay != 0L) {
            this.logCallback = new Callback(this, "logProc", 4);
            this.logProc = this.logCallback.getAddress();
            if (this.logProc == 0L) {
                SWT.error(3);
            }
            if (this.debug) {
                int flags = -1;
                int i = 0;
                while (i < this.log_domains.length) {
                    byte[] log_domain = Converter.wcsToMbcs(null, this.log_domains[i], true);
                    this.handler_ids[i] = OS.g_log_set_handler(log_domain, flags, this.logProc, 0L);
                    ++i;
                }
            }
        }
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
        this.emptyTab = OS.pango_tab_array_new(1, false);
        if (this.emptyTab == 0L) {
            SWT.error(2);
        }
        OS.pango_tab_array_set_tab(this.emptyTab, 0, 0L, 1);
        this.shellHandle = OS.gtk_window_new(0);
        if (this.shellHandle == 0L) {
            SWT.error(2);
        }
        OS.gtk_widget_realize(this.shellHandle);
        this.systemFont = this.getSystemFont();
    }

    public abstract long internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(long var1, GCData var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String path) {
        this.checkDevice();
        if (path == null) {
            SWT.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, path, true);
        return OS.FcConfigAppFontAddFile(0L, buffer);
    }

    long logProc(long log_domain, long log_level, long message, long user_data) {
        if (this.warningLevel == 0) {
            if (DEBUG || this.debug) {
                new Error().printStackTrace();
            }
            OS.g_log_default_handler(log_domain, (int)log_level, message, 0L);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int i = 0;
            while (i < this.objects.length) {
                if (this.objects[i] == null) {
                    this.objects[i] = object;
                    this.errors[i] = new Error();
                    return;
                }
                ++i;
            }
            Object[] newObjects = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
            newObjects[this.objects.length] = object;
            this.objects = newObjects;
            Error[] newErrors = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
            newErrors[this.errors.length] = new Error();
            this.errors = newErrors;
        }
    }

    static synchronized void register(Device device) {
        int i = 0;
        while (i < Devices.length) {
            if (Devices[i] == null) {
                Device.Devices[i] = device;
                return;
            }
            ++i;
        }
        Device[] newDevices = new Device[Devices.length + 4];
        System.arraycopy(Devices, 0, newDevices, 0, Devices.length);
        newDevices[Device.Devices.length] = device;
        Devices = newDevices;
    }

    protected void release() {
        if (this.shellHandle != 0L) {
            OS.gtk_widget_destroy(this.shellHandle);
        }
        this.shellHandle = 0L;
        if (this.gdkColors != null) {
            long colormap = OS.gdk_colormap_get_system();
            int i = 0;
            while (i < this.gdkColors.length) {
                GdkColor color = this.gdkColors[i];
                if (color != null) {
                    while (this.colorRefCount[i] > 0) {
                        OS.gdk_colormap_free_colors(colormap, color, 1);
                        int n = i;
                        this.colorRefCount[n] = this.colorRefCount[n] - 1;
                    }
                }
                ++i;
            }
        }
        this.gdkColors = null;
        this.colorRefCount = null;
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
        if (this.emptyTab != 0L) {
            OS.pango_tab_array_free(this.emptyTab);
        }
        this.emptyTab = 0L;
        if (this.xDisplay != 0L) {
            int i = 0;
            while (i < this.handler_ids.length) {
                if (this.handler_ids[i] != 0) {
                    byte[] log_domain = Converter.wcsToMbcs(null, this.log_domains[i], true);
                    OS.g_log_remove_handler(log_domain, this.handler_ids[i]);
                    this.handler_ids[i] = 0;
                }
                ++i;
            }
            this.logCallback.dispose();
            this.logCallback = null;
            this.handler_ids = null;
            this.log_domains = null;
            this.logProc = 0L;
        }
    }

    public void setWarnings(boolean warnings) {
        block9: {
            block8: {
                this.checkDevice();
                if (!warnings) break block8;
                if (--this.warningLevel != 0) break block9;
                if (this.debug) {
                    return;
                }
                if (this.logProc != 0L) {
                    int i = 0;
                    while (i < this.handler_ids.length) {
                        if (this.handler_ids[i] != 0) {
                            byte[] log_domain = Converter.wcsToMbcs(null, this.log_domains[i], true);
                            OS.g_log_remove_handler(log_domain, this.handler_ids[i]);
                            this.handler_ids[i] = 0;
                        }
                        ++i;
                    }
                }
                break block9;
            }
            if (this.warningLevel++ == 0) {
                if (this.debug) {
                    return;
                }
                if (this.logProc != 0L) {
                    int flags = -1;
                    int i = 0;
                    while (i < this.log_domains.length) {
                        byte[] log_domain = Converter.wcsToMbcs(null, this.log_domains[i], true);
                        this.handler_ids[i] = OS.g_log_set_handler(log_domain, flags, this.logProc, 0L);
                        ++i;
                    }
                }
            }
        }
    }

    static long XErrorProc(long xDisplay, long xErrorEvent) {
        Device device = Device.findDevice(xDisplay);
        if (device != null) {
            if (device.warningLevel == 0) {
                if (DEBUG || device.debug) {
                    new SWTError().printStackTrace();
                }
                OS.Call(XErrorProc, xDisplay, xErrorEvent);
            }
        } else {
            if (DEBUG) {
                new SWTError().printStackTrace();
            }
            OS.Call(XErrorProc, xDisplay, xErrorEvent);
        }
        return 0L;
    }

    static long XIOErrorProc(long xDisplay) {
        Device device = Device.findDevice(xDisplay);
        if (device != null) {
            if (DEBUG || device.debug) {
                new SWTError().printStackTrace();
            }
        } else if (DEBUG) {
            new SWTError().printStackTrace();
        }
        OS.Call(XIOErrorProc, xDisplay, 0L);
        return 0L;
    }
}

