/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;

public class ExpandItem
extends Item {
    ExpandBar parent;
    Control control;
    ImageList imageList;
    long clientHandle;
    long boxHandle;
    long labelHandle;
    long imageHandle;
    boolean expanded;
    int x;
    int y;
    int width;
    int height;
    int imageHeight;
    int imageWidth;
    static final int TEXT_INSET = 6;
    static final int BORDER = 1;
    static final int CHEVRON_SIZE = 24;

    public ExpandItem(ExpandBar expandBar, int n) {
        super(expandBar, n);
        this.parent = expandBar;
        this.createWidget(expandBar.getItemCount());
    }

    public ExpandItem(ExpandBar expandBar, int n, int n2) {
        super(expandBar, n);
        this.parent = expandBar;
        this.createWidget(n2);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int n) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.state |= 8;
            this.handle = OS.gtk_expander_new(null);
            if (this.handle == 0L) {
                this.error(2);
            }
            this.clientHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
            if (this.clientHandle == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(this.handle, this.clientHandle);
            this.boxHandle = OS.gtk_hbox_new(false, 4);
            if (this.boxHandle == 0L) {
                this.error(2);
            }
            this.labelHandle = OS.gtk_label_new(null);
            if (this.labelHandle == 0L) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            if (this.imageHandle == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(this.boxHandle, this.imageHandle);
            OS.gtk_container_add(this.boxHandle, this.labelHandle);
            OS.gtk_expander_set_label_widget(this.handle, this.boxHandle);
            OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.showWidget(n);
        this.parent.createItem(this, this.style, n);
    }

    void deregister() {
        super.deregister();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.display.removeWidget(this.clientHandle);
            this.display.removeWidget(this.boxHandle);
            this.display.removeWidget(this.labelHandle);
            this.display.removeWidget(this.imageHandle);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        super.destroyWidget();
    }

    void drawChevron(GC gC, int n, int n2) {
        int[] nArray;
        int[] nArray2;
        if (this.expanded) {
            int n3 = n + 4 + 5;
            int n4 = n2 + 4 + 7;
            nArray2 = new int[]{n3, n4, n3 + 1, n4, n3 + 1, n4 - 1, n3 + 2, n4 - 1, n3 + 2, n4 - 2, n3 + 3, n4 - 2, n3 + 3, n4 - 3, n3 + 3, n4 - 2, n3 + 4, n4 - 2, n3 + 4, n4 - 1, n3 + 5, n4 - 1, n3 + 5, n4, n3 + 6, n4};
            nArray = new int[]{n3, n4 += 4, n3 + 1, n4, n3 + 1, n4 - 1, n3 + 2, n4 - 1, n3 + 2, n4 - 2, n3 + 3, n4 - 2, n3 + 3, n4 - 3, n3 + 3, n4 - 2, n3 + 4, n4 - 2, n3 + 4, n4 - 1, n3 + 5, n4 - 1, n3 + 5, n4, n3 + 6, n4};
        } else {
            int n5 = n + 4 + 5;
            int n6 = n2 + 4 + 4;
            nArray2 = new int[]{n5, n6, n5 + 1, n6, n5 + 1, n6 + 1, n5 + 2, n6 + 1, n5 + 2, n6 + 2, n5 + 3, n6 + 2, n5 + 3, n6 + 3, n5 + 3, n6 + 2, n5 + 4, n6 + 2, n5 + 4, n6 + 1, n5 + 5, n6 + 1, n5 + 5, n6, n5 + 6, n6};
            nArray = new int[]{n5, n6 += 4, n5 + 1, n6, n5 + 1, n6 + 1, n5 + 2, n6 + 1, n5 + 2, n6 + 2, n5 + 3, n6 + 2, n5 + 3, n6 + 3, n5 + 3, n6 + 2, n5 + 4, n6 + 2, n5 + 4, n6 + 1, n5 + 5, n6 + 1, n5 + 5, n6, n5 + 6, n6};
        }
        gC.setForeground(this.display.getSystemColor(30));
        gC.drawPolyline(nArray2);
        gC.drawPolyline(nArray);
    }

    void drawItem(GC gC, boolean bl) {
        int n = this.parent.getBandHeight();
        Display display = this.getDisplay();
        gC.setForeground(display.getSystemColor(31));
        gC.setBackground(display.getSystemColor(32));
        gC.fillGradientRectangle(this.x, this.y, this.width, n, true);
        if (this.expanded) {
            gC.setForeground(display.getSystemColor(32));
            gC.drawLine(this.x, this.y + n, this.x, this.y + n + this.height - 1);
            gC.drawLine(this.x, this.y + n + this.height - 1, this.x + this.width - 1, this.y + n + this.height - 1);
            gC.drawLine(this.x + this.width - 1, this.y + n + this.height - 1, this.x + this.width - 1, this.y + n);
        }
        int n2 = this.x;
        if (this.image != null) {
            n2 += 6;
            if (this.imageHeight > n) {
                gC.drawImage(this.image, n2, this.y + n - this.imageHeight);
            } else {
                gC.drawImage(this.image, n2, this.y + (n - this.imageHeight) / 2);
            }
            n2 += this.imageWidth;
        }
        if (this.text.length() > 0) {
            Point point = gC.stringExtent(this.text);
            gC.setForeground(this.parent.getForeground());
            gC.drawString(this.text, n2 += 6, this.y + (n - point.y) / 2, true);
        }
        int n3 = 24;
        this.drawChevron(gC, this.x + this.width - n3, this.y + (n - n3) / 2);
        if (bl) {
            gC.drawFocus(this.x + 1, this.y + 1, this.width - 2, n - 2);
        }
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            return OS.GTK_WIDGET_HEIGHT(this.handle) - (this.expanded ? this.height : 0);
        }
        return Math.max(this.parent.getBandHeight(), this.imageHeight);
    }

    public int getHeight() {
        this.checkWidget();
        return this.height;
    }

    public ExpandBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth(GC gC) {
        int n = 36;
        if (this.image != null) {
            n += 6 + this.imageWidth;
        }
        if (this.text.length() > 0) {
            n += gC.stringExtent((String)this.text).x;
        }
        return n;
    }

    long gtk_activate(long l) {
        Event event = new Event();
        event.item = this;
        int n = OS.gtk_expander_get_expanded(this.handle) ? 18 : 17;
        this.parent.sendEvent(n, event);
        return 0L;
    }

    long gtk_button_press_event(long l, long l2) {
        this.setFocus();
        return 0L;
    }

    long gtk_focus_out_event(long l, long l2) {
        OS.GTK_WIDGET_UNSET_FLAGS(this.handle, 2048);
        this.parent.lastFocus = this;
        return 0L;
    }

    long gtk_size_allocate(long l, long l2) {
        this.parent.layoutItems(0, false);
        return 0L;
    }

    long gtk_enter_notify_event(long l, long l2) {
        this.parent.gtk_enter_notify_event(l, l2);
        return 0L;
    }

    boolean hasFocus() {
        return OS.GTK_WIDGET_HAS_FOCUS(this.handle);
    }

    void hookEvents() {
        super.hookEvents();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_connect_closure(this.handle, OS.activate, this.display.closures[1], false);
            OS.g_signal_connect_closure(this.handle, OS.activate, this.display.closures[60], true);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.closures[2], false);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[22], 0, this.display.closures[22], false);
            OS.g_signal_connect_closure(this.clientHandle, OS.size_allocate, this.display.closures[47], true);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[14], 0, this.display.closures[14], false);
        }
    }

    void redraw() {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
            int n = this.parent.getBandHeight();
            if (this.imageHeight > n) {
                this.parent.redraw(this.x + 6, this.y + n - this.imageHeight, this.imageWidth, this.imageHeight, false);
            }
            this.parent.redraw(this.x, this.y, this.width, n + this.height, false);
        }
    }

    void register() {
        super.register();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.display.addWidget(this.clientHandle, this);
            this.display.addWidget(this.boxHandle, this);
            this.display.addWidget(this.labelHandle, this);
            this.display.addWidget(this.imageHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0L;
        this.labelHandle = 0L;
        this.boxHandle = 0L;
        this.clientHandle = 0L;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0) && this.parent.lastFocus == this) {
            this.parent.lastFocus = null;
        }
        this.imageList = null;
        this.control = null;
    }

    void resizeControl(int n) {
        if (this.control != null && !this.control.isDisposed()) {
            boolean bl = OS.gtk_expander_get_expanded(this.handle);
            if (bl) {
                int n2 = OS.GTK_WIDGET_X(this.clientHandle);
                int n3 = OS.GTK_WIDGET_Y(this.clientHandle);
                if (n2 != -1 && n3 != -1) {
                    int n4 = OS.GTK_WIDGET_WIDTH(this.clientHandle);
                    int n5 = OS.GTK_WIDGET_HEIGHT(this.clientHandle);
                    int[] nArray = new int[1];
                    OS.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray, 0L);
                    this.control.setBounds(n2, (n3 += nArray[0] * 2) - n, n4, Math.max(0, n5 -= nArray[0] * 2), true, true);
                }
            }
            this.control.setVisible(bl);
        }
    }

    void setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.redraw();
        int n5 = this.parent.getBandHeight();
        if (bl) {
            if (this.imageHeight > n5) {
                n2 += this.imageHeight - n5;
            }
            this.x = n;
            this.y = n2;
            this.redraw();
        }
        if (bl2) {
            this.width = n3;
            this.height = n4;
            this.redraw();
        }
        if (this.control != null && !this.control.isDisposed()) {
            if (bl) {
                this.control.setLocation(n + 1, n2 + n5);
            }
            if (bl2) {
                this.control.setSize(Math.max(0, n3 - 2), Math.max(0, n4 - 1));
            }
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        if (control != null) {
            control.setVisible(this.expanded);
            if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
                int n = this.parent.getBandHeight();
                control.setBounds(this.x + 1, this.y + n, Math.max(0, this.width - 2), Math.max(0, this.height - 1));
            }
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.parent.layoutItems(0, true);
        }
    }

    public void setExpanded(boolean bl) {
        this.checkWidget();
        this.expanded = bl;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.gtk_expander_set_expanded(this.handle, bl);
            this.parent.layoutItems(0, true);
        } else {
            this.parent.showItem(this);
        }
    }

    boolean setFocus() {
        if (!OS.gtk_widget_get_child_visible(this.handle)) {
            return false;
        }
        OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        OS.gtk_widget_grab_focus(this.handle);
        boolean bl = OS.gtk_widget_is_focus(this.handle);
        if (!bl) {
            OS.GTK_WIDGET_UNSET_FLAGS(this.handle, 2048);
        }
        return bl;
    }

    void setFontDescription(long l) {
        OS.gtk_widget_modify_font(this.handle, l);
        if (this.labelHandle != 0L) {
            OS.gtk_widget_modify_font(this.labelHandle, l);
        }
        if (this.imageHandle != 0L) {
            OS.gtk_widget_modify_font(this.imageHandle, l);
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        this.setForegroundColor(this.handle, gdkColor);
        if (this.labelHandle != 0L) {
            this.setForegroundColor(this.labelHandle, gdkColor);
        }
        if (this.imageHandle != 0L) {
            this.setForegroundColor(this.imageHandle, gdkColor);
        }
    }

    public void setHeight(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.height = n;
            OS.gtk_widget_set_size_request(this.clientHandle, -1, n);
            this.parent.layoutItems(0, false);
        } else {
            this.setBounds(0, 0, this.width, n, false, true);
            if (this.expanded) {
                this.parent.layoutItems(this.parent.indexOf(this) + 1, true);
            }
        }
    }

    public void setImage(Image image) {
        super.setImage(image);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.imageList != null) {
                this.imageList.dispose();
            }
            this.imageList = null;
            if (image != null) {
                if (image.isDisposed()) {
                    this.error(5);
                }
                this.imageList = new ImageList();
                int n = this.imageList.add(image);
                long l = this.imageList.getPixbuf(n);
                OS.gtk_image_set_from_pixbuf(this.imageHandle, l);
                if (this.text.length() == 0) {
                    OS.gtk_widget_hide(this.labelHandle);
                }
                OS.gtk_widget_show(this.imageHandle);
            } else {
                OS.gtk_image_set_from_pixbuf(this.imageHandle, 0L);
                OS.gtk_widget_show(this.labelHandle);
                OS.gtk_widget_hide(this.imageHandle);
            }
        } else {
            int n = this.imageHeight;
            if (image != null) {
                Rectangle rectangle = image.getBounds();
                this.imageHeight = rectangle.height;
                this.imageWidth = rectangle.width;
            } else {
                this.imageWidth = 0;
                this.imageHeight = 0;
            }
            if (n != this.imageHeight) {
                this.parent.layoutItems(this.parent.indexOf(this), true);
            } else {
                this.redraw();
            }
        }
    }

    void setOrientation() {
        super.setOrientation();
        if ((this.parent.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction(this.handle, 2);
            OS.gtk_container_forall(this.handle, this.display.setDirectionProc, 2L);
        }
    }

    public void setText(String string) {
        super.setText(string);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            OS.gtk_label_set_text(this.labelHandle, byArray);
        } else {
            this.redraw();
        }
    }

    void showWidget(int n) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.gtk_widget_show(this.handle);
            OS.gtk_widget_show(this.clientHandle);
            OS.gtk_container_add(this.parent.handle, this.handle);
            OS.gtk_box_set_child_packing(this.parent.handle, this.handle, false, false, 0, 0);
            if (this.boxHandle != 0L) {
                OS.gtk_widget_show(this.boxHandle);
            }
            if (this.labelHandle != 0L) {
                OS.gtk_widget_show(this.labelHandle);
            }
        }
    }

    long windowProc(long l, long l2) {
        switch ((int)l2) {
            case 60: {
                this.expanded = OS.gtk_expander_get_expanded(l);
                this.parent.layoutItems(0, false);
                return 0L;
            }
        }
        return super.windowProc(l, l2);
    }
}

