/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkFileSelection;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    String[] fileNames = new String[0];
    String fullPath = "";
    int filterIndex = -1;
    boolean overwrite = false;
    boolean uriMode;
    int handle;
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);
    static final char EXTENSION_SEPARATOR = ';';

    public FileDialog(Shell shell) {
        this(shell, 65536);
    }

    public FileDialog(Shell shell, int n) {
        super(shell, FileDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    String computeResultChooserDialog() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.fullPath = null;
        if ((this.style & 0x2002) == 2) {
            n5 = 0;
            n5 = this.uriMode ? OS.gtk_file_chooser_get_uris(this.handle) : OS.gtk_file_chooser_get_filenames(this.handle);
            int n6 = OS.g_slist_length(n5);
            this.fileNames = new String[n6];
            n4 = n5;
            n3 = 0;
            int n7 = 0;
            while (n7 < n6) {
                n2 = OS.g_slist_data(n4);
                int n8 = 0;
                if (this.uriMode) {
                    n8 = n2;
                } else {
                    n8 = OS.g_filename_to_utf8(n2, -1, null, null, null);
                    OS.g_free(n2);
                }
                if (n8 != 0) {
                    int[] nArray = new int[1];
                    int n9 = OS.g_utf8_to_utf16(n8, -1, null, nArray, null);
                    OS.g_free(n8);
                    if (n9 != 0) {
                        int n10 = nArray[0];
                        char[] cArray = new char[n10];
                        OS.memmove(cArray, n9, n10 * 2);
                        OS.g_free(n9);
                        this.fullPath = new String(cArray);
                        this.fileNames[n3++] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
                n4 = OS.g_slist_next(n4);
                ++n7;
            }
            if (n3 != 0 && n3 != n6) {
                String[] stringArray = new String[n3];
                System.arraycopy(this.fileNames, 0, stringArray, 0, n3);
                this.fileNames = stringArray;
            }
            OS.g_slist_free(n5);
        } else {
            n5 = 0;
            if (this.uriMode) {
                n5 = OS.gtk_file_chooser_get_uri(this.handle);
            } else {
                int n11 = OS.gtk_file_chooser_get_filename(this.handle);
                if (n11 != 0) {
                    n5 = OS.g_filename_to_utf8(n11, -1, null, null, null);
                    OS.g_free(n11);
                }
            }
            if (n5 != 0) {
                int[] nArray = new int[1];
                n4 = OS.g_utf8_to_utf16(n5, -1, null, nArray, null);
                OS.g_free(n5);
                if (n4 != 0) {
                    n3 = nArray[0];
                    char[] cArray = new char[n3];
                    OS.memmove(cArray, n4, n3 * 2);
                    OS.g_free(n4);
                    this.fullPath = new String(cArray);
                    this.fileNames = new String[1];
                    this.fileNames[0] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                }
            }
        }
        this.filterIndex = -1;
        n5 = OS.gtk_file_chooser_get_filter(this.handle);
        if (n5 != 0 && (n = OS.gtk_file_filter_get_name(n5)) != 0) {
            n4 = OS.strlen(n);
            byte[] byArray = new byte[n4];
            OS.memmove(byArray, n, n4);
            String string = new String(Converter.mbcsToWcs(null, byArray));
            n2 = 0;
            while (n2 < this.filterExtensions.length) {
                if (this.filterNames.length > 0) {
                    if (this.filterNames[n2].equals(string)) {
                        this.filterIndex = n2;
                        break;
                    }
                } else if (this.filterExtensions[n2].equals(string)) {
                    this.filterIndex = n2;
                    break;
                }
                ++n2;
            }
        }
        if (this.fullPath != null) {
            int n12 = this.fullPath.lastIndexOf(SEPARATOR);
            this.fileName = this.fullPath.substring(n12 + 1);
            this.filterPath = this.fullPath.substring(0, n12);
        }
        return this.fullPath;
    }

    String computeResultClassicDialog() {
        int n;
        int n2;
        int[] nArray;
        int n3;
        int n4;
        this.filterIndex = -1;
        GtkFileSelection gtkFileSelection = new GtkFileSelection();
        OS.memmove(gtkFileSelection, this.handle);
        int n5 = gtkFileSelection.selection_entry;
        int n6 = OS.gtk_entry_get_text(n5);
        int n7 = OS.strlen(n6);
        if (n7 == 0) {
            n4 = gtkFileSelection.file_list;
            n3 = OS.gtk_tree_view_get_selection(n4);
            n2 = OS.gtk_tree_selection_get_selected_rows(n3, nArray = new int[1]);
            if (n2 == 0) {
                return null;
            }
            int n8 = OS.g_list_length(n2);
            if (n8 == 0) {
                OS.g_list_free(n2);
                return null;
            }
            int n9 = OS.g_list_nth_data(n2, 0);
            int[] nArray2 = new int[1];
            int n10 = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (OS.gtk_tree_model_get_iter(nArray[0], n10, n9)) {
                OS.gtk_tree_model_get(nArray[0], n10, 0, nArray2, -1);
            }
            OS.g_free(n10);
            n = 0;
            while (n < n8) {
                OS.gtk_tree_path_free(OS.g_list_nth_data(n2, n));
                ++n;
            }
            OS.g_list_free(n2);
            if (nArray2[0] == 0) {
                return null;
            }
            n = OS.strlen(nArray2[0]);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, nArray2[0], n);
            OS.g_free(nArray2[0]);
            OS.gtk_entry_set_text(n5, byArray);
        }
        n4 = OS.gtk_file_selection_get_filename(this.handle);
        n3 = OS.g_filename_to_utf8(n4, -1, null, null, null);
        nArray = new int[1];
        n2 = OS.g_utf8_to_utf16(n3, -1, null, nArray, null);
        n7 = nArray[0];
        char[] cArray = new char[n7];
        OS.memmove(cArray, n2, n7 * 2);
        String string = new String(cArray);
        OS.g_free(n2);
        OS.g_free(n3);
        if (string == null) {
            return null;
        }
        int n11 = string.lastIndexOf(SEPARATOR);
        if (n11 + 1 == string.length()) {
            return null;
        }
        String string2 = this.fullPath = string;
        this.fileName = this.fullPath.substring(n11 + 1);
        this.filterPath = this.fullPath.substring(0, n11);
        if ((this.style & 2) == 0) {
            this.fileNames = new String[]{this.fileName};
        } else {
            int n12 = n = OS.gtk_file_selection_get_selections(this.handle);
            int[] nArray3 = new int[1];
            OS.memmove(nArray3, n12, OS.PTR_SIZEOF);
            int n13 = 0;
            while (nArray3[0] != 0) {
                ++n13;
                OS.memmove(nArray3, n12 += OS.PTR_SIZEOF, OS.PTR_SIZEOF);
            }
            this.fileNames = new String[n13];
            nArray3 = new int[n13];
            OS.memmove(nArray3, n, n13 * OS.PTR_SIZEOF);
            int n14 = 0;
            while (n14 < n13) {
                n3 = OS.g_filename_to_utf8(nArray3[n14], -1, null, null, null);
                nArray = new int[1];
                n2 = OS.g_utf8_to_utf16(n3, -1, null, nArray, null);
                cArray = new char[nArray[0]];
                OS.memmove(cArray, n2, nArray[0] * 2);
                String string3 = new String(cArray);
                this.fileNames[n14] = string3.substring(string3.lastIndexOf(SEPARATOR) + 1);
                OS.g_free(n2);
                OS.g_free(n3);
                ++n14;
            }
            OS.g_strfreev(n);
        }
        return string2;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        boolean bl;
        boolean bl2 = bl = OS.GTK_VERSION >= OS.VERSION(2, 4, 10);
        if (bl) {
            return this.openChooserDialog();
        }
        return this.openClassicDialog();
    }

    String openChooserDialog() {
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        int n = (this.style & 0x2000) != 0 ? 1 : 0;
        int n2 = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.handle = display.getDismissalAlignment() == 131072 ? OS.gtk_file_chooser_dialog_new(byArray, n2, n, OS.GTK_STOCK_CANCEL(), -6, OS.GTK_STOCK_OK(), -5, 0) : OS.gtk_file_chooser_dialog_new(byArray, n2, n, OS.GTK_STOCK_OK(), -5, OS.GTK_STOCK_CANCEL(), -6, 0);
        OS.gtk_window_set_modal(this.handle, true);
        int n3 = OS.gtk_window_get_icon_list(n2);
        if (n3 != 0) {
            OS.gtk_window_set_icon_list(this.handle, n3);
            OS.g_list_free(n3);
        }
        if (this.uriMode) {
            OS.gtk_file_chooser_set_local_only(this.handle, false);
        }
        this.presetChooserDialog();
        display.addIdleProc();
        String string = null;
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(this.handle)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n4 = 0;
        int n5 = 0;
        if ((this.style & 0x4000000) != 0) {
            n4 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            n5 = OS.g_signal_add_emission_hook(n4, 0, display.emissionProc, this.handle, 0);
        }
        int n6 = OS.gtk_dialog_run(this.handle);
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n4, n5);
        }
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setModalDialog(dialog);
        }
        if (n6 == -5) {
            string = this.computeResultChooserDialog();
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(this.handle);
        return string;
    }

    String openClassicDialog() {
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        this.handle = OS.gtk_file_selection_new(byArray);
        if (this.parent != null) {
            int n = this.parent.topHandle();
            OS.gtk_window_set_transient_for(this.handle, n);
            int n2 = OS.gtk_window_get_icon_list(n);
            if (n2 != 0) {
                OS.gtk_window_set_icon_list(this.handle, n2);
                OS.g_list_free(n2);
            }
        }
        OS.gtk_window_set_modal(this.handle, true);
        this.presetClassicDialog();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.addIdleProc();
        String string = null;
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(this.handle)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n = 0;
        int n3 = 0;
        if ((this.style & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            n3 = OS.g_signal_add_emission_hook(n, 0, display.emissionProc, this.handle, 0);
        }
        int n4 = OS.gtk_dialog_run(this.handle);
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, n3);
        }
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setModalDialog(dialog);
        }
        if (n4 == -5) {
            string = this.computeResultClassicDialog();
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(this.handle);
        return string;
    }

    void presetChooserDialog() {
        int n;
        int n2;
        Object object;
        if ((this.style & 0x2002) == 2) {
            OS.gtk_file_chooser_set_select_multiple(this.handle, true);
        }
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if (this.fileName == null) {
            this.fileName = "";
        }
        if ((this.style & 0x2000) != 0) {
            if (this.filterPath.length() > 0) {
                if (this.uriMode) {
                    object = Converter.wcsToMbcs(null, this.filterPath, true);
                    OS.gtk_file_chooser_set_current_folder_uri(this.handle, (byte[])object);
                } else {
                    object = Converter.wcsToMbcs(null, String.valueOf(SEPARATOR) + this.filterPath, true);
                    n2 = OS.realpath((byte[])object, null);
                    OS.gtk_file_chooser_set_current_folder(this.handle, n2);
                    OS.g_free(n2);
                }
            }
            if (this.fileName.length() > 0) {
                object = Converter.wcsToMbcs(null, this.fileName, true);
                OS.gtk_file_chooser_set_current_name(this.handle, (byte[])object);
            }
        } else {
            object = new StringBuffer();
            if (this.filterPath.length() > 0) {
                if (!this.uriMode) {
                    ((StringBuffer)object).append(SEPARATOR);
                }
                ((StringBuffer)object).append(this.filterPath);
                ((StringBuffer)object).append(SEPARATOR);
            }
            if (this.fileName.length() > 0) {
                ((StringBuffer)object).append(this.fileName);
            }
            byte[] byArray = Converter.wcsToMbcs(null, ((StringBuffer)object).toString(), true);
            if (this.uriMode) {
                OS.gtk_file_chooser_set_uri(this.handle, byArray);
            } else {
                n = OS.realpath(byArray, null);
                if (n != 0) {
                    if (this.fileName.length() > 0) {
                        OS.gtk_file_chooser_set_filename(this.handle, n);
                    } else {
                        OS.gtk_file_chooser_set_current_folder(this.handle, n);
                    }
                    OS.g_free(n);
                }
            }
        }
        if ((this.style & 0x2000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
            OS.gtk_file_chooser_set_do_overwrite_confirmation(this.handle, this.overwrite);
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        int n3 = 0;
        n2 = 0;
        while (n2 < this.filterExtensions.length) {
            if (this.filterExtensions[n2] != null) {
                byte[] byArray;
                String string;
                byte[] byArray2;
                n = OS.gtk_file_filter_new();
                if (this.filterNames.length > n2 && this.filterNames[n2] != null) {
                    byArray2 = Converter.wcsToMbcs(null, this.filterNames[n2], true);
                    OS.gtk_file_filter_set_name(n, byArray2);
                } else {
                    byArray2 = Converter.wcsToMbcs(null, this.filterExtensions[n2], true);
                    OS.gtk_file_filter_set_name(n, byArray2);
                }
                int n4 = 0;
                int n5 = this.filterExtensions[n2].indexOf(59);
                while (n5 != -1) {
                    string = this.filterExtensions[n2].substring(n4, n5);
                    byArray = Converter.wcsToMbcs(null, string, true);
                    OS.gtk_file_filter_add_pattern(n, byArray);
                    n4 = n5 + 1;
                    n5 = this.filterExtensions[n2].indexOf(59, n4);
                }
                string = this.filterExtensions[n2].substring(n4);
                byArray = Converter.wcsToMbcs(null, string, true);
                OS.gtk_file_filter_add_pattern(n, byArray);
                OS.gtk_file_chooser_add_filter(this.handle, n);
                if (n2 == this.filterIndex) {
                    n3 = n;
                }
            }
            ++n2;
        }
        if (n3 != 0) {
            OS.gtk_file_chooser_set_filter(this.handle, n3);
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    void presetClassicDialog() {
        OS.gtk_file_selection_set_select_multiple(this.handle, (this.style & 2) != 0);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.filterPath == null) {
            this.filterPath = "";
        } else if (this.filterPath.length() > 0) {
            stringBuffer.append(this.filterPath);
            if (this.filterPath.charAt(this.filterPath.length() - 1) != SEPARATOR) {
                stringBuffer.append(SEPARATOR);
            }
        }
        if (this.fileName == null) {
            this.fileName = "";
        } else {
            stringBuffer.append(this.fileName);
        }
        this.fullPath = stringBuffer.toString();
        int n = this.fullPath.length();
        char[] cArray = new char[n + 1];
        this.fullPath.getChars(0, n, cArray, 0);
        int n2 = OS.g_utf16_to_utf8(cArray, -1, null, null, null);
        int n3 = OS.g_filename_from_utf8(n2, -1, null, null, null);
        OS.gtk_file_selection_set_filename(this.handle, n3);
        OS.g_free(n2);
        OS.g_free(n3);
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterIndex(int n) {
        this.filterIndex = n;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    void setURIMode(boolean bl) {
        this.uriMode = bl;
    }
}

