/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Library {
    static int MAJOR_VERSION = 3;
    static int MINOR_VERSION = 555;
    static int REVISION = 0;
    public static final int JAVA_VERSION;
    public static final int SWT_VERSION;
    static final String SEPARATOR;
    static boolean IS_64;
    static final String SUFFIX_64 = "-64";
    static final String SWTDIR_32 = "swtlib-32";
    static final String SWTDIR_64 = "swtlib-64";
    static /* synthetic */ Class class$0;

    static {
        IS_64 = false;
        SEPARATOR = System.getProperty("file.separator");
        JAVA_VERSION = Library.parseVersion(System.getProperty("java.version"));
        SWT_VERSION = Library.SWT_VERSION(MAJOR_VERSION, MINOR_VERSION);
    }

    static int parseVersion(String version) {
        if (version == null) {
            return 0;
        }
        int major = 0;
        int minor = 0;
        int micro = 0;
        int length = version.length();
        int index = 0;
        int start = 0;
        while (index < length && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < length) {
                major = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        start = ++index;
        while (index < length && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < length) {
                minor = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        start = ++index;
        while (index < length && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < length) {
                micro = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return Library.JAVA_VERSION(major, minor, micro);
    }

    public static int JAVA_VERSION(int major, int minor, int micro) {
        return (major << 16) + (minor << 8) + micro;
    }

    public static int SWT_VERSION(int major, int minor) {
        return major * 1000 + minor;
    }

    static boolean extract(String fileName, String mappedName) {
        block19: {
            FileOutputStream os = null;
            InputStream is = null;
            File file = new File(fileName);
            boolean extracted = false;
            try {
                if (!file.exists()) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.swt.internal.Library");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((is = clazz.getResourceAsStream("/" + mappedName)) != null) {
                        int read;
                        extracted = true;
                        byte[] buffer = new byte[4096];
                        os = new FileOutputStream(fileName);
                        while ((read = is.read(buffer)) != -1) {
                            os.write(buffer, 0, read);
                        }
                        os.close();
                        is.close();
                        if (!"gtk".equals("win32")) {
                            try {
                                Runtime.getRuntime().exec(new String[]{"chmod", "755", fileName}).waitFor();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
                if (Library.load(fileName)) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                if (!extracted || !file.exists()) break block19;
                file.delete();
            }
        }
        return false;
    }

    static boolean load(String libName) {
        try {
            if (libName.indexOf(SEPARATOR) != -1) {
                System.load(libName);
            } else {
                System.loadLibrary(libName);
            }
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    public static void loadLibrary(String name) {
        Library.loadLibrary(name, true);
    }

    public static void loadLibrary(String name, boolean mapName) {
        String mappedName2;
        String mappedName1;
        String libName2;
        String libName1;
        String prop = System.getProperty("sun.arch.data.model");
        if (prop == null) {
            prop = System.getProperty("com.ibm.vm.bitmode");
        }
        if (prop != null) {
            if ("32".equals(prop) && IS_64) {
                throw new UnsatisfiedLinkError("Cannot load 64-bit SWT libraries on 32-bit JVM");
            }
            if ("64".equals(prop) && !IS_64) {
                throw new UnsatisfiedLinkError("Cannot load 32-bit SWT libraries on 64-bit JVM");
            }
        }
        if (mapName) {
            String version = System.getProperty("swt.version");
            if (version == null) {
                version = "" + MAJOR_VERSION;
                if (MINOR_VERSION < 10) {
                    version = String.valueOf(version) + "00";
                } else if (MINOR_VERSION < 100) {
                    version = String.valueOf(version) + "0";
                }
                version = String.valueOf(version) + MINOR_VERSION;
                if (REVISION > 0) {
                    version = String.valueOf(version) + "r" + REVISION;
                }
            }
            libName1 = String.valueOf(name) + "-" + "gtk" + "-" + version;
            libName2 = String.valueOf(name) + "-" + "gtk";
            mappedName1 = Library.mapLibraryName(libName1);
            mappedName2 = Library.mapLibraryName(libName2);
        } else {
            mappedName1 = mappedName2 = name;
            libName2 = mappedName2;
            libName1 = mappedName2;
        }
        String path = System.getProperty("swt.library.path");
        if (path != null) {
            if (Library.load(String.valueOf(path = new File(path).getAbsolutePath()) + SEPARATOR + mappedName1)) {
                return;
            }
            if (mapName && Library.load(String.valueOf(path) + SEPARATOR + mappedName2)) {
                return;
            }
        }
        if (Library.load(libName1)) {
            return;
        }
        if (mapName && Library.load(libName2)) {
            return;
        }
        String fileName1 = mappedName1;
        String fileName2 = mappedName2;
        if (path == null) {
            path = System.getProperty("java.io.tmpdir");
            File dir = new File(path, IS_64 ? SWTDIR_64 : SWTDIR_32);
            boolean make = false;
            if (dir.exists() && dir.isDirectory() || (make = dir.mkdir())) {
                path = dir.getAbsolutePath();
                if (make && !"gtk".equals("win32")) {
                    try {
                        Runtime.getRuntime().exec(new String[]{"chmod", "777", path}).waitFor();
                    }
                    catch (Throwable throwable) {}
                }
            } else if (IS_64) {
                fileName1 = Library.mapLibraryName(String.valueOf(libName1) + SUFFIX_64);
                fileName2 = Library.mapLibraryName(String.valueOf(libName2) + SUFFIX_64);
            }
            if (Library.load(String.valueOf(path) + SEPARATOR + fileName1)) {
                return;
            }
            if (mapName && Library.load(String.valueOf(path) + SEPARATOR + fileName2)) {
                return;
            }
        }
        if (path != null) {
            if (Library.extract(String.valueOf(path) + SEPARATOR + fileName1, mappedName1)) {
                return;
            }
            if (mapName && Library.extract(String.valueOf(path) + SEPARATOR + fileName2, mappedName2)) {
                return;
            }
        }
        throw new UnsatisfiedLinkError("no " + libName1 + " or " + libName2 + " in swt.library.path, java.library.path or the jar file");
    }

    static String mapLibraryName(String libName) {
        String ext;
        if ((libName = System.mapLibraryName(libName)).endsWith(ext = ".dylib")) {
            libName = String.valueOf(libName.substring(0, libName.length() - ext.length())) + ".jnilib";
        }
        return libName;
    }
}

