/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventCrossing;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.GdkEventScroll;
import org.eclipse.swt.internal.gtk.GdkEventVisibility;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XWindowChanges;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    int fixedHandle;
    int redrawWindow;
    int enableWindow;
    int drawCount;
    Composite parent;
    Cursor cursor;
    Menu menu;
    Image backgroundImage;
    Font font;
    Region region;
    String toolTipText;
    Object layoutData;
    Accessible accessible;
    static final String IS_ACTIVE = "org.eclipse.swt.internal.control.isactive";

    Control() {
    }

    public Control(Composite composite, int n) {
        super(composite, n);
        this.parent = composite;
        this.createWidget(0);
    }

    Font defaultFont() {
        return this.display.getSystemFont();
    }

    void deregister() {
        int n;
        super.deregister();
        if (this.fixedHandle != 0) {
            this.display.removeWidget(this.fixedHandle);
        }
        if ((n = this.imHandle()) != 0) {
            this.display.removeWidget(n);
        }
    }

    boolean drawGripper(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6 = this.paintHandle();
        int n7 = OS.GTK_WIDGET_WINDOW(n6);
        if (n7 == 0) {
            return false;
        }
        int n8 = n5 = bl ? 0 : 1;
        if ((this.style & 0x8000000) != 0) {
            n = this.getClientWidth() - n3 - n;
        }
        OS.gtk_paint_handle(OS.gtk_widget_get_style(n6), n7, 0, 2, null, n6, new byte[1], n, n2, n3, n4, n5);
        return true;
    }

    void enableWidget(boolean bl) {
        OS.gtk_widget_set_sensitive(this.handle, bl);
    }

    int enterExitHandle() {
        return this.eventHandle();
    }

    int eventHandle() {
        return this.handle;
    }

    int eventWindow() {
        int n = this.eventHandle();
        OS.gtk_widget_realize(n);
        return OS.GTK_WIDGET_WINDOW(n);
    }

    void fixFocus(Control control) {
        Shell shell = this.getShell();
        Control control2 = this;
        while (control2 != shell && (control2 = control2.parent) != null) {
            if (!control2.setFocus()) continue;
            return;
        }
        shell.setSavedFocus(control);
        int n = shell.vboxHandle;
        OS.GTK_WIDGET_SET_FLAGS(n, 2048);
        OS.gtk_widget_grab_focus(n);
        OS.GTK_WIDGET_UNSET_FLAGS(n, 2048);
    }

    void fixStyle() {
        if (this.fixedHandle != 0) {
            this.fixStyle(this.fixedHandle);
        }
    }

    void fixStyle(int n) {
        if ((this.state & 0x2000) != 0) {
            return;
        }
        if ((this.state & 0x10000) == 0) {
            return;
        }
        int n2 = this.parent.childStyle();
        if (n2 != 0) {
            GdkColor gdkColor = new GdkColor();
            OS.gtk_style_get_bg(n2, 0, gdkColor);
            this.setBackgroundColor(gdkColor);
        }
    }

    int focusHandle() {
        return this.handle;
    }

    int fontHandle() {
        return this.handle;
    }

    boolean hasFocus() {
        return this == this.display.getFocusControl();
    }

    void hookEvents() {
        int n = this.focusHandle();
        int n2 = 19456;
        OS.gtk_widget_add_events(n, n2);
        OS.g_signal_connect_closure_by_id(n, this.display.signalIds[38], 0, this.display.closures[38], false);
        OS.g_signal_connect_closure_by_id(n, this.display.signalIds[46], 0, this.display.closures[46], false);
        OS.g_signal_connect_closure_by_id(n, this.display.signalIds[27], 0, this.display.closures[27], false);
        OS.g_signal_connect_closure_by_id(n, this.display.signalIds[28], 0, this.display.closures[28], false);
        OS.g_signal_connect_closure_by_id(n, this.display.signalIds[20], 0, this.display.closures[20], false);
        OS.g_signal_connect_closure_by_id(n, this.display.signalIds[21], 0, this.display.closures[21], false);
        OS.g_signal_connect_closure_by_id(n, this.display.signalIds[22], 0, this.display.closures[22], false);
        int n3 = this.eventHandle();
        int n4 = 772;
        OS.gtk_widget_add_events(n3, n4);
        OS.g_signal_connect_closure_by_id(n3, this.display.signalIds[2], 0, this.display.closures[2], false);
        OS.g_signal_connect_closure_by_id(n3, this.display.signalIds[4], 0, this.display.closures[4], false);
        OS.g_signal_connect_closure_by_id(n3, this.display.signalIds[33], 0, this.display.closures[33], false);
        OS.g_signal_connect_closure_by_id(n3, this.display.signalIds[43], 0, this.display.closures[43], false);
        int n5 = this.enterExitHandle();
        int n6 = 12288;
        OS.gtk_widget_add_events(n5, n6);
        OS.g_signal_connect_closure_by_id(n5, this.display.signalIds[14], 0, this.display.closures[14], false);
        OS.g_signal_connect_closure_by_id(n5, this.display.signalIds[29], 0, this.display.closures[29], false);
        int n7 = this.fixedHandle != 0 ? this.fixedHandle : n3;
        OS.g_signal_connect_closure_by_id(n7, this.display.signalIds[2], 0, this.display.closures[3], true);
        OS.g_signal_connect_closure_by_id(n7, this.display.signalIds[4], 0, this.display.closures[5], true);
        OS.g_signal_connect_closure_by_id(n7, this.display.signalIds[33], 0, this.display.closures[34], true);
        OS.g_signal_connect_closure_by_id(n3, this.display.signalIds[16], 0, this.display.closures[16], false);
        if (n != n3) {
            OS.g_signal_connect_closure_by_id(n, this.display.signalIds[16], 0, this.display.closures[16], false);
        }
        int n8 = this.paintHandle();
        int n9 = 131074;
        OS.gtk_widget_add_events(n8, n9);
        OS.g_signal_connect_closure_by_id(n8, this.display.signalIds[18], 0, this.display.closures[19], false);
        OS.g_signal_connect_closure_by_id(n8, this.display.signalIds[58], 0, this.display.closures[58], false);
        OS.g_signal_connect_closure_by_id(n8, this.display.signalIds[18], 0, this.display.closures[18], true);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[40], 0, this.display.closures[40], true);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[56], 0, this.display.closures[56], false);
        int n10 = this.imHandle();
        if (n10 != 0) {
            OS.g_signal_connect_closure(n10, OS.commit, this.display.closures[9], false);
            OS.g_signal_connect_closure(n10, OS.preedit_changed, this.display.closures[39], false);
        }
        OS.g_signal_connect_closure_by_id(n8, this.display.signalIds[48], 0, this.display.closures[48], false);
        int n11 = this.topHandle();
        OS.g_signal_connect_closure_by_id(n11, this.display.signalIds[30], 0, this.display.closures[30], true);
    }

    int hoverProc(int n) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.gdk_window_get_pointer(0, nArray, nArray2, nArray3);
        this.sendMouseEvent(32, 0, 0, nArray[0], nArray2[0], false, nArray3[0]);
        return 0;
    }

    int topHandle() {
        if (this.fixedHandle != 0) {
            return this.fixedHandle;
        }
        return super.topHandle();
    }

    int paintHandle() {
        int n = this.topHandle();
        int n2 = this.handle;
        while (n2 != n) {
            if ((OS.GTK_WIDGET_FLAGS(n2) & 0x20) == 0) break;
            n2 = OS.gtk_widget_get_parent(n2);
        }
        return n2;
    }

    int paintWindow() {
        int n = this.paintHandle();
        OS.gtk_widget_realize(n);
        return OS.GTK_WIDGET_WINDOW(n);
    }

    public boolean print(GC gC) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        int n = this.topHandle();
        OS.gtk_widget_realize(n);
        int n2 = OS.GTK_WIDGET_WINDOW(n);
        GCData gCData = gC.getGCData();
        OS.gdk_window_process_updates(n2, true);
        this.printWidget(gC, gCData.drawable, OS.gdk_drawable_get_depth(gCData.drawable), 0, 0);
        return true;
    }

    void printWidget(GC gC, int n, int n2, int n3, int n4) {
        boolean bl = (this.state & 0x40) != 0;
        this.state &= 0xFFFFFFBF;
        int n5 = this.topHandle();
        int n6 = OS.GTK_WIDGET_WINDOW(n5);
        this.printWindow(true, this, gC, n, n2, n6, n3, n4);
        if (bl) {
            this.state |= 0x40;
        }
    }

    void printWindow(boolean bl, Control control, GC gC, int n, int n2, int n3, int n4, int n5) {
        int n6;
        Object object;
        int n7;
        if (OS.gdk_drawable_get_depth(n3) != n2) {
            return;
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(n3, nArray, nArray2);
        gdkRectangle.width = nArray[0];
        gdkRectangle.height = nArray2[0];
        OS.gdk_window_begin_paint_rect(n3, gdkRectangle);
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        OS.gdk_window_get_internal_paint_info(n3, nArray3, nArray4, nArray5);
        int[] nArray6 = new int[1];
        OS.gdk_window_get_user_data(n3, nArray6);
        if (nArray6[0] != 0) {
            n7 = OS.gdk_event_new(2);
            GdkEventExpose gdkEventExpose = new GdkEventExpose();
            gdkEventExpose.type = 2;
            gdkEventExpose.window = OS.g_object_ref(n3);
            gdkEventExpose.area_width = gdkRectangle.width;
            gdkEventExpose.area_height = gdkRectangle.height;
            gdkEventExpose.region = OS.gdk_region_rectangle(gdkRectangle);
            OS.memmove(n7, gdkEventExpose, GdkEventExpose.sizeof);
            OS.gtk_widget_send_expose(nArray6[0], n7);
            OS.gdk_event_free(n7);
        }
        n7 = nArray4[0];
        int n8 = nArray5[0];
        int n9 = n4;
        int n10 = n5;
        int n11 = nArray[0];
        int n12 = nArray2[0];
        if (!bl) {
            object = new int[1];
            int[] nArray7 = new int[1];
            OS.gdk_window_get_position(n3, object, nArray7);
            n6 = OS.gdk_window_get_parent(n3);
            int[] nArray8 = new int[1];
            int[] nArray9 = new int[1];
            OS.gdk_drawable_get_size(n6, nArray8, nArray9);
            n7 = nArray4[0] - object[0];
            n8 = nArray5[0] - nArray7[0];
            n9 = n4 - object[0];
            n10 = n5 - nArray7[0];
            n11 = Math.min(object[0] + nArray[0], nArray8[0]);
            n12 = Math.min(nArray7[0] + nArray2[0], nArray9[0]);
        }
        object = gC.getGCData();
        int n13 = object.cairo;
        if (n13 != 0) {
            n6 = OS.GDK_DISPLAY();
            int n14 = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
            int n15 = OS.GDK_PIXMAP_XID(nArray3[0]);
            int n16 = Cairo.cairo_xlib_surface_create(n6, n15, n14, nArray[0], nArray2[0]);
            if (n16 == 0) {
                SWT.error(2);
            }
            Cairo.cairo_save(n13);
            Cairo.cairo_rectangle(n13, n9, n10, n11, n12);
            Cairo.cairo_clip(n13);
            Cairo.cairo_translate(n13, n9, n10);
            int n17 = Cairo.cairo_pattern_create_for_surface(n16);
            if (n17 == 0) {
                SWT.error(2);
            }
            Cairo.cairo_pattern_set_filter(n17, 2);
            Cairo.cairo_set_source(n13, n17);
            if (object.alpha != 255) {
                Cairo.cairo_paint_with_alpha(n13, (float)object.alpha / 255.0f);
            } else {
                Cairo.cairo_paint(n13);
            }
            Cairo.cairo_restore(n13);
            Cairo.cairo_pattern_destroy(n17);
            Cairo.cairo_surface_destroy(n16);
        } else {
            OS.gdk_draw_drawable(n, gC.handle, nArray3[0], n7, n8, n9, n10, n11, n12);
        }
        OS.gdk_window_end_paint(n3);
        n6 = OS.gdk_window_get_children(n3);
        if (n6 != 0) {
            int n18 = n6;
            while (n18 != 0) {
                int n19 = OS.g_list_data(n18);
                if (OS.gdk_window_is_visible(n19)) {
                    Widget widget;
                    int[] nArray10 = new int[1];
                    OS.gdk_window_get_user_data(n19, nArray10);
                    if (nArray10[0] != 0 && ((widget = this.display.findWidget(nArray10[0])) == null || widget == control)) {
                        int[] nArray11 = new int[1];
                        int[] nArray12 = new int[1];
                        OS.gdk_window_get_position(n19, nArray11, nArray12);
                        this.printWindow(false, control, gC, n, n2, n19, n4 + nArray11[0], n5 + nArray12[0]);
                    }
                }
                n18 = OS.g_list_next(n18);
            }
            OS.g_list_free(n6);
        }
    }

    public Point computeSize(int n, int n2) {
        return this.computeSize(n, n2, true);
    }

    Widget computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Widget[]{this};
        }
        return new Widget[0];
    }

    Control computeTabRoot() {
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            int n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) break;
                ++n;
            }
            if (n == controlArray.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    void checkBuffered() {
        this.style |= 0x20000000;
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFF7FFF;
        Composite composite = this.parent;
        while (true) {
            int n;
            if ((n = composite.backgroundMode) != 0) {
                if (n == 1) {
                    Control control = this;
                    do {
                        if ((control.state & 0x10000) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x8000;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkBorder() {
        if (this.getBorderWidth() == 0) {
            this.style &= 0xFFFFF7FF;
        }
    }

    void checkMirrored() {
        if ((this.style & 0x4000000) != 0) {
            this.style |= 0x8000000;
        }
    }

    int childStyle() {
        return this.parent.childStyle();
    }

    void createWidget(int n) {
        this.state |= 0x800000;
        this.checkOrientation(this.parent);
        super.createWidget(n);
        this.checkBackground();
        if ((this.state & 0x8000) != 0) {
            this.setBackground();
        }
        this.checkBuffered();
        this.showWidget();
        this.setInitialBounds();
        this.setZOrder(null, false, false);
        this.setRelations();
        this.checkMirrored();
        this.checkBorder();
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        return this.computeNativeSize(this.handle, n, n2, bl);
    }

    Point computeNativeSize(int n, int n2, int n3, boolean bl) {
        int n4 = n2;
        int n5 = n3;
        if (n2 == -1 && n3 == -1) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            this.gtk_widget_size_request(n, gtkRequisition);
            n4 = OS.GTK_WIDGET_REQUISITION_WIDTH(n);
            n5 = OS.GTK_WIDGET_REQUISITION_HEIGHT(n);
        } else if (n2 == -1 || n3 == -1) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_widget_get_size_request(n, nArray, nArray2);
            OS.gtk_widget_set_size_request(n, n2, n3);
            GtkRequisition gtkRequisition = new GtkRequisition();
            this.gtk_widget_size_request(n, gtkRequisition);
            OS.gtk_widget_set_size_request(n, nArray[0], nArray2[0]);
            n4 = n2 == -1 ? gtkRequisition.width : n2;
            n5 = n3 == -1 ? gtkRequisition.height : n3;
        }
        return new Point(n4, n5);
    }

    void forceResize() {
        int n = this.topHandle();
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_size_request(n, gtkRequisition);
        GtkAllocation gtkAllocation = new GtkAllocation();
        gtkAllocation.x = OS.GTK_WIDGET_X(n);
        gtkAllocation.y = OS.GTK_WIDGET_Y(n);
        gtkAllocation.width = OS.GTK_WIDGET_WIDTH(n);
        gtkAllocation.height = OS.GTK_WIDGET_HEIGHT(n);
        OS.gtk_widget_size_allocate(n, gtkAllocation);
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public Rectangle getBounds() {
        int n;
        this.checkWidget();
        int n2 = this.topHandle();
        int n3 = OS.GTK_WIDGET_X(n2);
        int n4 = OS.GTK_WIDGET_Y(n2);
        int n5 = (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(n2);
        int n6 = n = (this.state & 0x400) != 0 ? 0 : OS.GTK_WIDGET_HEIGHT(n2);
        if ((this.parent.style & 0x8000000) != 0) {
            n3 = this.parent.getClientWidth() - n5 - n3;
        }
        return new Rectangle(n3, n4, n5, n);
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, Math.max(0, rectangle.width), Math.max(0, rectangle.height), true, true);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.setBounds(n, n2, Math.max(0, n3), Math.max(0, n4), true, true);
    }

    void markLayout(boolean bl, boolean bl2) {
    }

    void modifyStyle(int n, int n2) {
        super.modifyStyle(n, n2);
        if (this.region != null) {
            OS.gdk_window_shape_combine_region(OS.GTK_WIDGET_WINDOW(this.topHandle()), this.region.handle, 0, 0);
        }
    }

    void moveHandle(int n, int n2) {
        int n3 = this.topHandle();
        int n4 = this.parent.parentingHandle();
        int n5 = OS.GTK_WIDGET_FLAGS(n4);
        OS.GTK_WIDGET_UNSET_FLAGS(n4, 256);
        OS.gtk_fixed_move(n4, n3, n, n2);
        if ((n5 & 0x100) != 0) {
            OS.GTK_WIDGET_SET_FLAGS(n4, 256);
        }
    }

    void resizeHandle(int n, int n2) {
        int n3 = this.topHandle();
        OS.gtk_widget_set_size_request(n3, n, n2);
        if (n3 != this.handle) {
            OS.gtk_widget_set_size_request(this.handle, n, n2);
        }
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = this.topHandle();
        boolean bl3 = bl;
        if ((this.parent.style & 0x8000000) != 0) {
            n8 = this.parent.getClientWidth();
            n7 = (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(n9);
            n6 = n8 - n7 - OS.GTK_WIDGET_X(n9);
            if (bl) {
                bl3 &= n != n6;
                n = n8 - (bl2 ? n3 : n7) - n;
            } else {
                bl = true;
                n = n8 - (bl2 ? n3 : n7) - n6;
                n2 = OS.GTK_WIDGET_Y(n9);
            }
        }
        n8 = 1;
        n7 = 1;
        if (bl) {
            n6 = OS.GTK_WIDGET_X(n9);
            n5 = OS.GTK_WIDGET_Y(n9);
            int n10 = n8 = n == n6 && n2 == n5 ? 1 : 0;
            if (n8 == 0) {
                if (this.enableWindow != 0) {
                    OS.gdk_window_move(this.enableWindow, n, n2);
                }
                this.moveHandle(n, n2);
            }
        }
        n6 = 0;
        if (bl2) {
            n5 = (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(n9);
            int n11 = (this.state & 0x400) != 0 ? 0 : OS.GTK_WIDGET_HEIGHT(n9);
            int n12 = n7 = n3 == n5 && n4 == n11 ? 1 : 0;
            if (n7 == 0 && (this.style & 0x8000000) != 0) {
                n6 = this.getClientWidth();
            }
            if (n7 == 0 && (n3 != 0 || n4 != 0)) {
                int n13 = Math.max(1, n3);
                int n14 = Math.max(1, n4);
                if (this.redrawWindow != 0) {
                    OS.gdk_window_resize(this.redrawWindow, n13, n14);
                }
                if (this.enableWindow != 0) {
                    OS.gdk_window_resize(this.enableWindow, n13, n14);
                }
                this.resizeHandle(n13, n14);
            }
        }
        if (n8 == 0 || n7 == 0) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            this.gtk_widget_size_request(n9, gtkRequisition);
            GtkAllocation gtkAllocation = new GtkAllocation();
            if (bl) {
                gtkAllocation.x = n;
                gtkAllocation.y = n2;
            } else {
                gtkAllocation.x = OS.GTK_WIDGET_X(n9);
                gtkAllocation.y = OS.GTK_WIDGET_Y(n9);
            }
            if (bl2) {
                gtkAllocation.width = n3;
                gtkAllocation.height = n4;
            } else {
                gtkAllocation.width = OS.GTK_WIDGET_WIDTH(n9);
                gtkAllocation.height = OS.GTK_WIDGET_HEIGHT(n9);
            }
            OS.gtk_widget_size_allocate(n9, gtkAllocation);
        }
        if (n7 == 0) {
            this.state = n3 == 0 ? this.state | 0x200 : this.state & 0xFFFFFDFF;
            int n15 = this.state = n4 == 0 ? this.state | 0x400 : this.state & 0xFFFFFBFF;
            if ((this.state & 0x600) != 0) {
                if (this.enableWindow != 0) {
                    OS.gdk_window_hide(this.enableWindow);
                }
                OS.gtk_widget_hide(n9);
            } else if ((this.state & 0x800) == 0) {
                if (this.enableWindow != 0) {
                    OS.gdk_window_show_unraised(this.enableWindow);
                }
                OS.gtk_widget_show(n9);
            }
            if ((this.style & 0x8000000) != 0) {
                this.moveChildren(n6);
            }
        }
        int n16 = 0;
        if (bl && n8 == 0) {
            Control control = this.findBackgroundControl();
            if (control != null && control.backgroundImage != null && this.isVisible()) {
                this.redrawWidget(0, 0, 0, 0, true, true, true);
            }
            if (bl3) {
                this.sendEvent(10);
            }
            n16 |= 0x80;
        }
        if (bl2 && n7 == 0) {
            this.sendEvent(11);
            n16 |= 0x100;
        }
        return n16;
    }

    public Point getLocation() {
        this.checkWidget();
        int n = this.topHandle();
        int n2 = OS.GTK_WIDGET_X(n);
        int n3 = OS.GTK_WIDGET_Y(n);
        if ((this.parent.style & 0x8000000) != 0) {
            int n4 = (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(n);
            n2 = this.parent.getClientWidth() - n4 - n2;
        }
        return new Point(n2, n3);
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(point.x, point.y, 0, 0, true, false);
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.setBounds(n, n2, 0, 0, true, false);
    }

    public Point getSize() {
        this.checkWidget();
        int n = this.topHandle();
        int n2 = (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(n);
        int n3 = (this.state & 0x400) != 0 ? 0 : OS.GTK_WIDGET_HEIGHT(n);
        return new Point(n2, n3);
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(0, 0, Math.max(0, point.x), Math.max(0, point.y), false, true);
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        int n = OS.GTK_WIDGET_WINDOW(this.topHandle());
        int n2 = region == null ? 0 : region.handle;
        OS.gdk_window_shape_combine_region(n, n2, 0, 0);
        this.region = region;
    }

    void setRelations() {
        Widget widget;
        int n;
        int n2 = this.parent.parentingHandle();
        int n3 = OS.gtk_container_get_children(n2);
        if (n3 == 0) {
            return;
        }
        int n4 = OS.g_list_length(n3);
        if (n4 > 1 && (n = OS.g_list_nth_data(n3, n4 - 2)) != 0 && (widget = this.display.getWidget(n)) != null && widget != this && widget instanceof Control) {
            Control control = (Control)widget;
            control.addRelation(this);
        }
        OS.g_list_free(n3);
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, n), Math.max(0, n2), false, true);
    }

    boolean isActive() {
        return this.getShell().getModalShell() == null && this.display.getModalDialog() == null;
    }

    boolean isDescribedByLabel() {
        return true;
    }

    boolean isFocusHandle(int n) {
        return n == this.focusHandle();
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, true, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, false, true);
    }

    void moveChildren(int n) {
    }

    public void pack() {
        this.pack(true);
    }

    public void pack(boolean bl) {
        this.setSize(this.computeSize(-1, -1, bl));
    }

    public void setLayoutData(Object object) {
        this.checkWidget();
        this.layoutData = object;
    }

    public Point toControl(int n, int n2) {
        this.checkWidget();
        int n3 = this.eventWindow();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(n3, nArray, nArray2);
        n -= nArray[0];
        n2 -= nArray2[0];
        if ((this.style & 0x8000000) != 0) {
            n = this.getClientWidth() - n;
        }
        return new Point(n, n2);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int n, int n2) {
        this.checkWidget();
        int n3 = this.eventWindow();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(n3, nArray, nArray2);
        if ((this.style & 0x8000000) != 0) {
            n = this.getClientWidth() - n;
        }
        return new Point(n += nArray[0], n2 += nArray2[0]);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(dragDetectListener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(focusListener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuDetectListener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseListener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseMoveListener);
        this.addListener(5, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseTrackListener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseWheelListener);
        this.addListener(37, typedListener);
    }

    public void addPaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(paintListener);
        this.addListener(9, typedListener);
    }

    void addRelation(Control control) {
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(traverseListener);
        this.addListener(31, typedListener);
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, dragDetectListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, focusListener);
        this.eventTable.unhook(16, focusListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, menuDetectListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, mouseListener);
        this.eventTable.unhook(4, mouseListener);
        this.eventTable.unhook(8, mouseListener);
    }

    public void removeMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, mouseMoveListener);
    }

    public void removeMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, mouseTrackListener);
        this.eventTable.unhook(7, mouseTrackListener);
        this.eventTable.unhook(32, mouseTrackListener);
    }

    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, mouseWheelListener);
    }

    public void removePaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, paintListener);
    }

    void removeRelation() {
        if (!this.isDescribedByLabel()) {
            return;
        }
        int n = OS.gtk_widget_get_accessible(this.handle);
        if (n == 0) {
            return;
        }
        int n2 = ATK.atk_object_ref_relation_set(n);
        int n3 = ATK.atk_relation_set_get_n_relations(n2);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = ATK.atk_relation_set_get_relation(n2, 0);
            ATK.atk_relation_set_remove(n2, n5);
            ++n4;
        }
        OS.g_object_unref(n2);
    }

    public void removeTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, traverseListener);
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent mouseEvent) {
        this.checkWidget();
        if (mouseEvent == null) {
            this.error(4);
        }
        return this.dragDetect(mouseEvent.button, mouseEvent.count, mouseEvent.stateMask, mouseEvent.x, mouseEvent.y);
    }

    boolean dragDetect(int n, int n2, int n3, int n4, int n5) {
        if (n != 1 || n2 != 1) {
            return false;
        }
        if (!this.dragDetect(n4, n5, false, null)) {
            return false;
        }
        return this.sendDragEvent(n, n3, n4, n5, true);
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl2) {
            int n3 = 0;
            long l = System.currentTimeMillis() + 500L;
            while (System.currentTimeMillis() < l) {
                n3 = OS.gdk_event_get();
                if (n3 != 0) break;
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
            if (n3 == 0) {
                return false;
            }
            switch (OS.GDK_EVENT_TYPE(n3)) {
                case 3: {
                    GdkEvent gdkEvent = new GdkEventMotion();
                    OS.memmove(gdkEvent, n3, GdkEventMotion.sizeof);
                    if ((gdkEvent.state & 0x100) != 0) {
                        if (OS.gtk_drag_check_threshold(this.handle, n, n2, (int)gdkEvent.x, (int)gdkEvent.y)) {
                            bl3 = true;
                            bl2 = true;
                        }
                    } else {
                        bl2 = true;
                    }
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    OS.gdk_window_get_pointer(gdkEvent.window, nArray, nArray2, null);
                    break;
                }
                case 8: 
                case 9: {
                    GdkEvent gdkEvent = new GdkEventKey();
                    OS.memmove((GdkEventKey)gdkEvent, n3, GdkEventKey.sizeof);
                    if (((GdkEventKey)gdkEvent).keyval != 65307) break;
                    bl2 = true;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    OS.gdk_event_put(n3);
                    bl2 = true;
                    break;
                }
                default: {
                    OS.gtk_main_do_event(n3);
                }
            }
            OS.gdk_event_free(n3);
        }
        return bl3;
    }

    boolean filterKey(int n, int n2) {
        int n3 = this.imHandle();
        if (n3 != 0) {
            return OS.gtk_im_context_filter_keypress(n3, n2);
        }
        return false;
    }

    Control findBackgroundControl() {
        if ((this.state & 0x2000) != 0 || this.backgroundImage != null) {
            return this;
        }
        return (this.state & 0x8000) != 0 ? this.parent.findBackgroundControl() : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        shell2.fixShell(shell, this);
        decorations2.fixDecorations(decorations, this, menuArray);
    }

    int fixedMapProc(int n) {
        OS.GTK_WIDGET_SET_FLAGS(n, 128);
        int n2 = OS.gtk_container_get_children(n);
        if (n2 != 0) {
            int n3 = n2;
            while (n3 != 0) {
                int n4 = OS.g_list_data(n3);
                if (OS.GTK_WIDGET_VISIBLE(n4) && OS.gtk_widget_get_child_visible(n4) && !OS.GTK_WIDGET_MAPPED(n4)) {
                    OS.gtk_widget_map(n4);
                }
                n3 = OS.g_list_next(n3);
            }
            OS.g_list_free(n2);
        }
        if ((OS.GTK_WIDGET_FLAGS(n) & 0x20) == 0) {
            OS.gdk_window_show_unraised(OS.GTK_WIDGET_WINDOW(n));
        }
        return 0;
    }

    void fixModal(int n, int n2) {
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Shell shell = this.getShell();
        shell.setSavedFocus(this);
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        shell.bringToTop(false);
        return this.forceFocus(this.focusHandle());
    }

    boolean forceFocus(int n) {
        if (OS.GTK_WIDGET_HAS_FOCUS(n)) {
            return true;
        }
        OS.gtk_widget_realize(n);
        OS.gtk_widget_grab_focus(n);
        Shell shell = this.getShell();
        int n2 = shell.shellHandle;
        int n3 = OS.gtk_window_get_focus(n2);
        while (n3 != 0) {
            if (n3 == n) {
                this.display.ignoreFocus = false;
                return true;
            }
            Widget widget = this.display.getWidget(n3);
            if (widget != null && widget instanceof Control) {
                return widget == this;
            }
            n3 = OS.gtk_widget_get_parent(n3);
        }
        return false;
    }

    public Color getBackground() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return Color.gtk_new(this.display, control.getBackgroundColor());
    }

    GdkColor getBackgroundColor() {
        return this.getBgColor();
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    GdkColor getBgColor() {
        int n = this.fontHandle();
        OS.gtk_widget_realize(n);
        GdkColor gdkColor = new GdkColor();
        OS.gtk_style_get_bg(OS.gtk_widget_get_style(n), 0, gdkColor);
        return gdkColor;
    }

    GdkColor getBaseColor() {
        int n = this.fontHandle();
        OS.gtk_widget_realize(n);
        GdkColor gdkColor = new GdkColor();
        OS.gtk_style_get_base(OS.gtk_widget_get_style(n), 0, gdkColor);
        return gdkColor;
    }

    public int getBorderWidth() {
        this.checkWidget();
        return 0;
    }

    int getClientWidth() {
        return 0;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public Object getData(String string) {
        if (string.equals(IS_ACTIVE)) {
            return new Boolean(this.isActive());
        }
        return super.getData(string);
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x800000) != 0;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : this.defaultFont();
    }

    int getFontDescription() {
        int n = this.fontHandle();
        OS.gtk_widget_realize(n);
        return OS.gtk_style_get_font_desc(OS.gtk_widget_get_style(n));
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.gtk_new(this.display, this.getForegroundColor());
    }

    GdkColor getForegroundColor() {
        return this.getFgColor();
    }

    GdkColor getFgColor() {
        int n = this.fontHandle();
        OS.gtk_widget_realize(n);
        GdkColor gdkColor = new GdkColor();
        OS.gtk_style_get_fg(OS.gtk_widget_get_style(n), 0, gdkColor);
        return gdkColor;
    }

    Point getIMCaretPos() {
        return new Point(0, 0);
    }

    GdkColor getTextColor() {
        int n = this.fontHandle();
        OS.gtk_widget_realize(n);
        GdkColor gdkColor = new GdkColor();
        OS.gtk_style_get_text(OS.gtk_widget_get_style(n), 0, gdkColor);
        return gdkColor;
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        Monitor monitor = null;
        int n = OS.gdk_screen_get_default();
        if (n != 0) {
            int n2 = OS.gdk_screen_get_monitor_at_window(n, this.paintWindow());
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.gdk_screen_get_monitor_geometry(n, n2, gdkRectangle);
            monitor = new Monitor();
            monitor.handle = n2;
            monitor.x = gdkRectangle.x;
            monitor.y = gdkRectangle.y;
            monitor.width = gdkRectangle.width;
            monitor.height = gdkRectangle.height;
            Rectangle rectangle = null;
            if (n2 == 0) {
                rectangle = this.display.getWorkArea();
            }
            if (rectangle != null) {
                monitor.clientX = rectangle.x;
                monitor.clientY = rectangle.y;
                monitor.clientWidth = rectangle.width;
                monitor.clientHeight = rectangle.height;
            } else {
                monitor.clientX = monitor.x;
                monitor.clientY = monitor.y;
                monitor.clientWidth = monitor.width;
                monitor.clientHeight = monitor.height;
            }
        } else {
            monitor = this.display.getPrimaryMonitor();
        }
        return monitor;
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int n = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++n;
            control = control.parent;
        }
        control = this;
        Control[] controlArray = new Control[n];
        while (control != shell) {
            controlArray[--n] = control;
            control = control.parent;
        }
        return controlArray;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this._getShell();
    }

    Shell _getShell() {
        return this.parent._getShell();
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x800) == 0;
    }

    int gtk_button_press_event(int n, int n2) {
        return this.gtk_button_press_event(n, n2, true);
    }

    int gtk_button_press_event(int n, int n2, boolean bl) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        if (gdkEventButton.type == 6) {
            return 0;
        }
        Shell shell = this._getShell();
        if ((shell.style & 0x4000) != 0 && ((shell.style & 0x80000) == 0 || (this.style & 0x80000) == 0)) {
            shell.forceActive();
        }
        int n3 = 0;
        if (gdkEventButton.type == 4) {
            int n4;
            this.display.clickCount = 1;
            int n5 = OS.gdk_event_peek();
            if (n5 != 0) {
                n4 = OS.GDK_EVENT_TYPE(n5);
                if (n4 == 5) {
                    this.display.clickCount = 2;
                }
                if (n4 == 6) {
                    this.display.clickCount = 3;
                }
                OS.gdk_event_free(n5);
            }
            n4 = 0;
            if ((this.state & 0x800000) != 0 && this.hooks(29) && gdkEventButton.button == 1) {
                boolean[] blArray = new boolean[1];
                if (this.dragDetect((int)gdkEventButton.x, (int)gdkEventButton.y, true, blArray)) {
                    n4 = 1;
                    if (blArray[0]) {
                        n3 = 1;
                    }
                }
                if (this.isDisposed()) {
                    return 1;
                }
            }
            if (bl && !this.sendMouseEvent(3, gdkEventButton.button, this.display.clickCount, 0, false, gdkEventButton.time, gdkEventButton.x_root, gdkEventButton.y_root, false, gdkEventButton.state)) {
                n3 = 1;
            }
            if (this.isDisposed()) {
                return 1;
            }
            if (n4 != 0) {
                this.sendDragEvent(gdkEventButton.button, gdkEventButton.state, (int)gdkEventButton.x, (int)gdkEventButton.y, false);
                if (this.isDisposed()) {
                    return 1;
                }
            }
            if ((this.state & 0x20) != 0 && gdkEventButton.button == 3 && this.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root)) {
                n3 = 1;
            }
        } else {
            this.display.clickCount = 2;
            int n6 = n3 = this.sendMouseEvent(8, gdkEventButton.button, this.display.clickCount, 0, false, gdkEventButton.time, gdkEventButton.x_root, gdkEventButton.y_root, false, gdkEventButton.state) ? 0 : 1;
            if (this.isDisposed()) {
                return 1;
            }
        }
        if (!shell.isDisposed()) {
            shell.setActiveControl(this);
        }
        return n3;
    }

    int gtk_button_release_event(int n, int n2) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        int n3 = gdkEventButton.button;
        switch (n3) {
            case -6: {
                n3 = 4;
                break;
            }
            case -7: {
                n3 = 5;
            }
        }
        return this.sendMouseEvent(4, n3, this.display.clickCount, 0, false, gdkEventButton.time, gdkEventButton.x_root, gdkEventButton.y_root, false, gdkEventButton.state) ? 0 : 1;
    }

    int gtk_commit(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = OS.strlen(n2);
        if (n3 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, n3);
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        this.sendIMKeyEvent(1, null, cArray);
        return 0;
    }

    int gtk_enter_notify_event(int n, int n2) {
        Object object;
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            object = null;
            if (this.toolTipText != null && this.toolTipText.length() != 0) {
                char[] cArray = this.fixMnemonic(this.toolTipText, false);
                object = Converter.wcsToMbcs(null, cArray, true);
            }
            int n3 = this.getShell().handle;
            OS.gtk_widget_set_tooltip_text(n3, object);
        }
        if (this.display.currentControl == this) {
            return 0;
        }
        object = new GdkEventCrossing();
        OS.memmove((GdkEventCrossing)object, n2, GdkEventCrossing.sizeof);
        if (object.subwindow != 0 && this.checkSubwindow()) {
            return 0;
        }
        if (object.mode != 0 && object.mode != 2) {
            return 0;
        }
        if ((object.state & 0x700) != 0) {
            return 0;
        }
        if (this.display.currentControl != null && !this.display.currentControl.isDisposed()) {
            this.display.removeMouseHoverTimeout(this.display.currentControl.handle);
            this.display.currentControl.sendMouseEvent(7, 0, object.time, object.x_root, object.y_root, false, object.state);
        }
        if (!this.isDisposed()) {
            this.display.currentControl = this;
            return this.sendMouseEvent(6, 0, object.time, object.x_root, object.y_root, false, object.state) ? 0 : 1;
        }
        return 0;
    }

    boolean checkSubwindow() {
        return false;
    }

    int gtk_event_after(int n, int n2) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, n2, GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 4: {
                if (n != this.eventHandle() || (this.state & 0x20) != 0) break;
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
                if (gdkEventButton.button != 3) break;
                this.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
                break;
            }
            case 12: {
                if (!this.isFocusHandle(n)) break;
                GdkEventFocus gdkEventFocus = new GdkEventFocus();
                OS.memmove(gdkEventFocus, n2, GdkEventFocus.sizeof);
                Display display = this.display;
                if (gdkEventFocus.in != 0) {
                    if (display.ignoreFocus) {
                        display.ignoreFocus = false;
                        break;
                    }
                } else {
                    display.ignoreFocus = false;
                    int n3 = OS.gtk_grab_get_current();
                    if (n3 != 0 && OS.G_OBJECT_TYPE(n3) == OS.GTK_TYPE_MENU()) {
                        display.ignoreFocus = true;
                        break;
                    }
                }
                this.sendFocusEvent(gdkEventFocus.in != 0 ? 15 : 16);
            }
        }
        return 0;
    }

    int gtk_expose_event(int n, int n2) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return 0;
        }
        GdkEventExpose gdkEventExpose = new GdkEventExpose();
        OS.memmove(gdkEventExpose, n2, GdkEventExpose.sizeof);
        Event event = new Event();
        event.count = gdkEventExpose.count;
        event.x = gdkEventExpose.area_x;
        event.y = gdkEventExpose.area_y;
        event.width = gdkEventExpose.area_width;
        event.height = gdkEventExpose.area_height;
        if ((this.style & 0x8000000) != 0) {
            event.x = this.getClientWidth() - event.width - event.x;
        }
        GCData gCData = new GCData();
        gCData.damageRgn = gdkEventExpose.region;
        GC gC = event.gc = GC.gtk_new(this, gCData);
        OS.gdk_gc_set_clip_region(gC.handle, gdkEventExpose.region);
        this.sendEvent(9, event);
        gC.dispose();
        event.gc = null;
        return 0;
    }

    int gtk_focus(int n, int n2) {
        return 1;
    }

    int gtk_focus_in_event(int n, int n2) {
        if (this.handle != 0) {
            int n3;
            Control control = this.display.imControl;
            if (control != this && control != null && !control.isDisposed() && (n3 = control.imHandle()) != 0) {
                OS.gtk_im_context_reset(n3);
            }
            if ((this.hooks(1) || this.hooks(2)) && (n3 = this.imHandle()) != 0) {
                OS.gtk_im_context_focus_in(n3);
            }
        }
        return 0;
    }

    int gtk_focus_out_event(int n, int n2) {
        int n3;
        if (this.handle != 0 && (this.hooks(1) || this.hooks(2)) && (n3 = this.imHandle()) != 0) {
            OS.gtk_im_context_focus_out(n3);
        }
        return 0;
    }

    int gtk_key_press_event(int n, int n2) {
        if (!this.hasFocus()) {
            return 0;
        }
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
        if (this.translateMnemonic(gdkEventKey.keyval, gdkEventKey)) {
            return 1;
        }
        if (this.isDisposed()) {
            return 0;
        }
        if (this.filterKey(gdkEventKey.keyval, n2)) {
            return 1;
        }
        if (this.isDisposed()) {
            return 0;
        }
        if (this.translateTraversal(gdkEventKey)) {
            return 1;
        }
        if (this.isDisposed()) {
            return 0;
        }
        return super.gtk_key_press_event(n, n2);
    }

    int gtk_key_release_event(int n, int n2) {
        if (!this.hasFocus()) {
            return 0;
        }
        int n3 = this.imHandle();
        if (n3 != 0 && OS.gtk_im_context_filter_keypress(n3, n2)) {
            return 1;
        }
        return super.gtk_key_release_event(n, n2);
    }

    int gtk_leave_notify_event(int n, int n2) {
        if (this.display.currentControl != this) {
            return 0;
        }
        this.display.removeMouseHoverTimeout(this.handle);
        int n3 = 0;
        if (this.sendLeaveNotify() || this.display.getCursorControl() == null) {
            GdkEventCrossing gdkEventCrossing = new GdkEventCrossing();
            OS.memmove(gdkEventCrossing, n2, GdkEventCrossing.sizeof);
            if (gdkEventCrossing.mode != 0 && gdkEventCrossing.mode != 2) {
                return 0;
            }
            if ((gdkEventCrossing.state & 0x700) != 0) {
                return 0;
            }
            n3 = this.sendMouseEvent(7, 0, gdkEventCrossing.time, gdkEventCrossing.x_root, gdkEventCrossing.y_root, false, gdkEventCrossing.state) ? 0 : 1;
            this.display.currentControl = null;
        }
        return n3;
    }

    int gtk_mnemonic_activate(int n, int n2) {
        int n3 = 0;
        int n4 = OS.gtk_get_current_event();
        if (n4 != 0) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n4, GdkEventKey.sizeof);
            if (gdkEventKey.type == 8) {
                int n5;
                Control control = this.display.getFocusControl();
                int n6 = n5 = control != null ? control.focusHandle() : 0;
                if (n5 != 0) {
                    this.display.mnemonicControl = this;
                    OS.gtk_widget_event(n5, n4);
                    this.display.mnemonicControl = null;
                }
                n3 = 1;
            }
            OS.gdk_event_free(n4);
        }
        return n3;
    }

    int gtk_motion_notify_event(int n, int n2) {
        GdkEventMotion gdkEventMotion = new GdkEventMotion();
        OS.memmove(gdkEventMotion, n2, GdkEventMotion.sizeof);
        if (this == this.display.currentControl && (this.hooks(32) || this.filters(32))) {
            this.display.addMouseHoverTimeout(this.handle);
        }
        double d = gdkEventMotion.x_root;
        double d2 = gdkEventMotion.y_root;
        int n3 = gdkEventMotion.state;
        if (gdkEventMotion.is_hint != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            int n4 = this.eventWindow();
            OS.gdk_window_get_pointer(n4, nArray, nArray2, nArray3);
            d = nArray[0];
            d2 = nArray2[0];
            n3 = nArray3[0];
        }
        int n5 = this.sendMouseEvent(5, 0, gdkEventMotion.time, d, d2, gdkEventMotion.is_hint != 0, n3) ? 0 : 1;
        return n5;
    }

    int gtk_popup_menu(int n) {
        if (!this.hasFocus()) {
            return 0;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_pointer(0, nArray, nArray2, null);
        return this.showMenu(nArray[0], nArray2[0]) ? 1 : 0;
    }

    int gtk_preedit_changed(int n) {
        this.display.showIMWindow(this);
        return 0;
    }

    int gtk_realize(int n) {
        int n2;
        int n3 = this.imHandle();
        if (n3 != 0) {
            n2 = OS.GTK_WIDGET_WINDOW(this.paintHandle());
            OS.gtk_im_context_set_client_window(n3, n2);
        }
        if (this.backgroundImage != null && (n2 = OS.GTK_WIDGET_WINDOW(this.paintHandle())) != 0) {
            OS.gdk_window_set_back_pixmap(n2, this.backgroundImage.pixmap, false);
        }
        return 0;
    }

    int gtk_scroll_event(int n, int n2) {
        GdkEventScroll gdkEventScroll = new GdkEventScroll();
        OS.memmove(gdkEventScroll, n2, GdkEventScroll.sizeof);
        switch (gdkEventScroll.direction) {
            case 0: {
                return this.sendMouseEvent(37, 0, 3, 1, true, gdkEventScroll.time, gdkEventScroll.x_root, gdkEventScroll.y_root, false, gdkEventScroll.state) ? 0 : 1;
            }
            case 1: {
                return this.sendMouseEvent(37, 0, -3, 1, true, gdkEventScroll.time, gdkEventScroll.x_root, gdkEventScroll.y_root, false, gdkEventScroll.state) ? 0 : 1;
            }
            case 2: {
                return this.sendMouseEvent(3, 4, gdkEventScroll.time, gdkEventScroll.x_root, gdkEventScroll.y_root, false, gdkEventScroll.state) ? 0 : 1;
            }
            case 3: {
                return this.sendMouseEvent(3, 5, gdkEventScroll.time, gdkEventScroll.x_root, gdkEventScroll.y_root, false, gdkEventScroll.state) ? 0 : 1;
            }
        }
        return 0;
    }

    int gtk_show_help(int n, int n2) {
        if (!this.hasFocus()) {
            return 0;
        }
        return this.sendHelpEvent(n2) ? 1 : 0;
    }

    int gtk_style_set(int n, int n2) {
        if (this.backgroundImage != null) {
            this.setBackgroundPixmap(this.backgroundImage.pixmap);
        }
        return 0;
    }

    int gtk_unrealize(int n) {
        int n2 = this.imHandle();
        if (n2 != 0) {
            OS.gtk_im_context_set_client_window(n2, 0);
        }
        return 0;
    }

    int gtk_visibility_notify_event(int n, int n2) {
        GdkEventVisibility gdkEventVisibility = new GdkEventVisibility();
        OS.memmove(gdkEventVisibility, n2, GdkEventVisibility.sizeof);
        int n3 = this.paintWindow();
        int n4 = gdkEventVisibility.window;
        if (n4 == n3) {
            if (gdkEventVisibility.state == 2) {
                this.state |= 0x40;
            } else {
                if ((this.state & 0x40) != 0) {
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    OS.gdk_drawable_get_size(n4, nArray, nArray2);
                    GdkRectangle gdkRectangle = new GdkRectangle();
                    gdkRectangle.width = nArray[0];
                    gdkRectangle.height = nArray2[0];
                    OS.gdk_window_invalidate_rect(n4, gdkRectangle, false);
                }
                this.state &= 0xFFFFFFBF;
            }
        }
        return 0;
    }

    void gtk_widget_size_request(int n, GtkRequisition gtkRequisition) {
        OS.gtk_widget_size_request(n, gtkRequisition);
    }

    public int internal_new_GC(GCData gCData) {
        int n;
        this.checkWidget();
        int n2 = this.paintWindow();
        if (n2 == 0) {
            SWT.error(2);
        }
        if ((n = OS.gdk_gc_new(n2)) == 0) {
            this.error(2);
        }
        if (gCData != null) {
            int n3 = 0x6000000;
            if ((gCData.style & n3) == 0) {
                gCData.style |= this.style & (n3 | 0x8000000);
            } else if ((gCData.style & 0x4000000) != 0) {
                gCData.style |= 0x8000000;
            }
            gCData.drawable = n2;
            gCData.device = this.display;
            gCData.foreground = this.getForegroundColor();
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            gCData.background = control.getBackgroundColor();
            gCData.font = this.font != null ? this.font : this.defaultFont();
        }
        return n;
    }

    int imHandle() {
        return 0;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        this.checkWidget();
        OS.g_object_unref(n);
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point point = control.getSize();
            if (point.x == 0 || point.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) {
                    return true;
                }
                ++n;
            }
        }
        if (((n = this.traversalCode(0, null)) & 0x60) != 0) {
            return false;
        }
        return (n & 0x18) != 0;
    }

    boolean isTabItem() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) {
                    return false;
                }
                ++n;
            }
        }
        return ((n = this.traversalCode(0, null)) & 0x60) != 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        Control control = this.display.focusControl;
        if (control != null && !control.isDisposed()) {
            return this == control;
        }
        return this.hasFocus();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char c) {
        return false;
    }

    boolean mnemonicMatch(char c) {
        return false;
    }

    void register() {
        int n;
        super.register();
        if (this.fixedHandle != 0) {
            this.display.addWidget(this.fixedHandle, this);
        }
        if ((n = this.imHandle()) != 0) {
            this.display.addWidget(n, this);
        }
    }

    public void redraw() {
        this.checkWidget();
        this.redraw(false);
    }

    void redraw(boolean bl) {
        if (!OS.GTK_WIDGET_VISIBLE(this.topHandle())) {
            return;
        }
        this.redrawWidget(0, 0, 0, 0, true, bl, false);
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        this.checkWidget();
        if (!OS.GTK_WIDGET_VISIBLE(this.topHandle())) {
            return;
        }
        if ((this.style & 0x8000000) != 0) {
            n = this.getClientWidth() - n3 - n;
        }
        this.redrawWidget(n, n2, n3, n4, false, bl, false);
    }

    void redrawChildren() {
    }

    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        if ((OS.GTK_WIDGET_FLAGS(this.handle) & 0x40) == 0) {
            return;
        }
        int n5 = this.paintWindow();
        GdkRectangle gdkRectangle = new GdkRectangle();
        if (bl) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gdk_drawable_get_size(n5, nArray, nArray2);
            gdkRectangle.width = nArray[0];
            gdkRectangle.height = nArray2[0];
        } else {
            gdkRectangle.x = n;
            gdkRectangle.y = n2;
            gdkRectangle.width = n3;
            gdkRectangle.height = n4;
        }
        OS.gdk_window_invalidate_rect(n5, gdkRectangle, bl2);
    }

    void release(boolean bl) {
        Control control = null;
        Control control2 = null;
        if (bl && this.parent != null) {
            Control[] controlArray = this.parent._getChildren();
            int n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) break;
                ++n;
            }
            if (n > 0 && n + 1 < controlArray.length) {
                control = controlArray[n + 1];
                control2 = controlArray[n - 1];
            }
        }
        super.release(bl);
        if (bl && control2 != null) {
            control2.addRelation(control);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.fixedHandle = 0;
        this.parent = null;
    }

    void releaseParent() {
        this.parent.removeControl(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.display.currentControl == this) {
            this.display.currentControl = null;
        }
        this.display.removeMouseHoverTimeout(this.handle);
        int n = this.imHandle();
        if (n != 0) {
            OS.gtk_im_context_reset(n);
            OS.gtk_im_context_set_client_window(n, 0);
        }
        if (this.enableWindow != 0) {
            OS.gdk_window_set_user_data(this.enableWindow, 0);
            OS.gdk_window_destroy(this.enableWindow);
            this.enableWindow = 0;
        }
        this.redrawWindow = 0;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.cursor = null;
        this.toolTipText = null;
        this.layoutData = null;
        this.accessible = null;
        this.region = null;
    }

    boolean sendDragEvent(int n, int n2, int n3, int n4, boolean bl) {
        Event event = new Event();
        event.button = n;
        event.x = n3;
        event.y = n4;
        if ((this.style & 0x8000000) != 0) {
            event.x = this.getClientWidth() - event.x;
        }
        if (bl) {
            event.stateMask = n2;
        } else {
            this.setInputState(event, n2);
        }
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendFocusEvent(int n) {
        Shell shell = this._getShell();
        Display display = this.display;
        display.focusControl = this;
        display.focusEvent = n;
        this.sendEvent(n);
        display.focusControl = null;
        display.focusEvent = 0;
        if (!shell.isDisposed()) {
            switch (n) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.activeShell) break;
                    shell.setActiveControl(null);
                }
            }
        }
    }

    boolean sendHelpEvent(int n) {
        Control control = this;
        while (control != null) {
            if (control.hooks(28)) {
                control.postEvent(28);
                return true;
            }
            control = control.parent;
        }
        return false;
    }

    boolean sendLeaveNotify() {
        return false;
    }

    boolean sendMouseEvent(int n, int n2, int n3, double d, double d2, boolean bl, int n4) {
        return this.sendMouseEvent(n, n2, 0, 0, false, n3, d, d2, bl, n4);
    }

    boolean sendMouseEvent(int n, int n2, int n3, int n4, boolean bl, int n5, double d, double d2, boolean bl2, int n6) {
        if (!this.hooks(n) && !this.filters(n)) {
            return true;
        }
        Event event = new Event();
        event.time = n5;
        event.button = n2;
        event.detail = n4;
        event.count = n3;
        if (bl2) {
            event.x = (int)d;
            event.y = (int)d2;
        } else {
            int n7 = this.eventWindow();
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gdk_window_get_origin(n7, nArray, nArray2);
            event.x = (int)d - nArray[0];
            event.y = (int)d2 - nArray2[0];
        }
        if ((this.style & 0x8000000) != 0) {
            event.x = this.getClientWidth() - event.x;
        }
        this.setInputState(event, n6);
        if (bl) {
            this.sendEvent(n, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(n, event);
        }
        return event.doit;
    }

    void setBackground() {
        if ((this.state & 0x8000) != 0 && (this.state & 0x2000) == 0 && this.backgroundImage == null) {
            this.setParentBackground();
        } else {
            this.setWidgetBackground();
        }
        this.redrawWidget(0, 0, 0, 0, true, false, false);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if ((this.state & 0x2000) == 0 && color == null) {
            return;
        }
        GdkColor gdkColor = null;
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            gdkColor = color.handle;
        }
        boolean bl = false;
        if (gdkColor == null) {
            int n = OS.gtk_widget_get_modifier_style(this.handle);
            bl = (OS.gtk_rc_style_get_color_flags(n, 0) & 2) != 0;
        } else {
            GdkColor gdkColor2 = this.getBackgroundColor();
            boolean bl2 = bl = gdkColor2.pixel != gdkColor.pixel;
        }
        if (bl) {
            this.state = color == null ? (this.state &= 0xFFFFDFFF) : (this.state |= 0x2000);
            this.setBackgroundColor(gdkColor);
            this.redrawChildren();
        }
    }

    void setBackgroundColor(int n, GdkColor gdkColor) {
        int n2 = 0;
        int n3 = OS.gtk_widget_get_modifier_style(n);
        int n4 = OS.gtk_rc_style_get_bg_pixmap_name(n3, n2);
        if (n4 != 0) {
            OS.g_free(n4);
        }
        String string = gdkColor == null ? "<parent>" : "<none>";
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        n4 = OS.g_malloc(byArray.length);
        OS.memmove(n4, byArray, byArray.length);
        OS.gtk_rc_style_set_bg_pixmap_name(n3, n2, n4);
        OS.gtk_rc_style_set_bg(n3, n2, gdkColor);
        int n5 = OS.gtk_rc_style_get_color_flags(n3, n2);
        n5 = gdkColor == null ? n5 & 0xFFFFFFFD : n5 | 2;
        OS.gtk_rc_style_set_color_flags(n3, n2, n5);
        this.modifyStyle(n, n3);
    }

    void setBackgroundColor(GdkColor gdkColor) {
        this.setBackgroundColor(this.handle, gdkColor);
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        if (image == this.backgroundImage) {
            return;
        }
        this.backgroundImage = image;
        if (this.backgroundImage != null) {
            this.setBackgroundPixmap(this.backgroundImage.pixmap);
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        } else {
            this.setWidgetBackground();
        }
        this.redrawChildren();
    }

    void setBackgroundPixmap(int n) {
        int n2 = OS.GTK_WIDGET_WINDOW(this.paintHandle());
        if (n2 != 0) {
            OS.gdk_window_set_back_pixmap(n2, this.backgroundImage.pixmap, false);
        }
    }

    public void setCapture(boolean bl) {
        this.checkWidget();
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        this.setCursor(cursor != null ? cursor.handle : 0);
    }

    void setCursor(int n) {
        int n2 = this.eventWindow();
        if (n2 != 0) {
            OS.gdk_window_set_cursor(n2, n);
            if (!OS.GDK_WINDOWING_X11()) {
                OS.gdk_flush();
            } else {
                int n3 = OS.GDK_DISPLAY();
                OS.XFlush(n3);
            }
        }
    }

    public void setDragDetect(boolean bl) {
        this.checkWidget();
        this.state = bl ? (this.state |= 0x800000) : (this.state &= 0xFF7FFFFF);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 0x10) == 0 == bl) {
            return;
        }
        Control control = null;
        boolean bl2 = false;
        if (!bl && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.state = bl ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        this.enableWidget(bl);
        if (this.isDisposed()) {
            return;
        }
        if (bl) {
            if (this.enableWindow != 0) {
                OS.gdk_window_set_user_data(this.enableWindow, 0);
                OS.gdk_window_destroy(this.enableWindow);
                this.enableWindow = 0;
            }
        } else {
            OS.gtk_widget_realize(this.handle);
            int n = this.parent.eventHandle();
            int n2 = this.parent.eventWindow();
            int n3 = this.topHandle();
            GdkWindowAttr gdkWindowAttr = new GdkWindowAttr();
            gdkWindowAttr.x = OS.GTK_WIDGET_X(n3);
            gdkWindowAttr.y = OS.GTK_WIDGET_Y(n3);
            gdkWindowAttr.width = (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(n3);
            gdkWindowAttr.height = (this.state & 0x400) != 0 ? 0 : OS.GTK_WIDGET_HEIGHT(n3);
            gdkWindowAttr.event_mask = -32769;
            gdkWindowAttr.wclass = 1;
            gdkWindowAttr.window_type = 2;
            this.enableWindow = OS.gdk_window_new(n2, gdkWindowAttr, 12);
            if (this.enableWindow != 0) {
                OS.gdk_window_set_user_data(this.enableWindow, n);
                if (!OS.GDK_WINDOWING_X11()) {
                    OS.gdk_window_raise(this.enableWindow);
                } else {
                    int n4 = OS.GTK_WIDGET_WINDOW(n3);
                    int n5 = OS.gdk_x11_drawable_get_xdisplay(n4);
                    int n6 = OS.gdk_x11_drawable_get_xid(this.enableWindow);
                    int n7 = OS.XDefaultScreen(n5);
                    int n8 = 96;
                    XWindowChanges xWindowChanges = new XWindowChanges();
                    xWindowChanges.sibling = OS.gdk_x11_drawable_get_xid(n4);
                    xWindowChanges.stack_mode = 0;
                    OS.XReconfigureWMWindow(n5, n6, n7, n8, xWindowChanges);
                }
                if (OS.GTK_WIDGET_VISIBLE(n3)) {
                    OS.gdk_window_show_unraised(this.enableWindow);
                }
            }
        }
        if (bl2) {
            this.fixFocus(control);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        int n;
        this.checkWidget();
        if ((this.state & 0x4000) == 0 && font == null) {
            return;
        }
        this.font = font;
        if (font == null) {
            n = this.defaultFont().handle;
        } else {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            n = font.handle;
        }
        this.state = font == null ? (this.state &= 0xFFFFBFFF) : (this.state |= 0x4000);
        this.setFontDescription(n);
    }

    void setFontDescription(int n) {
        OS.gtk_widget_modify_font(this.handle, n);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if ((this.state & 0x1000) == 0 && color == null) {
            return;
        }
        GdkColor gdkColor = null;
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            gdkColor = color.handle;
        }
        boolean bl = false;
        if (gdkColor == null) {
            int n = OS.gtk_widget_get_modifier_style(this.handle);
            bl = (OS.gtk_rc_style_get_color_flags(n, 0) & 1) != 0;
        } else {
            GdkColor gdkColor2 = this.getForegroundColor();
            boolean bl2 = bl = gdkColor2.pixel != gdkColor.pixel;
        }
        if (bl) {
            this.state = color == null ? (this.state &= 0xFFFFEFFF) : (this.state |= 0x1000);
            this.setForegroundColor(gdkColor);
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        this.setForegroundColor(this.handle, gdkColor);
    }

    void setInitialBounds() {
        if ((this.state & 0x200) != 0 && (this.state & 0x400) != 0) {
            int n = this.topHandle();
            if ((this.parent.style & 0x8000000) != 0) {
                OS.GTK_WIDGET_SET_X(n, this.parent.getClientWidth());
            } else {
                OS.GTK_WIDGET_SET_X(n, 0);
            }
            OS.GTK_WIDGET_SET_Y(n, 0);
        } else {
            this.resizeHandle(1, 1);
            this.forceResize();
        }
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    void setOrientation() {
        if ((this.style & 0x4000000) != 0) {
            if (this.handle != 0) {
                OS.gtk_widget_set_direction(this.handle, 2);
            }
            if (this.fixedHandle != 0) {
                OS.gtk_widget_set_direction(this.fixedHandle, 2);
            }
        }
    }

    public boolean setParent(Composite composite) {
        int n;
        this.checkWidget();
        if (composite == null) {
            SWT.error(4);
        }
        if (composite.isDisposed()) {
            SWT.error(5);
        }
        if (this.parent == composite) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        OS.gtk_widget_realize(composite.handle);
        int n2 = this.topHandle();
        int n3 = OS.GTK_WIDGET_X(n2);
        int n4 = n = (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(n2);
        if ((this.parent.style & 0x8000000) != 0) {
            n3 = this.parent.getClientWidth() - n - n3;
        }
        if ((composite.style & 0x8000000) != 0) {
            n3 = composite.getClientWidth() - n - n3;
        }
        int n5 = OS.GTK_WIDGET_Y(n2);
        this.releaseParent();
        Shell shell = composite.getShell();
        Shell shell2 = this.getShell();
        Decorations decorations = composite.menuShell();
        Decorations decorations2 = this.menuShell();
        Menu[] menuArray = shell2.findMenus(this);
        if (shell2 != shell || decorations2 != decorations) {
            this.fixChildren(shell, shell2, decorations, decorations2, menuArray);
            decorations.fixAccelGroup();
            decorations2.fixAccelGroup();
        }
        int n6 = composite.parentingHandle();
        OS.gtk_widget_reparent(n2, n6);
        OS.gtk_fixed_move(n6, n2, n3, n5);
        this.parent = composite;
        this.setZOrder(null, false, true);
        return true;
    }

    void setParentBackground() {
        this.setBackgroundColor(this.handle, null);
        if (this.fixedHandle != 0) {
            this.setBackgroundColor(this.fixedHandle, null);
        }
    }

    void setParentWindow(int n) {
    }

    boolean setRadioSelection(boolean bl) {
        return false;
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        if (bl) {
            if (--this.drawCount == 0 && this.redrawWindow != 0) {
                int n = this.paintWindow();
                OS.gdk_window_hide(this.redrawWindow);
                OS.gdk_window_destroy(this.redrawWindow);
                OS.gdk_window_set_events(n, OS.gtk_widget_get_events(this.paintHandle()));
                this.redrawWindow = 0;
            }
        } else if (this.drawCount++ == 0 && (OS.GTK_WIDGET_FLAGS(this.handle) & 0x40) != 0) {
            int n = this.paintWindow();
            Rectangle rectangle = this.getBounds();
            GdkWindowAttr gdkWindowAttr = new GdkWindowAttr();
            gdkWindowAttr.width = rectangle.width;
            gdkWindowAttr.height = rectangle.height;
            gdkWindowAttr.event_mask = 2;
            gdkWindowAttr.window_type = 2;
            this.redrawWindow = OS.gdk_window_new(n, gdkWindowAttr, 0);
            if (this.redrawWindow != 0) {
                int n2 = 13308;
                OS.gdk_window_set_events(n, OS.gdk_window_get_events(n) & ~n2);
                OS.gdk_window_set_back_pixmap(this.redrawWindow, 0, false);
                OS.gdk_window_show(this.redrawWindow);
            }
        }
    }

    boolean setTabItemFocus(boolean bl) {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.setToolTipText(this._getShell(), string);
        this.toolTipText = string;
    }

    void setToolTipText(Shell shell, String string) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            if (this.display.currentControl == this) {
                shell.setToolTipText(shell.handle, this.eventHandle(), string);
            }
        } else {
            shell.setToolTipText(this.eventHandle(), string);
        }
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if ((this.state & 0x800) == 0 == bl) {
            return;
        }
        int n = this.topHandle();
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.state &= 0xFFFFF7FF;
            if ((this.state & 0x600) == 0) {
                if (this.enableWindow != 0) {
                    OS.gdk_window_show_unraised(this.enableWindow);
                }
                OS.gtk_widget_show(n);
            }
        } else {
            Control control = null;
            boolean bl2 = false;
            if (this.display.focusEvent != 16) {
                control = this.display.getFocusControl();
                bl2 = this.isFocusAncestor(control);
            }
            this.state |= 0x800;
            if (bl2) {
                OS.GTK_WIDGET_UNSET_FLAGS(n, 256);
                this.fixFocus(control);
                if (this.isDisposed()) {
                    return;
                }
                OS.GTK_WIDGET_SET_FLAGS(n, 256);
            }
            OS.gtk_widget_hide(n);
            if (this.isDisposed()) {
                return;
            }
            if (this.enableWindow != 0) {
                OS.gdk_window_hide(this.enableWindow);
            }
            this.sendEvent(23);
        }
    }

    void setZOrder(Control control, boolean bl, boolean bl2) {
        this.setZOrder(control, bl, bl2, true);
    }

    void setZOrder(Control control, boolean bl, boolean bl2, boolean bl3) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        Control[] controlArray = null;
        if (bl2) {
            controlArray = this.parent._getChildren();
            while (n < controlArray.length) {
                if (controlArray[n] == this) break;
                ++n;
            }
            if (control != null) {
                while (n2 < controlArray.length) {
                    if (controlArray[n2] == control) break;
                    ++n2;
                }
            }
            this.removeRelation();
            if (n + 1 < controlArray.length) {
                n3 = n + 1;
                controlArray[n3].removeRelation();
            }
            if (control != null) {
                if (bl) {
                    control.removeRelation();
                } else if (n2 + 1 < controlArray.length) {
                    controlArray[n2 + 1].removeRelation();
                }
            }
        }
        int n4 = this.topHandle();
        int n5 = control != null ? control.topHandle() : 0;
        int n6 = OS.GTK_WIDGET_WINDOW(n4);
        if (n6 != 0) {
            int n7;
            int n8 = 0;
            if (control != null) {
                n8 = bl && control.enableWindow != 0 ? this.enableWindow : OS.GTK_WIDGET_WINDOW(n5);
            }
            int n9 = n7 = bl3 ? this.parent.redrawWindow : 0;
            if (!OS.GDK_WINDOWING_X11() || n8 == 0 && (!bl || n7 == 0)) {
                if (bl) {
                    OS.gdk_window_raise(n6);
                    if (n7 != 0) {
                        OS.gdk_window_raise(n7);
                    }
                    if (this.enableWindow != 0) {
                        OS.gdk_window_raise(this.enableWindow);
                    }
                } else {
                    if (this.enableWindow != 0) {
                        OS.gdk_window_lower(this.enableWindow);
                    }
                    OS.gdk_window_lower(n6);
                }
            } else {
                XWindowChanges xWindowChanges = new XWindowChanges();
                xWindowChanges.sibling = OS.gdk_x11_drawable_get_xid(n8 != 0 ? n8 : n7);
                int n10 = xWindowChanges.stack_mode = bl ? 0 : 1;
                if (n7 != 0 && n8 == 0) {
                    xWindowChanges.stack_mode = 1;
                }
                int n11 = OS.gdk_x11_drawable_get_xdisplay(n6);
                int n12 = OS.gdk_x11_drawable_get_xid(n6);
                int n13 = OS.XDefaultScreen(n11);
                int n14 = 96;
                OS.XReconfigureWMWindow(n11, n12, n13, n14, xWindowChanges);
                if (this.enableWindow != 0) {
                    xWindowChanges.sibling = OS.gdk_x11_drawable_get_xid(n6);
                    xWindowChanges.stack_mode = 0;
                    n12 = OS.gdk_x11_drawable_get_xid(this.enableWindow);
                    OS.XReconfigureWMWindow(n11, n12, n13, n14, xWindowChanges);
                }
            }
        }
        if (bl3) {
            if (bl) {
                this.parent.moveAbove(n4, n5);
            } else {
                this.parent.moveBelow(n4, n5);
            }
        }
        if (!bl && bl3) {
            this.parent.fixZOrder();
        }
        if (bl2) {
            n = control != null ? (bl ? n2 - (n < n2 ? 1 : 0) : n2 + (n2 < n ? 1 : 0)) : (bl ? 0 : controlArray.length - 1);
            controlArray = this.parent._getChildren();
            if (n > 0) {
                controlArray[n - 1].addRelation(this);
            }
            if (n + 1 < controlArray.length) {
                this.addRelation(controlArray[n + 1]);
            }
            if (n3 != -1) {
                if (n3 <= n) {
                    --n3;
                }
                if (n3 > 0 && n3 != n && n3 != n + 1) {
                    controlArray[n3 - 1].addRelation(controlArray[n3]);
                }
            }
        }
    }

    void setWidgetBackground() {
        int n;
        if (this.fixedHandle != 0) {
            n = OS.gtk_widget_get_modifier_style(this.fixedHandle);
            this.modifyStyle(this.fixedHandle, n);
        }
        n = OS.gtk_widget_get_modifier_style(this.handle);
        this.modifyStyle(this.handle, n);
    }

    boolean showMenu(int n, int n2) {
        Event event = new Event();
        event.x = n;
        event.y = n2;
        this.sendEvent(35, event);
        if (this.isDisposed()) {
            return false;
        }
        if (event.doit && this.menu != null && !this.menu.isDisposed()) {
            boolean bl = this.hooks(1) || this.hooks(2);
            this.menu.createIMMenu(bl ? this.imHandle() : 0);
            if (event.x != n || event.y != n2) {
                this.menu.setLocation(event.x, event.y);
            }
            this.menu.setVisible(true);
            return true;
        }
        return false;
    }

    void showWidget() {
        this.state |= 0x600;
        int n = this.topHandle();
        int n2 = this.parent.parentingHandle();
        this.parent.setParentWindow(n);
        OS.gtk_container_add(n2, n);
        if (this.handle != 0 && this.handle != n) {
            OS.gtk_widget_show(this.handle);
        }
        if ((this.state & 0x600) == 0 && this.fixedHandle != 0) {
            OS.gtk_widget_show(this.fixedHandle);
        }
        if (this.fixedHandle != 0) {
            this.fixStyle(this.fixedHandle);
        }
    }

    void sort(int[] nArray) {
        int n = nArray.length;
        int n2 = n / 2;
        while (n2 > 0) {
            int n3 = n2;
            while (n3 < n) {
                int n4 = n3 - n2;
                while (n4 >= 0) {
                    if (nArray[n4] <= nArray[n4 + n2]) {
                        int n5 = nArray[n4];
                        nArray[n4] = nArray[n4 + n2];
                        nArray[n4 + n2] = n5;
                    }
                    n4 -= n2;
                }
                ++n3;
            }
            n2 /= 2;
        }
    }

    public boolean traverse(int n) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = n;
        return this.traverse(event);
    }

    boolean translateMnemonic(Event event, Control control) {
        if (control == this) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        event.doit = this == this.display.mnemonicControl || this.mnemonicMatch(event.character);
        return this.traverse(event);
    }

    boolean translateMnemonic(int n, GdkEventKey gdkEventKey) {
        Decorations decorations;
        int n2 = OS.gdk_keyval_to_unicode(n);
        if (n2 < 32) {
            return false;
        }
        if (gdkEventKey.state == 0) {
            int n3 = this.traversalCode(n, gdkEventKey);
            if ((n3 & 0x80) == 0) {
                return false;
            }
        } else {
            Shell shell = this._getShell();
            int n4 = 13;
            if ((gdkEventKey.state & n4) != OS.gtk_window_get_mnemonic_modifier(shell.shellHandle)) {
                return false;
            }
        }
        if ((decorations = this.menuShell()).isVisible() && decorations.isEnabled()) {
            Event event = new Event();
            event.detail = 128;
            if (this.setKeyState(event, gdkEventKey)) {
                return this.translateMnemonic(event, null) || decorations.translateMnemonic(event, this);
            }
        }
        return false;
    }

    boolean translateTraversal(GdkEventKey gdkEventKey) {
        int n = 0;
        int n2 = gdkEventKey.keyval;
        int n3 = this.traversalCode(n2, gdkEventKey);
        boolean bl = false;
        switch (n2) {
            case 65307: {
                bl = true;
                n = 2;
                break;
            }
            case 65293: 
            case 65421: {
                bl = true;
                n = 4;
                break;
            }
            case 65056: 
            case 65289: {
                boolean bl2 = (gdkEventKey.state & 1) == 0;
                n = bl2 ? 16 : 8;
                break;
            }
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                boolean bl2;
                boolean bl3 = bl2 = n2 == 65364 || n2 == 65363;
                if (this.parent != null && (this.parent.style & 0x8000000) != 0 && (n2 == 65361 || n2 == 65363)) {
                    bl2 = !bl2;
                }
                n = bl2 ? 64 : 32;
                break;
            }
            case 65365: 
            case 65366: {
                bl = true;
                if ((gdkEventKey.state & 4) == 0) {
                    return false;
                }
                n = n2 == 65366 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = (n3 & n) != 0;
        event.detail = n;
        event.time = gdkEventKey.time;
        if (!this.setKeyState(event, gdkEventKey)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (bl && control != null);
        return false;
    }

    int traversalCode(int n, GdkEventKey gdkEventKey) {
        int n2 = 796;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            n2 |= 2;
        }
        return n2;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean bl) {
        Control control = this.computeTabRoot();
        Widget widget = this.computeTabGroup();
        Widget[] widgetArray = control.computeTabList();
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (widgetArray[n2] == widget) break;
            ++n2;
        }
        if (n2 == n) {
            return false;
        }
        int n3 = n2;
        int n4 = bl ? 1 : -1;
        while ((n2 = (n2 + n4 + n) % n) != n3) {
            Widget widget2 = widgetArray[n2];
            if (widget2.isDisposed() || !widget2.setTabGroupFocus(bl)) continue;
            return true;
        }
        if (widget.isDisposed()) {
            return false;
        }
        return widget.setTabGroupFocus(bl);
    }

    boolean traverseItem(boolean bl) {
        Control[] controlArray = this.parent._getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (controlArray[n2] == this) break;
            ++n2;
        }
        if (n2 == n) {
            return false;
        }
        int n3 = n2;
        int n4 = bl ? 1 : -1;
        while ((n2 = (n2 + n4 + n) % n) != n3) {
            Control control = controlArray[n2];
            if (control.isDisposed() || !control.isTabItem() || !control.setTabItemFocus(bl)) continue;
            return true;
        }
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    boolean traversePage(boolean bl) {
        return false;
    }

    boolean traverseMnemonic(char c) {
        return this.mnemonicHit(c);
    }

    public void update() {
        this.checkWidget();
        this.update(false, true);
    }

    void update(boolean bl, boolean bl2) {
        if (!OS.GTK_WIDGET_VISIBLE(this.topHandle())) {
            return;
        }
        if ((OS.GTK_WIDGET_FLAGS(this.handle) & 0x40) == 0) {
            return;
        }
        int n = this.paintWindow();
        if (bl2) {
            this.display.flushExposes(n, bl);
        }
        OS.gdk_window_process_updates(n, bl);
        OS.gdk_flush();
    }

    void updateBackgroundMode() {
        int n = this.state & 0x8000;
        this.checkBackground();
        if (n != (this.state & 0x8000)) {
            this.setBackground();
        }
    }

    void updateLayout(boolean bl) {
    }

    int windowProc(int n, int n2, int n3) {
        switch (n3) {
            case 19: {
                Control control;
                if (OS.GTK_VERSION >= OS.VERSION(2, 8, 0) || (this.state & 0x40) != 0 || (control = this.findBackgroundControl()) == null || control.backgroundImage == null) break;
                GdkEventExpose gdkEventExpose = new GdkEventExpose();
                OS.memmove(gdkEventExpose, n2, GdkEventExpose.sizeof);
                int n4 = this.paintWindow();
                int n5 = gdkEventExpose.window;
                if (n5 != n4) break;
                int n6 = OS.gdk_gc_new(n5);
                OS.gdk_gc_set_clip_region(n6, gdkEventExpose.region);
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.gtk_widget_translate_coordinates(this.paintHandle(), control.paintHandle(), 0, 0, nArray, nArray2);
                OS.gdk_gc_set_fill(n6, 1);
                OS.gdk_gc_set_ts_origin(n6, -nArray[0], -nArray2[0]);
                OS.gdk_gc_set_tile(n6, control.backgroundImage.pixmap);
                OS.gdk_draw_rectangle(n5, n6, 1, gdkEventExpose.area_x, gdkEventExpose.area_y, gdkEventExpose.area_width, gdkEventExpose.area_height);
                OS.g_object_unref(n6);
            }
        }
        return super.windowProc(n, n2, n3);
    }
}

