/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleObject;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public class Accessible {
    Vector accessibleListeners = new Vector();
    Vector controlListeners = new Vector();
    Vector textListeners = new Vector();
    AccessibleObject accessibleObject;
    Control control;

    Accessible(Control control) {
        this.control = control;
        AccessibleFactory.registerAccessible(this);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                Accessible.this.release();
            }
        });
    }

    public void addAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.addElement(accessibleListener);
    }

    public void addAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.controlListeners.addElement(accessibleControlListener);
    }

    public void addAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        this.textListeners.addElement(accessibleTextListener);
    }

    public Control getControl() {
        return this.control;
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    AccessibleListener[] getAccessibleListeners() {
        if (this.accessibleListeners == null) {
            return null;
        }
        Object[] objectArray = new AccessibleListener[this.accessibleListeners.size()];
        this.accessibleListeners.copyInto(objectArray);
        return objectArray;
    }

    long getControlHandle() {
        return this.control.handle;
    }

    AccessibleControlListener[] getControlListeners() {
        if (this.controlListeners == null) {
            return null;
        }
        Object[] objectArray = new AccessibleControlListener[this.controlListeners.size()];
        this.controlListeners.copyInto(objectArray);
        return objectArray;
    }

    AccessibleTextListener[] getTextListeners() {
        if (this.textListeners == null) {
            return null;
        }
        Object[] objectArray = new AccessibleTextListener[this.textListeners.size()];
        this.textListeners.copyInto(objectArray);
        return objectArray;
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }

    void release() {
        AccessibleFactory.unregisterAccessible(this);
        if (this.accessibleObject != null) {
            this.accessibleObject.release();
            this.accessibleObject = null;
        }
        this.accessibleListeners = null;
        this.controlListeners = null;
        this.textListeners = null;
    }

    public void removeAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.controlListeners.removeElement(accessibleControlListener);
    }

    public void removeAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.removeElement(accessibleListener);
    }

    public void removeAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        this.textListeners.removeElement(accessibleTextListener);
    }

    public void selectionChanged() {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.selectionChanged();
        }
    }

    public void setFocus(int n) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.setFocus(n);
        }
    }

    public void textCaretMoved(int n) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textCaretMoved(n);
        }
    }

    public void textChanged(int n, int n2, int n3) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textChanged(n, n2, n3);
        }
    }

    public void textSelectionChanged() {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textSelectionChanged();
        }
    }
}

