/*******************************************************************************
 * Copyright (c) 2000, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation
 *******************************************************************************/

#include "swt.h"
#include "xpcominit_structs.h"

#ifndef NO_GREVersionRange
typedef struct GREVersionRange_FID_CACHE {
	int cached;
	jclass clazz;
	jfieldID upperInclusive, upper, lowerInclusive, lower;
} GREVersionRange_FID_CACHE;

GREVersionRange_FID_CACHE GREVersionRangeFc;

void cacheGREVersionRangeFields(JNIEnv *env, jobject lpObject)
{
	if (GREVersionRangeFc.cached) return;
	GREVersionRangeFc.clazz = env->GetObjectClass(lpObject);
	GREVersionRangeFc.upperInclusive = env->GetFieldID(GREVersionRangeFc.clazz, "upperInclusive", "Z");
	GREVersionRangeFc.upper = env->GetFieldID(GREVersionRangeFc.clazz, "upper", "J");
	GREVersionRangeFc.lowerInclusive = env->GetFieldID(GREVersionRangeFc.clazz, "lowerInclusive", "Z");
	GREVersionRangeFc.lower = env->GetFieldID(GREVersionRangeFc.clazz, "lower", "J");
	GREVersionRangeFc.cached = 1;
}

GREVersionRange *getGREVersionRangeFields(JNIEnv *env, jobject lpObject, GREVersionRange *lpStruct)
{
	if (!GREVersionRangeFc.cached) cacheGREVersionRangeFields(env, lpObject);
	lpStruct->upperInclusive = env->GetBooleanField(lpObject, GREVersionRangeFc.upperInclusive);
	lpStruct->upper = (const char *)env->GetLongField(lpObject, GREVersionRangeFc.upper);
	lpStruct->lowerInclusive = env->GetBooleanField(lpObject, GREVersionRangeFc.lowerInclusive);
	lpStruct->lower = (const char *)env->GetLongField(lpObject, GREVersionRangeFc.lower);
	return lpStruct;
}

void setGREVersionRangeFields(JNIEnv *env, jobject lpObject, GREVersionRange *lpStruct)
{
	if (!GREVersionRangeFc.cached) cacheGREVersionRangeFields(env, lpObject);
	env->SetBooleanField(lpObject, GREVersionRangeFc.upperInclusive, (jboolean)lpStruct->upperInclusive);
	env->SetLongField(lpObject, GREVersionRangeFc.upper, (jlong)lpStruct->upper);
	env->SetBooleanField(lpObject, GREVersionRangeFc.lowerInclusive, (jboolean)lpStruct->lowerInclusive);
	env->SetLongField(lpObject, GREVersionRangeFc.lower, (jlong)lpStruct->lower);
}
#endif

