/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Canvas
extends Composite {
    Caret caret;

    Canvas() {
    }

    public Canvas(Composite composite, int n) {
        super(composite, n);
    }

    public void drawBackground(GC gC, int n, int n2, int n3, int n4) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        super.drawBackground(gC, n, n2, n3, n4);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    Point getIMCaretPos() {
        if (this.caret == null) {
            return super.getIMCaretPos();
        }
        return new Point(this.caret.x, this.caret.y);
    }

    long gtk_expose_event(long l, long l2) {
        boolean bl;
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        boolean bl2 = bl = this.caret != null && this.caret.isFocusCaret();
        if (bl) {
            this.caret.killFocus();
        }
        long l3 = super.gtk_expose_event(l, l2);
        if (bl) {
            this.caret.setFocus();
        }
        return l3;
    }

    long gtk_focus_in_event(long l, long l2) {
        long l3 = super.gtk_focus_in_event(l, l2);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return l3;
    }

    long gtk_focus_out_event(long l, long l2) {
        long l3 = super.gtk_focus_out_event(l, l2);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return l3;
    }

    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5 = bl4 = this.caret != null && this.caret.isFocusCaret();
        if (bl4) {
            this.caret.killFocus();
        }
        super.redrawWidget(n, n2, n3, n4, bl, bl2, bl3);
        if (bl4) {
            this.caret.setFocus();
        }
    }

    void releaseChildren(boolean bl) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        super.releaseChildren(bl);
    }

    public void scroll(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Object object;
        Control control;
        boolean bl2;
        this.checkWidget();
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        int n7 = n - n3;
        int n8 = n2 - n4;
        if (n7 == 0 && n8 == 0) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean bl3 = bl2 = this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.killFocus();
        }
        long l = this.paintWindow();
        long l2 = OS.gdk_drawable_get_visible_region(l);
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n3;
        gdkRectangle.y = n4;
        gdkRectangle.width = n5;
        gdkRectangle.height = n6;
        long l3 = OS.gdk_region_rectangle(gdkRectangle);
        OS.gdk_region_intersect(l3, l2);
        long l4 = OS.gdk_region_rectangle(gdkRectangle);
        OS.gdk_region_subtract(l4, l2);
        OS.gdk_region_offset(l4, n7, n8);
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        OS.gdk_region_get_clipbox(l3, gdkRectangle2);
        if (gdkRectangle2.width != 0 && gdkRectangle2.height != 0) {
            this.update();
        }
        if ((control = this.findBackgroundControl()) == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            this.redrawWidget(n3, n4, n5, n6, false, false, false);
            this.redrawWidget(n, n2, n5, n6, false, false, false);
        } else {
            boolean bl4;
            long l5 = OS.gdk_gc_new(l);
            OS.gdk_gc_set_exposures(l5, true);
            OS.gdk_draw_drawable(l, l5, l, gdkRectangle2.x, gdkRectangle2.y, gdkRectangle2.x + n7, gdkRectangle2.y + n8, gdkRectangle2.width, gdkRectangle2.height);
            OS.g_object_unref(l5);
            boolean bl5 = bl4 = n + n5 < n3 || n3 + n5 < n || n2 + n6 < n4 || n4 + n6 < n2;
            if (bl4) {
                object = new GdkRectangle();
                ((GdkRectangle)object).x = n3;
                ((GdkRectangle)object).y = n4;
                ((GdkRectangle)object).width = n5;
                ((GdkRectangle)object).height = n6;
                OS.gdk_region_union_with_rect(l4, (GdkRectangle)object);
            } else {
                int n9;
                object = new GdkRectangle();
                if (n7 != 0) {
                    n9 = n - n7;
                    if (n7 < 0) {
                        n9 = n + n5;
                    }
                    ((GdkRectangle)object).x = n9;
                    ((GdkRectangle)object).y = n4;
                    ((GdkRectangle)object).width = Math.abs(n7);
                    ((GdkRectangle)object).height = n6;
                    OS.gdk_region_union_with_rect(l4, (GdkRectangle)object);
                }
                if (n8 != 0) {
                    n9 = n2 - n8;
                    if (n8 < 0) {
                        n9 = n2 + n6;
                    }
                    ((GdkRectangle)object).x = n3;
                    ((GdkRectangle)object).y = n9;
                    ((GdkRectangle)object).width = n5;
                    ((GdkRectangle)object).height = Math.abs(n8);
                    OS.gdk_region_union_with_rect(l4, (GdkRectangle)object);
                }
            }
            OS.gdk_window_invalidate_region(l, l4, bl);
            OS.gdk_region_destroy(l2);
            OS.gdk_region_destroy(l3);
            OS.gdk_region_destroy(l4);
        }
        if (bl) {
            Control[] controlArray = this._getChildren();
            int n10 = 0;
            while (n10 < controlArray.length) {
                Control control2 = controlArray[n10];
                object = control2.getBounds();
                if (Math.min(n3 + n5, ((Rectangle)object).x + ((Rectangle)object).width) >= Math.max(n3, ((Rectangle)object).x) && Math.min(n4 + n6, ((Rectangle)object).y + ((Rectangle)object).height) >= Math.max(n4, ((Rectangle)object).y)) {
                    control2.setLocation(((Rectangle)object).x + n7, ((Rectangle)object).y + n8);
                }
                ++n10;
            }
        }
        if (bl2) {
            this.caret.setFocus();
        }
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.caret != null && this.caret.isFocusCaret();
        if (bl3) {
            this.caret.killFocus();
        }
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3) {
            this.caret.setFocus();
        }
        return n5;
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.hasFocus()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    void updateCaret() {
        long l = this.imHandle();
        if (l == 0L) {
            return;
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = this.caret.x;
        gdkRectangle.y = this.caret.y;
        gdkRectangle.width = this.caret.width;
        gdkRectangle.height = this.caret.height;
        OS.gtk_im_context_set_cursor_location(l, gdkRectangle);
    }
}

