/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cairo.Cairo;

public class Pattern
extends Resource {
    public long handle;

    public Pattern(Device device, Image image) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.device = device;
        device.checkCairo();
        image.createSurface();
        this.handle = Cairo.cairo_pattern_create_for_surface(image.surface);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_pattern_set_extend(this.handle, 1);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Pattern(Device device, float f, float f2, float f3, float f4, Color color, Color color2) {
        this(device, f, f2, f3, f4, color, 255, color2, 255);
    }

    public Pattern(Device device, float f, float f2, float f3, float f4, Color color, int n, Color color2, int n2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 == null) {
            SWT.error(4);
        }
        if (color2.isDisposed()) {
            SWT.error(5);
        }
        this.device = device;
        device.checkCairo();
        this.handle = Cairo.cairo_pattern_create_linear(f, f2, f3, f4);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        GC.setCairoPatternColor(this.handle, 0, color, n);
        GC.setCairoPatternColor(this.handle, 1, color2, n2);
        Cairo.cairo_pattern_set_extend(this.handle, 1);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == 0L) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        Cairo.cairo_pattern_destroy(this.handle);
        this.handle = 0L;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Pattern {*DISPOSED*}";
        }
        return "Pattern {" + this.handle + "}";
    }
}

