/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_path_data_t;
import org.eclipse.swt.internal.cairo.cairo_path_t;

public class Path
extends Resource {
    public long handle;
    boolean moved;
    boolean closed = true;

    public Path(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        device.checkCairo();
        long l = Cairo.cairo_image_surface_create(0, 1, 1);
        if (l == 0L) {
            SWT.error(2);
        }
        this.handle = Cairo.cairo_create(l);
        Cairo.cairo_surface_destroy(l);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void addArc(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.moved = true;
        if (f3 == f4) {
            float f7 = -f5 * (float)Compatibility.PI / 180.0f;
            if (this.closed) {
                Cairo.cairo_move_to(this.handle, (double)(f + f3 / 2.0f) + (double)(f3 / 2.0f) * Math.cos(f7), (double)(f2 + f4 / 2.0f) + (double)(f4 / 2.0f) * Math.sin(f7));
            }
            if (f6 >= 0.0f) {
                Cairo.cairo_arc_negative(this.handle, f + f3 / 2.0f, f2 + f4 / 2.0f, f3 / 2.0f, f7, -(f5 + f6) * (float)Compatibility.PI / 180.0f);
            } else {
                Cairo.cairo_arc(this.handle, f + f3 / 2.0f, f2 + f4 / 2.0f, f3 / 2.0f, f7, -(f5 + f6) * (float)Compatibility.PI / 180.0f);
            }
        } else {
            Cairo.cairo_save(this.handle);
            Cairo.cairo_translate(this.handle, f + f3 / 2.0f, f2 + f4 / 2.0f);
            Cairo.cairo_scale(this.handle, f3 / 2.0f, f4 / 2.0f);
            float f8 = -f5 * (float)Compatibility.PI / 180.0f;
            if (this.closed) {
                Cairo.cairo_move_to(this.handle, Math.cos(f8), Math.sin(f8));
            }
            if (f6 >= 0.0f) {
                Cairo.cairo_arc_negative(this.handle, 0.0, 0.0, 1.0, f8, -(f5 + f6) * (float)Compatibility.PI / 180.0f);
            } else {
                Cairo.cairo_arc(this.handle, 0.0, 0.0, 1.0, f8, -(f5 + f6) * (float)Compatibility.PI / 180.0f);
            }
            Cairo.cairo_restore(this.handle);
        }
        this.closed = false;
        if (Math.abs(f6) >= 360.0f) {
            this.close();
        }
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        this.moved = false;
        long l = Cairo.cairo_copy_path(path.handle);
        if (l == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(this.handle, l);
        Cairo.cairo_path_destroy(l);
        this.closed = path.closed;
    }

    public void addRectangle(float f, float f2, float f3, float f4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.moved = false;
        Cairo.cairo_rectangle(this.handle, f, f2, f3, f4);
        this.closed = true;
    }

    public void addString(String string, float f, float f2, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        this.moved = false;
        GC.addCairoString(this.handle, string, f, f2, font);
        this.closed = true;
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_close_path(this.handle);
        this.moved = false;
        this.closed = true;
    }

    public boolean contains(float f, float f2, GC gC, boolean bl) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        gC.initCairo();
        gC.checkGC(120);
        boolean bl2 = false;
        long l = gC.data.cairo;
        long l2 = Cairo.cairo_copy_path(this.handle);
        if (l2 == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(l, l2);
        Cairo.cairo_path_destroy(l2);
        bl2 = bl ? Cairo.cairo_in_stroke(l, f, f2) != 0 : Cairo.cairo_in_fill(l, f, f2) != 0;
        Cairo.cairo_new_path(l);
        return bl2;
    }

    public void cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (!this.moved) {
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            Cairo.cairo_get_current_point(this.handle, dArray, dArray2);
            Cairo.cairo_move_to(this.handle, dArray[0], dArray2[0]);
            this.moved = true;
        }
        Cairo.cairo_curve_to(this.handle, f, f2, f3, f4, f5, f6);
        this.closed = false;
    }

    public void getBounds(float[] fArray) {
        long l;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 4) {
            SWT.error(5);
        }
        if ((l = Cairo.cairo_copy_path(this.handle)) == 0L) {
            SWT.error(2);
        }
        cairo_path_t cairo_path_t2 = new cairo_path_t();
        Cairo.memmove(cairo_path_t2, l, (long)cairo_path_t.sizeof);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (cairo_path_t2.num_data > 0) {
            d2 = Double.POSITIVE_INFINITY;
            d = Double.POSITIVE_INFINITY;
            d4 = Double.NEGATIVE_INFINITY;
            d3 = Double.NEGATIVE_INFINITY;
            int n = 0;
            double[] dArray = new double[6];
            cairo_path_data_t cairo_path_data_t2 = new cairo_path_data_t();
            while (n < cairo_path_t2.num_data) {
                long l2 = cairo_path_t2.data + (long)(n * cairo_path_data_t.sizeof);
                Cairo.memmove(cairo_path_data_t2, l2, (long)cairo_path_data_t.sizeof);
                switch (cairo_path_data_t2.type) {
                    case 0: {
                        Cairo.memmove(dArray, l2 + (long)cairo_path_data_t.sizeof, (long)cairo_path_data_t.sizeof);
                        d = Math.min(d, dArray[0]);
                        d2 = Math.min(d2, dArray[1]);
                        d3 = Math.max(d3, dArray[0]);
                        d4 = Math.max(d4, dArray[1]);
                        break;
                    }
                    case 1: {
                        Cairo.memmove(dArray, l2 + (long)cairo_path_data_t.sizeof, (long)cairo_path_data_t.sizeof);
                        d = Math.min(d, dArray[0]);
                        d2 = Math.min(d2, dArray[1]);
                        d3 = Math.max(d3, dArray[0]);
                        d4 = Math.max(d4, dArray[1]);
                        break;
                    }
                    case 2: {
                        Cairo.memmove(dArray, l2 + (long)cairo_path_data_t.sizeof, (long)(cairo_path_data_t.sizeof * 3));
                        d = Math.min(d, dArray[0]);
                        d2 = Math.min(d2, dArray[1]);
                        d3 = Math.max(d3, dArray[0]);
                        d4 = Math.max(d4, dArray[1]);
                        d = Math.min(d, dArray[2]);
                        d2 = Math.min(d2, dArray[3]);
                        d3 = Math.max(d3, dArray[2]);
                        d4 = Math.max(d4, dArray[3]);
                        d = Math.min(d, dArray[4]);
                        d2 = Math.min(d2, dArray[5]);
                        d3 = Math.max(d3, dArray[4]);
                        d4 = Math.max(d4, dArray[5]);
                        break;
                    }
                }
                n += cairo_path_data_t2.length;
            }
        }
        fArray[0] = (float)d;
        fArray[1] = (float)d2;
        fArray[2] = (float)(d3 - d);
        fArray[3] = (float)(d4 - d2);
        Cairo.cairo_path_destroy(l);
    }

    public void getCurrentPoint(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 2) {
            SWT.error(5);
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Cairo.cairo_get_current_point(this.handle, dArray, dArray2);
        fArray[0] = (float)dArray[0];
        fArray[1] = (float)dArray2[0];
    }

    public PathData getPathData() {
        long l;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if ((l = Cairo.cairo_copy_path(this.handle)) == 0L) {
            SWT.error(2);
        }
        cairo_path_t cairo_path_t2 = new cairo_path_t();
        Cairo.memmove(cairo_path_t2, l, (long)cairo_path_t.sizeof);
        byte[] byArray = new byte[cairo_path_t2.num_data];
        float[] fArray = new float[cairo_path_t2.num_data * 6];
        int n = 0;
        int n2 = 0;
        if (cairo_path_t2.num_data > 0) {
            int n3 = 0;
            double[] dArray = new double[6];
            cairo_path_data_t cairo_path_data_t2 = new cairo_path_data_t();
            while (n3 < cairo_path_t2.num_data) {
                long l2 = cairo_path_t2.data + (long)(n3 * cairo_path_data_t.sizeof);
                Cairo.memmove(cairo_path_data_t2, l2, (long)cairo_path_data_t.sizeof);
                switch (cairo_path_data_t2.type) {
                    case 0: {
                        byArray[n++] = 1;
                        Cairo.memmove(dArray, l2 + (long)cairo_path_data_t.sizeof, (long)cairo_path_data_t.sizeof);
                        fArray[n2++] = (float)dArray[0];
                        fArray[n2++] = (float)dArray[1];
                        break;
                    }
                    case 1: {
                        byArray[n++] = 2;
                        Cairo.memmove(dArray, l2 + (long)cairo_path_data_t.sizeof, (long)cairo_path_data_t.sizeof);
                        fArray[n2++] = (float)dArray[0];
                        fArray[n2++] = (float)dArray[1];
                        break;
                    }
                    case 2: {
                        byArray[n++] = 4;
                        Cairo.memmove(dArray, l2 + (long)cairo_path_data_t.sizeof, (long)(cairo_path_data_t.sizeof * 3));
                        fArray[n2++] = (float)dArray[0];
                        fArray[n2++] = (float)dArray[1];
                        fArray[n2++] = (float)dArray[2];
                        fArray[n2++] = (float)dArray[3];
                        fArray[n2++] = (float)dArray[4];
                        fArray[n2++] = (float)dArray[5];
                        break;
                    }
                    case 3: {
                        byArray[n++] = 5;
                    }
                }
                n3 += cairo_path_data_t2.length;
            }
        }
        if (n != byArray.length) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
        if (n2 != fArray.length) {
            float[] fArray2 = new float[n2];
            System.arraycopy(fArray, 0, fArray2, 0, n2);
            fArray = fArray2;
        }
        Cairo.cairo_path_destroy(l);
        PathData pathData = new PathData();
        pathData.types = byArray;
        pathData.points = fArray;
        return pathData;
    }

    public void lineTo(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (!this.moved) {
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            Cairo.cairo_get_current_point(this.handle, dArray, dArray2);
            Cairo.cairo_move_to(this.handle, dArray[0], dArray2[0]);
            this.moved = true;
        }
        Cairo.cairo_line_to(this.handle, f, f2);
        this.closed = false;
    }

    public void moveTo(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.moved = true;
        Cairo.cairo_move_to(this.handle, f, f2);
        this.closed = true;
    }

    public void quadTo(float f, float f2, float f3, float f4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Cairo.cairo_get_current_point(this.handle, dArray, dArray2);
        if (!this.moved) {
            Cairo.cairo_move_to(this.handle, dArray[0], dArray2[0]);
            this.moved = true;
        }
        float f5 = (float)dArray[0];
        float f6 = (float)dArray2[0];
        float f7 = f5 + 2.0f * (f - f5) / 3.0f;
        float f8 = f6 + 2.0f * (f2 - f6) / 3.0f;
        float f9 = f7 + (f3 - f5) / 3.0f;
        float f10 = f8 + (f4 - f6) / 3.0f;
        Cairo.cairo_curve_to(this.handle, f7, f8, f9, f10, f3, f4);
        this.closed = false;
    }

    public void dispose() {
        if (this.handle == 0L) {
            return;
        }
        Cairo.cairo_destroy(this.handle);
        this.handle = 0L;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

