/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkImage;
import org.eclipse.swt.internal.gtk.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public long pixmap;
    public long mask;
    long surface;
    long surfaceData;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image() {
    }

    public Image(Device device, int n, int n2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, n, n2);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, Image image, int n) {
        long l;
        long l2;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.device = device;
        this.type = image.type;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(image.pixmap, nArray, nArray2);
        int n2 = nArray[0];
        int n3 = nArray2[0];
        if (image.type == 1 && image.mask != 0L || image.transparentPixel != -1) {
            if (image.transparentPixel != -1) {
                image.createMask();
            }
            if ((l2 = OS.gdk_pixmap_new(0L, n2, n3, 1)) == 0L) {
                SWT.error(2);
            }
            if ((l = OS.gdk_gc_new(l2)) == 0L) {
                SWT.error(2);
            }
            OS.gdk_draw_drawable(l2, l, image.mask, 0, 0, 0, 0, n2, n3);
            OS.g_object_unref(l);
            this.mask = l2;
            if (image.transparentPixel != -1 && image.memGC != null) {
                image.destroyMask();
            }
        }
        if (n != 1) {
            this.transparentPixel = image.transparentPixel;
        }
        this.alpha = image.alpha;
        if (image.alphaData != null) {
            this.alphaData = new byte[image.alphaData.length];
            System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
        }
        this.createAlphaMask(n2, n3);
        l2 = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), n2, n3, -1);
        if (l2 == 0L) {
            SWT.error(2);
        }
        if ((l = OS.gdk_gc_new(l2)) == 0L) {
            SWT.error(2);
        }
        this.pixmap = l2;
        if (n == 0) {
            OS.gdk_draw_drawable(l2, l, image.pixmap, 0, 0, 0, 0, n2, n3);
            OS.g_object_unref(l);
            if (device.tracking) {
                device.new_Object(this);
            }
            return;
        }
        long l3 = OS.gdk_pixbuf_new(0, false, 8, n2, n3);
        if (l3 == 0L) {
            SWT.error(2);
        }
        long l4 = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(l3, image.pixmap, l4, 0, 0, 0, 0, n2, n3);
        int n4 = OS.gdk_pixbuf_get_rowstride(l3);
        long l5 = OS.gdk_pixbuf_get_pixels(l3);
        switch (n) {
            case 1: {
                Color color = device.getSystemColor(18);
                RGB rGB = color.getRGB();
                byte by = (byte)rGB.red;
                byte by2 = (byte)rGB.green;
                byte by3 = (byte)rGB.blue;
                Color color2 = device.getSystemColor(22);
                RGB rGB2 = color2.getRGB();
                byte by4 = (byte)rGB2.red;
                byte by5 = (byte)rGB2.green;
                byte by6 = (byte)rGB2.blue;
                byte[] byArray = new byte[n4];
                int n5 = 0;
                while (n5 < n3) {
                    OS.memmove(byArray, l5 + (long)(n5 * n4), (long)n4);
                    int n6 = 0;
                    while (n6 < n2) {
                        int n7 = n6 * 3;
                        int n8 = byArray[n7] & 0xFF;
                        int n9 = byArray[n7 + 1] & 0xFF;
                        int n10 = byArray[n7 + 2] & 0xFF;
                        int n11 = n8 * n8 + n9 * n9 + n10 * n10;
                        if (n11 < 98304) {
                            byArray[n7] = by;
                            byArray[n7 + 1] = by2;
                            byArray[n7 + 2] = by3;
                        } else {
                            byArray[n7] = by4;
                            byArray[n7 + 1] = by5;
                            byArray[n7 + 2] = by6;
                        }
                        ++n6;
                    }
                    OS.memmove(l5 + (long)(n5 * n4), byArray, (long)n4);
                    ++n5;
                }
                break;
            }
            case 2: {
                byte[] byArray = new byte[n4];
                int n12 = 0;
                while (n12 < n3) {
                    OS.memmove(byArray, l5 + (long)(n12 * n4), (long)n4);
                    int n13 = 0;
                    while (n13 < n2) {
                        byte by;
                        int n14 = n13 * 3;
                        int n15 = byArray[n14] & 0xFF;
                        int n16 = byArray[n14 + 1] & 0xFF;
                        int n17 = byArray[n14 + 2] & 0xFF;
                        byte by7 = by = (byte)(n15 + n15 + n16 + n16 + n16 + n16 + n16 + n17 >> 3);
                        byArray[n14 + 2] = by7;
                        byArray[n14 + 1] = by7;
                        byArray[n14] = by7;
                        ++n13;
                    }
                    OS.memmove(l5 + (long)(n12 * n4), byArray, (long)n4);
                    ++n12;
                }
                break;
            }
        }
        OS.gdk_pixbuf_render_to_drawable(l3, l2, l, 0, 0, 0, 0, n2, n3, 1, 0, 0);
        OS.g_object_unref(l3);
        OS.g_object_unref(l);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, Rectangle rectangle) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.init(device, rectangle.width, rectangle.height);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData imageData) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, imageData);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData imageData, ImageData imageData2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        imageData2 = ImageData.convertMask(imageData2);
        ImageData imageData3 = new ImageData(imageData.width, imageData.height, imageData.depth, imageData.palette, imageData.scanlinePad, imageData.data);
        imageData3.maskPad = imageData2.scanlinePad;
        imageData3.maskData = imageData2.data;
        this.init(device, imageData3);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, InputStream inputStream) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, new ImageData(inputStream));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, String string) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.device = device;
        try {
            int n = string.length();
            char[] cArray = new char[n];
            string.getChars(0, n, cArray, 0);
            byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
            long l = OS.gdk_pixbuf_new_from_file(byArray, null);
            if (l != 0L) {
                boolean bl = OS.gdk_pixbuf_get_has_alpha(l);
                if (bl) {
                    int n2 = OS.gdk_pixbuf_get_width(l);
                    int n3 = OS.gdk_pixbuf_get_height(l);
                    int n4 = OS.gdk_pixbuf_get_rowstride(l);
                    long l2 = OS.gdk_pixbuf_get_pixels(l);
                    byte[] byArray2 = new byte[n4];
                    this.alphaData = new byte[n2 * n3];
                    int n5 = 0;
                    while (n5 < n3) {
                        OS.memmove(byArray2, l2 + (long)(n5 * n4), (long)n4);
                        int n6 = 0;
                        while (n6 < n2) {
                            this.alphaData[n5 * n2 + n6] = byArray2[n6 * 4 + 3];
                            byArray2[n6 * 4 + 3] = -1;
                            ++n6;
                        }
                        OS.memmove(l2 + (long)(n5 * n4), byArray2, (long)n4);
                        ++n5;
                    }
                    this.createAlphaMask(n2, n3);
                }
                long[] lArray = new long[1];
                OS.gdk_pixbuf_render_pixmap_and_mask(l, lArray, null, 0);
                this.type = 0;
                this.pixmap = lArray[0];
                if (this.pixmap == 0L) {
                    SWT.error(2);
                }
                OS.g_object_unref(l);
                return;
            }
        }
        catch (SWTException sWTException) {}
        this.init(device, new ImageData(string));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void createAlphaMask(int n, int n2) {
        if (this.device.useXRender && (this.alpha != -1 || this.alphaData != null)) {
            this.mask = OS.gdk_pixmap_new(0L, this.alpha != -1 ? 1 : n, this.alpha != -1 ? 1 : n2, 8);
            if (this.mask == 0L) {
                SWT.error(2);
            }
            long l = OS.gdk_gc_new(this.mask);
            if (this.alpha != -1) {
                GdkColor gdkColor = new GdkColor();
                gdkColor.pixel = (this.alpha & 0xFF) << 8 | this.alpha & 0xFF;
                OS.gdk_gc_set_foreground(l, gdkColor);
                OS.gdk_draw_rectangle(this.mask, l, 1, 0, 0, 1, 1);
            } else {
                long l2 = OS.gdk_drawable_get_image(this.mask, 0, 0, n, n2);
                if (l2 == 0L) {
                    SWT.error(2);
                }
                GdkImage gdkImage = new GdkImage();
                OS.memmove(gdkImage, l2);
                if (gdkImage.bpl == n) {
                    OS.memmove(gdkImage.mem, this.alphaData, (long)this.alphaData.length);
                } else {
                    byte[] byArray = new byte[gdkImage.bpl];
                    int n3 = 0;
                    while (n3 < n2) {
                        System.arraycopy(this.alphaData, n * n3, byArray, 0, n);
                        OS.memmove(gdkImage.mem + (long)(gdkImage.bpl * n3), byArray, (long)gdkImage.bpl);
                        ++n3;
                    }
                }
                OS.gdk_draw_image(this.mask, l, l2, 0, 0, 0, 0, n, n2);
                OS.g_object_unref(l2);
            }
            OS.g_object_unref(l);
        }
    }

    void createMask() {
        if (this.mask != 0L) {
            return;
        }
        this.mask = this.createMask(this.getImageData(), false);
        if (this.mask == 0L) {
            SWT.error(2);
        }
    }

    long createMask(ImageData imageData, boolean bl) {
        ImageData imageData2 = imageData.getTransparencyMask();
        byte[] byArray = imageData2.data;
        byte[] byArray2 = bl ? new byte[byArray.length] : byArray;
        int n = 0;
        while (n < byArray2.length) {
            byte by = byArray[n];
            byArray2[n] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            ++n;
        }
        byArray2 = ImageData.convertPad(byArray2, imageData2.width, imageData2.height, imageData2.depth, imageData2.scanlinePad, 1);
        return OS.gdk_bitmap_create_from_data(0L, byArray2, imageData2.width, imageData2.height);
    }

    void createSurface() {
        if (this.surface != 0L) {
            return;
        }
        if (this.transparentPixel != -1) {
            this.createMask();
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(this.pixmap, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        if (this.mask != 0L || this.alpha != -1 || this.alphaData != null) {
            long l = OS.gdk_pixbuf_new(0, true, 8, n, n2);
            if (l == 0L) {
                SWT.error(2);
            }
            long l2 = OS.gdk_colormap_get_system();
            OS.gdk_pixbuf_get_from_drawable(l, this.pixmap, l2, 0, 0, 0, 0, n, n2);
            int n3 = OS.gdk_pixbuf_get_rowstride(l);
            long l3 = OS.gdk_pixbuf_get_pixels(l);
            byte[] byArray = new byte[n3];
            if (this.mask != 0L && OS.gdk_drawable_get_depth(this.mask) == 1) {
                long l4 = OS.gdk_pixbuf_new(0, false, 8, n, n2);
                if (l4 == 0L) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(l4, this.mask, 0L, 0, 0, 0, 0, n, n2);
                int n4 = OS.gdk_pixbuf_get_rowstride(l4);
                long l5 = OS.gdk_pixbuf_get_pixels(l4);
                byte[] byArray2 = new byte[n4];
                long l6 = l3;
                long l7 = l5;
                int n5 = 0;
                while (n5 < n2) {
                    OS.memmove(byArray, l6, (long)n3);
                    OS.memmove(byArray2, l7, (long)n4);
                    int n6 = 0;
                    int n7 = 0;
                    while (n6 < n) {
                        if (byArray2[n6 * 3] == 0) {
                            byArray[n7 + 3] = 0;
                            byArray[n7 + 2] = 0;
                            byArray[n7 + 1] = 0;
                            byArray[n7 + 0] = 0;
                        }
                        byte by = byArray[n7];
                        byArray[n7] = byArray[n7 + 2];
                        byArray[n7 + 2] = by;
                        ++n6;
                        n7 += 4;
                    }
                    OS.memmove(l6, byArray, (long)n3);
                    l6 += (long)n3;
                    l7 += (long)n4;
                    ++n5;
                }
                OS.g_object_unref(l4);
            } else if (this.alpha != -1) {
                long l8 = l3;
                int n8 = 0;
                while (n8 < n2) {
                    OS.memmove(byArray, l8, (long)n3);
                    int n9 = 0;
                    int n10 = 0;
                    while (n9 < n) {
                        byArray[n10 + 3] = (byte)this.alpha;
                        int n11 = (byArray[n10 + 0] & 0xFF) * this.alpha + 128;
                        n11 = n11 + (n11 >> 8) >> 8;
                        int n12 = (byArray[n10 + 1] & 0xFF) * this.alpha + 128;
                        n12 = n12 + (n12 >> 8) >> 8;
                        int n13 = (byArray[n10 + 2] & 0xFF) * this.alpha + 128;
                        n13 = n13 + (n13 >> 8) >> 8;
                        byArray[n10 + 0] = (byte)n13;
                        byArray[n10 + 1] = (byte)n12;
                        byArray[n10 + 2] = (byte)n11;
                        ++n9;
                        n10 += 4;
                    }
                    OS.memmove(l8, byArray, (long)n3);
                    l8 += (long)n3;
                    ++n8;
                }
            } else if (this.alphaData != null) {
                long l9 = l3;
                int n14 = 0;
                while (n14 < nArray2[0]) {
                    OS.memmove(byArray, l9, (long)n3);
                    int n15 = 0;
                    int n16 = 0;
                    while (n15 < n) {
                        int n17 = this.alphaData[n14 * nArray[0] + n15] & 0xFF;
                        byArray[n16 + 3] = (byte)n17;
                        int n18 = (byArray[n16 + 0] & 0xFF) * n17 + 128;
                        n18 = n18 + (n18 >> 8) >> 8;
                        int n19 = (byArray[n16 + 1] & 0xFF) * n17 + 128;
                        n19 = n19 + (n19 >> 8) >> 8;
                        int n20 = (byArray[n16 + 2] & 0xFF) * n17 + 128;
                        n20 = n20 + (n20 >> 8) >> 8;
                        byArray[n16 + 0] = (byte)n20;
                        byArray[n16 + 1] = (byte)n19;
                        byArray[n16 + 2] = (byte)n18;
                        ++n15;
                        n16 += 4;
                    }
                    OS.memmove(l9, byArray, (long)n3);
                    l9 += (long)n3;
                    ++n14;
                }
            } else {
                long l10 = l3;
                int n21 = 0;
                while (n21 < nArray2[0]) {
                    OS.memmove(byArray, l10, (long)n3);
                    int n22 = 0;
                    int n23 = 0;
                    while (n22 < n) {
                        byArray[n23 + 3] = -1;
                        byte by = byArray[n23];
                        byArray[n23] = byArray[n23 + 2];
                        byArray[n23 + 2] = by;
                        ++n22;
                        n23 += 4;
                    }
                    OS.memmove(l10, byArray, (long)n3);
                    l10 += (long)n3;
                    ++n21;
                }
            }
            this.surfaceData = OS.g_malloc(n3 * n2);
            OS.memmove(this.surfaceData, l3, (long)(n3 * n2));
            this.surface = Cairo.cairo_image_surface_create_for_data(this.surfaceData, 0, n, n2, n3);
            OS.g_object_unref(l);
        } else {
            long l = OS.GDK_DISPLAY();
            long l11 = OS.GDK_PIXMAP_XID(this.pixmap);
            long l12 = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
            this.surface = Cairo.cairo_xlib_surface_create(l, l11, l12, n, n2);
        }
        if (this.transparentPixel != -1 && this.memGC != null) {
            this.destroyMask();
        }
    }

    void destroyMask() {
        if (this.mask == 0L) {
            return;
        }
        OS.g_object_unref(this.mask);
        this.mask = 0L;
    }

    public void dispose() {
        if (this.pixmap == 0L) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.pixmap != 0L) {
            OS.g_object_unref(this.pixmap);
        }
        if (this.mask != 0L) {
            OS.g_object_unref(this.mask);
        }
        if (this.surface != 0L) {
            Cairo.cairo_surface_destroy(this.surface);
        }
        if (this.surfaceData != 0L) {
            OS.g_free(this.surfaceData);
        }
        this.mask = 0L;
        this.pixmap = 0L;
        this.surface = 0L;
        this.surfaceData = 0L;
        this.memGC = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.pixmap == image.pixmap;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(this.pixmap, nArray, nArray2);
        this.width = nArray[0];
        this.height = nArray2[0];
        return new Rectangle(0, 0, this.width, this.height);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(this.pixmap, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        long l = OS.gdk_pixbuf_new(0, false, 8, n, n2);
        if (l == 0L) {
            SWT.error(2);
        }
        long l2 = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(l, this.pixmap, l2, 0, 0, 0, 0, n, n2);
        int n3 = OS.gdk_pixbuf_get_rowstride(l);
        long l3 = OS.gdk_pixbuf_get_pixels(l);
        byte[] byArray = new byte[n3 * n2];
        OS.memmove(byArray, l3, (long)byArray.length);
        OS.g_object_unref(l);
        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(n, n2, 24, paletteData);
        imageData.data = byArray;
        imageData.bytesPerLine = n3;
        if (this.transparentPixel == -1 && this.type == 1 && this.mask != 0L) {
            int n4;
            long l4 = OS.gdk_drawable_get_image(this.mask, 0, 0, n, n2);
            if (l4 == 0L) {
                SWT.error(2);
            }
            GdkImage gdkImage = new GdkImage();
            OS.memmove(gdkImage, l4);
            byte[] byArray2 = new byte[gdkImage.bpl * gdkImage.height];
            OS.memmove(byArray2, gdkImage.mem, (long)byArray2.length);
            OS.g_object_unref(l4);
            int n5 = 1;
            while (n5 < 128) {
                n4 = ((n + 7) / 8 + (n5 - 1)) / n5 * n5;
                if (gdkImage.bpl == n4) break;
                ++n5;
            }
            imageData.maskPad = 2;
            byArray2 = ImageData.convertPad(byArray2, n, n2, 1, n5, imageData.maskPad);
            if (gdkImage.byte_order == 0) {
                n4 = 0;
                while (n4 < byArray2.length) {
                    byte by = byArray2[n4];
                    byArray2[n4] = (byte)((by & 1) << 7 | (by & 2) << 5 | (by & 4) << 3 | (by & 8) << 1 | (by & 0x10) >> 1 | (by & 0x20) >> 3 | (by & 0x40) >> 5 | (by & 0x80) >> 7);
                    ++n4;
                }
            }
            imageData.maskData = byArray2;
        }
        imageData.transparentPixel = this.transparentPixel;
        imageData.alpha = this.alpha;
        if (this.alpha == -1 && this.alphaData != null) {
            imageData.alphaData = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, imageData.alphaData, 0, this.alphaData.length);
        }
        return imageData;
    }

    public static Image gtk_new(Device device, int n, long l, long l2) {
        if (device == null) {
            device = Device.getDevice();
        }
        Image image = new Image();
        image.type = n;
        image.pixmap = l;
        image.mask = l2;
        image.device = device;
        return image;
    }

    public int hashCode() {
        return (int)this.pixmap;
    }

    void init(Device device, int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        this.device = device;
        this.type = 0;
        this.pixmap = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), n, n2, -1);
        if (this.pixmap == 0L) {
            SWT.error(2);
        }
        GdkColor gdkColor = new GdkColor();
        gdkColor.red = (short)-1;
        gdkColor.green = (short)-1;
        gdkColor.blue = (short)-1;
        long l = OS.gdk_colormap_get_system();
        OS.gdk_colormap_alloc_color(l, gdkColor, true, true);
        long l2 = OS.gdk_gc_new(this.pixmap);
        OS.gdk_gc_set_foreground(l2, gdkColor);
        OS.gdk_draw_rectangle(this.pixmap, l2, 1, 0, 0, n, n2);
        OS.g_object_unref(l2);
        OS.gdk_colormap_free_colors(l, gdkColor, 1);
    }

    void init(Device device, ImageData imageData) {
        boolean bl;
        long l;
        long l2;
        if (imageData == null) {
            SWT.error(4);
        }
        this.device = device;
        int n = imageData.width;
        int n2 = imageData.height;
        PaletteData paletteData = imageData.palette;
        if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || paletteData.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !paletteData.isDirect)) {
            SWT.error(38);
        }
        if ((l2 = OS.gdk_pixbuf_new(0, false, 8, n, n2)) == 0L) {
            SWT.error(2);
        }
        int n3 = OS.gdk_pixbuf_get_rowstride(l2);
        long l3 = OS.gdk_pixbuf_get_pixels(l2);
        byte[] byArray = imageData.data;
        if (!paletteData.isDirect || imageData.depth != 24 || n3 != imageData.bytesPerLine || paletteData.redMask != 0xFF0000 || paletteData.greenMask != 65280 || paletteData.blueMask != 255) {
            byArray = new byte[n3 * n2];
            if (paletteData.isDirect) {
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n, n2, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, byArray, 24, n3, 1, 0, 0, n, n2, 0xFF0000, 65280, 255, false, false);
            } else {
                RGB[] rGBArray = paletteData.getRGBs();
                int n4 = rGBArray.length;
                byte[] byArray2 = new byte[n4];
                byte[] byArray3 = new byte[n4];
                byte[] byArray4 = new byte[n4];
                int n5 = 0;
                while (n5 < rGBArray.length) {
                    RGB rGB = rGBArray[n5];
                    if (rGB != null) {
                        byArray2[n5] = (byte)rGB.red;
                        byArray3[n5] = (byte)rGB.green;
                        byArray4[n5] = (byte)rGB.blue;
                    }
                    ++n5;
                }
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n, n2, byArray2, byArray3, byArray4, 255, null, 0, 0, 0, byArray, 24, n3, 1, 0, 0, n, n2, 0xFF0000, 65280, 255, false, false);
            }
        }
        OS.memmove(l3, byArray, (long)(n3 * n2));
        long l4 = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), n, n2, -1);
        if (l4 == 0L) {
            SWT.error(2);
        }
        if ((l = OS.gdk_gc_new(l4)) == 0L) {
            SWT.error(2);
        }
        OS.gdk_pixbuf_render_to_drawable(l2, l4, l, 0, 0, 0, 0, n, n2, 1, 0, 0);
        OS.g_object_unref(l);
        OS.g_object_unref(l2);
        boolean bl2 = bl = imageData.getTransparencyType() == 2;
        if (bl || imageData.transparentPixel != -1) {
            long l5;
            if (imageData.transparentPixel != -1) {
                RGB rGB = null;
                if (paletteData.isDirect) {
                    rGB = paletteData.getRGB(imageData.transparentPixel);
                } else if (imageData.transparentPixel < paletteData.colors.length) {
                    rGB = paletteData.getRGB(imageData.transparentPixel);
                }
                if (rGB != null) {
                    this.transparentPixel = rGB.red << 16 | rGB.green << 8 | rGB.blue;
                }
            }
            if ((l5 = this.createMask(imageData, bl)) == 0L) {
                SWT.error(2);
            }
            this.mask = l5;
            this.type = bl ? 1 : 0;
        } else {
            this.type = 0;
            this.mask = 0L;
            this.alpha = imageData.alpha;
            if (imageData.alpha == -1 && imageData.alphaData != null) {
                this.alphaData = new byte[imageData.alphaData.length];
                System.arraycopy(imageData.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
            this.createAlphaMask(n, n2);
        }
        this.pixmap = l4;
    }

    public long internal_new_GC(GCData gCData) {
        if (this.pixmap == 0L) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        long l = OS.gdk_gc_new(this.pixmap);
        if (gCData != null) {
            int n = 0x6000000;
            if ((gCData.style & n) == 0) {
                gCData.style |= 0x2000000;
            }
            gCData.device = this.device;
            gCData.drawable = this.pixmap;
            gCData.background = this.device.COLOR_WHITE.handle;
            gCData.foreground = this.device.COLOR_BLACK.handle;
            gCData.font = this.device.systemFont.handle;
            gCData.image = this;
        }
        return l;
    }

    public void internal_dispose_GC(long l, GCData gCData) {
        OS.g_object_unref(l);
    }

    public boolean isDisposed() {
        return this.pixmap == 0L;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.pixmap + "}";
    }
}

