/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.browser.MozillaDelegate;
import org.eclipse.swt.browser.PromptDialog;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIDOMWindow;
import org.eclipse.swt.internal.mozilla.nsIEmbeddingSiteWindow;
import org.eclipse.swt.internal.mozilla.nsIMemory;
import org.eclipse.swt.internal.mozilla.nsIPromptService;
import org.eclipse.swt.internal.mozilla.nsIServiceManager;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserChrome;
import org.eclipse.swt.internal.mozilla.nsIWindowWatcher;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

class PromptService {
    XPCOMObject supports;
    XPCOMObject promptService;
    int refCount = 0;

    public PromptService() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public long method0(long[] lArray) {
                return PromptService.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return PromptService.this.AddRef();
            }

            public long method2(long[] lArray) {
                return PromptService.this.Release();
            }
        };
        int[] nArray2 = new int[12];
        nArray2[0] = 2;
        nArray2[3] = 3;
        nArray2[4] = 5;
        nArray2[5] = 4;
        nArray2[6] = 6;
        nArray2[7] = 10;
        nArray2[8] = 7;
        nArray2[9] = 8;
        nArray2[10] = 7;
        nArray2[11] = 7;
        this.promptService = new XPCOMObject(nArray2){

            public long method0(long[] lArray) {
                return PromptService.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return PromptService.this.AddRef();
            }

            public long method2(long[] lArray) {
                return PromptService.this.Release();
            }

            public long method3(long[] lArray) {
                return PromptService.this.Alert(lArray[0], lArray[1], lArray[2]);
            }

            public long method4(long[] lArray) {
                return PromptService.this.AlertCheck(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4]);
            }

            public long method5(long[] lArray) {
                return PromptService.this.Confirm(lArray[0], lArray[1], lArray[2], lArray[3]);
            }

            public long method6(long[] lArray) {
                return PromptService.this.ConfirmCheck(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5]);
            }

            public long method7(long[] lArray) {
                return PromptService.this.ConfirmEx(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], lArray[7], lArray[8], lArray[9]);
            }

            public long method8(long[] lArray) {
                return PromptService.this.Prompt(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6]);
            }

            public long method9(long[] lArray) {
                return PromptService.this.PromptUsernameAndPassword(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], lArray[7]);
            }

            public long method10(long[] lArray) {
                return PromptService.this.PromptPassword(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6]);
            }

            public long method11(long[] lArray) {
                return PromptService.this.Select(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.promptService != null) {
            this.promptService.dispose();
            this.promptService = null;
        }
    }

    long getAddress() {
        return this.promptService.getAddress();
    }

    long QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147467262L;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, l, 16);
        if (nsID2.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(l2, new long[]{this.supports.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (nsID2.Equals(nsIPromptService.NS_IPROMPTSERVICE_IID)) {
            XPCOM.memmove(l2, new long[]{this.promptService.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        XPCOM.memmove(l2, new long[1], (long)C.PTR_SIZEOF);
        return -2147467262L;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    Browser getBrowser(long l) {
        if (l == 0L) {
            return null;
        }
        long[] lArray = new long[1];
        int n = XPCOM.NS_GetServiceManager(lArray);
        if (n != 0) {
            Mozilla.error(n);
        }
        if (lArray[0] == 0L) {
            Mozilla.error(-2147467262);
        }
        nsIServiceManager nsIServiceManager2 = new nsIServiceManager(lArray[0]);
        lArray[0] = 0L;
        byte[] byArray = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/embedcomp/window-watcher;1", true);
        n = nsIServiceManager2.GetServiceByContractID(byArray, nsIWindowWatcher.NS_IWINDOWWATCHER_IID, lArray);
        if (n != 0) {
            Mozilla.error(n);
        }
        if (lArray[0] == 0L) {
            Mozilla.error(-2147467262);
        }
        nsIServiceManager2.Release();
        nsIWindowWatcher nsIWindowWatcher2 = new nsIWindowWatcher(lArray[0]);
        lArray[0] = 0L;
        nsIDOMWindow nsIDOMWindow2 = new nsIDOMWindow(l);
        n = nsIDOMWindow2.GetTop(lArray);
        if (n != 0) {
            Mozilla.error(n);
        }
        if (lArray[0] == 0L) {
            Mozilla.error(-2147467262);
        }
        l = lArray[0];
        lArray[0] = 0L;
        n = nsIWindowWatcher2.GetChromeForWindow(l, lArray);
        if (n != 0) {
            Mozilla.error(n);
        }
        if (lArray[0] == 0L) {
            Mozilla.error(-2147467262);
        }
        nsIWindowWatcher2.Release();
        nsIWebBrowserChrome nsIWebBrowserChrome2 = new nsIWebBrowserChrome(lArray[0]);
        lArray[0] = 0L;
        n = nsIWebBrowserChrome2.QueryInterface(nsIEmbeddingSiteWindow.NS_IEMBEDDINGSITEWINDOW_IID, lArray);
        if (n != 0) {
            Mozilla.error(n);
        }
        if (lArray[0] == 0L) {
            Mozilla.error(-2147467262);
        }
        nsIWebBrowserChrome2.Release();
        nsIEmbeddingSiteWindow nsIEmbeddingSiteWindow2 = new nsIEmbeddingSiteWindow(lArray[0]);
        lArray[0] = 0L;
        n = nsIEmbeddingSiteWindow2.GetSiteWindow(lArray);
        if (n != 0) {
            Mozilla.error(n);
        }
        if (lArray[0] == 0L) {
            Mozilla.error(-2147467262);
        }
        nsIEmbeddingSiteWindow2.Release();
        return Mozilla.findBrowser(lArray[0]);
    }

    String getLabel(int n, int n2, long l) {
        String string = null;
        int n3 = (n & 255 * n2) / n2;
        switch (n3) {
            case 2: {
                string = SWT.getMessage("SWT_Cancel");
                break;
            }
            case 4: {
                string = SWT.getMessage("SWT_No");
                break;
            }
            case 1: {
                string = SWT.getMessage("SWT_OK");
                break;
            }
            case 5: {
                string = SWT.getMessage("SWT_Save");
                break;
            }
            case 3: {
                string = SWT.getMessage("SWT_Yes");
                break;
            }
            case 127: {
                int n4 = XPCOM.strlen_PRUnichar(l);
                char[] cArray = new char[n4];
                XPCOM.memmove(cArray, l, (long)(n4 * 2));
                string = new String(cArray);
            }
        }
        return string;
    }

    public long Alert(long l, long l2, long l3) {
        Browser browser = this.getBrowser(l);
        int n = XPCOM.strlen_PRUnichar(l2);
        char[] cArray = new char[n];
        XPCOM.memmove(cArray, l2, (long)(n * 2));
        String string = new String(cArray);
        n = XPCOM.strlen_PRUnichar(l3);
        cArray = new char[n];
        XPCOM.memmove(cArray, l3, (long)(n * 2));
        String string2 = new String(cArray);
        Shell shell = browser == null ? new Shell() : browser.getShell();
        MessageBox messageBox = new MessageBox(shell, 40);
        messageBox.setText(string);
        messageBox.setMessage(string2);
        messageBox.open();
        return 0L;
    }

    public long AlertCheck(long l, long l2, long l3, long l4, long l5) {
        Browser browser = this.getBrowser(l);
        int n = XPCOM.strlen_PRUnichar(l2);
        char[] cArray = new char[n];
        XPCOM.memmove(cArray, l2, (long)(n * 2));
        String string = new String(cArray);
        n = XPCOM.strlen_PRUnichar(l3);
        cArray = new char[n];
        XPCOM.memmove(cArray, l3, (long)(n * 2));
        String string2 = new String(cArray);
        n = XPCOM.strlen_PRUnichar(l4);
        cArray = new char[n];
        XPCOM.memmove(cArray, l4, (long)(n * 2));
        String string3 = new String(cArray);
        Shell shell = browser == null ? new Shell() : browser.getShell();
        PromptDialog promptDialog = new PromptDialog(shell);
        int[] nArray = new int[1];
        if (l5 != 0L) {
            XPCOM.memmove(nArray, l5, 4L);
        }
        promptDialog.alertCheck(string, string2, string3, nArray);
        if (l5 != 0L) {
            XPCOM.memmove(l5, nArray, 4L);
        }
        return 0L;
    }

    public long Confirm(long l, long l2, long l3, long l4) {
        Browser browser = this.getBrowser(l);
        int n = XPCOM.strlen_PRUnichar(l2);
        char[] cArray = new char[n];
        XPCOM.memmove(cArray, l2, (long)(n * 2));
        String string = new String(cArray);
        n = XPCOM.strlen_PRUnichar(l3);
        cArray = new char[n];
        XPCOM.memmove(cArray, l3, (long)(n * 2));
        String string2 = new String(cArray);
        Shell shell = browser == null ? new Shell() : browser.getShell();
        MessageBox messageBox = new MessageBox(shell, 292);
        messageBox.setText(string);
        messageBox.setMessage(string2);
        int n2 = messageBox.open();
        int[] nArray = new int[]{n2 == 32 ? 1 : 0};
        XPCOM.memmove(l4, nArray, 4L);
        return 0L;
    }

    public long ConfirmCheck(long l, long l2, long l3, long l4, long l5, long l6) {
        return -2147467263L;
    }

    public long ConfirmEx(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10) {
        Browser browser = this.getBrowser(l);
        int n = XPCOM.strlen_PRUnichar(l2);
        char[] cArray = new char[n];
        XPCOM.memmove(cArray, l2, (long)(n * 2));
        String string = new String(cArray);
        n = XPCOM.strlen_PRUnichar(l3);
        cArray = new char[n];
        XPCOM.memmove(cArray, l3, (long)(n * 2));
        String string2 = new String(cArray);
        String string3 = null;
        if (l8 != 0L) {
            n = XPCOM.strlen_PRUnichar(l8);
            cArray = new char[n];
            XPCOM.memmove(cArray, l8, (long)(n * 2));
            string3 = new String(cArray);
        }
        String string4 = this.getLabel((int)l4, 1, l5);
        String string5 = this.getLabel((int)l4, 256, l6);
        String string6 = this.getLabel((int)l4, 65536, l7);
        int n2 = 0;
        if ((l4 & 0x1000000L) != 0L) {
            n2 = 1;
        } else if ((l4 & 0x2000000L) != 0L) {
            n2 = 2;
        }
        Shell shell = browser == null ? new Shell() : browser.getShell();
        PromptDialog promptDialog = new PromptDialog(shell);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (l9 != 0L) {
            XPCOM.memmove(nArray, l9, 4L);
        }
        promptDialog.confirmEx(string, string2, string3, string4, string5, string6, n2, nArray, nArray2);
        if (l9 != 0L) {
            XPCOM.memmove(l9, nArray, 4L);
        }
        XPCOM.memmove(l10, nArray2, 4L);
        return 0L;
    }

    public long Prompt(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        char[] cArray;
        int n;
        Browser browser = this.getBrowser(l);
        String string = null;
        String string2 = null;
        String[] stringArray = new String[1];
        if (l2 != 0L) {
            n = XPCOM.strlen_PRUnichar(l2);
            cArray = new char[n];
            XPCOM.memmove(cArray, l2, (long)(n * 2));
            string = new String(cArray);
        }
        n = XPCOM.strlen_PRUnichar(l3);
        cArray = new char[n];
        XPCOM.memmove(cArray, l3, (long)(n * 2));
        String string3 = new String(cArray);
        long[] lArray = new long[1];
        XPCOM.memmove(lArray, l4, (long)C.PTR_SIZEOF);
        if (lArray[0] != 0L) {
            n = XPCOM.strlen_PRUnichar(lArray[0]);
            cArray = new char[n];
            XPCOM.memmove(cArray, lArray[0], (long)(n * 2));
            stringArray[0] = new String(cArray);
        }
        if (l5 != 0L && (n = XPCOM.strlen_PRUnichar(l5)) > 0) {
            cArray = new char[n];
            XPCOM.memmove(cArray, l5, (long)(n * 2));
            string2 = new String(cArray);
        }
        Shell shell = browser == null ? new Shell() : browser.getShell();
        PromptDialog promptDialog = new PromptDialog(shell);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (l6 != 0L) {
            XPCOM.memmove(nArray, l6, 4L);
        }
        promptDialog.prompt(string, string3, string2, stringArray, nArray, nArray2);
        XPCOM.memmove(l7, nArray2, 4L);
        if (nArray2[0] == 1) {
            long[] lArray2 = new long[1];
            if (stringArray[0] != null) {
                int n2 = stringArray[0].length();
                char[] cArray2 = new char[n2 + 1];
                stringArray[0].getChars(0, n2, cArray2, 0);
                int n3 = cArray2.length * 2;
                long l8 = C.malloc(n3);
                XPCOM.memmove(l8, cArray2, (long)n3);
                XPCOM.memmove(l4, new long[]{l8}, (long)C.PTR_SIZEOF);
                if (lArray[0] != 0L) {
                    int n4 = XPCOM.NS_GetServiceManager(lArray2);
                    if (n4 != 0) {
                        SWT.error(n4);
                    }
                    if (lArray2[0] == 0L) {
                        SWT.error(-2147467262);
                    }
                    nsIServiceManager nsIServiceManager2 = new nsIServiceManager(lArray2[0]);
                    lArray2[0] = 0L;
                    byte[] byArray = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/xpcom/memory-service;1", true);
                    n4 = nsIServiceManager2.GetServiceByContractID(byArray, nsIMemory.NS_IMEMORY_IID, lArray2);
                    if (n4 != 0) {
                        SWT.error(n4);
                    }
                    if (lArray2[0] == 0L) {
                        SWT.error(-2147467262);
                    }
                    nsIServiceManager2.Release();
                    nsIMemory nsIMemory2 = new nsIMemory(lArray2[0]);
                    lArray2[0] = 0L;
                    nsIMemory2.Free(lArray[0]);
                    nsIMemory2.Release();
                }
            }
        }
        if (l6 != 0L) {
            XPCOM.memmove(l6, nArray, 4L);
        }
        return 0L;
    }

    public long PromptUsernameAndPassword(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        String string;
        char[] cArray;
        int n;
        Browser browser = this.getBrowser(l);
        String string2 = null;
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        if (l2 != 0L) {
            n = XPCOM.strlen_PRUnichar(l2);
            cArray = new char[n];
            XPCOM.memmove(cArray, l2, (long)(n * 2));
            string = new String(cArray);
        } else {
            string = "";
        }
        n = XPCOM.strlen_PRUnichar(l3);
        cArray = new char[n];
        XPCOM.memmove(cArray, l3, (long)(n * 2));
        String string3 = new String(cArray);
        long[] lArray = new long[1];
        XPCOM.memmove(lArray, l4, (long)C.PTR_SIZEOF);
        if (lArray[0] != 0L) {
            n = XPCOM.strlen_PRUnichar(lArray[0]);
            cArray = new char[n];
            XPCOM.memmove(cArray, lArray[0], (long)(n * 2));
            stringArray[0] = new String(cArray);
        }
        long[] lArray2 = new long[1];
        XPCOM.memmove(lArray2, l5, (long)C.PTR_SIZEOF);
        if (lArray2[0] != 0L) {
            n = XPCOM.strlen_PRUnichar(lArray2[0]);
            cArray = new char[n];
            XPCOM.memmove(cArray, lArray2[0], (long)(n * 2));
            stringArray2[0] = new String(cArray);
        }
        if (l6 != 0L && (n = XPCOM.strlen_PRUnichar(l6)) > 0) {
            cArray = new char[n];
            XPCOM.memmove(cArray, l6, (long)(n * 2));
            string2 = new String(cArray);
        }
        Shell shell = browser == null ? new Shell() : browser.getShell();
        PromptDialog promptDialog = new PromptDialog(shell);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (l7 != 0L) {
            XPCOM.memmove(nArray, l7, 4L);
        }
        promptDialog.promptUsernameAndPassword(string, string3, string2, stringArray, stringArray2, nArray, nArray2);
        XPCOM.memmove(l8, nArray2, 4L);
        if (nArray2[0] == 1) {
            nsIMemory nsIMemory2;
            byte[] byArray;
            nsIServiceManager nsIServiceManager2;
            int n2;
            long l9;
            int n3;
            char[] cArray2;
            int n4;
            long[] lArray3 = new long[1];
            if (stringArray[0] != null) {
                n4 = stringArray[0].length();
                cArray2 = new char[n4 + 1];
                stringArray[0].getChars(0, n4, cArray2, 0);
                n3 = cArray2.length * 2;
                l9 = C.malloc(n3);
                XPCOM.memmove(l9, cArray2, (long)n3);
                XPCOM.memmove(l4, new long[]{l9}, (long)C.PTR_SIZEOF);
                if (lArray[0] != 0L) {
                    n2 = XPCOM.NS_GetServiceManager(lArray3);
                    if (n2 != 0) {
                        SWT.error(n2);
                    }
                    if (lArray3[0] == 0L) {
                        SWT.error(-2147467262);
                    }
                    nsIServiceManager2 = new nsIServiceManager(lArray3[0]);
                    lArray3[0] = 0L;
                    byArray = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/xpcom/memory-service;1", true);
                    n2 = nsIServiceManager2.GetServiceByContractID(byArray, nsIMemory.NS_IMEMORY_IID, lArray3);
                    if (n2 != 0) {
                        SWT.error(n2);
                    }
                    if (nArray2[0] == 0) {
                        SWT.error(-2147467262);
                    }
                    nsIServiceManager2.Release();
                    nsIMemory2 = new nsIMemory(lArray3[0]);
                    lArray3[0] = 0L;
                    nsIMemory2.Free(lArray[0]);
                    nsIMemory2.Release();
                }
            }
            if (stringArray2[0] != null) {
                n4 = stringArray2[0].length();
                cArray2 = new char[n4 + 1];
                stringArray2[0].getChars(0, n4, cArray2, 0);
                n3 = cArray2.length * 2;
                l9 = C.malloc(n3);
                XPCOM.memmove(l9, cArray2, (long)n3);
                XPCOM.memmove(l5, new long[]{l9}, (long)C.PTR_SIZEOF);
                if (lArray2[0] != 0L) {
                    n2 = XPCOM.NS_GetServiceManager(lArray3);
                    if (n2 != 0) {
                        SWT.error(n2);
                    }
                    if (lArray3[0] == 0L) {
                        SWT.error(-2147467262);
                    }
                    nsIServiceManager2 = new nsIServiceManager(lArray3[0]);
                    lArray3[0] = 0L;
                    byArray = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/xpcom/memory-service;1", true);
                    n2 = nsIServiceManager2.GetServiceByContractID(byArray, nsIMemory.NS_IMEMORY_IID, lArray3);
                    if (n2 != 0) {
                        SWT.error(n2);
                    }
                    if (lArray3[0] == 0L) {
                        SWT.error(-2147467262);
                    }
                    nsIServiceManager2.Release();
                    nsIMemory2 = new nsIMemory(lArray3[0]);
                    lArray3[0] = 0L;
                    nsIMemory2.Free(lArray2[0]);
                    nsIMemory2.Release();
                }
            }
        }
        if (l7 != 0L) {
            XPCOM.memmove(l7, nArray, 4L);
        }
        return 0L;
    }

    public long PromptPassword(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        return -2147467263L;
    }

    public long Select(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        return -2147467263L;
    }
}

