/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.weblinks.bugs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.statcvs.Messages;
import net.sf.statcvs.pages.HTML;

public abstract class BugTracker {
    protected static final Pattern bugRegex = Pattern.compile("bug\\s*(?:number\\s*)?(?:#\\s*)?(\\d+)", 2);
    public static final BugTracker NO_BUG_TRACKER = new BugTracker(""){

        public String bugURL(String bugNumber) {
            return null;
        }

        public String getName() {
            return "No bug tracker";
        }

        public String toHTMLWithLinks(String plainText) {
            return HTML.webifyLinksFromPlainText(plainText);
        }
    };
    private final String baseURL;

    public BugTracker(String baseURL) {
        this.baseURL = baseURL + (baseURL.endsWith("/") ? "" : "/");
    }

    public abstract String getName();

    public String baseURL() {
        return this.baseURL;
    }

    public abstract String bugURL(String var1);

    public String toHTMLWithLinks(String plainTextInput) {
        if (this.baseURL() == null || this.baseURL().length() == 0) {
            return HTML.webifyLinksFromPlainText(plainTextInput);
        }
        StringBuffer result = new StringBuffer();
        Matcher m = bugRegex.matcher(plainTextInput);
        int offset = 0;
        while (m.find()) {
            String linkLabel = m.group();
            String bugNumber = m.group(1);
            String bugURL = this.bugURL(bugNumber);
            result.append(HTML.webifyLinksFromPlainText(plainTextInput.substring(offset, m.start())));
            if (bugURL == null) {
                result.append(HTML.webifyLinksFromPlainText(linkLabel));
            } else {
                result.append(HTML.getLink(bugURL, linkLabel, HTML.getIcon("bug.png", Messages.getString("BUG_ICON")), ""));
            }
            offset = m.end();
        }
        result.append(HTML.webifyLinksFromPlainText(plainTextInput.substring(offset, plainTextInput.length())));
        return result.toString();
    }
}

