/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reports;

import net.sf.statcvs.model.Revision;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

public class LOCSeriesBuilder {
    private final TimeSeries series;
    private boolean hasRevisions = false;
    private Minute minute;
    private int loc = 0;
    private boolean finished = false;
    private final boolean countEffective;
    private int maximum = 0;

    public LOCSeriesBuilder(String seriesTitle, boolean countEffective) {
        this.series = new TimeSeries((Comparable)((Object)seriesTitle), Minute.class);
        this.countEffective = countEffective;
    }

    public void addRevision(Revision revision) {
        if (this.finished) {
            throw new IllegalStateException("can't add more revisions after getTimeSeries()");
        }
        if (!this.hasRevisions) {
            if (revision.isBeginOfLog()) {
                this.loc += revision.getLines();
                return;
            }
            this.minute = new Minute(revision.getDate());
            RegularTimePeriod previousMinute = this.minute.previous();
            if (previousMinute == null) {
                previousMinute = new Minute(59, (Hour)this.minute.getHour().previous());
            }
            this.series.add(previousMinute, this.loc);
            this.hasRevisions = true;
        } else {
            Minute currentMinute = new Minute(revision.getDate());
            if (!currentMinute.equals(this.minute)) {
                this.series.add((RegularTimePeriod)this.minute, this.loc);
                this.minute = currentMinute;
            }
        }
        this.loc = this.countEffective ? (this.loc += revision.getLinesDelta()) : (this.loc += revision.getNewLines());
        this.maximum = Math.max(this.maximum, this.loc);
    }

    public TimeSeries getTimeSeries() {
        if (!this.hasRevisions) {
            return null;
        }
        if (!this.finished) {
            this.series.add((RegularTimePeriod)this.minute, this.loc);
            this.series.add(this.minute.next(), this.loc);
            this.finished = true;
        }
        return this.series;
    }

    public int getMaximum() {
        return this.maximum;
    }
}

