/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reports;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.reportmodel.IntegerColumn;
import net.sf.statcvs.reportmodel.SimpleTextColumn;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.reports.TableReport;
import net.sf.statcvs.util.IntegerMap;

public class CloudCommitTableReport
implements TableReport {
    private static final String ENGLISH_EXCLUSIONS = "\\d+|an|the|me|my|we|you|he|she|it|are|is|am|will|shall|should|would|had|have|has|was|were|be|been|this|that|there||who|when|how|where|which|already|after|by|on|or|so|some|commit|also|got|get|do|don't|from|all|but|yet|to|in|does|doesn'tout|of|for|if|yes|no|not|may|might|can|could|at|as|with|without|some|more|lot|lots|than|then|adding|added|work|they|used|still|show|must|into|same";
    private Table table = null;
    private final ReportConfig config;
    private final Repository content;
    private final IntegerMap cloudMap = new IntegerMap();
    private Pattern excluded;

    public CloudCommitTableReport(ReportConfig config) {
        this.content = config.getRepository();
        this.config = config;
    }

    public void calculate() {
        if (this.table != null) {
            return;
        }
        if (this.excluded == null) {
            this.excluded = Pattern.compile(ConfigurationOptions.getConfigStringProperty("cloud.exclusionRegExp", ENGLISH_EXCLUSIONS), 2);
        }
        String summary = Messages.getString("CLOUD_TABLE_TITLE");
        this.table = new Table(summary);
        SimpleTextColumn wordColumn = new SimpleTextColumn(Messages.getString("CLOUD_WORD_COL"));
        IntegerColumn frequencyColumn = new IntegerColumn(Messages.getString("CLOUD_COUNT_COL"));
        frequencyColumn.setShowPercentages(true);
        this.table.addColumn(wordColumn);
        this.table.addColumn(frequencyColumn);
        this.table.setKeysInFirstColumn(true);
        this.calculate(this.content.getCommits());
        int lines = 0;
        Integer minFrequency = ConfigurationOptions.getConfigIntegerProperty("cloud.minFrequency", new Integer(5));
        Integer maxNumbers = ConfigurationOptions.getConfigIntegerProperty("cloud.maxWordNumberInTable", new Integer(50));
        Iterator it = this.cloudMap.iteratorSortedByValueReverse();
        double maxFreq = -1.0;
        while (it.hasNext()) {
            String word = (String)it.next();
            int frequency = this.cloudMap.get(word);
            if (maxFreq < 0.0) {
                maxFreq = Math.log(frequency);
            }
            if (frequency < minFrequency) break;
            wordColumn.addValue(word);
            frequencyColumn.addValue(frequency);
            if (++lines < maxNumbers) continue;
            break;
        }
    }

    private void calculate(List commits) {
        Iterator it = commits.iterator();
        Integer minSize = ConfigurationOptions.getConfigIntegerProperty("cloud.minLengthForWord", new Integer(4));
        while (it.hasNext()) {
            String comment;
            Commit commit = (Commit)it.next();
            if (commit.getAuthor() == null || !this.config.isDeveloper(commit.getAuthor()) || (comment = commit.getComment()) == null || comment.length() <= minSize) continue;
            String[] split = comment.split("\\W+");
            for (int i = 0; i < split.length; ++i) {
                String word = split[i];
                if (word == null || word.length() < minSize) continue;
                this.tryToAdd(word.toLowerCase());
            }
        }
    }

    private void tryToAdd(String word) {
        Matcher m = this.excluded.matcher(word);
        if (m.matches()) {
            return;
        }
        this.mergeIfRequired(word, "ed", 1);
        this.mergeIfRequired(word, "ing", 3);
        this.mergeIfRequired(word, "es", 1);
        this.mergeIfRequired(word, "s", 1);
    }

    private void mergeIfRequired(String word, String suffix, int toRemove) {
        String chopped;
        this.cloudMap.addInt(word, 1);
        if (word.endsWith(suffix) && this.cloudMap.contains(chopped = word.substring(0, word.length() - toRemove))) {
            this.cloudMap.addInt(chopped, this.cloudMap.get(word));
            this.cloudMap.remove(word);
        }
    }

    public Table getTable() {
        return this.table;
    }

    public String getRawContent() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<p>");
        int lines = 0;
        Iterator it = this.cloudMap.iteratorSortedByValueReverse();
        Integer minFrequency = ConfigurationOptions.getConfigIntegerProperty("cloud.minFrequency", new Integer(5));
        Integer maxNumbers = ConfigurationOptions.getConfigIntegerProperty("cloud.maxWordNumberInCloud", new Integer(100));
        double maxFreq = -1.0;
        TreeMap<String, String> tm = new TreeMap<String, String>();
        while (it.hasNext()) {
            String word = (String)it.next();
            int frequency = this.cloudMap.get(word);
            if (maxFreq < 0.0) {
                maxFreq = Math.log(frequency);
            }
            if (frequency < minFrequency) break;
            long fontSize = Math.round(Math.min(-2.0 + Math.log(frequency) * 10.0 / maxFreq, 8.0));
            StringBuffer buffer1 = new StringBuffer();
            buffer1.append("<font size=\"").append(fontSize).append("\">").append(word).append(" </font> ");
            tm.put(word, buffer1.toString());
            if (++lines < maxNumbers) continue;
            break;
        }
        Iterator it2 = tm.values().iterator();
        while (it2.hasNext()) {
            buffer.append(it2.next());
        }
        buffer.append("</p>");
        return buffer.toString();
    }
}

