/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reports;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.reportmodel.GenericColumn;
import net.sf.statcvs.reportmodel.IntegerColumn;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.util.IntegerMap;

public abstract class AbstractRollingLocTableReport {
    private static final int NUMBER_OF_MONTHS = 12;
    public static final int SORT_BY_NAME = 0;
    public static final int SORT_BY_LINES = 1;
    private final ReportConfig config;
    private final Repository content;
    private final List changesMaps;
    private final List linesMaps;
    private final IntegerMap authors = new IntegerMap();
    private Date cutOff;

    public AbstractRollingLocTableReport(ReportConfig config) {
        this.config = config;
        this.content = config.getRepository();
        this.changesMaps = new ArrayList(13);
        this.linesMaps = new ArrayList(13);
        for (int i = 0; i < 13; ++i) {
            this.changesMaps.add(new IntegerMap());
            this.linesMaps.add(new IntegerMap());
        }
    }

    protected void calculateChangesAndLinesPerDeveloper(Collection revs) {
        Iterator it = revs.iterator();
        Date last = this.content.getLastDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(last);
        cal.add(2, -11);
        cal.set(5, 1);
        cal.add(5, -1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        this.cutOff = cal.getTime();
        while (it.hasNext()) {
            Revision rev = (Revision)it.next();
            if (rev.getAuthor() == null || !this.config.isDeveloper(rev.getAuthor())) continue;
            IntegerMap changesMap = this.findMap(cal, rev.getDate(), this.cutOff, this.changesMaps);
            IntegerMap linesMap = this.findMap(cal, rev.getDate(), this.cutOff, this.linesMaps);
            changesMap.addInt(rev.getAuthor(), 1);
            linesMap.addInt(rev.getAuthor(), rev.getNewLines());
            this.authors.addInt(rev.getAuthor(), rev.getNewLines());
        }
    }

    private IntegerMap findMap(Calendar cal, Date date, Date cutOff, List listOfMaps) {
        if (date.compareTo(cutOff) < 0) {
            return (IntegerMap)listOfMaps.get(0);
        }
        cal.setTime(cutOff);
        int cutOffMonth = cal.get(2) + 1;
        cal.setTime(date);
        int monthRev = cal.get(2) + 1;
        int idx = monthRev - cutOffMonth;
        if (idx < 0) {
            idx += 12;
        }
        if (idx == 0) {
            idx = 12;
        }
        return (IntegerMap)listOfMaps.get(idx);
    }

    protected Table createChangesAndLinesTable(GenericColumn keys, GenericColumn keys2, String summary) {
        Table result = new Table(summary);
        keys.setTotal(Messages.getString("TOTALS"));
        result.addColumn(keys);
        if (keys2 != null) {
            keys.setTotal("");
            keys2.setTotal(Messages.getString("TOTALS"));
            result.addColumn(keys2);
        }
        result.setKeysInFirstColumn(true);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.cutOff);
        ArrayList<IntegerColumn> columns = new ArrayList<IntegerColumn>();
        for (int i = 0; i < 13; ++i) {
            String title = null;
            if (i == 0) {
                title = "Up to " + (cal.get(2) + 1) + "/" + cal.get(1);
            }
            if (i != 0) {
                cal.add(2, 1);
                title = "" + (cal.get(2) + 1) + "/" + cal.get(1);
            }
            IntegerColumn column = new IntegerColumn(title);
            columns.add(column);
            result.addColumn(column);
        }
        Iterator it = this.authors.iteratorSortedByValueReverse();
        while (it.hasNext()) {
            Object key = it.next();
            keys.addValue(key);
            if (keys2 != null) {
                keys2.addValue(key);
            }
            for (int i = 0; i < 13; ++i) {
                IntegerMap linesMap = (IntegerMap)this.linesMaps.get(i);
                ((IntegerColumn)columns.get(i)).addValue(linesMap.get(key));
            }
        }
        if (result.getRowCount() > 1) {
            result.setShowTotals(true);
        }
        return result;
    }

    protected Repository getContent() {
        return this.content;
    }

    public int getDeveloperCount() {
        int result = 0;
        Iterator it = this.getContent().getAuthors().iterator();
        while (it.hasNext()) {
            Author author = (Author)it.next();
            if (!this.config.isDeveloper(author)) continue;
            ++result;
        }
        return result;
    }
}

