/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reportmodel;

import java.util.Date;

class HelperTimePoint
implements Comparable {
    private final Date date;
    private final int value;
    private final boolean isAbsolute;

    private HelperTimePoint(Date date, int value, boolean isAbsolute) {
        this.date = date;
        this.value = value;
        this.isAbsolute = isAbsolute;
    }

    public static HelperTimePoint createAbsoluteValueTimePoint(Date date, int value) {
        return new HelperTimePoint(date, value, true);
    }

    public static HelperTimePoint createDeltaTimePoint(Date date, int delta) {
        return new HelperTimePoint(date, delta, false);
    }

    public HelperTimePoint join(HelperTimePoint other) {
        if (!this.date.equals(other.getDate())) {
            throw new IllegalArgumentException("Can only add time points having the same date");
        }
        if (this.isAbsolute) {
            return this;
        }
        if (other.isAbsolute()) {
            return other;
        }
        return HelperTimePoint.createDeltaTimePoint(this.date, this.value + other.getValue());
    }

    public Date getDate() {
        return this.date;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public int compareTo(Object o) {
        HelperTimePoint other = (HelperTimePoint)o;
        return this.getDate().compareTo(other.getDate());
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof HelperTimePoint)) {
            return false;
        }
        HelperTimePoint that = (HelperTimePoint)rhs;
        boolean eq = this.getDate().equals(that.getDate());
        return eq;
    }

    public int hashCode() {
        return this.getDate().hashCode();
    }
}

