/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.SymbolicName;
import net.sf.statcvs.output.ReportConfig;
import org.jdom.Element;

public class RevisedFilesXml {
    private static final String[] MONTH_TWO_CHARACTERS = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
    private final Repository repo;
    private final List commits = new ArrayList();

    public static String getAnchor(SymbolicName tag) {
        return "tag-" + tag.getName();
    }

    public static String getURL(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return RevisedFilesXml.getFileName(calendar.get(1), calendar.get(2)) + ".html";
    }

    private static String getFileName(int year, int month) {
        return year + "-" + MONTH_TWO_CHARACTERS[month];
    }

    public RevisedFilesXml(ReportConfig config) {
        this.repo = config.getRepository();
        Iterator it = this.repo.getCommits().iterator();
        while (it.hasNext()) {
            Commit commit = (Commit)it.next();
            this.commits.add(commit);
        }
        Collections.reverse(this.commits);
    }

    public Element toFile() throws NoSuchElementException {
        Set files = null;
        Hashtable coms = new Hashtable();
        Iterator commitIt = this.commits.iterator();
        Commit nextCommit = commitIt.hasNext() ? (Commit)commitIt.next() : null;
        ArrayList<String> al = new ArrayList<String>();
        while (nextCommit != null) {
            files = nextCommit.getAffectedFiles();
            Iterator it = files.iterator();
            String auth = nextCommit.getAuthor().toString();
            while (it.hasNext()) {
                String path = it.next().toString();
                if (!coms.containsKey(path)) {
                    al.add(path);
                    ArrayList<String> a = new ArrayList<String>();
                    a.add(auth);
                    coms.put(path, a);
                    continue;
                }
                ArrayList alist = (ArrayList)coms.get(path);
                Iterator iter = alist.iterator();
                ArrayList<String> l = new ArrayList<String>();
                for (int i = 0; i < alist.size(); ++i) {
                    l.add(iter.next().toString());
                }
                l.add(auth);
                coms.remove(path);
                coms.put(path, l);
            }
            nextCommit = commitIt.hasNext() ? (Commit)commitIt.next() : null;
        }
        Element lg = new Element("RevisedFiles");
        Iterator it = al.iterator();
        while (it.hasNext()) {
            Element file = new Element("File");
            Element path = new Element("Path");
            String str = it.next().toString();
            path.setText(str);
            ArrayList a = (ArrayList)coms.get(str);
            Iterator itr = a.iterator();
            file.addContent(path);
            while (itr.hasNext()) {
                String s = itr.next().toString();
                Element auth = new Element("Author");
                auth.setText(s);
                file.addContent(auth);
            }
            lg.addContent(file);
        }
        return lg;
    }
}

