/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.SymbolicName;
import net.sf.statcvs.pages.xml.XML;
import net.sf.statcvs.renderer.FileCollectionFormatter;
import org.jdom.CDATA;
import org.jdom.Element;

public class CommitListXml {
    private final List commits;
    private final List tags;
    private final HashMap commitHashMap = new HashMap();

    public CommitListXml(List commits, List tags, boolean withPermalinks) {
        this(commits, tags, Integer.MAX_VALUE, withPermalinks);
    }

    public CommitListXml(List commit, List tags, int max, boolean withPermalinks) {
        this.commits = new ArrayList(commit);
        this.tags = tags;
        Collections.reverse(this.commits);
    }

    public Element renderCommitList(List commitList) {
        SymbolicName nextTag;
        if (commitList.isEmpty()) {
            return null;
        }
        int id = commitList.size();
        Element lg = new Element("Commits");
        Iterator commitIt = commitList.iterator();
        Commit nextCommit = commitIt.hasNext() ? (Commit)commitIt.next() : null;
        Iterator tagIt = this.tags.iterator();
        SymbolicName symbolicName = nextTag = tagIt.hasNext() ? (SymbolicName)tagIt.next() : null;
        while (nextCommit != null) {
            Element log = null;
            if (nextTag == null || nextCommit.getDate().getTime() > nextTag.getDate().getTime()) {
                log = this.renderCommit(nextCommit, id);
                nextCommit = commitIt.hasNext() ? (Commit)commitIt.next() : null;
                --id;
            } else {
                nextTag = tagIt.hasNext() ? (SymbolicName)tagIt.next() : null;
            }
            lg.addContent(log);
        }
        return lg;
    }

    private Element renderCommit(Commit commit, int id) {
        Element cmt = new Element("Commit");
        cmt.setAttribute("date", this.getDate(commit));
        cmt.setAttribute("author", this.getAuthor(commit));
        cmt.setAttribute("loc_change", this.getLinesOfCode(commit));
        String revision = this.getRevisionNumber(commit);
        if (revision != null) {
            cmt.setAttribute("revision", revision);
        }
        Element comment = new Element("Comment");
        CDATA theActualComment = new CDATA(commit.getComment());
        comment.addContent(theActualComment);
        cmt.addContent(comment);
        cmt.addContent(this.getAffectedFiles(commit));
        return cmt;
    }

    private String getRevisionNumber(Commit commit) {
        HashSet<String> rev = new HashSet<String>();
        Iterator it = commit.getRevisions().iterator();
        while (it.hasNext()) {
            rev.add(((Revision)it.next()).getRevisionNumber());
        }
        if (rev.size() == 1) {
            return (String)rev.iterator().next();
        }
        return null;
    }

    private String getDate(Commit commit) {
        return XML.getDateAndTime(commit.getDate());
    }

    private String getAuthor(Commit commit) {
        return XML.getAuthorLink(commit.getAuthor());
    }

    private String getLinesOfCode(Commit commit) {
        Iterator it = commit.getRevisions().iterator();
        int locSum = 0;
        while (it.hasNext()) {
            Revision each = (Revision)it.next();
            locSum += each.getNewLines();
            this.saveRevision(each);
        }
        return Integer.toString(locSum);
    }

    private void saveRevision(Revision revision) {
        this.commitHashMap.put(revision.getFile().getFilenameWithPath(), revision);
    }

    private Element getAffectedFiles(Commit commit) {
        Element result = new Element("FilesAffected");
        FileCollectionFormatter formatter = new FileCollectionFormatter(commit.getAffectedFiles());
        Iterator it = formatter.getDirectories().iterator();
        while (it.hasNext()) {
            String directory = (String)it.next();
            Iterator files = formatter.getFiles(directory).iterator();
            StringBuffer fileList = new StringBuffer();
            while (files.hasNext()) {
                Element File2 = new Element("File");
                if (fileList.length() > 0) {
                    fileList.append(",\n");
                }
                String file = (String)files.next();
                Element path = new Element("Path").setText(directory + file);
                File2.addContent(path);
                Revision revision = (Revision)this.commitHashMap.get(directory + file);
                if (revision.isInitialRevision()) {
                    int linesAdded = revision.getLines();
                    File2.setAttribute("action", "new");
                    if (linesAdded > 0) {
                        File2.addContent(new Element("LocAdd").setText(Integer.toString(linesAdded)));
                    }
                } else if (revision.isDead()) {
                    File2.setAttribute("action", "deleted");
                } else {
                    int delta = revision.getLinesDelta();
                    int linesAdded = revision.getReplacedLines() + (delta > 0 ? delta : 0);
                    int linesRemoved = revision.getReplacedLines() - (delta < 0 ? delta : 0);
                    if (linesAdded > 0) {
                        File2.setAttribute("action", "changed");
                        File2.addContent(new Element("LocAdd").setText(Integer.toString(linesAdded)));
                        if (linesRemoved > 0) {
                            File2.addContent(new Element("LocRem").setText(Integer.toString(linesRemoved)));
                        }
                    } else if (linesRemoved > 0) {
                        File2.setAttribute("action", "changed");
                        File2.addContent(new Element("LocAdd").setText("0"));
                        File2.addContent(new Element("LocRem").setText(Integer.toString(linesRemoved)));
                    } else {
                        File2.setAttribute("action", "binary file or keyword subst change");
                    }
                }
                result.addContent(File2);
            }
        }
        return result;
    }
}

