/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.Messages;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.charts.LOCChartMaker;
import net.sf.statcvs.charts.ModuleEvolutionChartMaker;
import net.sf.statcvs.charts.ModuleSizePieChartMaker;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.NavigationNode;
import net.sf.statcvs.pages.Page;
import net.sf.statcvs.reports.ModuleTableReport;
import net.sf.statcvs.util.ModuleUtil;

public class ModulesPageMaker {
    private final ReportConfig config;
    private final Repository repository;

    public ModulesPageMaker(ReportConfig config) {
        this.config = config;
        this.repository = config.getRepository();
    }

    public NavigationNode toFile() {
        ChartImage allDirLOCChart = new LOCChartMaker.AllModulesLOCChartMaker(this.config, 6).toFile();
        Page page = this.config.createPage("modules", Messages.getString("MODULES_SIZES_TITLE"), Messages.getString("MODULES_SIZES_SUBTITLE"));
        List moduleIds = ModuleUtil.getConfigModules();
        Iterator mod = moduleIds.iterator();
        while (mod.hasNext()) {
            String moduleId = (String)mod.next();
            String pattern = ModuleUtil.getConfigModuleRegexp(moduleId);
            String name = ModuleUtil.getConfigModuleName(moduleId);
            page.addAttribute(name, pattern);
        }
        page.addSection(Messages.getString("MODULES_CURRENT_SIZES_TITLE"));
        ChartImage dirSizesChart = new ModuleSizePieChartMaker("modules_sizes", this.config, Messages.getString("PIE_MODSIZE_TITLE"), Messages.getString("PIE_MODSIZE_SUBTITLE"), "modules_sizes.png").toFile();
        page.add(dirSizesChart);
        ModuleTableReport table = new ModuleTableReport(this.repository);
        page.addSection(Messages.getString("MODULES_LOC_TITLE"));
        page.add(allDirLOCChart);
        page.addSection(Messages.getString("MODULES_EVO_TITLE"));
        ChartImage modEvoChart = new ModuleEvolutionChartMaker("modules_evolution", this.config, Messages.getString("MODULE_EVO_TITLE"), "modules_evolution.png").toFile();
        page.add(modEvoChart);
        page.addSection(Messages.getString("MODULES_STATS_TITLE"));
        page.add(table);
        return page;
    }
}

