/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import net.sf.statcvs.Messages;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.pages.AbstractMarkup;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.pages.MarkupSyntax;
import net.sf.statcvs.util.FileUtils;

public class MarkupHTML
extends AbstractMarkup
implements MarkupSyntax {
    private static final MarkupSyntax instance = new MarkupHTML();

    public static MarkupSyntax getInstance() {
        return instance;
    }

    private MarkupHTML() {
    }

    public String getExtension() {
        return "html";
    }

    public String getHeader(String pageName, String stylesheetURL, String charSet) {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version=\"1.0\"?>\n");
        b.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" ");
        b.append("\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
        b.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
        b.append("<head>\n    <title>");
        b.append(Messages.getString("PROJECT_SHORTNAME"));
        b.append(" - ");
        b.append(pageName);
        b.append("</title>\n");
        b.append(" <meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
        b.append(charSet);
        b.append("\"/>\n");
        b.append("    <meta name=\"Generator\" content=\"");
        b.append(Messages.getString("PROJECT_SHORTNAME"));
        b.append(" ");
        b.append(Messages.getString("PROJECT_VERSION"));
        b.append("\"/>\n");
        b.append("<link rel=\"stylesheet\" href=\"");
        b.append(HTML.escape(stylesheetURL));
        b.append("\" type=\"text/css\"/>\n");
        if (ConfigurationOptions.isEnableTwitterButton()) {
            this.addTwitterScript(b);
        }
        b.append("  </head>\n\n<body>\n");
        if (ConfigurationOptions.getHeaderUrl() != null) {
            b.append(FileUtils.readTextFromURL(ConfigurationOptions.getHeaderUrl()));
        }
        return b.toString();
    }

    public String getEndOfPage() {
        StringBuffer b = new StringBuffer();
        if (ConfigurationOptions.getFooterUrl() != null) {
            b.append(FileUtils.readTextFromURL(ConfigurationOptions.getFooterUrl()));
        }
        b.append("</body>\n</html>");
        return b.toString();
    }

    public String startSection1(String title) {
        return "\n<h1>" + title + "</h1>\n";
    }

    public String endSection1() {
        return "";
    }

    public String startSection2(String title) {
        return "\n<div class=\"section\">\n<h2>" + title + "</h2>\n";
    }

    public String startSection2(String title, String id) {
        return "\n<div id=\"" + HTML.escape(id) + "\" class=\"section\">\n<h2>" + title + "</h2>\n";
    }

    public String endSection2() {
        return "</div>";
    }

    public String getTableFormat() {
        return "";
    }

    public String toString() {
        return "HTML";
    }
}

