/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.Messages;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.charts.LOCChartMaker;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.output.WebRepositoryIntegration;
import net.sf.statcvs.pages.CommitListFormatter;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.pages.Page;
import net.sf.statcvs.reports.AuthorsForDirectoryTableReport;

public class DirectoryPageMaker {
    private static final int RECENT_COMMITS_LENGTH = 40;
    private final ReportConfig config;
    private final Repository repository;
    private final Directory directory;

    public static String getURL(Directory directory) {
        return DirectoryPageMaker.getFilename(directory) + ".html";
    }

    private static String getFilename(Directory directory) {
        return "dir" + HTML.escapeDirectoryName(directory.getPath());
    }

    public DirectoryPageMaker(ReportConfig config, Directory directory) {
        this.config = config;
        this.repository = config.getRepository();
        this.directory = directory;
    }

    public Page toFile() {
        List dirCommits;
        ChartImage chart = new LOCChartMaker.DirectoryLOCChartMaker(this.config, this.directory).toFile();
        String title = "Directory " + (this.directory.isRoot() ? "[root]" : this.directory.getPath());
        Page page = this.config.createPage(DirectoryPageMaker.getFilename(this.directory), title, title);
        if (!this.directory.getRevisions().isEmpty() && this.isInitiallyEmpty()) {
            page.addAttribute("Directory Created", ((Revision)this.directory.getRevisions().first()).getDate());
        }
        if (!this.directory.getRevisions().isEmpty() && this.getCurrentFileCount() == 0) {
            page.addAttribute("Directory Deleted", ((Revision)this.directory.getRevisions().last()).getDate());
        }
        page.addAttribute("Total Files", this.getCurrentFileCount());
        page.addAttribute("Deleted Files", this.getDeadFileCount());
        page.addAttribute("Lines of Code", this.getCurrentLOC());
        if (this.config.getWebRepository() != null) {
            WebRepositoryIntegration rep = this.config.getWebRepository();
            String text = Messages.getString("BROWSE_WEB_REPOSITORY") + " " + rep.getName();
            page.addLink(rep.getDirectoryUrl(this.directory), text);
        }
        page.add(this.directory, true);
        if (chart != null) {
            page.addSection(Messages.getString("LOC_TITLE"));
            page.add(chart);
        }
        if (!this.directory.getRevisions().isEmpty()) {
            page.addSection("Developers");
            page.add(new AuthorsForDirectoryTableReport(this.config, this.directory));
        }
        if (!(dirCommits = this.getCommitsInDirectory()).isEmpty()) {
            page.addSection(Messages.getString("MOST_RECENT_COMMITS"));
            CommitListFormatter renderer = new CommitListFormatter(this.config, dirCommits, Collections.EMPTY_LIST, 40, false);
            page.addRawContent(renderer.render());
        }
        return page;
    }

    private Commit getCommit(Revision rev) {
        Iterator it = this.repository.getCommits().iterator();
        while (it.hasNext()) {
            Commit commit = (Commit)it.next();
            if (!commit.getRevisions().contains(rev)) continue;
            return commit;
        }
        return null;
    }

    private List getCommitsInDirectory() {
        HashMap<Commit, Commit> commitsToFilteredCommits = new HashMap<Commit, Commit>();
        Iterator it = this.directory.getRevisions().iterator();
        while (it.hasNext()) {
            Commit filteredCommit;
            Revision rev = (Revision)it.next();
            Commit commit = this.getCommit(rev);
            if (commit == null) continue;
            if (commitsToFilteredCommits.containsKey(commit)) {
                filteredCommit = (Commit)commitsToFilteredCommits.get(commit);
                filteredCommit.addRevision(rev);
                continue;
            }
            filteredCommit = new Commit(rev);
            commitsToFilteredCommits.put(commit, filteredCommit);
        }
        ArrayList commits = new ArrayList(commitsToFilteredCommits.values());
        Collections.sort(commits);
        return commits;
    }

    private int getCurrentLOC() {
        int result = 0;
        Iterator it = this.directory.getFiles().iterator();
        while (it.hasNext()) {
            VersionedFile file = (VersionedFile)it.next();
            result += file.getCurrentLinesOfCode();
        }
        return result;
    }

    private int getCurrentFileCount() {
        int result = 0;
        Iterator it = this.directory.getFiles().iterator();
        while (it.hasNext()) {
            VersionedFile file = (VersionedFile)it.next();
            if (file.isDead()) continue;
            ++result;
        }
        return result;
    }

    private int getDeadFileCount() {
        int result = 0;
        Iterator it = this.directory.getFiles().iterator();
        while (it.hasNext()) {
            VersionedFile file = (VersionedFile)it.next();
            if (!file.isDead()) continue;
            ++result;
        }
        return result;
    }

    private boolean isInitiallyEmpty() {
        Iterator it = this.directory.getFiles().iterator();
        while (it.hasNext()) {
            VersionedFile file = (VersionedFile)it.next();
            if (file.getInitialRevision().isInitialRevision()) continue;
            return false;
        }
        return true;
    }
}

