/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.SymbolicName;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.output.WebRepositoryIntegration;
import net.sf.statcvs.pages.CommitLogPageMaker;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.renderer.FileCollectionFormatter;

public class CommitListFormatter {
    private final ReportConfig config;
    private final List commits;
    private final List tags;
    private final int max;
    private final boolean withPermalinks;
    private final HashMap commitHashMap = new HashMap();

    public CommitListFormatter(ReportConfig config, List commits, List tags, boolean withPermalinks) {
        this(config, commits, tags, Integer.MAX_VALUE, withPermalinks);
    }

    public CommitListFormatter(ReportConfig config, List commit, List tags, int max, boolean withPermalinks) {
        this.config = config;
        this.commits = new ArrayList(commit);
        this.tags = tags;
        this.max = max;
        this.withPermalinks = withPermalinks;
        Collections.reverse(this.commits);
    }

    public String render() {
        if (this.commits.size() > this.max) {
            List recentCommits = this.commits.subList(0, this.max);
            return this.renderCommitList(recentCommits) + "<p>(" + (this.commits.size() - this.max) + " " + Messages.getString("MORE_COMMITS") + ")</p>\n";
        }
        return this.renderCommitList(this.commits);
    }

    private String renderCommitList(List commitList) {
        SymbolicName nextTag;
        if (commitList.isEmpty()) {
            return "<p>No commits</p>\n";
        }
        int id = commitList.size();
        StringBuffer result = new StringBuffer("<dl class=\"commitlist\">\n");
        Iterator commitIt = commitList.iterator();
        Commit nextCommit = commitIt.hasNext() ? (Commit)commitIt.next() : null;
        Iterator tagIt = this.tags.iterator();
        SymbolicName symbolicName = nextTag = tagIt.hasNext() ? (SymbolicName)tagIt.next() : null;
        while (nextCommit != null) {
            if (nextTag == null || nextCommit.getDate().getTime() > nextTag.getDate().getTime()) {
                result.append(this.renderCommit(nextCommit, id));
                nextCommit = commitIt.hasNext() ? (Commit)commitIt.next() : null;
                --id;
                continue;
            }
            this.renderTag(result, nextTag);
            nextTag = tagIt.hasNext() ? (SymbolicName)tagIt.next() : null;
        }
        result.append("</dl>\n\n");
        return result.toString();
    }

    private void renderTag(StringBuffer s, SymbolicName tag) {
        String anchor = HTML.escape(CommitLogPageMaker.getAnchor(tag));
        s.append("  <dt class=\"tag\"><a name=\"").append(anchor).append("\">\n");
        s.append("    Repository Tag: ").append(HTML.escape(tag.getName())).append("</a>\n");
        s.append("  </dt>\n");
    }

    private String renderCommit(Commit commit, int id) {
        String revisionNumber;
        StringBuffer result = new StringBuffer();
        result.append("  <dt><a name=\"" + id + "\"></a>\n");
        result.append("    ").append(this.getAuthor(commit)).append("\n");
        result.append("    ").append(this.getDate(commit)).append("\n");
        if (this.withPermalinks) {
            result.append("    ").append(this.getPermalink(id)).append("\n");
        }
        if ((revisionNumber = this.getRevisionNumber(commit)) != null) {
            result.append("    ").append(revisionNumber).append("\n");
        }
        result.append("  </dt>\n");
        result.append("  <dd>\n");
        result.append("    <p class=\"comment\">\n");
        result.append(this.getComment(commit)).append("\n");
        result.append("    </p>\n");
        result.append("    <p class=\"commitdetails\"><strong>");
        result.append(this.getLinesOfCode(commit)).append("</strong> ");
        result.append("lines of code changed in ");
        result.append(this.getAffectedFilesCount(commit));
        result.append(":</p>\n");
        result.append(this.getAffectedFiles(commit)).append("  </dd>\n\n");
        return result.toString();
    }

    private String getPermalink(int id) {
        return "<a class=\"permalink\" title=\"Permalink to this commit\" href=\"#" + id + "\">#" + id + "</a>";
    }

    private String getRevisionNumber(Commit commit) {
        HashSet<String> rev = new HashSet<String>();
        Iterator it = commit.getRevisions().iterator();
        while (it.hasNext()) {
            rev.add(((Revision)it.next()).getRevisionNumber());
        }
        if (rev.size() == 1) {
            return HTML.getRevisionNumber((String)rev.iterator().next());
        }
        return null;
    }

    private String getDate(Commit commit) {
        return HTML.getDateAndTime(commit.getDate());
    }

    private String getAuthor(Commit commit) {
        return HTML.getAuthorLink(commit.getAuthor());
    }

    private String getAffectedFilesCount(Commit commit) {
        return HTML.getAffectedFilesCount(commit.getRevisions());
    }

    private String getComment(Commit commit) {
        return this.config.getWebBugtracker().toHTMLWithLinks(commit.getComment());
    }

    private String getLinesOfCode(Commit commit) {
        Iterator it = commit.getRevisions().iterator();
        int locSum = 0;
        while (it.hasNext()) {
            Revision each = (Revision)it.next();
            locSum += each.getNewLines();
            this.saveRevision(each);
        }
        return Integer.toString(locSum);
    }

    private void saveRevision(Revision revision) {
        this.commitHashMap.put(revision.getFile().getFilenameWithPath(), revision);
    }

    private String getAffectedFiles(Commit commit) {
        StringBuffer result = new StringBuffer("    <ul class=\"commitdetails\">\n");
        FileCollectionFormatter formatter = new FileCollectionFormatter(commit.getAffectedFiles());
        Iterator it = formatter.getDirectories().iterator();
        while (it.hasNext()) {
            result.append("      <li>\n");
            String directory = (String)it.next();
            if (!directory.equals("")) {
                result.append("        <strong>").append(directory.substring(0, directory.length() - 1)).append("</strong>:\n");
            }
            Iterator files = formatter.getFiles(directory).iterator();
            StringBuffer fileList = new StringBuffer();
            while (files.hasNext()) {
                if (fileList.length() > 0) {
                    fileList.append(",\n");
                }
                fileList.append("        ");
                String file = (String)files.next();
                Revision revision = (Revision)this.commitHashMap.get(directory + file);
                WebRepositoryIntegration webRepository = this.config.getWebRepository();
                if (webRepository != null) {
                    Revision previous = revision.getPreviousRevision();
                    String url = previous == null || revision.isInitialRevision() ? webRepository.getFileViewUrl(revision) : (revision.isDead() ? webRepository.getFileViewUrl(previous) : webRepository.getDiffUrl(previous, revision));
                    fileList.append("<a href=\"").append(HTML.escapeUrl(url)).append("\" class=\"webrepository\">").append(HTML.escape(file)).append("</a>");
                } else {
                    fileList.append(file);
                }
                if (revision.isInitialRevision()) {
                    int linesAdded = revision.getLines();
                    fileList.append("&#160;<span class=\"new\">(new");
                    if (linesAdded > 0) {
                        fileList.append("&#160;").append(linesAdded);
                    }
                    fileList.append(")</span>");
                    continue;
                }
                if (revision.isDead()) {
                    fileList.append("&#160;<span class=\"del\">(del)</span>");
                    continue;
                }
                int delta = revision.getLinesDelta();
                int linesAdded = revision.getReplacedLines() + (delta > 0 ? delta : 0);
                int linesRemoved = revision.getReplacedLines() - (delta < 0 ? delta : 0);
                fileList.append("&#160;<span class=\"change\">(");
                if (linesAdded > 0) {
                    fileList.append("+").append(linesAdded);
                    if (linesRemoved > 0) {
                        fileList.append("&#160;-").append(linesRemoved);
                    }
                } else if (linesRemoved > 0) {
                    fileList.append("-").append(linesRemoved);
                } else {
                    fileList.append("changed");
                }
                fileList.append(")</span>");
            }
            result.append(fileList.toString()).append("\n      </li>\n");
        }
        result.append("    </ul>\n");
        return result.toString();
    }
}

