/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.model;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.statcvs.model.VersionedFile;

public class Module
implements Comparable {
    private final SortedSet files = new TreeSet();
    private final String name;
    private int currentLoc = -1;

    public Module(String name) {
        this.name = name;
    }

    public void addFile(VersionedFile vf) {
        this.files.add(vf);
    }

    public int getCurrentLinesOfCode() {
        if (this.currentLoc < 0) {
            Iterator it = this.files.iterator();
            this.currentLoc = 0;
            while (it.hasNext()) {
                VersionedFile vf = (VersionedFile)it.next();
                this.currentLoc += vf.getCurrentLinesOfCode();
            }
        }
        return this.currentLoc;
    }

    public SortedSet getRevisions() {
        TreeSet result = new TreeSet();
        Iterator iterator = this.files.iterator();
        while (iterator.hasNext()) {
            VersionedFile file = (VersionedFile)iterator.next();
            result.addAll(file.getRevisions());
        }
        return result;
    }

    public int compareTo(Object mod) {
        return this.name.compareTo(((Module)mod).name);
    }

    public String getName() {
        return this.name;
    }

    public SortedSet getFiles() {
        return this.files;
    }
}

