/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.statcvs.input.CvsLogBuilder;
import net.sf.statcvs.input.CvsRevisionParser;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.util.CvsLogUtils;
import net.sf.statcvs.util.LookaheadReader;

public class CvsFileBlockParser {
    private static Logger logger = Logger.getLogger(CvsFileBlockParser.class.getName());
    private final LookaheadReader logReader;
    private final CvsLogBuilder builder;
    private boolean isLogWithoutSymbolicNames = false;
    private final boolean isFirstFile;
    private final Map revBySymNames = new HashMap();

    public CvsFileBlockParser(LookaheadReader logReader, CvsLogBuilder builder, boolean isFirstFile) {
        this.logReader = logReader;
        this.builder = builder;
        this.isFirstFile = isFirstFile;
    }

    public void parse() throws LogSyntaxException, IOException {
        String rcsFile = this.parseSingleLine(this.logReader.getCurrentLine(), "RCS file: ");
        String workingFile = this.parseSingleLine(this.logReader.nextLine(), "Working file: ");
        boolean isInAttic = CvsLogUtils.isInAttic(rcsFile, workingFile);
        this.requireLine(this.logReader.nextLine(), "head:");
        this.requireLine(this.logReader.nextLine(), "branch:");
        this.requireLine(this.logReader.nextLine(), "locks:");
        this.parseLocksAndAccessList();
        this.parseSymbolicNames();
        String keywordSubst = this.parseSingleLine(this.logReader.getCurrentLine(), "keyword substitution: ");
        boolean isBinary = false;
        try {
            isBinary = CvsLogUtils.isBinaryKeywordSubst(keywordSubst);
        }
        catch (IllegalArgumentException unknownKeywordSubst) {
            logger.warning("unknown keyword substitution '" + keywordSubst + "' in line " + this.logReader.getLineNumber());
        }
        this.requireLine(this.logReader.nextLine(), "total revisions:");
        this.parseDescription();
        if (this.isFirstFile) {
            this.builder.buildModule(CvsLogUtils.getModuleName(rcsFile, workingFile));
        }
        this.builder.buildFile(workingFile, isBinary, isInAttic, this.revBySymNames);
        if (!"=============================================================================".equals(this.logReader.getCurrentLine())) {
            new CvsRevisionParser(this.logReader, this.builder).parse();
        }
    }

    public boolean isLogWithoutSymbolicNames() {
        return this.isLogWithoutSymbolicNames;
    }

    private String parseSingleLine(String line, String lineStart) throws LogSyntaxException {
        if (!line.startsWith(lineStart)) {
            throw new LogSyntaxException("line " + this.logReader.getLineNumber() + ": expected '" + lineStart + "' but found '" + line + "'");
        }
        return line.substring(lineStart.length());
    }

    private void requireLine(String line, String lineStart) throws LogSyntaxException {
        this.parseSingleLine(line, lineStart);
    }

    private void parseSymbolicNames() throws IOException {
        String line;
        if (this.logReader.getCurrentLine().startsWith("keyword substitution: ")) {
            return;
        }
        if (this.logReader.getCurrentLine().equals("symbolic names:")) {
            line = this.logReader.nextLine();
        } else {
            this.isLogWithoutSymbolicNames = true;
            line = this.logReader.getCurrentLine();
        }
        while (line != null && !line.startsWith("keyword substitution: ")) {
            int firstColon = line.indexOf(58);
            String tagName = line.substring(1, firstColon);
            String tagRevision = line.substring(firstColon + 2);
            this.revBySymNames.put(tagName, tagRevision);
            line = this.logReader.nextLine();
        }
    }

    private void parseLocksAndAccessList() throws IOException {
        String line;
        while (!"access list:".equals(this.logReader.nextLine())) {
        }
        while (!(line = this.logReader.nextLine()).equals("symbolic names:") && !line.startsWith("keyword substitution: ")) {
        }
    }

    private void parseDescription() throws LogSyntaxException, IOException {
        String line = this.logReader.nextLine();
        if (line.equals("=============================================================================")) {
            throw new LogSyntaxException("line " + this.logReader.getLineNumber() + ": missing description; please don't use the -h switch of 'cvs log'!");
        }
        this.requireLine(this.logReader.getCurrentLine(), "description:");
        while (!this.isDescriptionDelimiter(this.logReader.nextLine())) {
        }
    }

    private boolean isDescriptionDelimiter(String line) {
        return "----------------------------".equals(line) || "=============================================================================".equals(line);
    }
}

